/*
 * This file is part of the M-Edit program (Copyright 1996 by Vincenzo Morello)
 * Permission to use is hereby granted for any purpose.
 *
 * Contains customization callbacks.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "mgui.h"
#include "medit.h"
#include "me.h"

#ifdef UNIX
#define RMODE	"r"
#define WMODE	"w"
#else
#define RMODE	"rb"
#define WMODE	"wb"
#endif

extern void ObjAttrPick(MOBJECT obj);

extern MOBJECT windows[MAX_N_WINDOW];
extern char pref_fname[MAXPATHLEN+1];

PREFERENCES default_pref = {
	{HELV_L_FONT, 0xa0, 0xc0, 0x90, 0, 0, 0},
	{DEFAULT_FONT, 0xc5, 0xc5, 0x90, 0, 0, 0},
	{DEFAULT_FONT, 0x35, 0x70, 0x70, 0xe0, 0xe0, 0xb0},
	False, 80, 20, 8
};

PREFERENCES prefs;

void LoadPrefs(void)
{
	FILE	*fp;

	if ((fp = fopen(pref_fname, RMODE)) != NULL) {
		if (fread(&prefs, 1, sizeof(prefs), fp) <= 0) {
			prefs = default_pref;
			MMessageDialog("Error", "Reading configuration file", "Ok", NULL);
		}
		fclose(fp);
	}
	else {
		if (errno != ENOENT)
			MMessageDialog("Error", "Opening configuration file", "Ok", NULL);
		prefs = default_pref;
	}
}

static void SetPrefs(PREFERENCES *pp)
{
	char str[32];

	MObjectSetFont(menu_sample, pp->menu.font, True);
	MObjectSetBackgroundRGB(menu_sample,
				pp->menu.bg_r,
				pp->menu.bg_g,
				pp->menu.bg_b);
	MObjectSetForegroundRGB(menu_sample,
				pp->menu.fg_r,
				pp->menu.fg_g,
				pp->menu.fg_b);

	MObjectSetFont(sbar_sample, pp->sbar.font, True);
	MObjectSetBackgroundRGB(sbar_sample,
				pp->sbar.bg_r,
				pp->sbar.bg_g,
				pp->sbar.bg_b);
	MObjectSetForegroundRGB(sbar_sample,
				pp->sbar.fg_r,
				pp->sbar.fg_g,
				pp->sbar.fg_b);

	MObjectSetFont(edit_sample, pp->edit.font, True);
	MObjectSetBackgroundRGB(edit_sample,
				pp->edit.bg_r,
				pp->edit.bg_g,
				pp->edit.bg_b);
	MObjectSetForegroundRGB(edit_sample,
				pp->edit.fg_r,
				pp->edit.fg_g,
				pp->edit.fg_b);

	MTButtonSetActivationStatus(auto_indent_tb, pp->auto_indent);

	sprintf(str, "%d", pp->initial_width);
	MObjectSetText(init_w_e, str);
	sprintf(str, "%d", pp->initial_height);
	MObjectSetText(init_h_e, str);
	sprintf(str, "%d", pp->tab_size);
	MObjectSetText(tab_size_e, str);
}

void SetWindowOptions(MOBJECT shell)
{
	FILE_DATA	*pfd;

	pfd = (FILE_DATA *)MObjectGetUserData(shell);
	MObjectSetBackgroundRGB(shell,
			prefs.edit.bg_r,
			prefs.edit.bg_g,
			prefs.edit.bg_b);
	MObjectSetFont(pfd->menu, prefs.menu.font, True);
	MObjectSetFont(pfd->edit, prefs.edit.font, True);
	MObjectSetFont(pfd->curs_x_label, prefs.sbar.font, True);
	MObjectSetFont(pfd->curs_y_label, prefs.sbar.font, True);
	MObjectSetFont(pfd->fname_label, prefs.sbar.font, True);
	MObjectSetFont(pfd->modified_label, prefs.sbar.font, True);
	MObjectSetBackgroundRGB(pfd->menu,
			prefs.menu.bg_r,
			prefs.menu.bg_g,
			prefs.menu.bg_b);
	MObjectSetBackgroundRGB(pfd->edit,
			prefs.edit.bg_r,
			prefs.edit.bg_g,
			prefs.edit.bg_b);
	MObjectSetBackgroundRGB(MObjectParent(pfd->menu),
			prefs.edit.bg_r,
			prefs.edit.bg_g,
			prefs.edit.bg_b);
	MObjectSetBackgroundRGB(MObjectParent(pfd->curs_x_label),
			prefs.edit.bg_r,
			prefs.edit.bg_g,
			prefs.edit.bg_b);
	MObjectSetBackgroundRGB(pfd->curs_x_label,
			prefs.sbar.bg_r,
			prefs.sbar.bg_g,
			prefs.sbar.bg_b);
	MObjectSetBackgroundRGB(pfd->curs_y_label,
			prefs.sbar.bg_r,
			prefs.sbar.bg_g,
			prefs.sbar.bg_b);
	MObjectSetBackgroundRGB(pfd->fname_label,
			prefs.sbar.bg_r,
			prefs.sbar.bg_g,
			prefs.sbar.bg_b);
	MObjectSetBackgroundRGB(pfd->modified_label,
			prefs.sbar.bg_r,
			prefs.sbar.bg_g,
			prefs.sbar.bg_b);
	MObjectSetForegroundRGB(pfd->menu,
			prefs.menu.fg_r,
			prefs.menu.fg_g,
			prefs.menu.fg_b);
	MObjectSetForegroundRGB(pfd->edit,
			prefs.edit.fg_r,
			prefs.edit.fg_g,
			prefs.edit.fg_b);
	MObjectSetForegroundRGB(pfd->curs_x_label,
			prefs.sbar.fg_r,
			prefs.sbar.fg_g,
			prefs.sbar.fg_b);
	MObjectSetForegroundRGB(pfd->curs_y_label,
			prefs.sbar.fg_r,
			prefs.sbar.fg_g,
			prefs.sbar.fg_b);
	MObjectSetForegroundRGB(pfd->fname_label,
			prefs.sbar.fg_r,
			prefs.sbar.fg_g,
			prefs.sbar.fg_b);
	MObjectSetForegroundRGB(pfd->modified_label,
			prefs.sbar.fg_r,
			prefs.sbar.fg_g,
			prefs.sbar.fg_b);
	MSetItemCheckStatus(pfd->options_pd,
			pfd->auto_indent,
			prefs.auto_indent);
	MEditSetAutoIndent(pfd->edit, prefs.auto_indent);
	MEditSetTabSize(pfd->edit, prefs.tab_size);
	MEditSetClipWindow(pfd->edit, prefs.initial_width, prefs.initial_height);
}

void PickOptions(void)
{
	char		str[32];
	MTColor 	bgc, fgc;
	int		r, g, b;

	prefs.auto_indent = MTButtonGetActivationStatus(auto_indent_tb);
	MObjectGetText(init_w_e, str);
	prefs.initial_width = atoi(str);
	MObjectGetText(init_h_e, str);
	prefs.initial_height = atoi(str);
	MObjectGetText(tab_size_e, str);
	prefs.tab_size = atoi(str);

	prefs.menu.font = MObjectGetFont(menu_sample);
	prefs.edit.font = MObjectGetFont(edit_sample);
	prefs.sbar.font = MObjectGetFont(sbar_sample);

	bgc = MObjectBackgroundColor(menu_sample);
	MQueryColor(bgc, &r, &g, &b);
	prefs.menu.bg_r = r;
	prefs.menu.bg_g = g;
	prefs.menu.bg_b = b;
	fgc = MObjectForegroundColor(menu_sample);
	MQueryColor(fgc, &r, &g, &b);
	prefs.menu.fg_r = r;
	prefs.menu.fg_g = g;
	prefs.menu.fg_b = b;

	bgc = MObjectBackgroundColor(edit_sample);
	MQueryColor(bgc, &r, &g, &b);
	prefs.edit.bg_r = r;
	prefs.edit.bg_g = g;
	prefs.edit.bg_b = b;
	fgc = MObjectForegroundColor(edit_sample);
	MQueryColor(fgc, &r, &g, &b);
	prefs.edit.fg_r = r;
	prefs.edit.fg_g = g;
	prefs.edit.fg_b = b;

	bgc = MObjectBackgroundColor(sbar_sample);
	MQueryColor(bgc, &r, &g, &b);
	prefs.sbar.bg_r = r;
	prefs.sbar.bg_g = g;
	prefs.sbar.bg_b = b;
	fgc = MObjectForegroundColor(sbar_sample);
	MQueryColor(fgc, &r, &g, &b);
	prefs.sbar.fg_r = r;
	prefs.sbar.fg_g = g;
	prefs.sbar.fg_b = b;
}

void CustomizeCB(MOBJECT p, void *od, void *ad)
{
	MOBJECT shell;

	shell = MDCreatecustom_shell();

	SetPrefs(&prefs);

	MShellRealize(shell);
}

void ObjectCustomizeCB(MOBJECT p, void *od, void *ad)
{
	ObjAttrPick((MOBJECT)ad);
}

void OptionsOkCB(MOBJECT p, void *od, void *ad)
{
	int     	ii;

	PickOptions();
	for (ii=0; ii < MAX_N_WINDOW; ii++)
		if (windows[ii] != NULL) {
			MObjectUnmap(windows[ii]);
			SetWindowOptions(windows[ii]);
			MObjectMap(windows[ii]);
		}
	MShellDestroy(p);
}

void OptionsSaveCB(MOBJECT p, void *od, void *ad)
{
	FILE	*fp;

	PickOptions();
	if ((fp = fopen(pref_fname, WMODE)) != NULL) {
		if (fwrite(&prefs, 1, sizeof(prefs), fp) <= 0)
			MMessageDialog("Error", "Writing configuration file", "Ok", NULL);
		fclose(fp);
	}
	else
		MMessageDialog("Error", "Opening configuration file", "Ok", NULL);
}

void OptionsDefaultCB(MOBJECT p, void *od, void *ad)
{
	SetPrefs(&default_pref);
}

void OptionsCancelCB(MOBJECT p, void *od, void *ad)
{
	MShellDestroy(p);
}
