CSEG SEGMENT
 ASSUME CS:CSEG
 ORG 100H
START:JMP BEGIN

;EXPENDABLE DATA AFTER STARTUP
TYPEMSG    DB 13,10,"TurboCopy V1.15.",13,10
           DB "by "
ID         DB "Pierre J. le Riche 1991-92.",13,10
           DB "Distribute freely and use as often as desired,",13,10,"but no modifications please.",13,10,13,10,"$"
PRM        DB "Invalid number of parameters,$"
BADSDRMSG  DB 13,10,"Invalid drive specification in source path,$"
BSRCE&WRK  DB "Bad or missing source path,"
FHMSG      DB " type TC /? for help.",13,10,"$"
MSG2       DB "TurboCopy requires 128K ram.",13,10,"$"
MSG3       DB "Total available memory is $"
MSG4       DB " bytes.",13,10,"$"
HELPMSG    DB "TC source [dest.] [/A] [/C] [/O] [/D:date] [/H] [/E] [/M] [/P] [/S] [/V] [/W]",13,10
           DB "  source       Specifies the file(s) to copy.",13,10
           DB "  destination  Specifies the location and/or name of new files.",13,10
           DB "  /A           Copy only files with the archive attribute set.",13,10
           DB "  /C           Do not create subdirectories on the destination drive.",13,10
           DB "  /O           Overwrite all existing files on the destination drive.",13,10
           DB "  /D:MM-DD-YY  Copy files changed on or after the specified date.",13,10
           DB "  /E           Append to end of file if it exists. /O has preference.",13,10
           DB "  /H           Include hidden files and system files in copy.",13,10
           DB "  /M           Same as /A, but resets archive attribute. Overrides /A.",13,10
           DB "  /P           Prompt for confirmation before copying each directory.",13,10
           DB "  /S           Include all source subdirectories in copy.",13,10
           DB "  /V           Verify all new files on the destination drive.",13,10
           DB "  /W           Wait for a keypress before commencing operation.",13,10
           DB "If you find this program useful, and use it often, a",9,9,   "P.O. Box 209",13,10
           DB "contribution will be much appreciated. Any advice and",9,9,  "Kuils River",13,10
           DB "suggestions for further versions will also be welcome.",9,9, "7580",13,10
           DB "Write to the address on the right.",9,9,9,9,                 "South Africa$"
PROTECT    DW "P"*10,"i"*20,"e"*30,"r"*40,"r"*50,"e"*60
BADDDRMSG  DB 13,10,"Invalid drive specification in destination path,$"
FILDIR     DB "' a directory or a filename?",13,10
           DB "Please select <F>ile, or <D>irectory: $"
WAITMSG    DB "Please press any key to start operation.",13,10,"$"




;INEXPENDABLE DATA
SHELL       DB  "C:\COMMAND.COM",51 DUP (0)
COMSPEC     DB  "OMSPEC="
SHPARM      DB  14 DUP (0)
PARM        DB  0
ERRLOAD     DB  13,10," Error loading command interpreter...","$"
RECERR      DB  13,10,"Unable to reclaim memory. Exiting Turbocopy.",13,10,"$"
FLOPSIZ12  DW 0
FLOPSIZ36  DW 0
YESNO      DB 0
FILYET     DW 0
RESERVE    DB 0 ;0=DO NOT RESERVE SPACE FOR DIRECTORIES
DISKS      DW 1
NOCREATE   DB 0
COPDIRS    DB 0
ARCHIVE    DB 0
ATTRCOPY   DW 0
APPEND     DB 0
PROMPT     DB 0
OVERWRITE  DB 0
ALLFIL     DB 0
VERSET     DB 0
STCOPY1    DB 13,10,13,10," Still to copy  file, totalling  bytes.$"
OVERMSG    DB 13,10,13,10,"  File exists. Select <O>verwrite, overwrite <A>ll, <S>kip or App<e>nd: $"
NEWDMSG    DB 13,10," Please insert destination disk $"
NEWDMSG1   DB " in drive "
NEWDMSG2   DB "A:, or press <S> to shell to DOS.",13,10,"$"
DISKFULL   DB 13,10,13,10," Non-removable disk in drive "
DISKFULL2  DB "@: is full.",13,10,"$"
PROCEED    DB 0
DISKLESS   DB " Insufficient space available on non-removable disk in drive "
DISKLESS2  DB "@:",13,10," Please select <P>roceed, or <A>bort: $"
PROMPTMSG  DB " Copy directory? Please press Y=yes, or N=no: $"
ROPEN      DB 0 ;0=FIRST FILE NOT OPEN, 1=FIRST FILE ALREADY OPEN
FIL2COPY   DW 0
STCK       DW 50 DUP (0)
           TOP EQU THIS WORD
ARCERR     DB 13,10,13,10,"  Error changing source file attribute.",13,10,"$"
ERRRFIL    DB 13,10,13,10,"  Error reading file.",13,10,"$"
ERRWFIL    DB 13,10,13,10,"  Error writing file.",13,10,"$"
FSIZ       DD 0 ;READ FILE SIZE
RHANDLE    DW 0 ;FILE HANDLE FOR READING
WHANDLE    DW 0
READMSG    DB 13,10,"  Reading: $"
WRITEMSG   DB 13,10,"  Writing: $"
NFTC       DB " Not enough free space on destination drive to hold any more files.$"
CRDIR      DB " Creating directory on destination drive.",13,10,"$"
BADCDIR    DB " Error creating directory on destination drive.",13,10,"$"
EMPDIR     DB " No matching files found.",13,10,"$"
SAMEMSG    DB " Source and destination paths identical.",13,10,"$"
BADSPATH   DB " Invalid source path.",13,10,"$"
BADDEST2   DB " Error accessing destination drive.",13,10,"$"
FILBYT     DB " bytes in "
FILNUM     DB " source files"
SUBDNUM    DB " subdirectories"
DAVAIL     DB " bytes available on destination drive.",13,10,"$"
FILES      DW 0
SUBDIRS    DW 0
PARMOFF    DW 0
MEM        DW 0 ;NUMBER OF PARAGRAPHS ALLOCATED TO PROGRAM
NEXTPATH   DW OFFSET PROGEND
CURPATH    DW OFFSET PROGEND
CURDEST    DW 0
CPMSG      DB 13,10,13,10,"Copy $"
PRIORITY   DB 1
RENFILE    DB "        .   "
ALLOC      DW 0 ;SIZE OF A ALLOCATION UNIT ON DESTINATION DRIVE IN BYTES
FREEALC    DW 0 ;NUMBER OF FREE SECTORS ON DESTINATION DRIVE
READPARA   DW 0 ;CURRENT OFFSET FROM CS IN PARAGRAPHS
WRITEPARA  DW 0
BEGINPARA  DW 0 ;BEGIN OFFSET OF READING OPERATION
TOTBYTES   DD 0
TOTFILES   DD 0
WSIZ       DD 0
NOFCOPY    DB 13,10,"No files copied.",13,10,"$"
TOTMSG     DB 13,10,13,10,"Copied a total of  bytes in  files.",13,10,"Program was active for "
ENDMES2    DB " hours"
ENDMES3    DB " minutes"
ENDMES4    DB " and "
ENDMES5    DB " seconds"
BTIMEDX    DW 0
BTIMECX    DW 0
ENDMES     DB 13,10,"Thank you for using TurboCopy!",13,10,36
FREAD      DW 0
DATEFILE   DB "File dates must be the same or later than $"
DATE       DB 0

YEAR    DW 1980
MONTH   DW 1
DAY     DW 1
DATELEN	DW 0
NUMLEN  DW 0
YFLAG	DB 0
WRKYEAR DW 0
WORKSI	DW 0
WRKMON	DW 0

;*************************************************************
;*INTELLIDATE:CONVERTS OBSCURE DATES INTO YEAR,MONTH,DAY     *
;*ENTRY: DS:BP POINTS TO ASCIIZ STRING THAT CONTAINS DATE;   *
;*	 DEFAULTS IN YEAR, MONTH AND DAY		     *
;*RETURN:DATE IN YEAR, MONTH AND DAY                         *
;*       REGISTERS, UNALTERED                                *
;*************************************************************
INTELLIDATE:PUSH AX BX CX DX SI DI BP DS ES
 MOV WRKYEAR,0
 MOV WRKMON,0
 MOV NUMLEN,0
 PUSH CS
 POP ES
 MOV DI,OFFSET TYPEMSG
 MOV SI,BP
 XOR CX,CX
COPYDATE:MOVSB
 CMP ES:[DI-1],BYTE PTR 0
 JE ENDCOPY
 CMP ES:[DI-1],BYTE PTR "0"
 JB NNCOPY
 CMP ES:[DI-1],BYTE PTR "9"
 JA NNCOPY
 INC NUMLEN
NNCOPY:INC CX
 JMP COPYDATE
ENDCOPY:PUSH CS
 POP DS
 MOV DATELEN,CX
 MOV CX,4    ;FIND THE YEAR FIRST
 CALL FINDLAST
 CMP AX,1980
 JB YEAR2
 CMP AX,2000
 JNA YEAR1OK
 CMP AX,2099
 JA YEAR2
 MOV WRKYEAR,AX
 MOV WORKSI,SI
 MOV YFLAG,255
 CMP AX,2013
 JB YEAR2
YEAR1OK:MOV YEAR,AX
 MOV AL,"X"
 MOV DI,SI
 REP STOSB
 CALL MONTHL;JUMP TO ROUTINE THAT CHECKS LEFT HAND SIDE FIRST FOR MONTH
 JMP DODAY
YEAR2:MOV CX,4
 CALL FINDFIRST
 CMP AX,1980
 JB YEAR3
 CMP AX,2000
 JNA YEAR2OK
 CMP AX,2099
 JA YEAR3
 MOV WRKYEAR,AX
 MOV WORKSI,SI
 MOV YFLAG,0
 CMP AX,2013
 JB YEAR3
YEAR2OK:MOV YEAR,AX
 CALL PATCH
 CALL MONTHR;JUMP TO ROUTINE THAT CHECKS RIGHT HAND SIDE FIRST FOR MONTH
 JMP DODAY
YEAR3:MOV CX,2
 CALL FINDLAST
 CMP AX,80
 JB YEAR4
 ADD AX,1900
 MOV YEAR,AX
 CALL PATCH
 CALL MONTHL
 JMP DODAY
YEAR4:MOV CX,2
 CALL FINDFIRST
 CMP AX,80
 JB YEAR5
 ADD AX,1900
 MOV YEAR,AX
 CALL PATCH
 CALL MONTHR
 JMP DODAY
YEAR5:CMP NUMLEN,5
 JB DOMONTH
 CMP WRKYEAR,0
 JE DOMONTH
 MOV CX,4
 MOV SI,WORKSI
 CALL PATCH
 MOV AX,WRKYEAR
 MOV YEAR,AX
 CMP YFLAG,255
 JNE YFNIL
 CALL MONTHL
 JMP DODAY
YFNIL:CALL MONTHR
 JMP DODAY
DOMONTH:CALL MONTHL
 CMP WRKMON,0
 JNE MONOK
 CALL MONTHR
MONOK:JMP DODAY
MONTHR:MOV CX,2
 CALL FINDLAST
 OR AX,AX
 JNZ MNZ
 RET
MNZ:CMP AX,12
 JA BADMON
 MOV WRKMON,AX
 CALL PATCH
 RET
BADMON:CMP NUMLEN,3
 JNA ONEDMON
 RET
ONEDMON:MOV BL,10
 DIV BL
 XCHG AL,AH
 XOR AH,AH
 MOV WRKMON,AX
 INC SI
 DEC CX
 CALL PATCH
 RET
MONTHL:MOV CX,2
 CALL FINDFIRST
 OR AX,AX
 JNZ MONLOK
 RET
MONLOK:CMP AX,12
 JA MONLBAD
 MOV WRKMON,AX
 CALL PATCH
 RET
MONLBAD:MOV BL,10
 DIV BL
 XOR AH,AH
 MOV WRKMON,AX
 DEC CX
 CALL PATCH
 RET
DODAY:CMP WRKMON,0
 JE MONDEF
 MOV AX,WRKMON
 MOV MONTH,AX
MONDEF:MOV CX,2
 CALL FINDFIRST
 OR AX,AX
 JZ DAYEND
 CMP AX,31
 JNA DAYOK
 MOV BL,10
 DIV BL
 XOR AH,AH
 OR AX,AX
 JZ DAYEND
DAYOK:MOV DAY,AX
 CALL PATCH
DAYEND:
INTELLLIEND:POP ES DS BP DI SI DX CX BX AX
 RET

;FINDFIRST:SCANS FROM LEFT OF DATE UNTIL IT FINDS THE BEGINNING OF A NUMERIC
;	   STRING. IT THEN CONVERTS THIS STRING INTO A NUMBER IN AX. THE
;	   MAXIMUM LENGTH OF THE STRING MUST BE IN CX (IN CASE OF LONG NUMBERS)
;RETURN:SI POINTS TO BEGINNING OF NUMBER, CX ACTUAL LENGTH, NUMBER IN AX
;	AX=65535 IF NO NUMBERS FOUND (SI=END+1, CX=UNCHANGED)
FINDFIRST:PUSH BX DX BP
 MOV SI,OFFSET TYPEMSG
SCANRIGHT:LODSB
 CMP AL,"0"
 JB SRNOTNUM
 CMP AL,"9"
 JA SRNOTNUM
 JMP FOUNDNUM
SRNOTNUM:OR AL,AL
 JNZ SRNOTNUM2
 XOR AX,AX
 XOR CX,CX
 POP BP DX BX
 RET
SRNOTNUM2:JMP SCANRIGHT
FOUNDNUM:XOR DX,DX
 DEC SI
 PUSH SI
FSRLENGTH:LODSB
 CMP AL,"0"
 JB ENDDLEN
 CMP AL,"9"
 JA ENDDLEN
 INC DX
 LOOP FSRLENGTH
 INC SI
ENDDLEN:DEC SI
 DEC SI
 MOV CX,DX
 PUSH CX
 MOV BX,1
 XOR BP,BP
GETNUM:STD
 LODSB
 CLD
 XOR AH,AH
 SUB AL,"0"
 MUL BX
 ADD BP,AX
 MOV AL,10
 XOR AH,AH
 MUL BX
 MOV BX,AX
 LOOP GETNUM
 MOV AX,BP
 POP CX SI BP DX BX
 RET

;FINDLAST: SCANS FROM RIGHT OF DATE UNTIL IT FINDS THE BEGINNING OF A NUMERIC
;	   STRING. IT THEN CONVERTS THIS STRING INTO A NUMBER IN AX. THE
;	   MAXIMUM LENGTH OF THE STRING MUST BE IN CX (IN CASE OF LONG NUMBERS)
;RETURN:SI POINTS TO BEGINNING OF NUMBER, CX ACTUAL LENGTH, NUMBER IN AX
;	AX=65535 IF NO NUMBERS FOUND (SI=END+1, CX=UNCHANGED)
FINDLAST:STD
 PUSH BX DX BP
 MOV SI,OFFSET TYPEMSG
 ADD SI,DATELEN
 DEC SI
SCANLEFT:LODSB
 CMP AL,"0"
 JB SLNOTNUM
 CMP AL,"9"
 JA SLNOTNUM
 JMP FOUNDNUML
SLNOTNUM:CMP SI,OFFSET TYPEMSG
 JNB SCANLEFT
 XOR AX,AX
 XOR CX,CX
 CLD
 POP BP DX BX
 RET
FOUNDNUML:INC SI
 XOR BP,BP
 MOV BX,1
 PUSH CX
GETNUML:LODSB
 CMP SI,OFFSET TYPEMSG-1
 JB ENDGET
 CMP AL,"0"
 JB ENDGET
 CMP AL,"9"
 JA ENDGET
 XOR AH,AH
 SUB AL,"0"
 MUL BX
 ADD BP,AX
 MOV AL,10
 XOR AH,AH
 MUL BX
 MOV BX,AX
 LOOP GETNUML
 DEC SI
ENDGET:POP DX
 SUB DX,CX
 MOV CX,DX
 INC SI
 INC SI
 MOV AX,BP
 CLD
 POP BP DX BX
 RET

;PATCH: INTERNAL ROUTINE FOR INTELLIDATE
PATCH:MOV AL,"X"
 SUB NUMLEN,CX
 MOV DI,SI
 JCXZ PATCH2
 REP STOSB
PATCH2:RET





;BOMB: ROUTINE TO EXIT PROGRAM
BOMB:MOV AL,VERSET
 MOV AH,2EH
 INT 21H
 MOV AX,4CH*256
 INT 21H

;BINTODEC: STORES DX:AX AS ASCII NUMBER AT DS:DI
;RETURN: DI POINTS TO NEXT CHARACTER
BINTODEC:PUSH AX BX CX DX BP
 XCHG DX,BP
 MOV BX,10
 MOV CX,48
BINTODEC2:MOV DH,CH
 INC DH
 AND DH,3
 JNZ BINTODEC3
 INC CH
 MOV DL,","
 PUSH DX
BINTODEC3:XCHG BP,AX
 XOR DX,DX
 DIV BX
 XCHG BP,AX
 DIV BX
 OR DL,CL
 INC CH
 PUSH DX
 OR BP,BP
 JNZ BINTODEC2
 OR AX,AX
 JNZ BINTODEC2
BINTODEC4:POP DX
 MOV DS:[DI],DL
 INC DI
 DEC CH
 JNZ BINTODEC4
 POP BP DX CX BX AX
 RET

BADDDRIVE:;DISPLAY INVALID SOURCE DRIVE MESSAGE
 MOV AH,9
 MOV DX,OFFSET BADDDRMSG
 INT 21H
 MOV DX,OFFSET FHMSG
 INT 21H
 JMP BOMB
BADMEMORY:MOV AH,9
 MOV DX,OFFSET MSG2
 INT 21H
 JMP BOMB
BADSDRIVE:;DISPLAY INVALID SOURCE DRIVE MESSAGE
 MOV AH,9
 MOV DX,OFFSET BADSDRMSG
 INT 21H
 MOV DX,OFFSET FHMSG
 INT 21H
 JMP BOMB
NOPARAM:;DISPLAY NO PARAMETERS MESSAGE
 MOV AH,9
 MOV DX,OFFSET PRM
 INT 21H
 MOV DX,OFFSET FHMSG
 INT 21H
 JMP BOMB
BADSOURCE:;DISPLAY BAD/MISSING SOURCE MESSAGE
 MOV DX,OFFSET BSRCE&WRK
 MOV AH,9
 INT 21H
 JMP BOMB

BEGIN:CLI
 MOV SP,OFFSET TOP
 STI
 MOV DX,OFFSET TYPEMSG
 MOV AH,9
 INT 21H
 MOV AH,4AH
 PUSH AX
 MOV BX,65535
 INT 21H
 POP AX
 INT 21H
 JC BADMEMORY
 CMP BX,128*64
 JB BADMEMORY
 MOV AH,9
 MOV DX,OFFSET MSG3
 INT 21H
 MOV DI,DX
 PUSH DX
 MOV AX,BX
 MOV CX,16
 MUL CX
 CALL BINTODEC
 POP DX
 MOV AL,"$"
 STOSB
 MOV AH,9
 INT 21H
 MOV DX,OFFSET MSG4
 INT 21H
 MOV MEM,BX
 MOV SI,80H
 PUSH SI SI
 POP DI
 MOV CX,128
MAKECAPS:LODSB
 CMP AL,"a"
 JB NOTSMALL
 CMP AL,"z"
 JA NOTSMALL
 SUB AL,32
NOTSMALL:STOSB
 LOOP MAKECAPS
 POP SI
 LODSB
 MOV CL,AL
 XOR CH,CH
 OR CX,CX
 JNZ NOPARAMNO
 JMP NOPARAM
NOPARAMNO:MOV BX,CX
 MOV DS:[SI+BX],BYTE PTR 0
 PUSH SI CX
 MOV AH,2CH
 INT 21H
 MOV BTIMEDX,DX ;SAVE BEGIN TIME
 MOV BTIMECX,CX
 MOV SI,OFFSET PROTECT
 MOV DI,OFFSET ID-1
 MOV CX,5
 MOV BL,10
PROT1:LODSW
 INC DI
 DIV BL
 ADD BL,10
 CMP AL,ES:[DI]
 JNE BADBOY
 LOOP PROT1
 JMP GOODBOY
BADBOY:JMP SHORT BADBOY

GOODBOY:POP CX SI
 PUSH SI CX
 ;SCAN THE PARAMETERS AND UPDATE ALL FLAGS
SCPARMS:LODSB
 OR AL,AL
 JNZ AGNO1
 JMP ENDSCPARMS
AGNO1:CMP AL,"/"
 JNE SCPARMS
 MOV AL,DS:[SI]
 CMP AL,"O"
 JNE NOTOVERWRITE
 MOV OVERWRITE,1
NOTOVERWRITE:CMP AL,"P"
 JNE NOTPROMPT
 MOV PROMPT,1
NOTPROMPT:CMP AL,"S"
 JNE NOCOPDIRS
 MOV COPDIRS,1
NOCOPDIRS:CMP AL,"C"
 JNE NONOCREATE
 MOV NOCREATE,1
NONOCREATE:CMP AL,"A"
 JNE NOARC1
 MOV ARCHIVE,2
NOARC1:CMP AL,"M"
 JNE NOARCHIVE
 MOV ARCHIVE,1
NOARCHIVE:CMP AL,"V"
 JNE NOVERIFY
 MOV AH,54H
 INT 21H
 MOV VERSET,AL
 MOV AX,1+2EH*256
 XOR DL,DL
 INT 21H
 JMP SCPARMS
NOVERIFY:CMP AL,"D"
 JNE NODATE
 MOV DATE,1
 MOV BP,SI
 CALL INTELLIDATE
 MOV AH,9
 MOV DX,OFFSET DATEFILE
 INT 21H
 XOR DX,DX
 MOV DI,OFFSET PROTECT
 PUSH DI
 MOV AX,MONTH
 CALL BINTODEC
 MOV AL,"-"
 STOSB
 MOV AX,DAY
 CALL BINTODEC
 MOV AX,"1-"
 STOSW
 MOV AX,YEAR
 SUB AX,1000
 CALL BINTODEC
 MOV AX,"."+13*256
 STOSW
 MOV AX,10+"$"*256
 STOSW
 MOV AH,9
 POP DX
 INT 21H

 JMP SCPARMS
NODATE:CMP AL,"W"
 JNE NOWAITE
 MOV AH,9
 MOV DX,OFFSET WAITMSG
 INT 21H
 MOV AH,8
 INT 21H
 JMP SCPARMS
NOWAITE:CMP AL,"E"
 JNE NOAPPZ
 MOV APPEND,1
NOAPPZ:CMP AL,"H"
 JNE NOHID
 MOV ATTRCOPY,7
NOHID:

 JMP SCPARMS
ENDSCPARMS:POP CX SI
SRCEFIND:LODSB
 CMP AL,32
 JNE FOUNDSRCE
 LOOP SRCEFIND
 JMP NOPARAM
FOUNDSRCE:CMP AL,"/"
 JNE OKSRCE
 LODSB
 CMP AL,"?"
 JE SHOWHELP
 CMP AL,"h"
 JE SHOWHELP
 JMP BADSOURCE
SHOWHELP: ;DISPLAY HELP MESSAGE
 MOV AH,9
 MOV DX,OFFSET HELPMSG
 INT 21H
 JMP BOMB
OKSRCE:MOV DI,OFFSET PROGEND
 XCHG AL,AH
 LODSB
 CMP AL,BYTE PTR ":"
 JE STORESDRV
 DEC SI
 DEC SI
 MOV AH,19H
 INT 21H
 MOV AH,AL
 ADD AH,"A"
 MOV AL,":"
STORESDRV:XCHG AL,AH
 STOSW
 LODSB
 DEC SI
 CMP AL,"\"
 JE FULLPATH
 MOV AL,"\"
 STOSB
 PUSH SI
 MOV AH,47H
 MOV DL,DS:[OFFSET PROGEND]
 SUB DL,64
 MOV SI,DI
 INT 21H
 JNC DOPATH
 JMP BADSDRIVE
DOPATH:DEC DI
DOPATHB:INC DI
 CMP ES:[DI],BYTE PTR 0
 JNE DOPATHB
 CMP ES:[DI-1],BYTE PTR "\"
 JE ENDDOPATH2
 MOV AL,"\"
 STOSB
ENDDOPATH2:POP SI
FULLPATH:LODSB
 CMP AL,"/"
 JE ENDPATH
 CMP AL," "
 JE ENDPATH
 OR AL,AL
 JE ENDPATH
 STOSB
 JMP FULLPATH
ENDPATH:DEC SI
 XOR AL,AL
 STOSB
 MOV PARMOFF,SI
 MOV SI,OFFSET PROGEND
 MOV DI,SI
SCANSPATH:LODSB
 STOSB
 OR AL,AL
 JZ ENDSCANS
 CMP AL,"."
 JNE SCANSPATH
SCANSF:LODSB
 DEC SI
 CMP AL,"."
 JNE NOTPREVPATH
 CMP ES:[DI-2],BYTE PTR "\"
 JNE SCANSPATH
 MOV AL,DS:[SI+1]
 CMP AL,BYTE PTR "\"
 JE NPSOK1
 OR AL,AL
 JNZ SCANSPATH
NPSOK1:INC SI
 SUB DI,2
PREVSDIR:MOV AL,ES:[DI-1]
 CMP AL,":"
 JE SCANSPATH
 DEC DI
 CMP AL,"\"
 JE SCANSPATH
 JMP PREVSDIR
NOTPREVPATH:CMP ES:[DI-2],BYTE PTR "\"
 JNE SCANSPATH
 SUB DI,2
 JMP SCANSPATH
ENDSCANS:DEC DI
 MOV BP,DI
 ADD BP,3
 CMP ES:[DI-1],BYTE PTR "\"
 JE NOTSLASH
 MOV AL,"\"
 STOSB
 SUB BP,3
NOTSLASH:MOV AX,".*"
 STOSW
 MOV AX,"*"
 STOSW
 MOV AH,1AH
 MOV DX,OFFSET TYPEMSG
 INT 21H
 MOV AH,4EH
 XOR CX,CX
 MOV DX,OFFSET PROGEND
 INT 21H
 JNC SPATHOKB
 CMP AX,3
 JNE SPATHOKB
 MOV DI,BP
 XOR AL,AL
 STOSB
SPATHOKB:MOV NEXTPATH,DI
 MOV DI,OFFSET TYPEMSG
 PUSH DI
 MOV SI,PARMOFF
SCANDEST:LODSB
 CMP AL,32
 JE SCANDEST
 DEC SI
COPYDEST:LODSB
 OR AL,AL
 JZ ENDDEST
 CMP AL,"/"
 JE ENDDEST
 CMP AL," "
 JE ENDDEST
 STOSB
 JMP COPYDEST
ENDDEST:DEC SI
 MOV PARMOFF,SI
 XOR AX,AX
 STOSW
 POP SI
 MOV DI,NEXTPATH
 LODSB
 XCHG AL,AH
 LODSB
 CMP AL,BYTE PTR ":"
 JE STOREDDRV
 DEC SI
 DEC SI
 MOV AH,19H
 INT 21H
 MOV AH,AL
 ADD AH,"A"
 MOV AL,":"
STOREDDRV:XCHG AL,AH
 STOSW
 LODSB
 DEC SI
 CMP AL,"\"
 JE FULLPATHD
 MOV AL,"\"
 STOSB
 PUSH SI
 MOV AH,47H
 MOV SI,NEXTPATH
 MOV DL,[SI]
 SUB DL,64
 MOV SI,DI
 INT 21H
 JNC DOPATHD
 JMP BADDDRIVE
DOPATHD:DEC DI
DOPATHBD:INC DI
 CMP ES:[DI],BYTE PTR 0
 JNE DOPATHBD
 CMP ES:[DI-1],BYTE PTR "\"
 JE ENDDOPATH2D
 MOV AL,"\"
 STOSB
ENDDOPATH2D:POP SI
FULLPATHD:LODSB
 OR AL,AL
 JE ENDPATHD
 STOSB
 JMP FULLPATHD
ENDPATHD:DEC SI
 XOR AL,AL
 STOSB
 MOV SI,NEXTPATH
 MOV DI,SI
SCANSPATHD:LODSB
 STOSB
 OR AL,AL
 JZ ENDSCANSD
 CMP AL,"."
 JNE SCANSPATHD
SCANSFD:LODSB
 DEC SI
 CMP AL,"."
 JNE NOTPREVPATHD
 CMP ES:[DI-2],BYTE PTR "\"
 JNE SCANSPATHD
 MOV AL,DS:[SI+1]
 CMP AL,BYTE PTR "\"
 JE NPSOK1D
 OR AL,AL
 JNZ SCANSPATHD
NPSOK1D:INC SI
 SUB DI,2
PREVSDIRD:MOV AL,ES:[DI-1]
 CMP AL,":"
 JE SCANSPATHD
 DEC DI
 CMP AL,"\"
 JE SCANSPATHD
 JMP PREVSDIRD
NOTPREVPATHD:CMP ES:[DI-2],BYTE PTR "\"
 JNE SCANSPATHD
 OR AL,AL
 JNZ NOTEDST
 INC DI
NOTEDST:SUB DI,2
 JMP SCANSPATHD
ENDSCANSD:DEC DI
 CMP ES:[DI-1],BYTE PTR "\"
 JNE NOTSLASHDB
GETSFILES:MOV SI,OFFSET PROGEND
GSF1:LODSB
 CMP AL,"\"
 JNE GSF2
 MOV BP,SI
GSF2:OR AL,AL
 JE GSF3
 JMP GSF1
GSF3:MOV SI,BP
GSF4:LODSB
 OR AL,AL
 JNZ NENDDFIL1
 JMP ENDDFIL
NENDDFIL1:STOSB
 JMP GSF4
NOTSLASHDB:PUSH DI
SCANWILD:DEC DI
 CMP ES:[DI],BYTE PTR "?"
 JNE NGOTWILD1
 JMP GOTWILD
NGOTWILD1:CMP ES:[DI],BYTE PTR "*"
 JNE NGOTWILD2
 JMP GOTWILD
NGOTWILD2:CMP ES:[DI-1],BYTE PTR "\"
 JNE SCANWILD
 MOV SI,DI
 POP DI
 PUSH DI
 MOV AX,"*\"
 STOSW
 MOV AX,"*."
 STOSW
 XOR AL,AL
 STOSB
 MOV AH,4EH
 XOR CX,CX
 MOV DX,NEXTPATH
 INT 21H
 JNC DPATHOKB
 CMP AX,3
 JNE DPATHOKB
 MOV ES:[DI-5],BYTE PTR 0
 JMP NOTSURE
DPATHOKB:POP AX
 DEC DI
 JMP ENDDFIL
NOTSURE:MOV DI,OFFSET TYPEMSG
 MOV AX,"sI"
 STOSW
 MOV AX,"' "
 STOSW
SDFZA:LODSB
 STOSB
 CMP AL,"."
 JNE NOTFILEY
 JMP GOTWILD
NOTFILEY:OR AL,AL
 JNE SDFZA
 DEC DI
 MOV AL,"$"
 STOSB
 MOV AH,9
 MOV DX,OFFSET TYPEMSG
 INT 21H
 MOV DX,OFFSET FILDIR
 INT 21H
FDKEY:MOV AH,8
 INT 21H
 CMP AL,"Z"
 JNA FDKEY2
 SUB AL,32
FDKEY2:CMP AL,"F"
 JE FDKEY4
FDKEY3:CMP AL,"D"
 JNE FDKEY
FDKEY4:PUSH AX
 MOV DL,AL
 MOV AH,2
 INT 21H
 MOV DL,13
 INT 21H
 MOV DL,10
 INT 21H
 POP AX
 CMP AL,"F"
 JE GOTWILD
 POP DI
 MOV AX,"*\"
 STOSW
 MOV AX,"*."
 STOSW
 JMP ENDDFIL
GOTWILD:POP DI
ENDDFIL:MOV AX,2*256
 STOSW
 MOV NEXTPATH,DI
 STOSB
 MOV SI,NEXTPATH
 STD
SCWCS:LODSB
 CMP AL,"\"
 JNE SCWCS
 CLD
 INC SI
 INC SI
 PUSH SI
 MOV DI,OFFSET RENFILE
 MOV CX,8
SCWCS2:LODSB
 CMP AL,"*"
 JNE NOTAST1
 MOV AL,"?"
 REP STOSB
 JMP GETEXT
NOTAST1:CMP AL,"."
 JNE NOTPUNT
 JMP GETEXT
NOTPUNT:OR AL,AL
 JNZ NOTZERO
 POP SI
 JMP TURBOCOPY
NOTZERO:STOSB
 LOOP SCWCS2
GETEXT:POP SI
SCWCS3:LODSB
 CMP AL,"."
 JE GOTEXT1
 OR AL,AL
 JNZ SCWCS3
 JMP TURBOCOPY
GOTEXT1:MOV CX,3
 MOV DI,OFFSET RENFILE+9
SCWCS4:LODSB
 CMP AL,"*"
 JNE NOTAST4
 MOV AL,"?"
 REP STOSB
 JMP TURBOCOPY
NOTAST4:OR AL,AL
 JZ TURBOCOPY
 STOSB
 LOOP SCWCS4

;Ŀ
;MAIN COPYING ROUTINE                                              
;SCANS THE LIST OF DIRECTORIES FOR THE HIGHEST PRIORITY (2 TO 255) 
;AND CONVERTS IT'S PRIORITY TO 1 (= ALREADY COPIED)                
;IT THEN COPIES THE DIRECTORIES IN ACCORDANCE WITH THE PARAMETERS  
;A 0 AFTER THE PRIORITY NUMBER INDICATES THE END OF THE LIST       
;STORES PRIORITY+1 INTO PRIORITY (PRIORITY EQUALS X COORDINATE)    
;
TURBOCOPY:MOV YESNO,0
 MOV SI,OFFSET PROGEND
 PUSH SI
FNULA:LODSB
 DEC SI
 OR AL,AL
 JZ ENDCLEAN
 MOV DI,SI
FNULA1:LODSB
 OR AL,AL
 JNZ FNULA1
FNULB:LODSB
 OR AL,AL
 JNZ FNULB
 LODSB
 CMP AL,1
 JNE FNULA
 MOV CX,NEXTPATH
 SUB CX,SI
 INC CX
 ADD NEXTPATH,DI
 SUB NEXTPATH,SI
 PUSH DI
 CLD
 REP MOVSB
 POP SI
 JMP FNULA
ENDCLEAN:POP SI
 XOR DL,DL
 LODSB
 DEC SI
 OR AL,AL
 JE ENDOFCOPY
TC0:MOV BP,SI
TC1:LODSB
 OR AL,AL
 JNZ TC1
TC2:LODSB
 OR AL,AL
 JNZ TC2
 LODSB
 CMP AL,DL
 JNA NOTBETTER
 MOV DL,AL
 MOV CURPATH,BP
 JMP NOTEQUAL
NOTBETTER:JNE NOTEQUAL
 PUSH SI DI
 MOV SI,CURPATH
 MOV DI,BP
 CLD
SORT1:CMPSB
 JE SORT1
 POP DI SI
 JB NOTEQUAL
 MOV CURPATH,BP
NOTEQUAL:LODSB
 DEC SI
 OR AL,AL
 JNZ TC0
 CMP AL,1
 JE ENDOFCOPY
 JMP STILLTOCOPY
ENDOFCOPY:MOV SI,OFFSET TOTMSG
 MOV DI,OFFSET TYPEMSG
 PUSH DI
 MOV CX,22
 REP MOVSB
 MOV AX,WORD PTR TOTBYTES
 MOV DX,WORD PTR TOTBYTES[2]
 CALL BINTODEC
 MOV CX,10
 REP MOVSB
 MOV AX,WORD PTR TOTFILES
 MOV DX,WORD PTR TOTFILES[2]
 CALL BINTODEC
 MOV CX,5
 REP MOVSB
 MOV CX,27
 CMP WORD PTR TOTFILES[2],0
 JNE OKGU
 CMP WORD PTR TOTFILES,1
 JE NOKGUA
 JMP OKGUA
NOKGUA:DEC CX
 INC SI
OKGU:REP MOVSB
 MOV AH,2CH
 INT 21H
 MOV AX,BTIMECX
 MOV BX,BTIMEDX
 CMP CX,AX
 JAE NOMIDNIGHT
 ADD CH,24
NOMIDNIGHT:SUB DL,BL
 JNC HUNSECS
 PUSHF
 ADD DL,100
 POPF
HUNSECS:SBB DH,BH
 JNC SECS
 PUSHF
 ADD DH,60
 POPF
SECS:SBB CL,AL
 JNC MINS
 PUSHF
 ADD CL,60
 POPF
MINS:SBB CH,AH
 MOV BX,CX
 OR BH,BH
 JZ NOHOURS
 MOV AL,BH
 XOR AH,AH
 PUSH DX
 XOR DX,DX
 CALL BINTODEC
 POP DX
 MOV SI,OFFSET ENDMES2
 MOV CX,OFFSET ENDMES3-OFFSET ENDMES2
 CMP AL,1
 JNE NOTONEHOUR
 DEC CX
NOTONEHOUR:REP MOVSB
 OR DX,DX
 JNZ DXNOTNUL
 INC CL
DXNOTNUL:OR BL,BL
 JNZ BLNOTNUL
 INC CL
BLNOTNUL:SUB CL,1
 JNC ENDTIME
 JZ EITHERNUL
 MOV AX," ,"
 STOSW
 JMP SHORT NOHOURS
EITHERNUL:MOV SI,OFFSET ENDMES4
 MOV CX,5
 REP MOVSB
NOHOURS:OR BL,BL
 JZ NOMINUTES
 MOV AL,BL
 XOR AH,AH
 PUSH DX
 XOR DX,DX
 CALL BINTODEC
 POP DX
 MOV SI,OFFSET ENDMES3
 MOV CX,OFFSET ENDMES4-OFFSET ENDMES3
 CMP BL,1
 JNE NOTONEMINUTE
 DEC CX
NOTONEMINUTE:REP MOVSB
 OR DX,DX
 JE ENDTIME
 MOV SI,OFFSET ENDMES4
 MOV CX,5
 REP MOVSB
NOMINUTES:MOV AL,DH
 XOR AH,AH
 PUSH DX
 XOR DX,DX
 CALL BINTODEC
 POP DX
 OR DL,DL
 JZ NOHUNSECS
 MOV AL,"."
 STOSB
 CMP DL,10
 JNB BIGTNINE
 MOV AL,"0"
 STOSB
BIGTNINE:MOV AL,DL
 PUSH DX
 XOR DX,DX
 CALL BINTODEC
 POP DX
 CMP ES:[DI-1],BYTE PTR "0"
 JNE NOHUNSECS
 DEC DI
NOHUNSECS:MOV SI,OFFSET ENDMES5
 MOV CX,OFFSET BTIMEDX-OFFSET ENDMES5
 CMP DH,1
 JNE NOTONESECOND
 OR DL,DL
 JNZ NOTONESECOND
 DEC CX
NOTONESECOND:REP MOVSB
ENDTIME:MOV AX,13*256+"."
 STOSW
 MOV AX,10+36*256
 STOSW
 POP DX
 MOV AH,9
 INT 21H
 MOV DX,OFFSET ENDMES
 MOV AH,9
 INT 21H
 JMP BOMB
OKGUA:CMP WORD PTR TOTFILES,0
 JE NOKGU
 JMP OKGU
NOKGU:POP DX
 MOV DX,OFFSET NOFCOPY
 MOV AH,9
 INT 21H
 JMP BOMB
STILLTOCOPY:CMP DL,255
 JE MAXPRIO
 INC DL
MAXPRIO:MOV PRIORITY,DL
 MOV SI,CURPATH
PRIO1:LODSB
 OR AL,AL
 JNZ PRIO1
 MOV CURDEST,SI
PRIO2:LODSB
 OR AL,AL
 JNZ PRIO2
 MOV DS:[SI],BYTE PTR 1
 MOV DX,OFFSET CPMSG
 MOV AH,9
 INT 21H
 MOV DI,OFFSET TYPEMSG
 MOV DX,DI
 MOV SI,CURPATH
CPPRMSG:LODSB
 OR AL,AL
 JZ PRTOMSG
 STOSB
 JMP CPPRMSG
PRTOMSG:MOV AX,"t "
 STOSW
 MOV AX," o"
 STOSW
CPDSTMSG:LODSB
 OR AL,AL
 JZ CPEDLN
 STOSB
 JMP CPDSTMSG
CPEDLN:MOV AX,13+10*256
 STOSW
 MOV AL,"$"
 STOSB
 MOV AH,9
 INT 21H
 MOV SI,CURPATH
 MOV DI,CURDEST
COMPSD:LODSB
 MOV AH,ES:[DI]
 INC DI
 CMP AH,AL
 JNE NOTSAMSD
 OR AL,AL
 JNZ COMPSD
 MOV AH,9
 MOV DX,OFFSET SAMEMSG
 INT 21H
 JMP TURBOCOPY
NOTSAMSD:



 MOV SUBDIRS,0
 CMP COPDIRS,1
 JE COPDIOK
 JMP NOSUBDIRS

;JMP TO NOSUBDIRS SO AS NOT TO COPY SUBDIRECTORIES
;SCANS SOURCE FOR DIRS (AT DS:50000), UPDATE DIRLIST

COPDIOK:MOV SI,CURDEST
FINDSLZ:DEC SI
 CMP DS:[SI-1],BYTE PTR "\"
 JNE FINDSLZ
 PUSH SI
 MOV DI,SI
 LODSW
 PUSH AX
 LODSW
 PUSH AX
 MOV AX,".*"
 STOSW
 MOV AX,"*"
 STOSW
 MOV AH,4EH
 MOV CX,16 ;DIRECTORIES FIRST
 MOV DX,CURPATH
 INT 21H
 POP BX
 POP AX
 POP DI
 STOSW
 MOV AX,BX
 STOSW
 MOV DI,50000
 JNC FINDNEXT
 CMP AX,3
 JNE NOFILES
 MOV AH,9
 MOV DX,OFFSET BADSPATH
 INT 21H
 JMP TURBOCOPY
NOFILES:JMP NOSUBDIRS
FINDNEXT:INC SUBDIRS
 MOV SI,OFFSET TYPEMSG+21
 MOV CX,11
 REP MOVSW
 MOV AH,4FH
 INT 21H
 JNC FINDNEXT
 MOV CX,SUBDIRS
 MOV SUBDIRS,0
 MOV SI,50000
SCANDIRS:MOV BP,SI
 LODSB
 ADD SI,21
 CMP AL,16
 JE OKDIR
NOTOKDIR:JMP ENDDIR
OKDIR:CMP DS:[SI-13],BYTE PTR "."      ;DON'T WANT ".." OR "." DIRECTORIES
 JE NOTOKDIR
 INC SUBDIRS
 PUSH SI CX
 MOV SI,CURDEST
 STD
 DEC SI
 XOR CX,CX
SCANFSL:INC CX
 LODSB
 CMP AL,"\"
 JNE SCANFSL
 INC SI
 PUSH SI CX
 CLD
 MOV CX,SI
 MOV SI,CURPATH
 SUB CX,SI
 MOV DI,NEXTPATH
 REP MOVSB
 MOV AL,"\"
 STOSB
 MOV SI,BP
 ADD SI,9
COPDIR:LODSB
 OR AL,AL
 JZ ENDDIRC
 STOSB
 JMP COPDIR
ENDDIRC:POP CX SI
 REP MOVSB
 MOV SI,CURDEST
SCANSFL:LODSB
 OR AL,AL
 JE OKFLSL
 CMP AL,"\"
 JNE SCANSFL
 MOV BX,SI
 JMP SCANSFL
OKFLSL:MOV CX,BX
 MOV SI,CURDEST
 SUB CX,SI
 REP MOVSB
 CMP NOCREATE,1
 JE COPDIRE
 PUSH SI
 MOV SI,BP
 ADD SI,9
COPDIRD:LODSB
 OR AL,AL
 JZ ENDDIRCD
 STOSB
 JMP COPDIRD
ENDDIRCD:POP SI
 MOV AL,"\"
 STOSB
COPDIRE:LODSB
 STOSB
 OR AL,AL
 JZ ENDDIRCE
 JMP COPDIRE
ENDDIRCE:MOV AL,PRIORITY
 STOSB
 MOV NEXTPATH,DI
 XOR AL,AL
 STOSB
 POP CX SI
ENDDIR:DEC CX
 JZ NOSUBDIRS
 JMP SCANDIRS


NOSUBDIRS: ;JUMP HERE SO AS NOT TO COPY SUBDIRECTORIES

 MOV DI,50000
 MOV FILES,0
 MOV AH,4EH
 MOV CX,ATTRCOPY ;FILE ATTRIBUTE MUST BE PUT IN HERE NB!!! (7 TO INCLUDE ALL)
 MOV DX,CURPATH
 INT 21H
 JNC FINDNEXTF
 CMP AX,3
 JNE NOFILESF
 MOV AH,9
 MOV DX,OFFSET BADSPATH
 INT 21H
 JMP TURBOCOPY
NOFILESF:MOV AH,9
 MOV DX,OFFSET EMPDIR
 INT 21H
 JMP TURBOCOPY
FINDNEXTF:MOV SI,OFFSET TYPEMSG+21
 CMP ARCHIVE,0
 JE NOARC
 MOV AL,DS:[SI]
 AND AL,32
 JZ NTFILE
NOARC:CMP DATE,1
 JNE NODATE2
 MOV AX,DS:[SI+3]
 MOV CL,AH
 SHR CL,1
 XOR CH,CH
 ADD CX,1980
 CMP CX,YEAR
 JA YTFILE
 JB NTFILE
 MOV CX,AX
 SHR CX,1
 SHR CX,1
 SHR CX,1
 SHR CX,1
 SHR CX,1
 AND CX,15
 CMP CX,MONTH
 JA YTFILE
 JB NTFILE
 AND AX,31
 CMP AX,DAY
 JB NTFILE
NODATE2:

;CHECK HERE IF FILE IS OK TO COPY ELSE: JMP NTFILE



YTFILE:MOV CX,11
 REP MOVSW
 INC FILES
NTFILE:MOV AH,4FH
 INT 21H
 JNC FINDNEXTF
 MOV CX,FILES
 JCXZ NOFILESF
 MOV SI,50005
 MOV FLOPSIZ36,0
 MOV FLOPSIZ12,0
FLSIZES:XOR DX,DX
 LODSW
 ADD AX,511
 ADC DX,DS:[SI]
 ADD SI,20
 PUSH AX DX
 MOV BX,512
 DIV BX
 ADD FLOPSIZ12,AX
 POP DX AX
 ADD AX,512
 ADC DX,0
 MOV BX,1024
 DIV BX
 ADD FLOPSIZ36,AX
 LOOP FLSIZES
 MOV AX,FLOPSIZ36
 ADD AX,353
 XOR DX,DX
 MOV BX,354
 DIV BX
 MOV FLOPSIZ36,AX
 MOV AX,FLOPSIZ12
 ADD AX,2370
 XOR DX,DX
 MOV BX,2371
 DIV BX
 MOV FLOPSIZ12,AX
 MOV CX,FILES
 MOV SI,50005
 XOR BX,BX
 XOR DX,DX
CSIZES:LODSW
 ADD BX,AX
 LODSW
 ADC DX,AX
 ADD SI,18
 LOOP CSIZES
 MOV DI,OFFSET TYPEMSG
 PUSH DI
 MOV AL,32
 STOSB
 MOV AX,BX
 CALL BINTODEC
 MOV SI,OFFSET FILBYT
 MOV CX,10
 REP MOVSB
 MOV AX,FILES
 XOR DX,DX
 CALL BINTODEC
 MOV CX,13
 REP MOVSB
 CMP FILES,1
 JNE NOTONEFILE
 DEC DI
NOTONEFILE:MOV AX," ."
 STOSW
 MOV AL,"("
 STOSB
 MOV AX,FLOPSIZ36
 XOR DX,DX
 CALL BINTODEC
 MOV AX,"3x"
 STOSW
 MOV AX,"06"
 STOSW
 MOV AX,",K"
 STOSW
 MOV AL," "
 STOSB
 MOV AX,FLOPSIZ12
 XOR DX,DX
 CALL BINTODEC
 MOV AX,"1x"
 STOSW
 MOV AX,"2."
 STOSW
 MOV AX,")M"
 STOSW
 MOV AX," ."
 STOSW
 MOV AX,SUBDIRS
 OR AX,AX
 JE NOSUBDIRSA
 XOR DX,DX
 CALL BINTODEC
 MOV CX,15
 REP MOVSB
 CMP SUBDIRS,1
 JNE NOTONESDIR
 SUB DI,3
 MOV AL,"y"
 STOSB
NOTONESDIR:MOV AL,"."
 STOSB
NOSUBDIRSA:MOV AX,13+10*256
 STOSW
 MOV AL,"$"
 STOSB
 POP DX
 MOV AH,9
 INT 21H
 MOV DI,NEXTPATH
 INC DI
SCANFMAIN:MOV SI,50000
 XOR DX,DX
 XOR CX,CX  ;DX:CX IS SIZE OF FILE
 XOR BP,BP  ;DS:BP IS OFFSET OF FILE
 MOV BX,FILES
SCANFFIL:LODSB
 DEC SI
 CMP AL,255
 JE SCANFNEXT
 CMP DX,DS:[SI+7]
 JA SCANFNEXT
 JB OKFOUNDL
 CMP CX,DS:[SI+5]
 JA SCANFNEXT
OKFOUNDL:MOV DX,DS:[SI+7]
 MOV CX,DS:[SI+5]
 MOV BP,SI
SCANFNEXT:ADD SI,22
 DEC BX
 JNZ SCANFFIL
 OR BP,BP
 JE FINSORT
 MOV CX,22
 MOV SI,BP
 XOR AL,AL
 STOSB
 REP MOVSB
 MOV DS:[BP],BYTE PTR 255
 JMP SCANFMAIN
FINSORT:



;HERE IS THE MAIN COPY ROUTINE:
;GET SIZE OF DISK; CREATE DIRECTORIES; COPY FILES; PROMPT FOR NEW DISK; REDO

MAINCOPY:MOV ROPEN,0 ;NO FILES ARE OPEN
 MOV DI,OFFSET TYPEMSG
 PUSH DI
 MOV AL,32
 STOSB
 MOV SI,CURDEST
 LODSB
 SUB AL,64
 MOV DL,AL
 MOV AH,36H
 INT 21H
 CMP AX,65535
 JNE DESTOK1
 POP DX
 MOV DX,OFFSET BADDEST2
 MOV AH,9
 INT 21H
 JMP BOMB
DESTOK1:MUL CX
 MOV ALLOC,AX
 MOV FREEALC,BX
 MUL BX
 CALL BINTODEC
 MOV SI,OFFSET DAVAIL
 MOV CX,41
 REP MOVSB
 POP DX
 MOV AH,9
 INT 21H
 CMP PROMPT,1
 JNE OKCOPY1AB
 CMP YESNO,1
 JE OKCOPY1AB
 MOV YESNO,1
 MOV DX,OFFSET PROMPTMSG
 MOV AH,9
 INT 21H
GETREP1LB:MOV AH,8
 INT 21H
 CMP AL,"a"
 JB GR1LB
 CMP AL,"z"
 JA GR1LB
 SUB AL,32
GR1LB:CMP AL,"Y"
 JNE GRNSLB
 JMP GR2LB
GRNSLB:CMP AL,"N"
 JNE GETREP1LB
GR2LB:MOV DL,AL
 PUSH AX
 MOV AH,2
 INT 21H
 MOV DL,13
 INT 21H
 MOV DL,10
 INT 21H
 POP AX
 CMP AL,"Y"
 JE OKCOPY1AB
 JMP TURBOCOPY
OKCOPY1AB:MOV FILYET,16
 MOV AH,4EH
 XOR CX,CX
 MOV DX,CURDEST
 INT 21H
 JNC DPATHOKZ
 CMP AX,3
 JNE DPATHOKZ
 MOV AH,9
 MOV DX,OFFSET CRDIR
 INT 21H
 MOV SI,CURDEST
 ADD SI,3
FINDBSL1:LODSB
 OR AL,AL
 JE DPATHOKX
 CMP AL,"\"
 JNE FINDBSL1
 DEC SI
 MOV DS:[SI],BYTE PTR 0
 MOV DX,CURDEST
 MOV AH,39H
 INT 21H
 PUSHF
 DEC FREEALC
 POPF
 JC BADCREAT
 MOV FILYET,2
 JMP OKCREAT
BADCREAT:INC FREEALC
 CMP AL,3
 JE NOCREAT
OKCREAT:MOV DS:[SI],BYTE PTR "\"
 INC SI
 JMP FINDBSL1
DPATHOKX:SAHF
 JNC DPATHOKZ
NOCREAT:MOV AH,9
 MOV DX,OFFSET BADCDIR
 INT 21H
 JMP TURBOCOPY
DPATHOKZ:MOV SI,CURDEST
 LODSB
 SUB AL,64
 MOV DL,AL
 MOV AH,36H
 INT 21H
 MUL CX
 MOV FREEALC,BX
 MOV RESERVE,0
 MOV SI,NEXTPATH
SCNAF1:LODSB
 OR AL,AL
 JNE SCNAF1
 STD
 DEC SI
SCNAF:LODSB
 CMP AL,"\"
 JNE SCNAF
 CLD
 LODSB
 CMP AL,":"
 JE ROOTOK
 MOV RESERVE,1
ROOTOK:MOV SI,NEXTPATH
 INC SI
 MOV CX,FILES
 MOV FIL2COPY,0
 MOV ALLFIL,0
 MOV AX,FREEALC
MARKFILES:LODSB  ;FILES TO COPY=16,0=NOT COPIED YET
 DEC SI
 CMP AL,255
 JE MARKNEXT
 CMP AL,16
 JNE NOTALMARK
 MOV DS:[SI],BYTE PTR 0
NOTALMARK:MOV AX,DS:[SI+6]
 MOV DX,DS:[SI+8]
 MOV BX,ALLOC
 DEC BX
 ADD AX,BX
 JNC NOOVER1
 INC DX
NOOVER1:DIV ALLOC
 MOV BX,FREEALC
 ;ADJUST BX TO INCLUDE DIRECTORIES
 CMP RESERVE,0
 JE NOTRESOK
 PUSH AX
 MOV AX,FIL2COPY
 ADD AX,FILYET
 MOV DL,16
 DIV DL
 XOR AH,AH
 SUB BX,AX
 POP AX
 JNC NOTRESOK
 JMP MARKNEXT
NOTRESOK:CMP AX,BX
 JNA NOMARKNEXT
 MOV ALLFIL,255
 JMP MARKNEXT
NOMARKNEXT:SUB FREEALC,AX
 MOV DS:[SI],BYTE PTR 16
 INC FIL2COPY
MARKNEXT:ADD SI,23
 LOOP MARKFILES
 CMP FIL2COPY,0
 JNZ OKCOPYA
 MOV DX,OFFSET NFTC
 MOV AH,9
 INT 21H
 JMP NEWDISK
OKCOPYA:CMP ALLFIL,0
 JE OKCOPY
 CMP PROCEED,1
 JE OKCOPY
 MOV SI,CURDEST
 LODSB
 MOV BL,AL
 SUB BL,64
 MOV AX,44H*256+8
 INT 21H
 JC NONREMA
 OR AX,AX
 JNZ NONREMA
 JMP OKCOPY
NONREMA:ADD BL,64
 MOV CS:[OFFSET DISKLESS2],BL
 MOV DX,OFFSET DISKLESS
 MOV AH,9
 INT 21H
GETREP1L:MOV AH,8
 INT 21H
 CMP AL,"a"
 JB GR1L
 CMP AL,"z"
 JA GR1L
 SUB AL,32
GR1L:CMP AL,"A"
 JNE GRNSL
 JMP GR2L
GRNSL:CMP AL,"P"
 JNE GETREP1L
GR2L:MOV DL,AL
 PUSH AX
 MOV AH,2
 INT 21H
 MOV DL,13
 INT 21H
 MOV DL,10
 INT 21H
 POP AX
 MOV PROCEED,1
 CMP AL,"P"
 JE OKCOPY
 JMP BOMB
OKCOPY:MOV DX,FILES
BUBSORT:MOV SI,NEXTPATH
 INC SI
 DEC DX
 OR DX,DX
 JZ SORTED
 MOV CX,DX
BUBSORT2:MOV DI,SI
 ADD DI,23
 LODSB
 DEC SI
 CMP AL,16
 JNE BUBSORTNXT
 CMP ES:[DI],BYTE PTR 16
 JNE OKSWAP
 PUSH SI DI CX
 ADD SI,10
 ADD DI,10
 MOV CX,13
 REP CMPSB
 POP CX DI SI
 JA OKSWAP
 JMP BUBSORTNXT
OKSWAP:PUSH SI CX
 MOV CX,23
SWAP:LODSB
 MOV AH,ES:[DI]
 STOSB
 MOV DS:[SI-1],AH
 LOOP SWAP
 POP CX SI
BUBSORTNXT:ADD SI,23
 LOOP BUBSORT2
 JMP BUBSORT
SORTED:MOV AX,FILES
 MOV BX,23
 MUL BX
 ADD AX,NEXTPATH
 ADD AX,16
 MOV CL,4
 SHR AX,CL
 MOV READPARA,AX  ;READPARA CONTAINS CURRENT PARAGRAPH FROM CS, MEM=MAX PARAS
 MOV BEGINPARA,AX
 MOV DX,OFFSET READMSG
 MOV AH,9
 INT 21H
 MOV SI,NEXTPATH
 INC SI
 MOV CX,FILES
 MOV FREAD,0
SCANFORFIL:LODSB
 DEC SI
 CMP AL,16
 JNE SCNEXTFIL
 JMP DOREAD
SCNEXTFIL:ADD SI,23
 LOOP SCANFORFIL
 PUSH CX SI
 CALL WRITE
 POP SI CX
OKDISKEND:MOV AX,FIL2COPY
 SUB FILES,AX
 JNZ NENDOFDIR
 JMP ENDOFDIR
NENDOFDIR:MOV AH,2
 MOV DL,13
 INT 21H
 MOV DL,10
 INT 21H
 MOV DL,13
 INT 21H
 MOV DL,10
 INT 21H
 JMP MAINCOPY
NEWDISK:PUSH CS
 POP DS
 MOV SI,CURDEST
 LODSB
 MOV DI,OFFSET NEWDMSG2
 STOSB
 MOV BL,AL
 SUB BL,64
 MOV AX,44H*256+8
 INT 21H
 JC NONREM
 OR AX,AX
 JZ REMOK
NONREM:ADD CS:[OFFSET DISKFULL2],BL
 MOV DX,OFFSET DISKFULL
 MOV AH,9
 INT 21H
 JMP BOMB
REMOK:MOV CX,FILES
 MOV SI,NEXTPATH
 ADD SI,7
 XOR BX,BX
 XOR DX,DX
CSIZES2:LODSW
 ADD BX,AX
 LODSW
 ADC DX,AX
NOTADD1:ADD SI,19
 LOOP CSIZES2
 MOV DI,OFFSET TYPEMSG
 MOV SI,OFFSET STCOPY1
 MOV CX,19
 REP MOVSB
 PUSH DX
 XOR DX,DX
 MOV AX,FILES
 CALL BINTODEC
 MOV CX,5
 REP MOVSB
 CMP FILES,1
 JE ONEFILE
 MOV AL,"s"
 STOSB
ONEFILE:MOV CX,12
 REP MOVSB
 POP DX
 MOV AX,BX
 CALL BINTODEC
 MOV CX,8
 REP MOVSB
 MOV DX,OFFSET TYPEMSG
 MOV AH,9
 INT 21H
 MOV DX,OFFSET NEWDMSG
 MOV AH,9
 INT 21H
 MOV DI,OFFSET TYPEMSG
 PUSH DI
 INC DISKS
 MOV AX,DISKS
 XOR DX,DX
 CALL BINTODEC
 MOV AL,"$"
 STOSB
 POP DX
 MOV AH,9
 INT 21H
 MOV DX,OFFSET NEWDMSG1
 MOV AH,9
 INT 21H
 MOV AH,8
 INT 21H
 AND AL,223
 CMP AL,"S"
 JE SHELLDOS
 JMP MAINCOPY
SHELLDOS:PUSH CS
 POP ES
 MOV BX,23
 MOV AX,FILES
 MUL BX
 ADD AX,NEXTPATH
 ADD AX,15
 MOV CL,4
 SHR AX,CL
 MOV BX,AX
 MOV AH,4AH
 INT 21H
 MOV AX,SS
 MOV BX,SP
 MOV WORD PTR WAITMSG,AX
 MOV WORD PTR WAITMSG[2],BX
 MOV DI,OFFSET SHPARM+2
 MOV [DI],OFFSET PARM
 MOV [DI+2],CS

 PUSH AX CX DS ES SI DI
 MOV AX,CS:[2CH]
 MOV DS,AX
 XOR SI,SI
 PUSH CS
 POP ES
GETCOMSPECLP:LODSB
 OR AL,AL
 JNZ CHKCOM
 CMP DS:[SI],AL
 JNE GETCOMSPECLP
 PUSH CS
 POP DS
 MOV SI,OFFSET SHELL
 JMP GOTSPEC2
CHKCOM:CMP AL,"C"
 JNE GETCOMSPECLP
 MOV DI,OFFSET COMSPEC
 PUSH SI
 MOV CX,7
 REPE CMPSB
 JCXZ GOTSPEC
 POP SI
 JMP GETCOMSPECLP
GOTSPEC:POP AX
GOTSPEC2:MOV DI,OFFSET SHELL
GOTSPEC3:LODSB
 STOSB
 OR AL,AL
 JNZ GOTSPEC3
 POP DI SI ES DS CX AX

 MOV AX,4BH*256
 MOV DX,OFFSET SHELL
 MOV BX,OFFSET SHPARM
 INT 21H
 MOV AX,WORD PTR WAITMSG
 MOV BX,WORD PTR WAITMSG[2]
 CLI
 MOV SS,AX
 MOV SP,BX
 STI
 JNC OVLOK
 MOV DX,OFFSET ERRLOAD
 MOV AH,9
 PUSH CS
 POP DS
 INT 21H
OVLOK:PUSH CS
 POP ES
 MOV BX,MEM
 MOV AH,4AH
 INT 21H
 JNC OVLOKMEM
 PUSH CS
 POP DS
 MOV AH,9
 MOV DX,OFFSET RECERR
 INT 21H
 JMP BOMB
OVLOKMEM:DEC DISKS
 JMP NEWDISK

;WRITE FILES THAT ARE STILL TO BE WRITTEN

;SUBTRACT FIL2COPY FROM FILES (PERMANENTLY)
;IF NOT ZERO JMP TO ROUTINE THAT ASKS FOR NEW DISK
;ELSE JUMP TO TURBOCOPY

ENDOFDIR:JMP TURBOCOPY

DOREAD:PUSH CX SI
 ADD SI,10
 MOV DX,SI
PRNAME:LODSB
 OR AL,AL
 JNZ PRNAME
 CALL PRFILENAME
 MOV SI,CURDEST
 STD
GETSLL:LODSB
 CMP AL,"\"
 JNE GETSLL
 CLD
 MOV CX,SI
 MOV SI,CURPATH
 SUB CX,SI
 INC CX
 INC CX
 MOV DI,OFFSET PROTECT
 REP MOVSB
 POP SI
 PUSH SI
 ADD SI,10
 MOV CX,13
 REP MOVSB
 POP SI
 PUSH SI
 MOV AX,DS:[SI+6]
 MOV WORD PTR FSIZ,AX
 MOV AX,DS:[SI+8]
 MOV WORD PTR FSIZ[2],AX
 INC FREAD
 MOV AX,3DH*256+160
 MOV DX,OFFSET PROTECT
 INT 21H
 MOV RHANDLE,AX
 JNC OPENFREAD
 JMP ERRREADF2

OPENFREAD:MOV AX,CS
 ADD AX,READPARA
 MOV DS,AX
 MOV CX,CS
 ADD CX,MEM
 SUB CX,AX
 JNZ STILLMEM
 CALL WRITE
 PUSH CS
 POP DS
 MOV AX,BEGINPARA
 MOV READPARA,AX
 POP SI
 PUSH SI
 CMP DS:[SI],BYTE PTR 255
 JNE NCLOSEF
 POP SI CX
 MOV AH,3EH
 MOV BX,RHANDLE
 INT 21H
 JNC ERRREADF2NO
 JMP ERRREADF2
ERRREADF2NO:CMP ARCHIVE,1
 JNE NOARC2B
 PUSH CX
 MOV AX,1+43H*256
 MOV CL,DS:[SI+1]
 AND CL,223
 XOR CH,CH
 MOV DX,OFFSET PROTECT
 INT 21H
 POP CX
 JNC NOARC2B
 MOV AH,9
 MOV DX,OFFSET ARCERR
 INT 21H
 JMP BOMB
NOARC2B:MOV AX,FREAD
 CMP AX,FIL2COPY
 JNE OKOK
 JMP OKDISKEND
OKOK:MOV AH,9
 MOV DX,OFFSET READMSG
 INT 21H
 JMP SCNEXTFIL
NCLOSEF:MOV AH,9
 MOV DX,OFFSET READMSG
 INT 21H
 ADD SI,10
 MOV DX,SI
PRNAMEB:LODSB
 OR AL,AL
 JNZ PRNAMEB
 CALL PRFILENAME
 JMP OPENFREAD

STILLMEM:CMP CX,4095
 JNA NOT2MUCH
 MOV CX,4095
NOT2MUCH:SHL CX,1
 SHL CX,1
 SHL CX,1
 SHL CX,1
 PUSH CX
 MOV AH,3FH
 MOV BX,RHANDLE
 XOR DX,DX
 INT 21H
 PUSH CS
 POP DS
 POP CX
 JNC READFOK1
ERRREADF: ;ERROR READING SOURCE FILE
 MOV AH,3EH
 MOV BX,RHANDLE
 INT 21H
ERRREADF2:MOV DX,OFFSET ERRRFIL
 MOV AH,9
 INT 21H
 JMP BOMB

READFOK1:CMP AX,CX
 JNE NLOTSLEFT
 SUB WORD PTR FSIZ,AX
 JNC NOCARRYZ
 DEC WORD PTR FSIZ[2]
NOCARRYZ:SHR CX,1
 SHR CX,1
 SHR CX,1
 SHR CX,1
 ADD READPARA,CX
 JMP OPENFREAD
NLOTSLEFT:SUB WORD PTR FSIZ,AX
 JNC NOCARRYW
 DEC WORD PTR FSIZ[2]
NOCARRYW:CMP WORD PTR FSIZ,0
 JNZ ERRREADF
 CMP WORD PTR FSIZ[2],0
 JNZ ERRREADF
 ADD AX,15
 SHR AX,1
 SHR AX,1
 SHR AX,1
 SHR AX,1
 ADD READPARA,AX
CLOSEF:POP SI CX
 MOV AH,3EH
 MOV BX,RHANDLE
 INT 21H
 JC ERRREADF2
 CMP ARCHIVE,1
 JNE NOARC2
 PUSH CX
 MOV AX,1+43H*256
 MOV CL,DS:[SI+1]
 AND CL,223
 XOR CH,CH
 MOV DX,OFFSET PROTECT
 INT 21H
 POP CX
 JNC NOARC2
 MOV AH,9
 MOV DX,OFFSET ARCERR
 INT 21H
 JMP BOMB
NOARC2:JMP SCNEXTFIL

WRITE:;WRITES FILES FROM THE BEGINNING TO END, ROPEN=1 FIRST FILE ALREADY OPEN
 PUSH CS
 POP DS
 MOV DX,OFFSET WRITEMSG
 MOV AH,9
 INT 21H
 MOV AX,BEGINPARA
 MOV WRITEPARA,AX
 MOV SI,NEXTPATH
 INC SI
 MOV CX,FILES
SCANFORFILW:LODSB
 DEC SI
 CMP AL,16
 JE DOWRITE
SCANFNEXTW:ADD SI,23
 LOOP SCANFORFILW

 ;FINISHED WRITING
 RET

DOWRITE:PUSH CX SI
 ADD SI,10
 PUSH CS
 POP DS
 MOV DI,OFFSET TYPEMSG
 MOV CX,8
 PUSH DI
 MOV AL,32
 REP STOSB
 MOV AL,"."
 STOSB
 MOV AL,32
 MOV CX,3
 REP STOSB
 POP DI
CHFNAM:LODSB
 CMP AL,"."
 JNE NOTDOTZ
 JMP DOEXTB
NOTDOTZ:OR AL,AL
 JZ ENDCHFNAM
 STOSB
 JMP CHFNAM
DOEXTB:MOV DI,OFFSET TYPEMSG+9
COPYEXT1:LODSB
 OR AL,AL
 JZ ENDCHFNAM
 STOSB
 JMP COPYEXT1
ENDCHFNAM:MOV DI,OFFSET TYPEMSG
 MOV SI,OFFSET RENFILE
 MOV CX,12
CPFN:LODSB
 INC DI
 CMP AL,"?"
 JE NXTCPFN
 DEC DI
 STOSB
NXTCPFN:LOOP CPFN
 MOV SI,OFFSET TYPEMSG
 MOV DI,OFFSET TYPEMSG+100
 MOV CX,12
CPFNB:LODSB
 CMP AL,32
 JE NOTST
 STOSB
NOTST:LOOP CPFNB
 CMP ES:[DI-1],BYTE PTR "."
 JNE NOTMINDI
 DEC DI
NOTMINDI:XOR AL,AL
 STOSB
 MOV SI,OFFSET TYPEMSG+100
 MOV DX,SI
PRNAMEW:LODSB
 OR AL,AL
 JNZ PRNAMEW
 CALL PRFILENAME
 MOV SI,CURDEST
GETENDD:LODSB
 OR AL,AL
 JNZ GETENDD
 STD
GETSLLW:LODSB
 CMP AL,"\"
 JNE GETSLLW
 CLD
 MOV CX,SI
 MOV SI,CURDEST
 SUB CX,SI
 INC CX
 INC CX
 MOV DI,OFFSET TYPEMSG
 REP MOVSB
 MOV SI,OFFSET TYPEMSG+100
 MOV CX,13
 REP MOVSB
 POP SI
 PUSH SI
 CMP ROPEN,1
 JNE NOTALROPEN
 JMP ALROPEN
NOTALROPEN:CMP OVERWRITE,1
 JNE OVEROFF
 JMP NOTEXISTYET
 ;CHECK IF FILE ALREADY EXISTS
 ;JUMP TO NOTEXISTYET IF OVERWRITE=ON
OVEROFF:MOV AX,3DH*256
 MOV DX,OFFSET TYPEMSG
 INT 21H
 JNC EXISTYET
 JMP NOTEXISTYET
EXISTYET:MOV BX,AX
 MOV AH,3EH
 INT 21H
 CMP APPEND,1
 JNE NOAPPB
 JMP DOAPP
NOAPPB:MOV DX,OFFSET OVERMSG
 MOV AH,9
 INT 21H
GETREP1:MOV AH,8
 INT 21H
 CMP AL,"a"
 JB GR1
 CMP AL,"z"
 JA GR1
 SUB AL,32
GR1:CMP AL,"E"
 JNE GR1AB
 JMP GR2
GR1AB:CMP AL,"S"
 JNE GRNS
 JMP GR2
GRNS:CMP AL,"A"
 JNE GRNSB
 JMP GR2
GRNSB:CMP AL,"O"
 JNE GETREP1
GR2:MOV DL,AL
 PUSH AX
 MOV AH,2
 INT 21H
 MOV DL,13
 INT 21H
 MOV DL,10
 INT 21H
 POP AX
 CMP AL,"A"
 JNE NOTAO
 MOV OVERWRITE,1
 JMP NOTEXISTYET
NOTAO:CMP AL,"O"
 JE NOTEXISTYET
 CMP AL,"E"
 JNE NOTAPPEND
DOAPP:MOV AX,3DH*256+146
 MOV DX,OFFSET TYPEMSG
 INT 21H
 JNC APPOK1
 JMP ERROPENW
APPOK1:MOV BX,AX
 MOV WHANDLE,AX
 XOR CX,CX
 XOR DX,DX
 MOV AX,42H*256+2
 INT 21H
 JNC APPOK2
 MOV AH,3EH
 INT 21H
 JMP ERROPENW
APPOK2:JMP APPOPEN
NOTAPPEND:POP SI
 PUSH SI
 MOV BYTE PTR DS:[SI],255
 MOV ROPEN,0
 ADD DS:[SI+6],WORD PTR 15
 JNC ADWRPARA
 INC WORD PTR DS:[SI+8]
ADWRPARA:SUB WORD PTR DS:[SI+8],1
 JC ADWRPARA2
 ADD WRITEPARA,4096
 JC NOTSLEFT1
 JMP ADWRPARA
ADWRPARA2:MOV AX,WORD PTR DS:[SI+6]
 MOV CL,4
 SHR AX,CL
 ADD WRITEPARA,AX
 MOV AX,WRITEPARA
 CMP AX,MEM
 JB STILLLEFT2W
NOTSLEFT1:POP SI CX
 RET
STILLLEFT2W:POP SI CX
 MOV AH,2
 MOV DL,13
 INT 21H
 MOV DL,10
 INT 21H
 JMP SCANFNEXTW


NOTEXISTYET:MOV AH,3CH
 MOV CL,DS:[SI+1]
 XOR CH,CH
 MOV DX,OFFSET TYPEMSG
 INT 21H
 JNC OPENOKW

ERROPENW:MOV AH,9
 MOV DX,OFFSET ERRWFIL
 INT 21H
 JMP BOMB
OPENOKW:MOV WHANDLE,AX
APPOPEN:MOV AX,DS:[SI+6]
 MOV WORD PTR WSIZ,AX
 MOV AX,DS:[SI+8]
 MOV WORD PTR WSIZ[2],AX
ALROPEN:

MAINWRITE:MOV AX,CS
 ADD AX,WRITEPARA
 MOV DS,AX
 MOV CX,CS
 ADD CX,MEM
 SUB CX,AX
 JNZ STILLMEMW

 ;WROTE EVERYTHING IN MEMORY
 POP SI CX
 MOV ROPEN,1
 RET

STILLMEMW:CMP CX,4095
 JNA NOT2MUCHW
 MOV CX,4095
NOT2MUCHW:SHL CX,1
 SHL CX,1
 SHL CX,1
 SHL CX,1
 PUSH DS CS
 POP DS
 CMP DS:[SI+8],WORD PTR 0
 JNE GOAHEAD
 CMP CX,DS:[SI+6]
 JNA GOAHEAD
 MOV CX,DS:[SI+6]
GOAHEAD:POP DS
 XOR DX,DX
 MOV BX,WHANDLE
 MOV AH,40H
 PUSH CX CS
 INT 21H
 POP DS CX
 JC WERR1
 CMP CX,AX
 JE WROK1
WERR1:MOV AH,3EH
 MOV BX,WHANDLE
 INT 21H
WERR2:JMP ERROPENW

WROK1:SUB DS:[SI+6],CX
 JNC NOCARRYD
 DEC WORD PTR DS:[SI+8]
NOCARRYD:ADD WORD PTR TOTBYTES,CX
 JNC TOTNOVER
 INC WORD PTR TOTBYTES[2]
TOTNOVER:ADD CX,15
 SHR CX,1
 SHR CX,1
 SHR CX,1
 SHR CX,1
 ADD WRITEPARA,CX
 CMP DS:[SI+6],WORD PTR 0
 JE MAINWRITEOK1
 JMP MAINWRITE
MAINWRITEOK1:CMP DS:[SI+8],WORD PTR 0
 JE MAINWRITEOK2
 JMP MAINWRITE
MAINWRITEOK2:MOV ROPEN,0
 PUSH CS
 POP DS
 MOV BX,WHANDLE
 MOV AX,87*256+1
 MOV CX,CS:[SI+2]
 MOV DX,CS:[SI+4]
 INT 21H
 JC WERR2
 MOV AH,3EH
 MOV BX,WHANDLE
 INT 21H
 JC WERR2
 POP SI CX
 MOV DS:[SI],BYTE PTR 255
 INC WORD PTR TOTFILES
 JNC TOTFNOVER
 INC WORD PTR TOTFILES[2]
TOTFNOVER:JMP SCANFNEXTW
;PRFILENAME:ROUTINE TO PRINT FILENAME FROM DS:DX
PRFILENAME:PUSH CX SI DX
 MOV SI,DX
 MOV AH,3
 XOR BH,BH
 INT 10H
 CMP DL,11
 JB BEGLIN
PRFN2:INC DL
 LODSB
 OR AL,AL
 JNE PRFN2
 CMP DL,78
 JNA OKNOTNEWLIN
 MOV AH,2
 MOV DL,10
 INT 21H
BEGLIN:MOV AH,2
 MOV DL,13
 INT 21H
 MOV CX,11
 MOV DL,32
PRFN3LP:INT 21H
 LOOP PRFN3LP
OKNOTNEWLIN:MOV AH,3
 XOR BH,BH
 INT 10H
 CMP DL,12
 JB NOCOMMA
 MOV AH,2
 MOV DL,","
 INT 21H
 MOV DL," "
 INT 21H
NOCOMMA:POP DX
 MOV SI,DX
 MOV AH,2
PRFNLP1:LODSB
 OR AL,AL
 JZ PRFNLP2
 MOV DL,AL
 INT 21H
 JMP PRFNLP1
PRFNLP2:POP SI CX
 RET


PROGEND LABEL BYTE
CSEG ENDS
 END START
