{
  INFODIFR.PAS

  Ce fichier est la source en version franaise de INFODISK 1.00.
  Il a besoin de Turbo Pascal 6.0 minimum pour tre compil car il contient
  du code assembleur. Si ce code est converti en inline, il peut alors tre
  compil avec des versions antrieures (TP 4 ou TP 5).

  Ce fichier peut tre copi et distribu librement pour tout usage non
  commercial.

  Si vous avez des modifications  y apporter, merci de m'en faire part afin
  que je puisse les intgrer dans une nouvelle version.

  Pour toute question ou suggestion, envoyez-moi un mail  :
      p6ip329@cicrp.jussieu.fr     jusqu' mi-septembre 1995,
  ou
      willy@U40024.citi2.fr        aprs cette date.
  (dans une future version, je donnerai ma nouvelle adresse)

  Vous pouvez aussi m'crire  l'adresse suivante:

      Willy TARREAU
      23, rue Richepanse
      78500 Sartrouville
      FRANCE


      PS: j'accepte aussi les cartes postales   :-)

                                                                     Willy.
}


uses temps;

const hextab : array [0..15] of char = '0123456789ABCDEF';
      NbTours = 200;
      numdsk : shortint = -1;   { signifie qu'on teste les 2 disques }
      dump   : boolean = false;
      inverse: boolean = true;

var b : array [0..511] of byte;
    c : array [0..511] of char absolute B;
    w : array [0..255] of word absolute B;
    s : string [50];
    ch : char;
    LngDump : word;
    ChParam   : string;

Procedure Delay1;
begin
  tempsazero;
  while (tempsactuel<10000) do;
{ delay(1);}
end;

function intstr(s : string) : integer;
var i,j : integer;
begin
  val(s,i,j);
  intstr:=i;
end;

function Hexb(b : byte) : string;
begin
  hexb:=hextab[b shr 4 and 15]+hextab[b and 15];
end;

Procedure Pret;
var i : word;
begin
  i:=1000;
  while ((port[$1F7] and $80)>0) and (i>0) do
  begin
    dec(i);
    delay1;
  end;
end;

Function Error : byte;
begin
  if (port[$1F7] and 1)=0 then Error:=0
                          else Error:=port[$1F1];
end;

Procedure ResetDsk;
begin
  port[$3f6]:=4;
  delay1;
  port[$3f6]:=0;
  Pret;
end;

Procedure ChgDsk(d : byte);
begin
  port[$1F6]:=$A0 or (d and 1) shl 4;
  Pret;
end;

Procedure Commande(c : byte);
begin
  port[$1f7]:=c;
  Pret;
end;

Procedure LitID;
var i : word;
begin
  fillchar(b,512,0);
  Commande($EC);
  if error>0 then exit;
  i:=0;
  while ((port[$1F7] and 8)>0) and (i<256) do
  begin
    w[i]:=portw[$1f0];
    inc(i);
  end;
end;

Procedure Nettoie(var s : string);
begin
  while (s[0]>#0) and (s[1]<=#32) do
    delete(s,1,1);
  while pos('  ',s)>0 do
    delete(s,pos('  ',s),1);
  if s[length(s)]=' ' then dec(s[0]);
end;


Function VitsRot : word;
var t : real;
    i : word;
    e : boolean;
begin
  e:=false;
  TempsAZero;
  for i:=1 to NbTours do
  asm
      mov    dx,1F7h
      xor    cx,cx
    @@1:
      in     al,dx
      test   al,2
      loopz  @@1
      jz     @@4
      xor    cx,cx
    @@2:
      in     al,dx
      test   al,2
      loopnz @@2
      jz     @@3
    @@4:
      mov    i,NbTours      { fin }
      mov    E,1
    @@3:
  end;
  if not e then
    t:=i/SecEnReel*60
  else
    t:=0;
  VitsRot:=round(t);
end;

Procedure Identifie(d : byte);
var cyl,tet,bpt,bps,bpsf,spt : word;
    cac : word;
    i,j : word;
    id,tol : byte;
    cap : longint;

begin
  write('Disque physique ',d,' : ');
  ResetDsk;
  chgdsk(d);
  if Error>0 then writeln('Erreur n',error,' avant l''identification.')
  else
  begin
    LitID;
    if Error>0 then writeln('Erreur n',error,' pendant l''identification.')
    else
    if dump then
    begin
      writeln('L''identification a donn les codes suivants : ');
      writeln;
      for i:=0 to ((LngDump+15) shr 4)-1 do
      begin
        write(hexb(hi(i*16)),hexb(lo(i*16)),':  ');
        for j:=0 to 15 do
          write(hexb(b[i*16+j]),' ');
        write('   ');
        for j:=0 to 15 do
        begin
          ch:=char(b[i*16+j]);
          if (ch<#32) or (ch>#160) then
            write('.')
          else
            write(ch);
        end;
        writeln;
      end;
    end
    else
    begin
      id:=b[0];
      tol:=b[1];
      cyl:=w[1];
      tet:=w[3];
      bpt:=w[4];
      bps:=w[5];
      bpsf:=bps and $FF00;
      spt:=w[6];
      cac:=w[$15];      { nbre de secteurs cachables }
      if id=0 then
      begin
        writeln('absent');
        exit;
      end;
      writeln('Identification termine.');
      writeln('  Dimensions physiques  : ',cyl,' cylindres, ',tet,' ttes, ',spt,' secteurs.');
      cap:=longint(bps)*longint(cyl)*longint(tet)*longint(spt);
    {  cap:=longint(bpt)*longint(cyl)*longint(tet); }
      writeln('  Capacit non formate : ',cap,' octets (',cap div 1048576,' Mo), ',bps,' octets par secteur');
      cap:=longint(bpsf)*longint(cyl)*longint(tet)*longint(spt);
      writeln('  Capacit formate     : ',cap,' octets (',cap div 1048576,' Mo), ',bpsf,' octets par secteur');
      cap:=longint(cac)*longint(bpsf) shr 10;
      writeln('  Mmoire cache         : ',cap,' Ko');
      if inverse then
        for i:=9 to $2E do
        begin
          j:=w[i];
          w[i]:=lo(j)*256+hi(j);     { inverse les octets 2  2 }
        end;
      s:='';
      for i:=$12 to $27 do s:=s+c[i];
      nettoie(s);
      writeln('  Numro de srie       : ',s);
      s:='';
      for i:=$2E to $35 do s:=s+c[i];
      nettoie(s);
      writeln('  Rfrence             : ',s);
      s:='';
      for i:=$36 to $5D do s:=s+c[i];
      nettoie(s);
      writeln('  Modle                : ',s);
      write  ('  Codes divers          : Mdia = ',hexb(id));
      writeln('h,  Tolrance = ',hexb(tol),'h');
    end;
  end;
  if not dump then
  begin
    write  ('  Vitesse de rotation   : ');
{    i:=wherex; }
    write('valuation en cours ...');
    j:=VitsRot;
{    gotoxy(i,wherey); }
    for i:=12 to 34 do write(#8);
{    clreol; }
    if j>0 then writeln(j,' tr/mn,  ',100/NbTours:0:1,'% prs.       ')
           else writeln('Mesure impossible.Contrleur certainement Local Bus.');
  end;
end;


Function StrPar(p : string) : string;
var i,j,k : integer;
begin
  k:=length(p);
  i:=pos(p,ChParam);
  inc(i,k);
  j:=i;
  if i>k then
    while (i<=length(ChParam)) and (ChParam[i]<>' ') do
      inc(i);
  StrPar:=copy(ChParam,j,i-j);
end;

Procedure InitParam;
var T : Text;
    i : word;
begin
  move(ptr(PrefixSeg,$80)^,ChParam,sizeof(ChPAram));
  for i:=1 to length(ChParam) do ChParam[i]:=upcase(ChParam[i]);
  for i:=2 to length(ChParam) do
    if (ChParam[i]='/') and (ChParam[i-1]<>' ') then insert(' ',ChParam,i);

  if pos('/?',ChParam)>0 then
  begin
    writeln('Syntaxe paramtre : INFODISK [/Ddisque] [/L[nombre]] [/I]');
    writeln('  - disque, qui vaut soit 0 soit 1, est le numro du disque  tester.');
    writeln('  - /L indique d''afficher  l''cran les codes hexadcimaux d''identification.');
    writeln('    [nombre] indique le nombre de codes  afficher (1  512), 128 par dfaut.');
    writeln('  - /I demande de ne pas inverser les octets de texte.');
    halt;
  end;

  Inverse:=pos('/I',ChParam)=0;
  Dump:=pos('/L',ChParam)>0;
  if dump then
  begin
    LngDump:=IntStr(StrPar('/L'));
    if (LngDump<1) or (LngDump>512) then LngDump:=128;
  end;
  if pos('/D',ChParam)>0 then
    NumDsk:=IntStr(StrPar('/D'));
end;


BEGIN
  writeln('INFODISK : Identificateur de type de disque dur              (W.Tarreau - 1994)');
  writeln('  NB : Les disques durs n''ont pas besoin d''avoir t dclars dans le setup');
  writeln('       pour pouvoir tre identifis.');
  writeln;
  InitParam;
  if NumDsk<=0 then
  begin
    identifie(0);
    writeln;
  end;
  if (NumDsk=-1) or (NumDsk=1) then
  begin
    identifie(1);
  end;
  ResetDsk;
  chgdsk(0);
end.
