Procedure Ask(Var Drive:Integer);
{
    This procedure determines which hard disk drive the user wants to test

    Input        None

    Output       Drive    Integer specifying drive to test

    Strategy     (1)      Determine how many hard drives controller reports
                          Fatal error if no controller or no drives

                 (2)      If more than one drive, request drive from user

}
Type
    Result=Record
                 Ax,Bx,Cx,Dx,Bp,Si,Di,Ds,Es,Flags:Integer;
    End;
Var
   Found:Integer;
   Sys:Result;
Begin
     SYS.AX:=$8*$0100+$01 { AH=8 means get parameters, AL=sector };
     SYS.CX:=$0*$0100+$01 { CH=Cylinder, CL=Sector };
     SYS.DX:=$0*$0100+$80 { DH=head, DL=$80+Drive };
     Intr($13,Sys);

     NormVideo;

     If Odd(Sys.Flags) then
        Begin
             Writeln('You do not have a hard disk controller');
             Halt;
        End;
     Found:=Lo(SYS.DX);

     Case Found of
          0:Begin
                   Writeln('No hard disk is attached to your controller');
                   Halt;
              End;
          1:Drive:=0;
          Else Begin
              Drive:=0;
                   While (Drive > Found) or (Drive < 1) do
                         Begin
                              Write('Found ',Found,' disks. ');
                              Write('Which one do you want? ');
                              Readln(Drive);
                              Writeln;
                         End;
              Drive:=Drive-1;
              End;
          End;

End;

