
;Ŀ
;                                                                   
;                                           
;                                                         
;                                                   
;                                                           
;                                                   
;                                                                   
;        FICHERO CON CODIGO ENSAMBLADOR LINKABLE CON 2MF.C          
;                                                                   
;       Cdigo de 2M que ser almacenado en los sectores de         
;       los disquetes, sectores de arranque de los mismos y         
;       algunas funciones ASM de utilidad.                          
;                                                                   
;  Proceso:                                                         
;                                                                   
;    TASM    2MFKIT  /m5 /mx                                        
;                                                                   
;    El fichero 2MFBOOT.DB que se carga con INCLUDE debe obtenerse  
;    previamente a partir de 2MFBOOT.ASM con ayuda de 2MFBMAKE.BAS  
;                                                                   
;

               PUBLIC  _Boot2mCode, _Boot2mLong
               PUBLIC  _biosdsk,    _PicoRetardo, _NuevaInt24
               PUBLIC  _BootHDPrg, _BootHDPrgLong
               PUBLIC  _BootDDPrg, _BootDDPrgLong


_DATA          SEGMENT WORD PUBLIC 'DATA'
               ASSUME  CS:_DATA, DS:_DATA

; ------------ Cdigo 2M para grabar en los 5 sectores ocultos de los
;              disquetes de alta densidad al formatear.

_Boot2mCode:   INCLUDE 2MFBOOT.DB
_Boot2mLong    DW    $-OFFSET _Boot2mCode

; ------------ Sectores de arranque de los disquetes 2M.

_BootHDPrg:    INCLUDE 2MBOOTHD.INC
_BootHDPrgLong DW    $-OFFSET _BootHDPrg

_BootDDPrg:    INCLUDE 2MBOOTDD.INC
_BootDDPrgLong DW    $-OFFSET _BootDDPrg

_DATA          ENDS


_TEXT          SEGMENT WORD PUBLIC 'TEXT'
               ASSUME  CS:_TEXT, DS:_TEXT

; ------------ Rutina de acceso a disco va BIOS. No se utiliza la
;              funcin biosdisk() del compilador porque en algunas
;              versiones del mismo hace tonteras que no debe. As,
;              adems, se puede llamar a INT 13h con CALL (bueno,
;              con RETF) para que dentro de WINDOWS 2MF /M no de
;              problemas; adems, la funcin de formateo de 2M
;              requiere SI="2M" al llamar.

_biosdsk       PROC  FAR
               PUSH  BP
               MOV   BP,SP
               PUSH  ES
               PUSH  SI
               PUSH  DI
               PUSHF                   ; estructura para futuro IRET
               PUSH  CS
               LEA   AX,bdsk_ret
               PUSH  AX
               XOR   AX,AX
               MOV   ES,AX
               PUSH  ES:[13h*4+2]      ; INT 13h -> pila
               PUSH  ES:[13h*4]
               MOV   AH,[BP+6]
               MOV   DL,[BP+8]
               MOV   DH,[BP+10]
               MOV   CH,[BP+12]
               MOV   CL,[BP+14]
               MOV   AL,[BP+16]
               LES   BX,DWORD PTR [BP+18]
               MOV   SI,"2M"
               RETF                    ; ejecutar INT 13h
bdsk_ret:      POP   DI
               POP   SI
               POP   ES
               POP   BP
               MOV   AL,AH             ; resultado
               MOV   AH,0
               RET
_biosdsk       ENDP

; ------------ Pequeo retardo de medio milisegundo.

_PicoRetardo   PROC  FAR
               PUSH  AX
               PUSHF
               POP   AX
               OR    AH,70h
               PUSH  AX
               POPF
               PUSHF
               POP   AX
               AND   AH,0F0h
               CMP   AH,0F0h           ; es PC/XT?
               JE    xt
               MOV   CX,33             ; 181193180*33*1000 = 0.5 ms
wrf:           IN    AL,61h
               AND   AL,10h
               CMP   AL,AH
               JE    wrf          ; esperar pulso refresco memoria
               MOV   AH,AL
               LOOP  wrf
xt:            POP   AX
               RET
_PicoRetardo   ENDP

; ------------ Nuevo gestor de errores crticos.

_NuevaInt24    PROC
               MOV   AL,3      ; error en la funcin DOS invocada.
               IRET
_NuevaInt24    ENDP

_TEXT          ENDS

               END
