;                                                                           ;
;                       TOUCH.S   v1.06   01-31-1999                        ;
;                       Copyright 1996-1999,  C. Dye                        ;
;                       email:  raster@highfiber.com                        ;
;                                                                           ;
;       This is source for Eric Isaacson's shareware assembler, A86.        ;
;       Re-assemble by typing A86 TOUCH.S                                   ;
;                                                                           ;
;       This program is copyrighted, but freeware.  Read the file           ;
;       TOUCH.DOC for information about distributing unmodified or          ;
;       modified copies of this program.                                    ;
;                                                                           ;

radix 16                               ; gentlemen prefer hex

doscall macro                          ; call to dos int_21 with a
mov ah,#1                              ; one-byte function in ah
int 21
#em

doscall2 macro                         ; call to dos int_21 with a
mov ax,#1                              ; two-byte function in ax
int 21
#em

dosprint macro                         ; call to dos string-print function
mov dx,offset #1
mov ah,09
int 21
#em

zprint macro                           ; call to program's asciiz-print
mov di,offset #1                       ; subroutine
call zprint1
#em

zero macro                             ; cheap way to zero a 16-bit register
xor #1,#1
#em


country  equ  005c                     ; put country data in the psp
country_date equ country + 00          ; local date format, usa-eur-japan
country_thou equ country + 07          ; local thousands char (',' in usa)
country_dsep equ country + 0b          ; local date separator ('-' in usa)
country_tsep equ country + 0d          ; local time separator (':' in usa)
country_time equ country + 11          ; local time format (0 12hr, 1 24hr)

temp     equ  006e                     ; local temp variable (byte or word)

fn_max   equ  0050                     ; max number of characters in filename


jmp begin                              ; skip over variables

even ; --------------------------------- WORD LENGTH VARIABLES:

newdate:                               ; new date stamp for files
dw 0021

newtime:                               ; new time stamp for files
dw 0000

today:                                 ; date when program starts
dw 0000

right_now:                             ; time when program starts
dw 0000

handle:                                ; handle for touch operation
dw 0000

auxhandle:                             ; handle for file list, template file
dw 0000

last_bs:                               ; offset of final backslash in fnbuf
dw 0000

tree_seg:                              ; segment of tree buffer
dw 0000

list_seg:                              ; segment of file list buffer
dw 0000

list_pnt:                              ; pointer into file list buffer
dw 0000

pointer_pointer:                       ; pointer into list of filespec
dw 0000                                ; pointers

dos_version:                           ; dos version:  major number in high
dw 0000                                ; byte, minor number in low byte

tfn_attr:                              ; legal attributes for template file
dw 0000

date1:                                 ; first  number in user-specified date
dw 0000                                ;    (month in u.s. format)
date2:                                 ; second number in user-specified date
dw 0000                                ;    (day in u.s. format)
date3:                                 ; third  number in user-specified date
dw 0000                                ;    (year in u.s. format)

;  Month, day, and year may be read into different variables depending on the
;  COUNTRY= setting in CONFIG.SYS.  If so, the eval_user_stamps routine will
;  rearrange these variables into United States order before converting to
;  DOS directory date-stamp format.

user_hour:                             ; user-specified  hour  for /t
dw 0000
user_minute:                           ; user-specified minute for /t
dw 0000
user_second:                           ; user-specified second for /t
dw 0000

found_lo:                              ; number of files found in current
dw 0000                                ; directory:
found_hi:                              ; low word / high word
dw 0000

touch_lo:                              ; number of files changed in current
dw 0000                                ; directory:
touch_hi:                              ; low word / high word
dw 0000

total_found_lo:                        ; total number of files found so far:
dw 0000                                ; low word / high word
total_found_hi:
dw 0000

total_touch_lo:                        ; total number of files changed:
dw 0000                                ; low word / high word
total_touch_hi:
dw 0000

; -------------------------------------- BYTE LENGTH VARIABLES:

flags:                                 ; bit 7 = change date     /D
db 00                                  ; bit 6 = change time     /T
                                       ; bit 5 = template date   /C /CD
                                       ; bit 4 = template time   /C /CT
                                       ; bit 3 = subdirectories  /S
                                       ; bit 2 = use file list   @filename
                                       ; bit 1 = stdout is redirected
                                       ; bit 0 = parsing between quotes

more_flags:                            ; bit 7 = never add .*    /E
db 00                                  ; bit 6 = prompt user     /P /Q
                                       ; bit 5 = user-specified date stamp
                                       ; bit 4 = user-specified time stamp
                                       ; bit 3 = user's date includes year
                                       ; bit 2 = change anything at all?
                                       ; bit 1 = weird values    /W
                                       ; bit 0 = user date fmt   /F

chgattr:                               ; which attributes to change?
db 00

newattr:                               ; new attributes
db 00

vga_lines:                             ; default number of lines to scroll
db 17

screen_lines:                          ; lines to print between pauses
db 00

line:                                  ; lines remaining before next pause
db 00

even ; --------------------------------- FILENAME BUFFERS:

nambuf:                                ; filename of files to touch,
db 0e dup 00                           ; without directory name

; -------------------------------------- START OF CODE:
begin:

doscall2 3000                          ; check ms-dos version:
cmp al,02
ja dos_okay
dosprint msg_err_dos_bad               ; dos prior to version 3 :  complain!
int 20                                 ; and abort
dos_okay:
mov b [dos_version+0],ah               ; save major version number
mov b [dos_version+1],al               ; save minor version number
mov ax,sp                              ; examine stack pointer:
cmp ax,stack_end                       ; plenty of room?
jae > l1
trs_80:                                ; not enough memory:
call error_out
dosprint msg_trs_80                    ; complain
doscall2 4c11                          ; and exit with errorlevel 17
l1:
mov sp,stack_end                       ; reduce stack size
push cs
pop es
mov bx,(stack_end / 10) + 2
doscall 4a                             ; and shrink program's memory block
jc trs_80

call get_country_info                  ; get current country info
mov dx,offset dta
doscall 1a                             ; set up disk transfer area
call get_current_time                  ; used for default time / date stamps
call get_vga_lines                     ; figure default scroll length
mov b [last_dir_shown],00              ; empty the last_dir_shown buffer

mov si,0080                            ; read from command line
mov di,offset fnbuf                    ; into filespec buffer

parse_main:                            ; PRIMARY PARSER LOOP:
inc si
switch_done:
mov al,b [si]                          ; examine next character
call force_uc                          ; in uppercase:
call test_eol                          ; end of line?
je parse_done                          ; if so, terminate primary parser
call test_space                        ; is it a space?
je parse_main                          ; if so, ignore it
call test_switch                       ; is it a switch character?
je found_switch                        ; if so, interpret it
mov bx,w [pointer_pointer]             ; otherwise, this is the start of a
mov w [filespec_pointers+bx],si        ; filespec; remember it
add bx,0002
mov w [pointer_pointer],bx
cmp bx,0040
jb l2
call error_out
dosprint msg_err_specs_galore
doscall2 4c10                          ; and exit with errorlevel 16
l2:
call parse_fn                          ; parse through the filespec
mov al,b [si]
call test_eol                          ; if the end of the line was found,
je parse_done                          ; terminate primary parser
jmp parse_main                         ; otherwise, keep on truckin'

found_switch:                          ; FOUND A SWITCH CHARACTER:
inc si
lodsb                                  ; examine next character
call force_uc                          ; in uppercase:
mov bx,0ffff                           ; start at beginning of switch table
l0:
inc bx
cmp b [switches+bx],00                 ; run out of legal switches to try?
je syntax                              ; if so, syntax error
cmp b [switches+bx],al                 ; found this letter in table?
jne l0                                 ; if not, keep looking
shl bx,01                              ; multiply .bx by two
mov ax,w [switch_routines+bx]          ; and get address of switch routine
jmp ax                                 ; to jump to

syntax:                                ; SYNTAX ERROR IN COMMAND LINE:
call error_out
dosprint msg_syntax                    ; print error message
call show_date_format                  ; and report the current date format
doscall2 4c10                          ; and exit with errorlevel 16

parse_done:                            ; DONE WITH PRIMARY PARSER:
mov bx,w [pointer_pointer]
or bx,bx                               ; found any filespecs at all?
jne > l1
mov ax,offset everything_cr
mov w [filespec_pointers],ax           ; if not, slip in a star-dot-star-cr
add bx,0002
l1:
mov w [filespec_pointers+bx],0000      ; add a null to end of list
mov w [pointer_pointer],0000           ; and point to the start of the list
mov al,b [flags]
and al,0f0                             ; supposed to change the date or time
or al,b [chgattr]                      ; or any attributes?
cmp al,00
je > l2
or b [more_flags],04                   ; if so, note it
l2:
call alloc_tree_buffer                 ; create buffer for /s tree if needed
call alloc_list_buffer                 ; get buffer for file list
call use_template_stamps               ; use /c stamps, if present
call eval_user_stamps                  ; evaluate user time and date
call prompt_fix                        ; check usage of /p
call fix_paging                        ; disable paging if output redirected

big_loop:                              ; LOOP THROUGH COMMAND-LINE FILESPECS:
mov bx,w [pointer_pointer]
mov ax,w [filespec_pointers+bx]        ; get offset of command-line filespec
or ax,ax                               ; have we run out yet?
je big_loop_done                       ; if so, exit
add w [pointer_pointer],0002           ; otherwise, point to next filespec
mov si,ax
call parse_fn                          ; and parse this one
call clean_up_filespec                 ; canonicalize it

filespec_loop:
call get_fn_from_list                  ; read filespec from list, if needed
jc big_loop                            ; if eof, back for next user filespec
subdir_loop:
call touch_multiple_files              ; touch files matching this filespec
call find_any_subdirs                  ; add any subdirectories to tree buff.
call use_next_subdir                   ; is there a subdirectory in buffer?
jnc subdir_loop                        ; if so, touch any files in it
test b [flags],04                      ; using a file list?
jne filespec_loop                      ; if so, get next filespec from it
jmp big_loop

big_loop_done:                         ; done with all user filespecs:
call show_file_count
call show_total_counts                 ; display num. of files found, changed
doscall2 4c00                          ; exit with errorlevel 0


parse_tfn:                             ; READ TEMPLATE FILENAME:
mov w [tfn_attr],0016                  ; directories are okay, hidden, etc.
and b [flags],0fe                      ; turn off quote mode
or b [flags],04                        ; turn on at-mode
mov di,offset tfbuf                    ; point to template filename buffer
jmp parse_fn_0

parse_fn:                              ; READ FILESPEC FROM COMMAND LINE:
and b [flags],0fa                      ; turn off quote-mode and at-mode
mov di,offset fnbuf                    ; point to filespec buffer
parse_fn_0:
mov cl,00                              ; no characters yet
mov b [di],cl                          ; empty the buffer

parse_fn_1:                            ; parse filename loop:
lodsb                                  ; get a character from command line
call force_uc                          ; and force it to uppercase
cmp al,'?'
je > l0                                ; found a wildcard in the filespec?
cmp al,'*'
jne > l1                               ; if not, never mind
l0:
and b [tfn_attr],0ef                   ; if so, disallow subdirectories
l1:
call test_eol                          ; end of line?
je parse_fn_eol                        ; if so, handle it
call test_space                        ; space or tab?
je parse_fn_space                      ; if so, handle it
cmp al,'"'                             ; quote mark?
je parse_fn_quote                      ; if so, handle it
cmp al,'/'                             ; forward slash?
jne > l2
mov al,'\'                             ; if so, convert to backslash
l2:
cmp al,'@'                             ; at sign?
jne parse_fn_char                      ; no, treat like a normal character
cmp cl,00                              ; yes:  got any characters yet?
jne parse_fn_char                      ; yes:  at sign is part of filename
test b [flags],05                      ; quote-mode or at-mode?  if either,
jne parse_fn_char                      ; at sign is part of filename
or b [flags],04                        ; note:  file list
jmp parse_fn_1                         ; continue parsing

parse_fn_char:                         ; NORMAL CHARACTER IN FILENAME:
mov b [di],al                          ; stash it
inc di
mov b [di],00                          ; null terminate the buffer
inc cl                                 ; increment count of characters
cmp cl,fn_max                          ; buffer overflow?
jb parse_fn_1                          ; if not, continue parsing
call error_out
dosprint msg_err_fn_ovf                ; if so, print error message
doscall2 4c10                          ; and exit with errorlevel 16

parse_fn_eol:                          ; FOUND THE END OF COMMAND LINE:
cmp cl,00                              ; found a filename yet?
jne > l0
call error_out
dosprint msg_err_in_filespec           ; if not, complain
doscall2 4c10                          ; and exit with errorlevel 16
l0:
dec si                                 ; let the primary parser see it
ret                                    ; and we're done parsing the filespec

parse_fn_space:                        ; FOUND A SPACE IN THE FILESPEC:
test b [flags],01                      ; parsing between quotes?
jne parse_fn_char                      ; if so, treat like any other char
cmp cl,00                              ; any characters in filespec yet?
jne > l1
call error_out
dosprint msg_err_in_filespec           ; if not, complain
doscall2 4c10                          ; and exit with errorlevel 16
l1:
dec si                                 ; if so, we're done parsing filespec
ret

parse_fn_quote:                        ; found a quote mark:
test b [flags],01                      ; has an opening quote been found?
jne parse_close_quote                  ; if so, this is a close quote
cmp cl,00                              ; is the filename empty?
jne parse_fn_char                      ; if not, quote is part of filename
or b [flags],01                        ; note that open quote was found
jmp parse_fn_1                         ; and continue parsing
parse_close_quote:
cmp cl,00                              ; empty filename?
jne > l2
call error_out
dosprint msg_err_in_filespec           ; if so, complain
doscall2 4c10                          ; and exit with errorlevel 16
l2:
ret                                    ; if not, done parsing filespec


touch_multiple_files:                  ; TOUCH FILES MATCHING CURRENT SPEC:
call append_short_filespec             ; add user's filespec
mov dx,offset fnbuf                    ; point to working filespec
mov cx,0006                            ; include hidden and system files
doscall 4e                             ; find first matching file
touch_multi_1:
jc touch_multi_exit                    ; any error, exit loop
call show_cur_dir_maybe                ; display current directory if need be
call show_cur_filename                 ; display current filename
call show_file_info                    ; and its date, time, attributes
add w [found_lo],0001                  ; add one to count of files found
adc w [found_hi],0000
call touch_file                        ; do it to it!
call pause_check
doscall 4f                             ; find next matching file
jmp touch_multi_1                      ; till the cows come home
touch_multi_exit:
ret

touch_file:                            ; CHANGE FILE DATE, TIME, ATTRIBUTES:
test b [more_flags],04                 ; supposed to change anything at all?
jne > l1                               ; if so, proceed
mov al,b [dta_attr]                    ; if not, user may just want info
call show_attribs                      ; so display file attributes
mov ax,w [dta_size+0]
mov dx,w [dta_size+2]                  ; display file size
call show_file_size
call crlf                              ; and terminate the print line
ret                                    ; before exiting
l1:
call prompt_user                       ; prompt user, if necessary
if ne jmp touch_file_no                ; if answer is 'no', do nothing, exit
call append_found_filespec             ; use the filename that was found

zero cx                                ; CLRMOD :
mov dx,offset fnbuf                    ; set file's attributes to 'none'
doscall2 4301
jnc > l2
mov dx,offset msg_clrmod               ; error!  point to 'clrmod' string
jmp touch_problem                      ; and print error message
l2:
test b [flags],0c0                     ; changing either the time or date?
je > l7                                ; if not, just fix the attributes
mov dx,offset fnbuf                    ; OPEN :
doscall2 3d22                          ; open file for read/write
jnc > l3
mov dx,offset msg_open                 ; error!  point to 'open' string
jmp touch_problem                      ; and print error message
l3:                                    ; file open succeeded:
mov w [handle],ax                      ; save handle
test b [flags],80                      ; switch d specified?
je > l4
mov ax,w [newdate]                     ; if so, use new date
mov w [dta_date],ax
l4:
test b [flags],40                      ; switch t specified?
je > l5
mov ax,w [newtime]                     ; if so, use new time
mov w [dta_time],ax
l5:                                    ; TOUCH :
mov bx,w [handle]
mov cx,w [dta_time]                    ; use the correct time
mov dx,w [dta_date]                    ; and date values
doscall2 5701                          ; to touch the file
jnc > l6
mov dx,offset msg_touch                ; error!  point to 'touch' string
jmp touch_problem                      ; and print error message
l6:                                    ; CLOSE :
mov bx,w [handle]                      ; get file handle
doscall 3e                             ; and close file
jnc > l7
mov dx,offset msg_close                ; error!  point to 'close' string
jmp touch_problem                      ; and print error message
l7:                                    ; FIXMOD :
mov ch,b [chgattr]
xor ch,0ff                             ; bits to _not_ change
and ch,b [dta_attr]                    ; value of those bits
mov cl,b [chgattr]                     ; bits to change
and cl,b [newattr]                     ; value of those bits
or cl,ch                               ; combine old and new attribute bytes
mov b [dta_attr],cl                    ; and save the resulting value
mov ch,00
mov dx,offset fnbuf                    ; set file's attributes correctly
doscall2 4301
jnc > l8
mov dx,offset msg_fixmod               ; error!  point to 'fixmod' string
jmp touch_problem                      ; and print error message
l8:
add w [touch_lo],0001                  ; add one to count of files changed
adc w [touch_hi],0000
file_touch_done:                       ; file was modified:
dosprint msg_arrow                     ; display the 'changed to' arrow
call show_file_info                    ; and new date, time, attributes
touch_file_no:                         ; nothing was done to the file:
call crlf                              ; terminate the current output line
ret                                    ; and exit
touch_problem:                         ; error trying to touch file:
push dx                                ; save error message
push ax                                ; and error number
call error_out
dosprint msg_touch_problem             ; print error message
pop ax
call decout                            ; and error number
dosprint msg_touch_prob_2
pop dx
doscall 09                             ; and where it happened
call crlf
ret

show_file_info:                        ; DISPLAY FILE'S DATE, TIME, ATTRIBS:
mov ax,w [dta_date]
call show_dow                          ; compute and display day of week
mov ax,w [dta_date]
call show_date                         ; display file's date stamp
dosprint msg_info_space
mov ax,w [dta_time]
call show_time                         ; display file's time stamp
ret

find_any_subdirs:                      ; FIND SUBDIRECTORIES, ADD TO TREE BUF
test b [flags],08                      ; was /s specified?
jne > l1
ret                                    ; if not, don't bother finding subdirs
l1:
mov si,offset star_dot_star            ; copy star-dot-star filespec
mov di,w [last_bs]                     ; just after the final backslash
inc di
call copy_string
cmp di,offset fnbuf + fn_max           ; did the copy overflow the buffer?
jna > l2                               ; no, continue
jmp error_fnbuf_over                   ; yes, crash and burn
l2:
mov dx,offset fnbuf
mov cx,0016                            ; look for subdir, hidden, system ...
doscall 4e
dir_loop:
jc dir_loop_exit                       ; any error, stop subdir search
test b [dta_attr],10                   ; is the item found a subdir?
je dir_loop_next                       ; if not, keep looking
cmp b [dta_name],'.'                   ; stupid dos . or .. entries?
je dir_loop_next                       ; if so, keep looking
call append_found_filespec             ; add subdir name to current dir name
mov es,w [tree_seg]
call find_es_zz                        ; find the end of the tree buffer
mov dx,si                              ; and remember where it was
mov di,si
mov si,offset fnbuf                    ; copy full pathname of found subdir
call copy_string_far                   ; into the tree buffer
mov cx,di
stosb                                  ; and add a second null
push ds
pop es
cmp cx,dx                              ; did we overflow the tree buffer?
jb tree_buffer_over                    ; if so, bomb out
dir_loop_next:                         ; look for next subdirectory:
doscall 4f                             ; dos find-next-handle function
jmp dir_loop
dir_loop_exit:                         ; done looking for subdirectories:
ret

tree_buffer_over:                      ; TREE BUFFER HAS OVERFLOWED:
call error_out                         ; fix stdout to screen
dosprint msg_tree_buffer_over          ; print an error message
doscall2 4c16                          ; and exit with errorlevel 22

use_next_subdir:                       ; IS A DIRECTORY NAME BUFFERED?
test b [flags],08                      ; was /s specified?
jne > l1
l0:
stc                                    ; if not, exit with no new subdir
ret
l1:                                    ; /s was specified:
mov es,w [tree_seg]
cmp b [es:0000],00                     ; is there anything in the buffer?
je l0                                  ; if not, don't use it.  duh.
push ds
pop es
mov di,offset fnbuf                    ; es:di points to fnbuf
mov ds,w [tree_seg]
zero si                                ; ds:si points to start of tree buffer
call copy_string_far                   ; get directory name from buffer
cmp b [si],00                          ; was it the last name in the buffer?
jne > l4
mov w [0000],0000                      ; if so, empty the tree buffer
jmp > l6
l4:                                    ; if not,
zero di                                ; copy to the start of the tree buffer
mov es,w [cs:tree_seg]
l5:
lodsb                                  ; copy one byte from tree buffer
stosb                                  ; down into its new location
cmp al,00                              ; null marking end of one subdir name?
jne l5
cmp b [si],00                          ; if so, look for second (final) null
jne l5                                 ; and keep copying until you find it
stosb                                  ; store final null to new location
l6:
push cs                                ; restore
push cs
pop ds                                 ; data segment
pop es                                 ; and extra segment
call find_null_fnbuf                   ; find the end of fnbuf
mov w [last_bs],di
mov w [di],00 by '\'                   ; add a backslash and terminal null
clc                                    ; and exit with carry clear
ret                                    ; to indicate new dir. name present

show_total_counts:                     ; FINAL DISPLAY OF ALL FOUND, CHANGED:
call crlf                              ; print a blank line
dosprint msg_total_found               ; print 'Total found'
mov ax,w [total_found_lo]
mov dx,w [total_found_hi]
call dec_print_big                     ; and number found.
dosprint msg_num_touched               ; print ', changed'
mov ax,w [total_touch_lo]
mov dx,w [total_touch_hi]
call dec_print_big                     ; and number changed.
test b [more_flags],04                 ; supposed to change anything at all?
if e dosprint msg_syntax_reminder      ; if not, display reminder message
call crlf                              ; terminate print line
ret                                    ; and exit.


switch_d_null:                         ; /D:N -- SET NULL DATE STAMP
zero ax
mov w [newdate],ax                     ; put zero value in newdate
l1:
mov al,b [si]
call force_uc
cmp al,'A'
jb > l2
cmp al,'Z'
ja > l2
inc si
jmp l1
l2:
jmp switch_done

switch_d_err:                          ; PROBLEM WITH /D SYNTAX
call error_out
dosprint msg_err_sw_d                  ; display help message
call show_date_format                  ; and current date style
doscall2 4c10                          ; and exit with errorlevel 16

switch_d_dupe:                         ; MORE THAN ONE /D ON COMMAND LINE:
mov al,'D'
jmp confused

switch_d:                              ; /D -- CHANGE DATE STAMPS
test b [flags],80                      ; was there a previous /d ?
jne switch_d_dupe                      ; if so, complain
or b [flags],80                        ; note it
and b [more_flags],0d7                 ; no user-specified date (yet)
mov al,b [si]                          ; examine next character
cmp al,'?'                             ; question mark?
je switch_d_err                        ; if so, show help for /d switch
call test_colon                        ; colon or equals sign?
jne > l0
inc si                                 ; if so, skip over it
mov al,b [si]                          ; and expect the next character
call force_uc
cmp al,'N'                             ; to be the letter 'n'
je switch_d_null
call test_digit                        ; or else a digit
jne switch_d_err                       ; colon but no digit = syntax error!
l0:                                    ; no colon:
call test_digit                        ; is the next character a digit?
je > l1                                ; if so, skip ahead, get user's date
mov ax,w [today]                       ; switch d with no date specified:
mov w [newdate],ax                     ; use default of today's date
jmp switch_done                        ; and return to main parse loop
l1:                                    ; switch d with a specific date:
or b [more_flags],20                   ; note user-specified date
call get_num                           ; get first number (month)
jc switch_d_err
mov w [date1],ax                       ; and save it
mov al,b [si]                          ; examine the next character
call test_dsep                         ; is it a date separator?
jne switch_d_err
inc si                                 ; if so, continue
call get_num                           ; get second number (day)
jc switch_d_err
mov w [date2],ax                       ; and save it
mov ax,w [today]
mov cl,09
shr ax,cl
add ax,01980xd
mov w [date3],ax                       ; year defaults to this year
mov al,b [si]                          ; examine the next character
call test_dsep                         ; is it a date separator?
jne > l3                               ; if not, year not specified
inc si                                 ; if so, skip over it
or b [more_flags],08                   ; note user-specified year
call get_num                           ; get third number (year)
jnc > l2
jmp switch_d_err
l2:
mov w [date3],ax                       ; and save it
l3:
jmp switch_done

switch_t_dupe:                         ; MORE THAN ONE /T ON COMMAND LINE:
mov al,'T'
confused:                              ; used for duplicate switches :
mov b [msg_err_dupe1],al               ; insert offending letter into message
call error_out                         ; force stdout to stderr, no paging
dosprint msg_err_dupe                  ; print unhappy confusion message 
doscall2 4c10                          ; and exit with errorlevel 16

switch_t_err:                          ; PROBLEM WITH /T SYNTAX
call error_out
dosprint msg_err_sw_t                  ; show help message
doscall2 4c10                          ; and exit with errorlevel 16

switch_t:                              ; /T -- CHANGE TIME STAMPS
test b [flags],40                      ; was there a previous /t ?
jne switch_t_dupe                      ; if so, complain
or b [flags],40                        ; note it
and b [more_flags],0ef                 ; no user time (yet)
mov al,b [si]                          ; examine next character
cmp al,'?'                             ; question mark?
je switch_t_err                        ; if so, show /t help
call test_colon                        ; colon or equals sign?
jne > l0
inc si                                 ; if so, skip over it
mov al,b [si]                          ; and expect the next character
call test_digit                        ; to be a digit
jne switch_t_err                       ; colon but no digit = syntax error!
l0:                                    ; no colon:
call test_digit                        ; is the character a digit?
je > l1                                ; if so, skip ahead, get user's time
mov ax,w [right_now]                   ; switch t with no time specified:
mov w [newtime],ax                     ; use default of current time
jmp switch_done                        ; and return to main parse loop
l1:                                    ; switch t with a specific time:
or b [more_flags],10                   ; note user-specified time
call get_num                           ; get first number (hour)
jc switch_t_err
mov w [user_hour],ax                   ; and save it
zero ax
mov w [user_minute],ax                 ; minutes default to zero
mov w [user_second],ax                 ; seconds default to zero
mov al,b [si]                          ; examine the next character
call test_tsep                         ; is it a time separator?
jne > l3                               ; if not, minutes not specified
inc si                                 ; if so, continue
call get_num                           ; get second number (minute)
jc switch_t_err
mov w [user_minute],ax                 ; and save it
mov al,b [si]                          ; examine the next character
call test_tsep                         ; is it a time separator?
jne > l3                               ; if not, seconds not specified
inc si                                 ; if so, skip over it
call get_num                           ; get third number (seconds)
jc switch_t_err
mov w [user_second],ax                 ; and save it
l3:
mov ax,w [user_hour]                   ; check user hours:
or ax,ax                               ; zero hours?
je got_user_time                       ; if so, don't look for am or pm
cmp ax,000c                            ; thirteen hours or more?
ja got_user_time                       ; if so, don't look for am or pm
mov al,b [si]                          ; examine the next character
call test_space                        ; is it a space?
jne > l4
inc si                                 ; if it is, skip over it
l4:
mov al,b [si]                          ; examine the next character
call force_uc
cmp al,'A'                             ; is it an 'a' ?
je time_is_am                          ; if so, adjust ante meridian
cmp al,'P'                             ; is it a 'p' ?
je time_is_pm                          ; if so, adjust post meridian
got_user_time:
jmp switch_done

time_is_am:                            ; A.M. HOUR:
cmp w [user_hour],000c                 ; am hours unchanged except for 12 am,
jne skip_am_pm
mov w [user_hour],0000                 ; which is zero hours
jmp skip_am_pm
time_is_pm:                            ; P.M. HOUR:
cmp w [user_hour],000c                 ; 12 pm unchanged (12 pm is 12 hours)
je skip_am_pm
add w [user_hour],000c                 ; other pm hours, add 12 hours
skip_am_pm:
inc si                                 ; skip over 'a' or 'p'
mov al,b [si]                          ; and examine following character
call force_uc
cmp al,'M'                             ; is it an 'm' ?
jne > l0
inc si                                 ; if so, skip over that as well
l0:
jmp got_user_time

switch_s:                              ; /S -- RECURSE INTO SUBDIRECTORIES
or b [flags],08
jmp switch_done

switch_p:                              ; /P /Q -- PROMPT USER, YES OR NO
or b [more_flags],40
jmp switch_done

switch_w:                              ; /W -- PERMIT WEIRD STAMP VALUES
or b [more_flags],02
jmp switch_done

switch_e:                              ; /E -- SUPPRESS AUTOMATIC .* EXT
or b [more_flags],80
switch_r:                              ; /R -- do-nothing switch, ignored
jmp switch_done

switch_f_dupe:                         ; MORE THAN ONE /F ON COMMAND LINE:
mov al,'F'
jmp confused

switch_f:                              ; /F -- DATE FORMAT
test b [more_flags],01                 ; has there already been a /f ?
jne switch_f_dupe                      ; if so, problem
or b [more_flags],01                   ; note it
mov al,b [si]                          ; examine the next character
call test_colon                        ; colon or equals sign?
jne switch_f_err                       ; if not, automatic syntax error
inc si                                 ; skip over colon
mov al,b [si]                          ; examine the next character
call force_uc                          ; in uppercase:
cmp al,'U'                             ; /f:u ?
je switch_f_u                          ; if so, force united states format
cmp al,'E'                             ; /f:e ?
je switch_f_e                          ; if so, force european date format
cmp al,'J'                             ; /f:j ?
je switch_f_j                          ; if so, force japanese date format
switch_f_err:                          ; PROBLEM WITH /F SYNTAX
call error_out
dosprint msg_err_sw_f                  ; complain
doscall2 4c10                          ; and exit with errorlevel 16
switch_f_u:
mov b [country_date],00                ; united states: use date format 0
inc si                                 ; skip over the u
jmp switch_done                        ; and exit
switch_f_e:
mov b [country_date],01                ; european: use date format 1
inc si                                 ; skip over the e
jmp switch_done                        ; and exit
switch_f_j:
mov b [country_date],02                ; japanese: use date format 2
inc si                                 ; skip over the j
jmp switch_done                        ; and exit

switch_c_err:                          ; PROBLEM WITH /C SYNTAX
call error_out
dosprint msg_err_sw_c                  ; complain
doscall2 4c10                          ; and exit with errorlevel 16

switch_cd_cd:                          ; MORE THAN ONE TEMPLATE DATE:
call error_out
dosprint msg_err_cd_cd                 ; complain
doscall2 4c10                          ; and exit with errorlevel 16

switch_ct_ct:                          ; MORE THAN ONE TEMPLATE TIME:
call error_out
dosprint msg_err_ct_ct                 ; complain
doscall2 4c10                          ; and exit with errorlevel 16

switch_c:                              ; /C -- TEMPLATE FILE
mov cl,30                              ; assume /c (both date and time)
mov al,b [si]                          ; examine next character after /c:
call force_uc
cmp al,'A'                             ; /ca?
jne > l0
jmp switch_ca                          ; if so, deal with it separately
l0:
cmp al,'D'                             ; /cd?
jne > l1
inc si                                 ; if so, skip over the d
mov cl,20                              ; copy only the date stamp
jmp > l2                               ; and continue
l1:
cmp al,'T'                             ; /ct?
jne > l2
inc si                                 ; if so, skip over the t
mov cl,10                              ; copy only the time stamp
l2:
mov b [temp],cl                        ; save flags for a moment
mov al,b [si]                          ; examine the next character
call test_colon                        ; colon or equals sign?
jne switch_c_err                       ; if not, automatic syntax error
and cl,b [flags]                       ; check for conflicts with earlier /c
test cl,20                             ; more than one template date?
jne switch_cd_cd                       ; if so, complain
test cl,10                             ; more than one template time?
jne switch_ct_ct                       ; if so, complain
mov cl,b [temp]
or b [flags],cl                        ; set appropriate flags
inc si                                 ; skip over colon and
call parse_tfn                         ; parse the template filename
mov dx,offset tfbuf                    ; use template filespec
mov cx,w [tfn_attr]                    ; and template attributes
doscall 4e                             ; attempt to locate matching file
jc switch_c_oops                       ; if any error, jump to handler
mov cx,w [dta_time]                    ; get file's time stamp in .cx
mov dx,w [dta_date]                    ; get file's date stamp in .dx
test b [temp],20                       ; supposed to use template date?
if ne mov w [newdate],dx               ; if so, stash template date
test b [temp],10                       ; supposed to use template time?
if ne mov w [newtime],cx               ; if so, stash template time
jmp switch_done                        ; done getting template stamp(s)

switch_c_oops:                         ; problem with template filespec :
call error_out
dosprint msg_err_temp_open             ; problem -- print error message
zprint tfbuf                           ; and template filespec
doscall2 4c12                          ; and exit with errorlevel 18

switch_ca:                             ; /CA -- COPY ATTRIBUTES FROM FILE
inc si
mov al,b [si]                          ; examine the next character
call test_colon                        ; colon or equals sign?
je > l1
jmp switch_c_err                       ; if not, automatic syntax error
l1:
cmp b [chgattr],00                     ; was there a previous /a or /ca ?
jne switch_a_dupe                      ; if there was, bomb out
inc si                                 ; skip over the colon
call parse_tfn                         ; parse the template filename
mov dx,offset tfbuf                    ; use template filespec
mov cx,w [tfn_attr]                    ; and template attributes
doscall 4e                             ; attempt to locate matching file
jc switch_c_oops                       ; if any error, jump to handler
mov cl,b [dta_attr]                    ; get attributes of found file
and cl,27                              ; mask off unwanted bits
mov b [newattr],cl                     ; save new attributes
mov b [chgattr],27                     ; note:  all attributes to be changed
jmp switch_done                        ; done getting template attributes

switch_a_dupe:                         ; MORE THAN ONE /A ON COMMAND LINE:
mov al,'A'
jmp confused

switch_a:                              ; /A -- CHANGE ATTRIBUTES
cmp b [chgattr],00
jne switch_a_dupe
mov al,b [si]                          ; examine next character
call test_colon                        ; colon or equals sign?
jne > l0
inc si                                 ; if so, skip over it
l0:
mov ch,00                              ; no attributes found yet
mov al,b [si]                          ; examine next character
cmp al,'+'
je sw_a_loop                           ; plus sign is legal, continue
cmp al,'-'
je sw_a_loop                           ; minus sign is legal, continue
jmp switch_a_err                       ; anything else is a boo-boo
sw_a_loop:                             ; main loop
mov al,b [si]                          ; examine next character
cmp al,'+'
je sw_a_plus                           ; if a plus, set following attribs
cmp al,'-'
je sw_a_minus                          ; if a minus, clear following attribs
call force_uc
cmp al,'A'                             ; is it an 'a' ?
je sw_a_a                              ; if so, change archive bit
cmp al,'S'                             ; is it an 's' ?
je sw_a_s                              ; if so, change system bit
cmp al,'H'                             ; is it an 'h' ?
je sw_a_h                              ; if so, change hidden bit
cmp al,'R'                             ; is it an 'r' ?
je sw_a_r                              ; if so, change read-only bit
call sw_a_set_clr                      ; anything else, clean up
jmp switch_done                        ; and exit
sw_a_plus:                             ; found a plus sign:
call sw_a_set_clr                      ; resolve any pending attributes
mov ch,00                              ; set following attributes
inc si                                 ; and the following character
jmp sw_a_get_letter                    ; must be an attribute letter
sw_a_minus:                            ; found a minus sign:
call sw_a_set_clr                      ; resolve any pending attributes
mov ch,80                              ; clear following attributes
inc si                                 ; and the following character
sw_a_get_letter:                       ; must be an attribute letter:
mov al,b [si]                          ; examine next character:
call force_uc
cmp al,'A'                             ; a for archive is legal
je sw_a_loop
cmp al,'S'                             ; s for system is legal
je sw_a_loop
cmp al,'H'                             ; h for hidden is legal
je sw_a_loop
cmp al,'R'                             ; r for read-only is legal
je sw_a_loop
jmp switch_a_err                       ; anything else is illegal!
sw_a_a:                                ; change archive bit:
or ch,20
inc si
jmp sw_a_loop
sw_a_s:                                ; change system bit:
or ch,04
inc si
jmp sw_a_loop
sw_a_h:                                ; change hidden bit:
or ch,02
inc si
jmp sw_a_loop
sw_a_r:                                ; change read-only bit:
or ch,01
inc si
jmp sw_a_loop
sw_a_set_clr:                          ; any attributes found yet?
cmp ch,00
je > l3                                ; if not, exit
test ch,80                             ; setting or clearing attribs?
jne > l2
or b [chgattr],ch                      ; setting - note bits to change
or b [newattr],ch                      ; and their new value
jmp > l3
l2:                                    ; clearing:
and ch,7f                              ; strip off the set/clear bit
or b [chgattr],ch                      ; note bits to change
xor ch,0ff
and b [newattr],ch                     ; and their new value
l3:
mov ch,00                              ; reset temp attribs
ret

switch_a_err:                          ; PROBLEM WITH /A SYNTAX
call error_out
dosprint msg_err_sw_a                  ; cry about it
doscall2 4c10                          ; and exit with errorlevel 16

switch_m_err:                          ; PROBLEM WITH /M SYNTAX
call error_out
dosprint msg_err_sw_m                  ; display error message
doscall2 4c10                          ; and exit with errorlevel 16

switch_m:                              ; /M -- CONTROL PAGING
mov al,b [si]                          ; examine the next character:
cmp al,'?'                             ; is it a question mark?
je switch_m_err                        ; if so, display syntax help
call test_colon                        ; is the next character a colon?
jne > l1
inc si                                 ; if so, skip over it
mov al,b [si]                          ; and expect the next character
call test_digit                        ; to be a digit
jne switch_m_err                       ; colon but no digit = syntax error!
l1:                                    ; no colon:
call test_digit                        ; is the character a digit?
je > l3                                ; if so, skip ahead, get user value
mov al,b [vga_lines]
mov b [screen_lines],al                ; otherwise, default to 23 lines
jmp switch_done                        ; and return to main parse loop
l3:                                    ; user-specified paging value:
call get_num                           ; read it in
cmp ah,00                              ; more than 255?
jne switch_m_err                       ; if so, problem
mov b [screen_lines],al                ; otherwise, save it
jmp switch_done                        ; and exit

show_cur_dir_maybe:                    ; DISPLAY DIRECTORY NAME IF NEEDED:
cmp w [last_bs],0000                   ; is there a backslash in fnbuf?
je > l9                                ; if not, exit in disgust
mov si,offset fnbuf
mov di,offset last_dir_shown
l2:
lodsb
cmp al,b [di]
jne > l8
inc di
cmp si,w [last_bs]
jbe l2
cmp b [di],00
je > l9
l8:
call show_file_count
call crlf                              ; display a blank line

show_cur_dir:
mov si,offset fnbuf                    ; point to start of filespec buffer
mov di,offset last_dir_shown
mov ah,02                              ; dos print-a-character function
l0:
cmp si,w [last_bs]                     ; passed the final backslash yet?
ja > l8                                ; if so, exit
mov dl,b [si]                          ; get a character from directory name
inc si
mov b [di],dl
inc di
int 21                                 ; and print it out
jmp l0                                 ; and loop back for more
l8:                                    ; done printing current directory name
mov b [di],00
call crlf                              ; terminate the current print line
l9:
ret                                    ; get outta here

show_cur_filename:                     ; DISPLAY FILENAME OF FOUND FILE:
dosprint msg_info_space                ; tab in
mov di,offset dta_name                 ; point to start of found filename
mov ah,02                              ; dos print-a-character function
mov cx,000e                            ; must print 14 characters
l0:
mov dl,[di]                            ; get a character from filename
cmp dl,'A'
jb > l4                                ; is it an uppercase letter?
cmp dl,'Z'                             ; if not, don't lowercase it
ja > l4
or dl,20                               ; if it is, force it to lowercase
l4:
inc di
cmp dl,00                              ; found the terminal null yet?
je > l1
int 21                                 ; if not, print the character
dec cx                                 ; decrement the characters index
jmp l0                                 ; and loop back
l1:                                    ; done printing filename:
mov dl,20
l2:
int 21                                 ; print spaces
loop l2                                ; until 13 characters have been shown
ret                                    ; then quit

show_date:                             ; display file's date stamp:
or ax,ax
jne > l10
dosprint msg_date_none
ret
l10:
push ax                                ; stash date stamp
mov al,b [country_date]                ; check country's date format
cmp al,01
je show_datee                          ; 01, european date format
cmp al,02
je show_datej                          ; 02, japanese date format
pop ax
push ax                                ; file's date stamp:
and ah,01
mov cl,05
shr ax,cl                              ; get month value in al
mov ah,80                              ; suppress leading zeroes
call time_print                        ; print month
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax
push ax                                ; file's date stamp:
and al,1f                              ; get day value in al
mov ah,00                              ; print leading zeroes
call time_print                        ; print day
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax                                 ; file's date stamp:
mov cl,09
shr ax,cl                              ; get year value in al
add ax,01980xd                         ; and normalize
call decout                            ; print the year
ret

show_datee:                            ; show date, european:
pop ax
push ax                                ; file's date stamp:
and ax,001f                            ; get day value in al
or ah,80
call time_print                        ; print day without leading zeroes
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ah,01
mov cl,05
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax                                 ; file's date stamp:
mov cl,09
shr ax,cl                              ; get year value in al
add ax,01980xd                         ; and normalize
call decout                            ; print the year
ret

show_datej:                            ; show date, japanese:
pop ax
push ax                                ; file's date stamp:
mov cl,09
shr ax,cl                              ; get year value in al
add ax,01980xd                         ; and normalize
call decout                            ; print the year
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ah,01
mov cl,05
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax                                 ; file's date stamp:
and ax,001f                            ; get day value in al
call time_print                        ; print day with leading zeroes
ret

show_time:                             ; display file's time stamp:
push ax                                ; save time stamp for future reference
mov cl,0b
shr ax,cl                              ; get hour in al
cmp b [country_time],00                ; do the locals use a 24-hour clock?
jne show_time_20                       ; if so, skip all am / pm fiddling
mov b [msg_info_ampm+1],'a'            ; assume a.m.
cmp al,00                              ; is it midnight?
jne show_time_15                       ; no, continue ....
mov al,0c                              ; display midnight as '12 am'
jmp show_time_20
show_time_15:                          ; not midnight:
cmp al,0c                              ; is it before noon?
jb show_time_20                        ; if so, don't need to manipulate it
mov b [msg_info_ampm+1],'p'            ; noon or later:  display as 'pm'
cmp al,0c                              ; is it noon?
je show_time_20                        ; if so, display as '12 pm'
sub al,0c                              ; otherwise, normalize hours
show_time_20:                          ; done fiddling with hours:
mov ah,80                              ; suppress leading zeroes
call time_print                        ; and print hours
mov dl,b [country_tsep]
doscall 02                             ; followed by the time separator char
pop ax
push ax                                ; file's time stamp:
and ah,07
mov cl,05
shr ax,cl                              ; get minutes in al
call time_print                        ; print minutes with leading zeroes
mov dl,b [country_tsep]
doscall 02                             ; followed by the time separator char
pop ax                                 ; file's time stamp:
and ax,001f
shl ax,01
call time_print                        ; print seconds with leading zeroes
cmp b [country_time],00                ; do the locals use a 24-hour clock?
jne > l30
dosprint msg_info_ampm                 ; if not, display a.m. or p.m.
l30:
ret

time_print:                            ; STUPID TWO-DIGIT DECIMAL PRINT:
mov dx,'0' by '0'
time_print_1:
cmp al,0a                              ; did i mention that it's stupid?
jb time_print_2
sub al,0a
inc dl                                 ; tens digit in .dl as ascii
jmp time_print_1
time_print_2:
add dh,al                              ; ones digit in .dh as ascii
test ah,80                             ; supposed to suppress leftmost zero?
je time_print_3
cmp dl,'0'                             ; if so, is the tens digit a zero?
jne time_print_3
mov dl,20                              ; if both true, convert it to a space
time_print_3:
mov ah,02
int 21                                 ; print tens digit (or space)
mov dl,dh
int 21                                 ; print ones digit
ret                                    ; gawd, is this stupid

show_dow_err:                          ; error computing day of week:
mov dx,0007                            ; return 7 (no day-of-week)
jmp show_dow_x

show_dow:                              ; compute and display day of week:
mov w [temp],ax                        ; save date in directory format
mov cl,09
shr ax,cl
mov w [date3],ax                       ; save year
mov ax,w [temp]
mov cl,05
shr ax,cl
and ax,000f                            ; extract month value
cmp al,01                              ; month less than 1?
jb show_dow_err                        ; if so, no day-of-week
cmp al,0c                              ; month greater than 12?
ja show_dow_err                        ; if so, no day-of-week
mov w [date1],ax                       ; save month
mov ax,w [temp]
and ax,001f                            ; extract day value
cmp al,01                              ; day less than 1?
jb show_dow_err                        ; if so, no day-of-week
mov w [date2],ax                       ; save day
call test_leap_year                    ; set correct length for february
mov bx,w [date1]
mov cl,b [months_table-1+bx]           ; get length of month in .cl
cmp cl,b [date2]                       ; date greater than maximum?
jb show_dow_err                        ; if so, no day-of-week
zero bx
l3:
mov al,b [months_table+bx]             ; get length of month
cbw                                    ; as a word
inc bx
cmp bx,w [date1]                       ; hit the user's month yet?
je > l4                                ; yes, exit this loop
add w [date2],ax                       ; no, add month length into julian
jmp l3                                 ; and loop back for next month
l4:                                    ; added in lengths of previous months:
mov bx,w [date3]                       ; get dos year in .bx
or bx,bx                               ; dos year zero?
je > l8                                ; if so, skip following calculations
inc w [date2]                          ; add one for leap day 1980
mov ax,bx
mov dx,0365xd
mul dx                                 ; multiply year number by 365
add w [date2],ax                       ; and add into the julian number
mov ax,bx
dec ax                                 ; decrement year number
shr ax,01
shr ax,01                              ; and divide by four
add w [date2],ax                       ; add leap days into julian number
cmp bx,0120xd                          ; year greater than 2100?
jbe > l8
dec w [date2]                          ; if so, subtract one leap day
l8:                                    ; done computing julian number:
; mov dx,0000
; mov ax,w [date2]                     ; debug code only:
; call dec_print_big                   ; display computed julian
; mov dl,20
; doscall 02
zero dx
mov ax,w [date2]                       ; get julian date as 32-bit number
inc ax                                 ; add one (1-1-1980 was a tuesday)
mov cx,0007                            ; divide julian number by seven
div cx                                 ; remainder in .dx is the day of week
show_dow_x:
shl dx,01
shl dx,01                              ; multiply dow number by four
add dx,offset dow_names                ; to get offset within dow names table
doscall 09                             ; print dow name
mov dl,20                              ; and a space
doscall 2
ret                                    ; exit

show_attribs:                          ; display file's attributes:
mov dl,al                              ; save attributes byte
zero si                                ; pointer to bit-name letters
mov cl,20                              ; highest bit is #5 (archive)
attr_loop:
mov al,'.'                             ; assume a space
test dl,cl                             ; is this bit set?
je attr_go                             ; clear, use the space
mov al,b [attr1+si]                    ; set, get the bit-name letter instead
attr_go:
mov b [msg_attrib+5+si],al             ; poke space or letter into string
inc si                                 ; and point to the next letter
attr_skip:
shr cl,1                               ; and shift right to next bit
test cl,18                             ; bit 3 (volume label) we
jne attr_skip                          ; don't care about, so skip it
cmp cl,00                              ; run out of bits?
jne attr_loop                          ; no, loop back for next
dosprint msg_attrib                    ; yes, print the attribute string
ret

show_file_size:
mov cl,0c
mov b [dp_min],cl
call dec_print_big
dosprint msg_bytes
ret

show_file_count:                       ; SHOW NUMBER OF FILES FOUND, CHANGED:
mov ax,w [found_lo]
or ax,w [found_hi]                     ; found any at all?
or ax,ax
je > l0                                ; if not, do nothing and exit
call crlf                              ; found some; print a blank line
dosprint msg_num_found                 ; and 'files found' message
mov ax,w [found_lo]
mov dx,w [found_hi]
call dec_print_big                     ; print number of files found
dosprint msg_num_touched               ; print 'files changed' message
mov ax,w [touch_lo]
mov dx,w [touch_hi]
call dec_print_big                     ; and number of files changed
dosprint msg_in_dir
zprint last_dir_shown
mov ax,w [found_lo]
add w [total_found_lo],ax              ; add number found
mov ax,w [found_hi]
adc w [total_found_hi],ax              ; to total number found
mov ax,w [touch_lo]
add w [total_touch_lo],ax              ; add number changed
mov ax,w [touch_hi]
adc w [total_touch_hi],ax              ; to total number changed
zero ax
mov w [found_lo],ax
mov w [found_hi],ax                    ; then zero out files-found count
mov w [touch_lo],ax
mov w [touch_hi],ax                    ; and files-changed count
l0:
ret


dec_print_big:                         ; DISPLAY DOUBLEWORD IN DX:AX
mov w [dp_t1],ax                       ; save the doubleword value
mov w [dp_t2],dx                       ; for later use
mov b [dp_t4],00
mov bx,000a                            ; ten decimal is our divisor
push bx                                ; also our end-of-stack marker
mov cl,00                              ; init digits-between-commas count
dec_print_1:                           ; main decimal division loop
zero dx
mov ax,w [dp_t2]                       ; dx:ax contains the high word as quad
div bx                                 ; divide by ten
mov w [dp_t2],ax                       ; save new high-order word
mov ax,w [dp_t1]                       ; get the old low word
div bx                                 ; and divide by ten
mov w [dp_t1],ax                       ; save new low word
add dx,0030                            ; convert remainder to ascii digit
push dx                                ; and save it on the stack
inc b [dp_t4]
cmp ax,0000                            ; anything left?
jne dec_print_12                       ; if so, continue with divisions
cmp w [dp_t2],0000
je dec_print_15                        ; if not, print out digits
dec_print_12:
inc cl
cmp cl,03                              ; three digits yet?
jne dec_print_1                        ; if not, loop back for next digit
mov cl,00                              ; yes, zero counter
mov dl,b [country_thou]
mov dh,dl                              ; and push a comma on the stack
push dx
inc b [dp_t4]
jmp dec_print_1                        ; and loop back for next digit
dec_print_15:                          ; done with divisions:
mov ah,02                              ; dos print-character function:
cmp b [dp_min],00                      ; right justified?
je dec_print_2                         ; if not, print digits now
mov cl,b [dp_min]                      ; get the decimal field width
sub cl,b [dp_t4]                       ; subtract number of characters pushed
jbe dec_print_2                        ; if width already exceeded, forget it
mov ch,00                              ; convert number of spaces to word
mov dl,20                              ; space character
dec_print_17:
int 21                                 ; print correct number of spaces
loop dec_print_17
dec_print_2:                           ; decimal printout loop
pop dx                                 ; get a digit from the stack
cmp dx,000a                            ; hit the end of stack yet?
je dec_print_3                         ; if so, exit decimal print routine
int 21                                 ; otherwise, print the digit
jmp dec_print_2                        ; and loop back for next digit
dec_print_3:
mov b [dp_min],00                      ; default to no justification
ret

dp_t1:                                 ; holds low-order word
dw 0000
dp_t2:                                 ; holds high-order word
dw 0000
dp_t4:                                 ; count of characters pushed on stack
db 00
dp_min:                                ; minimum number of chars to print
db 00

decout:                                ; DECIMAL PRINT, ONE WORD, NO COMMAS:
zero dx
push dx                                ; save zero as end-of-stack marker
mov cx,000a                            ; use ten as decimal divisor
decout1:                               ; decimal division loop:
div cx                                 ; divide to get next lowest digit
add dx,'0'                             ; convert to ascii
push dx                                ; and save on the stack
zero dx                                ; recover high word for division
cmp ax,dx                              ; and check whether done dividing yet
jne decout1                            ; if not, loop back for more
mov ah,02                              ; dos print-a-character function
decout2:                               ; decimal print loop:
pop dx                                 ; get a word from the stack
cmp dx,0000                            ; run out of decimal digits yet?
je decout3                             ; if so, we're done
int 21                                 ; otherwise, print this digit
jmp decout2                            ; and loop back for more
decout3:
ret

get_num:                               ; READ DEC. NUMBER FROM COMMAND LINE:
mov al,b [si]                          ; examine first digit
call test_digit                        ; it is a digit, right?
jne get_num_err                        ; if not, exit with carry set
zero bx                                ; start with zero
get_num_loop:
lodsb                                  ; get digit from command line
sub al,'0'                             ; and convert to a value
mov cl,al                              ; save it in .cl
mov ch,00                              ; as a word value
mov ax,bx                              ; get interim value
mov bx,000a
mul bx                                 ; and multiply by ten
cmp dx,0000                            ; if overflow on multiply,
jne get_num_err                        ; abort
add ax,cx                              ; add in value of most recent digit
jc get_num_err
mov bx,ax                              ; and save
mov al,b [si]                          ; examine next character
call test_digit                        ; is it a decimal digit?
je get_num_loop                        ; if so, use it as well
mov ax,bx                              ; if not, done -- return value in .ax
clc                                    ; with carry clear
ret
get_num_err:                           ; overflow, or no number at all:
stc                                    ; exit with carry set
ret

force_uc:                              ; FORCE CHARACTER IN .AL TO UPPERCASE:
cmp al,'a'
jb > l0                                ; lowercase letter?
cmp al,'z'                             ; if not, make no changes
ja > l0
and al,0df                             ; if so, force to uppercase
l0:
ret

test_eol:                              ; IS CHARACTER IN .AL AN EOL OR NULL?
cmp al,00
je ret
cmp al,0d
ret

test_switch:                           ; IS CHAR IN .AL A SWITCH CHARACTER?
cmp al,'/'                             ; exit with zero-flag set if it is
je > l1
cmp al,'-'
l1:
ret

test_space:                            ; IS CHARACTER IN .AL A SPACE OR TAB?
cmp al,20                              ; exit with zero-flag set if it is
je > l1
cmp al,09
l1:
ret

test_colon:                            ; IS CHAR. IN .AL A COLON OR EQUALS?
cmp al,':'                             ; exit with zero-flag set if it is
je > l0
cmp al,'='
l0:
ret

test_tsep:                             ; IS CHAR. IN .AL A TIME SEPARATOR?
cmp al,':'                             ; exit with zero-flag set if it is
je > l0
cmp al,'.'
je > l0
cmp al,','
l0:
ret

test_dsep:                             ; IS CHAR. IN .AL A DATE SEPARATOR?
cmp al,'/'                             ; exit with zero-flag set if it is
je > l0
cmp al,'-'
je > l0
cmp al,'.'
l0:
ret

test_digit:                            ; IS CHARACTER IN .AL A DECIMAL DIGIT?
cmp al,'0'                             ; exit with zero-flag set if it is
jb > l0
cmp al,'9'
ja > l0
cmp al,al
l0:
ret

get_current_time:                      ; AND CONVERT TO DIRECTORY FORMAT
doscall 2a                             ; get date
sub cx,01980xd                         ; normalize year to 1980-based
mov ch,cl
shl ch,01                              ; and multiply by 512
and dl,1f                              ; mask off day (shouln't need this)
mov cl,dl                              ; add in day
shr dx,01
shr dx,01
shr dx,01                              ; multiply month by 32
and dx,01e0                            ; mask off month value
or cx,dx                               ; and add it in
mov w [today],cx                       ; stash date in directory format
doscall 2c                             ; get time
mov al,00
shl ch,01
shl ch,01
shl ch,01                              ; multiply hours by 2048
mov ah,ch                              ; save hours
shl cx,01
shl cx,01
shl cx,01
shl cx,01
shl cx,01                              ; multiply minutes by 32
and cx,07e0                            ; mask off minutes
or ax,cx                               ; and add them in
shr dh,01                              ; drop least significant bit of
and dh,1f                              ; seconds and mask 'em off
or al,dh                               ; add in seconds
mov w [right_now],ax                   ; stash time in directory format
ret

get_vga_lines:                         ; FIGURE DEFAULT SCROLL LENGTH
push cs
pop es                                 ; point es:di
mov di,offset dta                      ; to temporary buffer
mov ax,1b00                            ; vga call:
zero bx
int 10                                 ; get state information
cmp al,1b                              ; was call successful?
jne > l2                               ; if not, done with paging setup
mov al,b [dta+22]                      ; get number of lines
sub al,02                              ; and subtract 2
mov b [vga_lines],al                   ; save as number of lines to scroll
l2:
ret

show_date_format:                      ; DISPLAY LOCAL DATE FORMAT:
call get_country_info                  ; get local format (override any /f:x)
dosprint msg_date_format               ; display introductory message
mov bx,offset msg_date_fmt_0           ; point to u.s. format string
cmp b [country_date],00                ; using u.s. date format?
je show_date_format_1                  ; if so, okay, use u.s. string
mov bx,offset msg_date_fmt_1           ; point to european format string
cmp b [country_date],01                ; using european date format?
je show_date_format_1                  ; if so, okay, use european string
mov bx,offset msg_date_fmt_2           ; otherwise, use japanese string
show_date_format_1:
mov ah,02                              ; dos print-a-character function
show_date_format_2:
mov dl,b [bx]                          ; get a byte from format string
inc bx
cmp dl,00                              ; end of string yet?
je show_date_format_4                  ; if so, exit
cmp dl,'-'                             ; minus sign?
jne show_date_format_3                 ; if so, convert
mov dl,b [country_dsep]                ; to local date separator character
show_date_format_3:
int 21                                 ; print the character
jmp show_date_format_2                 ; and loop back for more
show_date_format_4:                    ; done printing format string:
dosprint msg_date_fmt_done             ; print closing message
ret                                    ; and exit

clean_up_filespec:                     ; CANONICALIZE FILESPEC:
call fix_last_bs                       ; find final backslash
call must_have_drive                   ; supply drive letter if needed
call must_have_path                    ; supply pathname if needed
call never_ends_in_bs                  ; make sure filespec doesn't end in \
call doesnt_name_dir                   ; make sure it isn't a directory name
call no_double_bs                      ; eliminate any duplicate backslashes
call dots_fix                          ; eliminate any . or .. entries
call add_star_maybe                    ; add .* if permitted in this context
call get_short_filespec                ; extract short filespec from long
ret

must_have_drive:                       ; MAKE SURE FILESPEC HAS A DRIVE:
mov ax,w [fnbuf]                       ; examine the first two characters :
cmp ax,'\' by '\'                      ; is this a unc filespec?
je ret                                 ; if so, don't muck about with it
cmp ah,':'                             ; is the second a colon?
jne > l0                               ; if not, add drive letter
cmp al,'A'
jb > l0                                ; is the first a letter?
cmp al,'Z'                             ; if not, add drive letter
ja > l0                                ; a drive letter was specified:
cmp b [fnbuf+2],00                     ; was there anything after it?
je > l5                                ; if not, add star-dot-star
ret                                    ; otherwise, exit with no change
l0:
call find_null_fnbuf                   ; find the end of the filespec
cmp di,offset fnbuf + fn_max - 2       ; will this overflow fnbuf?
jae > l7                               ; if so, problem
l1:
mov al,b [di]                          ; copy a byte from source
mov b [di+2],al                        ; to destination
dec di
cmp di,offset fnbuf                    ; done yet?
jae l1                                 ; no, continue
doscall 19                             ; get current drive number
add al,'A'                             ; and convert to a letter
mov b [fnbuf+0],al                     ; stash it in the filename buffer
mov b [fnbuf+1],':'                    ; poke in a colon
cmp w [last_bs],0000                   ; if a backslash was found,
je > l2
add w [last_bs],0002                   ; add 2 to its location
l2:
ret                                    ; and we're done
l5:                                    ; only a drive letter found:
mov si,offset star_dot_star
mov di,offset fnbuf+2                  ; supply a star-dot-star
call copy_string
ret
l7:                                    ; adding a drive would overflow fnbuf:
jmp error_fnbuf_over                   ; handle error

must_have_path:                        ; SUPPLY PATHNAME IF NEEDED:
cmp w [fnbuf],'\' by '\'               ; is this a unc filespec?
je > l4                                ; if so, don't muck about with it
cmp b [fnbuf+2],'\'                    ; did the user supply an abs. path?
je > l4                                ; if so, exit without further ado
mov si,offset fnbuf+2                  ; starting immediately after colon,
mov di,offset dta                      ; copy everything to temp buffer
call copy_string
mov w [fnbuf+2],00 by '\'              ; poke in initial backslash
mov dl,b [fnbuf]                       ; get drive letter
sub dl,40                              ; and convert to a number
mov si,offset fnbuf + 3
doscall 47                             ; get current directory name
call find_null_fnbuf                   ; find the end of the pathname
dec di
cmp b [di],'\'                         ; does path already end in backslash?
je > l3
inc di
l3:
mov b [di],'\'                         ; terminate pathname
inc di
mov si,offset dta
call copy_string                       ; and copy remainder of filespec back
call fix_last_bs                       ; repair last_bs variable
l4:
ret

never_ends_in_bs:                      ; FIX PATHNAMES ENDING IN BACKSLASH:
mov di,w [last_bs]                     ; get address of final backslash
inc di                                 ; and examine the following char.
cmp b [di],00                          ; is it a null?
jne > l0                               ; if not, do nothing and exit
mov si,offset star_dot_star            ; if so, tack on a star-dot-star
call copy_string                       ; after the backslash
cmp di,offset fnbuf + fn_max           ; didn't overflow the buffer, did we?
ja > l2
l0:
ret
l2:
jmp error_fnbuf_over                   ; oops

doesnt_name_dir:                       ; MAKE SURE IT'S NOT A DIRECTORY NAME:
call find_null_fnbuf                   ; find end of filename
push di                                ; and remember it
mov b [di],'\'                         ; tack on a backslash
inc di
mov si,offset star_dot_star            ; and a star-dot-star
call copy_string
mov di,w [last_bs]
inc di                                 ; check first character after final \
cmp b [di],'.'                         ; if it's a period,
je > l3                                ; assume this is a directory name
mov cx,0006
mov dx,offset fnbuf
doscall 4e                             ; search for files
jnc > l3                               ; if no problem, leave it like this!
cmp ax,0012
je > l3                                ; empty directory, leave it like this!
cmp ax,0002
je > l3                                ; empty directory, leave it like this!
pop di                                 ; not a directory:
mov b [di],00                          ; remove the \*.*
ret
l3:                                    ; fnbuf actually names a directory:
pop ax
mov w [last_bs],ax                     ; save address of last backslash
add ax,0004                            ; calculate address of terminal null
cmp ax,offset fnbuf + fn_max           ; overflowed the working buffer?
jae > l5
ret                                    ; no, exit
l5:
jmp error_fnbuf_over                   ; yes, apologize

no_double_bs:                          ; remove any duplicated backslashes :
mov di,offset fnbuf                    ; start at beginning of filename
l10:
inc di
mov ax,w [di]                          ; examine two characters at a time
cmp al,00                              ; found the end of the filespec yet?
je ret                                 ; if so, exit
cmp ax,'\' by '\'                      ; duplicate backslashes?
jne l10                                ; if not, loop back, keep searching
l20:
mov si,di                              ; copy down
inc si                                 ; from the second backslash
call copy_string                       ; onto the first
dec w [last_bs]                        ; adjust last-backslash pointer
jmp no_double_bs                       ; and loop back for more abuse
ret

dots_fix:                              ; LOOK FOR . OR .. ENTRIES:
mov si,offset fnbuf                    ; start at beginning of filespec
l0:
mov ax,w [si]                          ; look at two bytes at a time
inc si
cmp al,00                              ; found the end of the filespec yet?
jne > l1
l9:
call fix_last_bs
ret                                    ; if so, exit
l1:
cmp ax,'.' by '\'                      ; found a . entry?
jne l0                                 ; if not, keep looking
mov cx,0001                            ; one dot found so far
l2:
inc si                                 ; skip past that first dot
mov al,b [si]                          ; examine the next character
cmp al,00                              ; end of filespec?
je l9                                  ; if so, exit
cmp al,'.'                             ; another dot?
jne > l3
inc cx                                 ; if so, count it
jmp l2                                 ; and keep parsing
l3:
cmp al,'\'                             ; another backslash?
jne l0                                 ; if not, ignore this (weird) entry
mov di,si                              ; point .di to backslash after dots
l4:
dec di                                 ; and scan backwards through fnbuf
cmp di,offset fnbuf                    ; fell off the beginning of fnbuf?
jbe > l8                               ; if so error
cmp b [di],'\'                         ; found a backslash?
jne l4                                 ; if not, keep searching backwards
loop l4                                ; decrement dots count, continue
call copy_string                       ; copy string after dots down
jmp dots_fix                           ; and loop back for more .\ entries
l8:                                    ; too many dot entries:
call error_out
dosprint msg_err_dots_fix              ; complain about it
doscall2 4c15                          ; and exit with errorlevel 21

add_star_maybe:                        ; ADD .* IF PERMITTED IN THIS CONTEXT:
test b [more_flags],80                 ; allowed to add .* ?
jne > l8                               ; if so, exit without effect
test b [flags],04                      ; list file name?  name from list?
jne > l8                               ; either case, exit without effect
mov cl,00                              ; have not found dot yet
mov si,offset fnbuf                    ; start at beginning of filespec
l1:
lodsb                                  ; get a character from filespec
cmp al,'\'                             ; backslash?
jne > l3
mov cl,00                              ; if so, note dot not found yet
l3:
cmp al,'.'                             ; dot?
jne > l4
mov cl,01                              ; if so, note dot has been found
l4:
cmp al,00                              ; found end of filespec?
jne l1                                 ; if not, keep parsing
cmp cl,00                              ; found a dot in the filespec?
jne > l8                               ; if so, exit with no effect
cmp si,offset fnbuf + fn_max - 2       ; have room to add the .* ?
ja > l9                                ; if not, bomb out
dec si                                 ; point to the terminal null
mov w [si],'*' by '.'                  ; add the .*
inc si
inc si
mov b [si],00                          ; and the terminal null
l8:                                    ; normal exit
ret
l9:                                    ; filespec buffer overflow:
jmp error_fnbuf_over                   ; bomb out

get_short_filespec:                    ; EXTRACT SHORT FILESPEC FROM LONG:
mov si, offset fnbuf + 2               ; copy entire filespec
cmp w [last_bs],0000                   ; or, if directory was specified,
je > l0
mov si,w [last_bs]                     ; the filespec immediately following
inc si                                 ; the last backslash
l0:
mov di,offset nambuf                   ; into the name buffer
push ds
pop es
l1:
lodsb                                  ; copy one character at a time
stosb                                  ; into the short name buffer
cmp al,00                              ; until the terminal null is found
jne l1                                 ; then stop.
cmp di,offset nambuf + 0e              ; overflowed the short name buffer?
jae > l3
ret                                    ; no, bliss
l3:                                    ; nambuf has overflowed:
call error_out                         ; fix stdout to screen
dosprint msg_err_nambuf_over           ; complain
doscall2 4c10                          ; and exit with errorlevel 16


alloc_tree_buffer:                     ; CREATE BUFFER FOR /S TREE IF NEEDED:
test b [flags],08                      ; /s specified?
je > l1                                ; no, don't bother with tree buffer
mov bx,1000                            ; yes, allocate 64k
doscall 48                             ; for tree buffer
jnc > l0
jmp trs_80                             ; any problem, complain and abort
l0:
mov w [tree_seg],ax                    ; no problem, remember segment
mov es,ax
zero ax
mov w [es:0000],ax                     ; and empty the tree buffer
l1:
ret

alloc_list_buffer:                     ; CREATE BUFFER FOR FILE LIST:
mov bx,0100                            ; allocate four kilobytes
doscall 48                             ; for list buffer
jnc > l0
jmp trs_80                             ; any problem, complain and abort
l0:
mov w [list_seg],ax                    ; no problem, remember segment
mov w [list_pnt],2000                  ; and note that the buffer is empty
ret

use_template_stamps:                   ; USE /C DATE AND TIME, IF PRESENT:
mov al,b [flags]
and al,0a0                             ; check for conflict between
cmp al,0a0                             ; /d and /cd:
jne > l1
call error_out                         ; if both are specified,
dosprint msg_err_d_cd                  ; print an error message
doscall2 4c10                          ; and exit with errorlevel 16
l1:
mov al,b [flags]
and al,50                              ; check for conflict between
cmp al,50                              ; /t and /ct:
jne > l2
call error_out                         ; if both are specified,
dosprint msg_err_t_ct                  ; print an error message
doscall2 4c10                          ; and exit with errorlevel 16
l2:
mov al,b [flags]
and al,30                              ; get template date and/or time flags
shl al,01
shl al,01                              ; and copy them over
or b [flags],al                        ; into the main date and/or time flags
ret

eval_user_stamps:                      ; EVALUATE USER DATE AND TIME VALUES:
test b [flags],80                      ; was there any /d at all?
je > l0                                ; if not, don't evaluate date stamp
test b [more_flags],20                 ; user-specified date stamp?
jne eval_user_date                     ; if not, don't evaluate date stamp
l0:
jmp eval_time
eval_user_date:                        ; EVALUATE USER DATE VALUE:
cmp b [country_date],02                ; japanese (long) format date?
jne > l4                               ; if not, don't do japanese adjustment
test b [more_flags],08                 ; long format -- user specified year?
je > l4                                ; if not, don't do japanese adjustment
mov ax,w [date1]
mov bx,w [date2]                       ; if so, shuffle values around:
mov cx,w [date3]
mov w [date3],ax                       ; first number is really the year
mov w [date1],bx                       ; second number is really the month
mov w [date2],cx                       ; third number is relly the day
jmp > l5
l4:
cmp b [country_date],01                ; european (long or short) format?
jne > l5
mov ax,w [date1]                       ; if so, shuffle values around:
mov bx,w [date2]
mov w [date2],ax                       ; first number is really the day
mov w [date1],bx                       ; second number is really the month
l5:
mov ax,w [date1]                       ; check user month:
mov bx,0c01                            ; normally 1 through 12
mov cx,0f00                            ; but might be zero through 15
mov dx,offset msg_month_eq             ; point to 'month =' message
call test_range                        ; and verify that month is reasonable
if c jmp eval_date_err
mov ax,w [date2]                       ; check user day:
mov bx,1f01                            ; normally 1 through 31
mov cx,1f00                            ; but might be zero through 31
mov dx,offset msg_day_eq               ; point to 'day =' message
call test_range                        ; and verify that day is reasonable
if c jmp eval_date_err
mov ax,w [date3]                       ; check user year:
mov dx,offset msg_year_eq
cmp ax,0050                            ; less than 80?
jae > l6                               ; if so, year is 2000 through 2079
add ax,0014                            ; so add 20
mov w [date3],ax                       ; to get dos year 20 through 99
jmp pack_date                          ; and convert date to directory form
l6:
cmp ax,0063                            ; 80 through 99?
ja > l7                                ; if so, year is 1980 through 1999
sub ax,0050                            ; so subtract 80
mov w [date3],ax                       ; to get dos year 0 through 19
jmp pack_date                          ; and convert date to directory form
l7:
cmp ax,01980xd                         ; anything else less than 1980
jb eval_date_err                       ; is an error
cmp ax,02107xd                         ; anything over 2107
ja eval_date_err                       ; is also an error
test b [more_flags],02                 ; weird values allowed?
jne > l8
cmp ax,02099xd                         ; if not, any year over 2099
ja eval_date_err                       ; is also an error
l8:
sub ax,01980xd                         ; year is 1980 - 2107, subtract 1980
mov w [date3],ax                       ; to get dos year 0 through 127
pack_date:
mov ax,w [date3]                       ; get user year
mov cl,09
shl ax,cl                              ; and multiply by 512
mov bx,w [date1]                       ; get user month
mov cl,05
shl bx,cl                              ; and multiply by 32
or ax,bx                               ; add it in
or ax,w [date2]                        ; add in user day
mov w [newdate],ax                     ; and save it
test b [more_flags],02                 ; weird dates allowed?
jne eval_time                          ; if so, skip remaining tests
call test_leap_year                    ; set correct length for february
mov bx,w [date1]
mov al,b [months_table-1+bx]           ; get max days in user's month
cmp al,b [date2]                       ; compare against user's day
jae eval_time                          ; if okay, continue with user's time
call error_out                         ; problem!
dosprint msg_err_user_date             ; print error message
mov ax,w [newdate]
call show_date                         ; and display the user's illegal date
call crlf                              ; blank line
doscall2 4c10                          ; exit with errorlevel 16

eval_time:                             ; skip over error code, evaluate time
jmp eval_user_time
eval_date_err:                         ; problem with user-specified date:
push ax                                ; save user value
push dx                                ; and pointer to string
call error_out                         ; force error output
dosprint msg_err_user_date             ; print error message 
pop dx
doscall 09                             ; and value-name string
pop ax
call decout                            ; and the user's erroneous value
call crlf                              ; and a blank line
doscall2 4c10                          ; and exit with errorlevel 16

eval_user_time:                        ; EVALUATE USER TIME VALUE:
test b [flags],40                      ; was there any /t at all?
je > l0                                ; if not, don't evaluate date stamp
test b [more_flags],10                 ; user-specified time stamp?
jne > l1                               ; if not, don't evaluate time stamp
l0:
ret
l1:
mov ax,w [user_hour]                   ; check user hours:
mov bx,1700                            ; normally zero through 23
mov cx,1f00                            ; but might be zero through 31
mov dx,offset msg_hour_eq              ; point to 'hour =' message
call test_range                        ; and verify that hour is reasonable
jc eval_time_err
mov ax,w [user_minute]                 ; check user minutes:
mov bx,3b00                            ; normally zero through 59
mov cx,3f00                            ; but might be zero through 63
mov dx,offset msg_minute_eq            ; point to 'minute =' message
call test_range                        ; and verify that minute is reasonable
jc eval_time_err
mov ax,w [user_second]                 ; check user seconds:
mov bx,3b00                            ; normally zero through 59
mov cx,3f00                            ; but might be zero through 63
mov dx,offset msg_second_eq            ; point to 'second =' message
call test_range                        ; and verify that second is reasonable
jc eval_time_err
mov ax,w [user_hour]                   ; get user hours
mov cl,0b
shl ax,cl                              ; and multiply by 2048
mov bx,w [user_minute]                 ; get user minutes
mov cl,05
shl bx,cl                              ; and multiply by 32
or ax,bx                               ; add in minutes
mov bx,w [user_second]                 ; get user seconds
shr bx,01                              ; and divide by two
or ax,bx                               ; add in user seconds
cmp ax,0000                            ; midnight exactly?
jne > l3                               ; no, don't worry about 12am blanking
cmp w [dos_version],031f               ; dos version 3.31 or later?
jae > l3                               ; yes, don't worry about 12am blanking
test b [more_flags],02                 ; weird values permitted?
jne > l3                               ; yes, don't worry about 12am blanking
inc ax                                 ; else add two seconds to midnight
l3:
mov w [newtime],ax                     ; and save
ret
eval_time_err:                         ; problem with user-specified time:
push ax                                ; save the value
push dx                                ; and the pointer to the value's name
call error_out
dosprint msg_err_user_time             ; print an error message
pop dx
doscall 09                             ; and the value's name
pop ax
call decout                            ; and the erroneous value
call crlf                              ; and a blank line
doscall2 4c10                          ; and exit with errorlevel 16

test_leap_year:                        ; SET CORRECT LENGTH FOR FEBRUARY:
cmp w [date3],0120xd                   ; year 2100 (dos year 120) ?
je > l1                                ; if so, not a leap year
test b [date3],03                      ; year divisible by 4 ?
je > l2                                ; if so, it is a leap year
l1:                                    ; not a leap year:
mov b [months_table+1],1c              ; february has 28 days
ret
l2:                                    ; leap year:
mov b [months_table+1],1d              ; february has 29 days
ret

get_fn_from_list:                      ; READ FILESPEC FROM FILE LIST:
test b [flags],04                      ; are we using a file list?
jne > l1
clc
ret                                    ; if not, simply exit with carry clear
l1:
cmp w [auxhandle],0000                 ; is it open yet?
jne > l3                               ; if so, continue
mov dx,offset fnbuf
doscall2 3d20                          ; open file list file
jnc > l2
dosprint msg_err_listfile              ; problem:  print error message
zprint fnbuf                           ; and filename
stc                                    ; and exit with carry
ret
l2:
mov w [auxhandle],ax                   ; save file handle
mov w [list_pnt],2000                  ; and note that the buffer is empty
l3:
mov di,offset fnbuf
mov b [di],00                          ; empty the filespec buffer
and b [flags],0fe                      ; not between quotes
read_fn_loop:
call read_from_list                    ; get a character from the file list
cmp al,1a                              ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,20                              ; end of line?
jb read_fn_eol                         ; if so, deal with it
call test_space                        ; space?
je read_fn_sp                          ; if so, deal with it
cmp al,'"'                             ; quote mark?
je read_fn_qu                          ; if so, deal with it
cmp al,';'                             ; semicolon?
je read_fn_semi                        ; if so, deal with it
cmp al,':'                             ; colon?
je read_fn_semi                        ; if so, deal with it
call force_uc
cmp al,'/'                             ; slash?
jne read_fn_ch
mov al,'\'                             ; if so, convert to a backslash
read_fn_ch:                            ; got a legal character for filename:
mov b [di],al                          ; put it in the buffer
inc di
mov b [di],00                          ; and null-terminate it
cmp di,offset fnbuf + fn_max           ; blown past the end of the buffer?
jb read_fn_loop                        ; no, loop back for more
jmp read_fn_spam                       ; yes, deal with it
read_fn_eof:                           ; found end of list file:
mov bx,w [auxhandle]
doscall 3e                             ; close the list file
mov w [auxhandle],0000                 ; and mark it closed
and b [flags],0fb                      ; no more file list!
cmp b [fnbuf],00                       ; was a filename retrieved before eof?
je > l1
clc                                    ; yes, exit with carry clear
ret
l1:
stc                                    ; no, exit with carry set
ret
read_fn_sp:                            ; found a space:
test b [flags],01                      ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
read_fn_eol:                           ; found end of line:
cmp b [fnbuf],00                       ; anything in the buffer yet?
je read_fn_loop                        ; if not, keep looking
call clean_up_filespec                 ; clean it up
clc
ret                                    ; and exit
read_fn_qu:                            ; found a quote:
test b [flags],01                      ; was there an open quote?
jne read_fn_eol                        ; if so, it ends the filespec
cmp b [fnbuf],00                       ; anything in the buffer yet?
jne read_fn_ch                         ; if so, treat like any other char
or b [flags],01                        ; otherwise, this is an open quote
jmp read_fn_loop                       ; keep reading
read_fn_semi:                          ; found a semicolon:
test b [flags],01                      ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
cmp b [fnbuf],00                       ; anything in the buffer yet?
jne read_fn_ch                         ; if so treat like any other char
cmp al,':'                             ; was comment character a colon?
je read_fn_notice                      ; if so, this is a printable 'notice'
read_fn_remark:                        ; NONPRINTABLE COMMENT IN FILE LIST:
call read_from_list                    ; get a character from the file list
cmp al,1a                              ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,20                              ; found the end of the remark?
jae read_fn_remark                     ; if not, keep looking
jmp read_fn_loop                       ; otherwise, resume hunt for filespec
read_fn_notice:                        ; PRINTABLE NOTICE IN FILE LIST:
dosprint msg_notice                    ; introduce it
l0:
call read_from_list                    ; get a character from the file list
cmp al,1a                              ; end of file?
je > l2                                ; if so, deal with it
cmp al,20                              ; found the end of the notice?
jae > l1
call crlf                              ; if so, terminate the output line
jmp read_fn_loop                       ; and go back to the filespec search
l1:
mov dl,al                              ; otherwise, this is a printable char
doscall 02                             ; print it
jmp l0                                 ; and continue scanning through notice
l2:                                    ; end-of-file within notice:
call crlf                              ; terminate the output line
jmp read_fn_eof                        ; and the input file

read_fn_spam:                          ; overflowed the working buffer:
mov b [fnbuf],00                       ; empty the working buffer
dosprint msg_err_list_spam             ; print an error message
jmp read_fn_eof                        ; and kill the current file list

read_from_list:                        ; GET CHARACTER FROM FILE LIST FILE:
mov ax,w [list_pnt]
cmp ax,1000                            ; need to refill the buffer?
jb read_list                           ; nope, skip ahead
mov cx,1000                            ; read four kilobytes
mov bx,w [auxhandle]                   ; from the file list
zero dx                                ; to the start
mov ds,w [list_seg]                    ; of the list buffer
doscall 3f
push cs
pop ds                                 ; restore data segment
jnc > l3
call error_out
dosprint msg_err_read_list             ; problem!  print error message
doscall2 4c13                          ; and exit with errorlevel 19
l3:
mov w [list_pnt],0000                  ; move pointer back to start of buffer
cmp ax,1000                            ; got four kilobytes?
je read_list                           ; cool!
cmp ax,0000                            ; got anything at all?
jne > l4
mov al,1a                              ; if not, return end-of-file
ret
l4:
mov si,ax                              ; got less than four kilobytes:
mov es,w [list_seg]                    ; poke in an eof
mov b [es:si],1a                       ; just to be on the safe side
read_list:                             ; get buffered char from file list:
mov es,w [list_seg]                    ; segment of file list buffer
mov si,w [list_pnt]                    ; pointer into list buffer
mov al,b [es:si]                       ; get character from buffer
inc si
mov w [list_pnt],si                    ; and increment the pointer
push ds
pop es                                 ; fix data segment
ret                                    ; and exit

find_null_fnbuf:                       ; FIND END OF FILESPEC:
mov di,offset fnbuf                    ; fall through to:

find_null:                             ; FIND END OF ASCIIZ STRING:
cmp b [di],00                          ; found null yet?
jne >l0                                ; no, keep searching
ret                                    ; yes, exit
l0:
inc di
jmp find_null

fix_last_bs:                           ; REPAIR LAST_BS VARIABLE:
mov w [last_bs],0000                   ; note no backslashes found yet
mov si,offset fnbuf                    ; point to start of filespec buffer
l0:
mov al,b [si]                          ; look at character
cmp al,00                              ; terminal null?
je > l2                                ; if so, exit
cmp al,'\'                             ; backslash?
jne > l1
mov w [last_bs],si                     ; if so, save its address
l1:
inc si                                 ; and keep on going
jmp l0
l2:                                    ; found the terminal null
cmp si,offset fnbuf + fn_max           ; have we wandered off the edge?
jae > l4                               ; if so, problem
ret
l4:                                    ; spammed fnbuf:
jmp error_fnbuf_over                   ; abort

prompt_user:                           ; PROMPT USER, IF NEEDED:
test b [more_flags],40                 ; was /p or /q specified?
je prompt_user_x                       ; if not, bug out
dosprint msg_query                     ; display prompt message
l0:
call flush_key_buffer                  ; empty keyboard buffer
mov ah,00
int 16                                 ; get a keystroke
call force_uc                          ; and convert it to uppercase
cmp al,'A'                             ; 'a' for 'all' ?
je prompt_user_all                     ; if so, deal with it
cmp al,'Q'                             ; 'q' for 'quit' ?
je prompt_user_quit                    ; if so, deal with it
cmp al,'N'                             ; 'n' for 'no' ?
je prompt_user_1                       ; if so, normal exit
cmp al,'Y'                             ; 'y' for 'yes' ?
jne l0                                 ; if not, ignore this keystroke
prompt_user_1:                         ; 'y' or 'n' pressed:
push ax                                ; save the keystroke
dosprint msg_unquery                   ; erase the prompt message
pop ax                                 ; and check the user's keystroke
cmp al,'Y'                             ; was it 'y' for 'yes' ?
prompt_user_x:                         ; exit
ret
prompt_user_all:                       ; 'a' for 'all' :
and b [more_flags],0bf                 ; turn off prompting
mov al,'Y'                             ; pretend this was a 'y'
jmp prompt_user_1                      ; and exit normally
prompt_user_quit:                      ; 'q' for 'quit' :
dosprint msg_unquery                   ; erase prompt message
call crlf                              ; terminate the current print line
call show_file_count                   ; show current files found/changed
jmp big_loop_done                      ; and break out of big_loop

flush_key_buffer:                      ; EMPTY KEYBOARD BUFFER:
mov ah,01
int 16                                 ; check keyboard buffer
je > l0                                ; exit if empty
mov ah,00                              ; otherwise,
int 16                                 ; get a keystroke from buffer
jmp flush_key_buffer                   ; and loop back
l0:
ret

get_country_info:                      ; time and date formats, etcetera
mov dx,offset country
doscall2 3800                          ; get current country info
ret                                    ; and exit

test_range:                            ; SANITY CHECK FOR TIME / DATE VALUES:
cmp ah,00                              ; all of which are less than 256
jne test_range_bad                     ; so a nonzero high byte is a problem
test b [more_flags],02                 ; are weird values permitted?
jne test_range_weird                   ; if so, do weird tests instead
cmp al,bl                              ; is it less than the minimum value?
jb test_range_bad                      ; if so, fail
cmp al,bh                              ; is it above the maximum value?
ja test_range_bad                      ; if so, fail
clc                                    ; all correct, exit with carry clear
ret
test_range_bad:                        ; any failure,
stc                                    ; exit with carry set
ret
test_range_weird:                      ; /w weird range check:
cmp al,cl                              ; is it less than the minimum value?
jb test_range_bad                      ; if so, fail
cmp al,ch                              ; is it above the maximum value?
ja test_range_bad                      ; if so, fail
clc                                    ; all correct, exit with carry clear
ret

append_found_filespec:                 ; ADD FOUND FILESPEC AFTER PATHNAME:
mov di,w [last_bs]                     ; destination is
inc di                                 ; character following final backslash
mov si,offset dta_name                 ; source is filename in dta
call copy_string                       ; copy found filename into fnbuf
cmp di,offset fnbuf + fn_max           ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

append_short_filespec:                 ; ADD USER FILESPEC AFTER PATHNAME:
mov di,w [last_bs]                     ; destination is
inc di                                 ; character following final backslash
mov si,offset nambuf                   ; source is short filespec buffer
call copy_string                       ; copy found filename into fnbuf
cmp di,offset fnbuf + fn_max           ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

error_fnbuf_over:                      ; fnbuf has overflowed:
call error_out                         ; fix stdout to screen
dosprint msg_err_fnbuf_over            ; complain
doscall2 4c14                          ; and exit with errorlevel 20

copy_string:                           ; COPY ASCIIZ STRING [SI] TO [DI]:
push ds                                ; make .es equal to .ds
pop es                                 ; and fall through ....

copy_string_far:                       ; COPY ASCIIZ STRING [SI] TO [ES:DI]:
lodsb                                  ; get a character from [ds:si]
stosb                                  ; put it in [es:di]
cmp al,00                              ; until the final null is found
jne copy_string_far
ret                                    ; then quit

find_es_zz:                            ; FIND TERMINAL DOUBLE-NULL:
zero si                                ; start at beginning of tree buffer
cmp w [es:si],0000                     ; is the tree buffer empty?
je > l2                                ; if so, return zero in .si
l0:                                    ; scan forward through tree buffer:
cmp w [es:si],0000                     ; found the double null null yet?
je > l1
inc si                                 ; if not, increment pointer
jmp l0                                 ; and keep looking
l1:                                    ; found the double null:
inc si                                 ; return offset of _second_ null
l2:
ret                                    ; exit

zprint1:                               ; PRINT ASCIIZ STRING VIA .DI:
mov ah,02                              ; dos print-a-character function
l0:
mov dl,b [di]                          ; get a byte from string
inc di
cmp dl,00                              ; found the final null?
je > l1                                ; if so, deal with it
int 21                                 ; otherwise, print the character
jmp l0                                 ; and loop back for more abuse
l1:                                    ; found the final null:

crlf:                                  ; END OF PRINT LINE:
dosprint msg_crlf                      ; print a carriage return, line feed
test b [flags],02                      ; was stdout redirected?
jne > l25                              ; if so, skip control-key handler
push es
mov es,0040
test b [es:0017],04                    ; is control key down?
je > l20                               ; if not, never mind
l10:                                   ; control pressed, so do brief delay :
test b [es:006c],01                    ; wait for an even jiffy
jne l10
l15:
test b [es:006c],01                    ; then wait for an odd jiffy
je l15
l20:
pop es
l25:
cmp b [line],00                        ; paging output?
jne pause_maybe                        ; if so, check whether pause needed
ret                                    ; otherwise, just exit

pause_maybe:                           ; CHECK WHETHER PAUSE NEEDED:
dec b [line]                           ; decrement line count
cmp b [line],00                        ; hit zero yet?
je > l0
ret                                    ; if not, just exit
l0:                                    ; time for a pause:
dosprint msg_pause                     ; announce it
call flush_key_buffer                  ; empty keyboard buffer
l1:
mov ah,00
int 16                                 ; get a keystroke
call force_uc                          ; and force it to uppercase
call unpause                           ; erase pause message
cmp al,0d                              ; enter?
je pause_cr                            ; if so, deal with it (scroll line)
cmp al,'/'                             ; slash?
je pause_slash                         ; if so, deal with it (scroll half)
cmp al,'C'                             ; C ?
je pause_c                             ; if so, deal with it (continuous)
cmp al,1b                              ; escape ?
je pause_c                             ; if so, deal with it (continuous)
mov al,b [screen_lines]                ; otherwise, move scroll value
mov b [line],al                        ; into line count
ret                                    ; and exit
pause_cr:                              ; scroll line:
inc b [line]                           ; set line count to one
ret                                    ; and exit
pause_slash:                           ; scroll half:
mov al,b [screen_lines]                ; get normal scroll value
shr al,01                              ; divide by two
inc al                                 ; and add one
mov b [line],al                        ; save new line count
ret                                    ; and exit
pause_c:                               ; continuous:
mov b [line],00                        ; set for no paging
ret                                    ; and exit

unpause:                               ; ERASE PAUSE MESSAGE FROM SCREEN:
push ax                                ; save .ax
mov ah,02                              ; dos print-a-character function
mov dl,0d                              ; carriage return
int 21                                 ; move cursor to start of line
mov dl,20                              ; ascii space
mov cx,004f                            ; 79 repetitions:
l0:
int 21                                 ; print a space
loop l0                                ; over and over again
mov dl,0d                              ; then another carriage return
int 21                                 ; move cursor to start of line
pop ax                                 ; restore previous .ax value
ret                                    ; and exit

pause_check:                           ; allow pausing a continuous scroll:
test b [flags],02                      ; was output redirected?
jne ret                                ; if so, never mind
cmp b [line],00                        ; continuous scrolling?
jne ret                                ; if not, never mind
mov ah,02
int 16                                 ; get keyboard shift status
test al,08                             ; is alt key pressed?
je ret                                 ; if not, never mind
call flush_key_buffer                  ; pause request!  empty key buffer
mov b [line],01                        ; and note that next line should pause
cmp b [screen_lines],00
jne ret                                ; if number of screen lines not set,
mov al,b [vga_lines]
mov b [screen_lines],al                ; set screen lines to 23
ret

prompt_fix:                            ; CHECK USAGE OF /P :
mov al,b [flags]
and al,0c0                             ; supposed to change date or time
or al,b [chgattr]                      ; or attributes?
cmp al,00
jne > l1                               ; if so, accept /p
and b [more_flags],0bf                 ; if not, ignore /p
ret
l1:
test b [more_flags],40                 ; was /p specified?
jne error_out                          ; if so, redirect output to screen
ret                                    ; otherwise, exit

error_out:                             ; FORCE STDOUT TO STDERR:
mov cx,0001                            ; force stdout
mov bx,0002                            ; to stderr
doscall 46
mov b [line],00                        ; and disable paging
and b [flags],0fd                      ; note that output is to the screen
ret

fix_paging:                            ; CHECK FOR OUTPUT REDIRECTION :
mov bx,0001                            ; standard output handle
doscall2 4400                          ; ioctl get handle info
and dl,82
cmp dl,82                              ; is this the console device?
je > l0
mov b [screen_lines],00                ; if not, disable paging
or b [flags],02                        ; and note stdout was redirected
l0:
mov al,b [screen_lines]                ; use paging value
mov b [line],al                        ; to initialize lines count
ret                                    ; and exit


msg_markver:                           ; for mark aitchison's version utility
db 'VeRsIoN=1.06',00
db 'CoPyRiGhT=Copyright 1999, Charles Dye',00

msg_syntax:
db 0d,0a
db 'TOUCH.COM   v1.06   01-31-1999   C. Dye   raster@highfiber.com',0d,0a
db 'Freeware.  Copyright 1996-1999, Charles Dye.  No warranty!',0d,0a,0a
db 'Syntax:',0d,0a
db 'TOUCH  filespec [switches]',0d,0a
db 'TOUCH @filelist [switches]',0d,0a,0a
db "   /D:date  set to specific date     /D  set to today's date",0d,0a
db '   /T:time  set to specific time     /T  set to current time',0d,0a
db '   /C=file  copy stamps from file',0d,0a
db '   /A:attr  change file attributes',0d,0a
db '   /P  offer yes/no prompt           /F:x  set date format',0d,0a
db '   /S  recurse into subdirectories   /M    page output',0d,0a,0a
db 'If you specify both a filespec and switches, you must have a space before',0d,0a
db 'the first switch.  If you do not specify a filespec, *.* is the default.',0d,0a
db 'It is possible to specify more than one filespec, separated by spaces.',0d,0a
db 'Unless you use /D /T /C or /A, no changes will be made!',0d,0a
db 'Try /D? /T? /C? /A? /F? or /M? for more info.',0d,0a
db '$'

switches:
db 'DTCSPQAWFRME',00

switch_routines:
dw switch_d, switch_t, switch_c, switch_s, switch_p, switch_p, switch_a
dw switch_w, switch_f, switch_r, switch_m, switch_e


months_table:                          ; number of days in each month
db 1f, 1c, 1f, 1e, 1f, 1e, 1f, 1f, 1e, 1f, 1e, 1f

dow_names:
db 'Sun$Mon$Tue$Wed$Thu$Fri$Sat$---$'

msg_err_dos_bad:
db 0d,0a,'Error:  Requires DOS version 3 or better!',0d,0a,'$'

msg_trs_80:
db 0d,0a,'Error:  Not enough memory!',0d,0a,'$'

msg_err_fn_ovf:
db 0d,0a,'Error:  Filespec too long!',0d,0a,'$'

msg_err_in_filespec:
db 0d,0a,'Error in filespec!',0d,0a,'$'

msg_err_specs_galore:
db 0d,0a,'Error:  More than 31 filespecs on command line!',0d,0a,'$'

msg_err_user_date:
db 0d,0a,'Error:  Illegal value in user date!  $'

msg_err_user_time:
db 0d,0a,'Error:  Illegal value in user time!  $'

msg_err_dots_fix:
db 0d,0a,'Error:  Resolving dots in directory name!',0d,0a,'$'

msg_err_d_cd:
db 0d,0a,'Error:  /D conflicts with /C date!',0d,0a,'$'

msg_err_t_ct:
db 0d,0a,'Error:  /T conflicts with /C time!',0d,0a,'$'

msg_err_cd_cd:
db 0d,0a,'Error:  More than one /C date file specified!',0d,0a,'$'

msg_err_ct_ct:
db 0d,0a,'Error:  More than one /C time file specified!',0d,0a,'$'

msg_err_temp_open:
db 0d,0a,'Error:  Unable to open template file $'

msg_err_listfile:
db 'Unable to open file list:  $'

msg_err_read_list:
db 0d,0a,'Error:  Problem reading from file list!$'

msg_err_fnbuf_over:
db 0d,0a,'Error:  Spammed working buffer!',0d,0a,'$'

msg_tree_buffer_over:
db 0d,0a,'Error:  Tree buffer overflow!  Too many subdirectories.',0d,0a,'$'

msg_err_list_spam:
db 'Filespec too long in file list!  Closing file list.',0d,0a,'$'

msg_err_nambuf_over:
db 0d,0a,'Error:  Filename longer than 12 characters!',0d,0a,'$'

msg_err_sw_d:
db 0d,0a
db 'TOUCH /D  -- change date stamps',0d,0a,0a
db "/D        set files to today's date",0d,0a
db '/D:date   set files to specific date',0d,0a,0a
db 'Date stamps will NOT be changed unless you use /D or /C.  You can force',0d,0a
db 'a specific date format by using /F.',0d,0a
db '$'

msg_err_sw_t:
db 0d,0a
db 'TOUCH /T  -- change time stamps',0d,0a,0a
db '/T        set files to the current time',0d,0a
db '/T:time   set files to a specific time',0d,0a,0a
db 'You may use 12- or 24-hour format; minutes and seconds are optional, and',0d,0a
db 'you may use a colon, period, or comma as the time separator.  You may',0d,0a
db 'append an AM or PM suffix ONLY if the hour is between 1 and 12.  You may',0d,0a
db 'express midnight as 00:00 or 12:00 AM, but not as 24:00.',0d,0a,0a
db 'Time stamps will NOT be changed unless you use /T or /C.',0d,0a
db '$'

msg_err_sw_c:
db 0d,0a
db 'TOUCH  /C=filename  -- copy date and time from file',0d,0a
db 'TOUCH /CD=filename  -- copy date stamp from file',0d,0a
db 'TOUCH /CT=filename  -- copy time stamp from file',0d,0a
db 'TOUCH /CA=filename  -- copy attributes from file',0d,0a,0a
db 'The template filename may be any legal DOS filename, possibly including',0d,0a
db 'a drive and path.  You may use slashes as path separators, and you can',0d,0a
db 'enclose the filespec in quotes to "trap" troublesome characters.  If you',0d,0a
db 'use wildcards, the first matching file will be used.',0d,0a,0a
db '$'

msg_err_sw_a:
db 0d,0a
db 'TOUCH /A:change  -- change file attributes',0d,0a,0a
db 'Use a plus sign followed by attribute letters to set the attributes, or',0d,0a
db 'a minus sign followed by letters to clear attributes.  Valid letters are',0d,0a
db 'A for "Archive needed", S for "System file", H for "Hidden", and R for',0d,0a
db '"Read-only".  You may not use spaces in the change string.  Any attributes',0d,0a
db 'you do not specify in the change string will not be altered.',0d,0a,0a
db 'Attributes will NOT be changed unless you use /A or /CA.',0d,0a
db '$'

msg_err_sw_f:
db 0d,0a
db 'TOUCH /F:x  -- select format for date',0d,0a,0a
db '/F:U  United States format:  MM-DD-YYYY or MM-DD',0d,0a
db '/F:E  European date format:  DD-MM-YYYY or DD-MM',0d,0a
db '/F:J  Japanese date format:  YYYY-MM-DD or MM-DD',0d,0a,0a
db 'If you do not specify /F=x, TOUCH will use the date format',0d,0a
db 'set by the COUNTRY= directive in your CONFIG.SYS file.',0d,0a
db '$'

msg_err_sw_m:
db 0d,0a
db 'TOUCH /M:x  -- select lines per page (More)',0d,0a,0a
db 'Sets the number of lines to print to the screen before pausing.',0d,0a
db 'Use 0 to disable screen pausing.  The value (x) is optional.  Screen',0d,0a
db 'pausing will always be disabled if /P is specified, or if output',0d,0a
db 'is redirected.',0d,0a
db '$'

msg_syntax_reminder:
db '   (Type TOUCH /? if you need syntax info)$'

msg_err_dupe:
db 0d,0a,'Error:  More than one switch /'
msg_err_dupe1:
db '# -- you must be trying to confuse me!',0d,0a,'$'

msg_month_eq:
db 'Month = $'
msg_day_eq:
db 'Day = $'
msg_year_eq:
db 'Year = $'

msg_hour_eq:
db 'Hour = $'
msg_minute_eq:
db 'Minute = $'
msg_second_eq:
db 'Second = $'

msg_notice:
db 'Notice:  $'

attributes:
db 'ASHR',00

attrib_values:
db 20,04,02,01

msg_date_format:
db 0d,0a,'The local date format is $'

msg_date_fmt_0:
db 'MM-DD-YYYY',00

msg_date_fmt_1:
db 'DD-MM-YYYY',00

msg_date_fmt_2:
db 'YYYY-MM-DD',00

msg_date_fmt_done:
db '; you may omit the year.',0d,0a,'$'

msg_info_ampm:
db ' am$'

msg_date_none:
db '  (none)'

msg_info_space:
db '  $'

attr1:
db 'ASHR'

msg_attrib:
db '    [----]  $'

msg_bytes:
db ' bytes$'

msg_num_found:
db 'Files found: $'

msg_num_touched:
db '; touched: $'

msg_in_dir:
db ' in $'

msg_total_found:
db 'Total found: $'

msg_arrow:
db '  -->  $'

msg_query:
db ' [Yes No All Quit] $'

msg_unquery:
db 13 dup 08, 13 dup 20, 13 dup 08, '$'

msg_touch_problem:
db '  DOS error $'

msg_touch_prob_2:
db ' dec on $'

msg_clrmod:
db '"clear"$'

msg_open:
db '"open"$'

msg_touch:
db '"touch"$'

msg_close:
db '"close"$'

msg_fixmod:
db '"fix_attr"$'

msg_pause:
db ' -- MORE --  <space> page, <enter> line, </> half page, <C> continuous $'

msg_crlf:
db 0d,0a,'$'

star_dot_star:
db '*.*',00

everything_cr:
db '*.*',0d

even

filespec_pointers:                               ; room for 32 pointers
                                                 ; (31 valid plus final null)

fnbuf     equ  filespec_pointers + 0040          ; filespec of files to touch
                                                 ; or of file list

tfbuf     equ  fnbuf + fn_max                    ; filespec of template file

last_dir_shown   equ  tfbuf + fn_max             ; last directory name shown

dta       equ  last_dir_shown + fn_max           ; disk transfer area:
dta_attr  equ  dta + 0015                        ; attribute of found file
dta_time  equ  dta + 0016                        ; time stamp of found file
dta_date  equ  dta + 0018                        ; date stamp of found file
dta_size  equ  dta + 001a                        ; size of found file
dta_name  equ  dta + 001e                        ; name of found file

stack_start  equ  (dta * 10 + 0f) / 10           ; stack starts on paragraph
stack_end    equ  stack_start + 0800             ; stack is about 2k long

;
;   Errorlevels:
;   00   All's well
;   16   General syntax, buffer overflow
;   17   Not enough memory
;   18   Problem with template file
;   19   Problem with list file
;   20   Internal buffer overflow
;   21   Error resolving directory name
;   22   Tree buffer overflow
;
;
;   Version log:
;
;   1.00   09-28-1996
;          First public release.
;   1.00a  10-16-1996
;          Purely cosmetic update:  displays my new email address.  No
;          functional changes at all.
;   1.00b  10-20-1996
;          Makes TOUCH less inimical to UNC filespecs.
;   1.00c  10-27-1996
;          During a continuous scroll, you may now press a key to pause
;          the display.  ESC now works the same as C, to force continuous
;          scrolling (i.e., to disable pausing.)
;   1.00d  11-11-1996
;          Minor changes to syntax display.  If no switches /D /T /C or /A
;          are specified, a 'reminder' message is displayed.
;   1.00e  12-31-1996
;          Fix for a trivial bug:  commas will now appear in numbers greater
;          than 999.
;
;   1.01   03-09-1997
;          Changes to /C -- /CD copies only the date.  /CT copies only the
;          time.  /C still copies both date and time, but /C is now illegal
;   with either /D or /T.  /CA copies attributes.  /K provides a slightly
;   different display, with days of the week instead of attributes.
;   Date checking is more thorough now; February 30 is an invalid date, and
;   February 29 is only valid for leap years -- /W suppresses these checks.
;   Years above 2099 are now considered illegal (outside DOS's date range;
;   I guess Microsoft didn't want to deal with the intricacies of the
;   Gregorian calendar) -- again, /W disables this restriction.
;
;   1.01a  04-24-1997
;          Fixes bug in day-of-week code.  1980 was a leap year, darnit!
;   1.01b  05-07-1997
;          Only ESC key permitted to pause continuous scrolling.
;
;   1.02   05-11-1997
;          Makes the /K day-of-week display the default, unless /A or /CA
;          is specified.
;   1.02a  06-14-1997
;          When /M is used with no value, the default scroll length will now
;          be the number of screen lines minus 2 -- not always 23.
;
;   1.03   08-25-1997
;          Several cosmetic changes to make TOUCH's output more readable and
;          more like some of my other programs.  Filenames are now indented
;          two spaces.  The single and double bars are gone, and so are the
;   'using-filespec' messages.  Attributes are no longer displayed, and /K
;   now does nothing.  The same directory name will not be displayed twice
;   running, which makes multiple filespecs in the same directory look
;   neater.  Also, the test for output redirection is now done correctly
;   (using IOCTL instead of peeking the PSP.)
;
;   1.04   10-31-1997
;          The template filespec for /C /CD /CT or /CA may contain wildcards,
;          or may name a directory.  If wildcards are used, the first
;          matching file will be used.  Wildcard template filespecs will not
;   match subdirectory names.  Also, if none of the 'change' switches /D /T
;   /C or /A is used, TOUCH will use the empty space on the right of the
;   screen to display file attributes and sizes:  a simple DIR replacement.
;
;   1.05   08-19-1998   9,800 bytes
;          Miscellaneous tweaks for FreeDOS compatibility.  Null is now a
;          legal end-of-line character, along with CR.  Removes any duplicate
;   backslashes from filespec.  Now works on 8086 and 8088-based systems.
;   Fixed a possible problem when an empty subdir was specified under DOS-C.
;   Moved the filespec buffers out to the uninitialized data area.  Added
;   version strings for Mark Aitchison's VERSION.EXE utility.  I have also
;   stopped compressing the executable, as it makes the version string
;   unintelligible to VERSION.EXE.
;
;   1.06   01-31-1999   9,880 bytes
;          Minor changes to the handling of the null date stamp.  It is now
;          displayed as (none) instead of 0-00-1980.  It can now be set with
;   /D:N -- easier than /D:0-0-80 /W.  Also, two changes to scrolling.  The
;   key to pause a continuous scroll is now Alt instead of Esc.  This change
;   eliminates the annoying problem of TOUCH 'eating' characters in the
;   typeahead buffer.  Also, the Control key may now be used to slow a
;   scrolling display.

