/************************************************************************
 *   DelUpto   ---  Deletes files with a date equal or prior to a given *
 *                  argument.                                           *
 *                                                                      *
 *   Written By:    Steve Palm                                          *
 *   Date:          09-28-92                                            *
 *   Written for:   Anyone who wants to benefit from it.                *
 *                                                                      *
 *   Bugs:          None                                                *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <dos.h>
#include <dir.h>
#include <sys\stat.h>
#include <ctype.h>
#include <time.h>

int main (int argc, char *argv[])
{
	int month, day, year, done;
	char *pdate, *ppat, answer;
	struct ffblk fblk;
	struct stat  statbuf;
	struct tm    *filetime;

	/* Print out banner */

	printf("\nDelUpto v1.0 --- Written by Steve Palm\n\n");

	/* Make sure the user gives us a date to work with.  If not, print out */
	/* some instructions for them. */

	if (argc < 3) {
		printf("USAGE:  DelUpto <date> <pattern>\n\n");
		printf("This utility Deletes specified files with a date equal to or earlier than\n");
		printf("the date specified (mm/dd/yy, mm-dd-yy, mm/dd/yyyy, or mm-dd-yyyy).\n\n");
		exit(1);
	}

	/* Okay.  Ready to do some work.  Set up working pointers. */

	pdate = argv[1];
	ppat  = argv[2];

	/* parse date handed to us.                                         */
	/* I'm not checking the date for validity, because the date is only */
	/* being used for comparison, so values larger than reality will    */
	/* have the expected effect of deleting all possible values.        */
	/* I do check to see that all parts are there, however.             */

	month = atoi(pdate);          /* Grab number portion */
	while (isdigit(*pdate))       /* parse up to separator, */
		pdate++;                  /* skipping digits on the way */
	pdate++;                      /* finally skip past the separator */

	day   = atoi(pdate);          /* same as above */
	while (isdigit(*pdate))
		pdate++;
	pdate++;

	year = atoi(pdate);           /* year is just the remainder */

	/* Handle years > 2000 by saying anyhing LESS THAN 70 (1970) */
	/* is actually 2070, not 1970.  MS-DOS cannot have a date    */
	/* before 1970, so this is a safe operation.                 */

	if (year < 70)
		year += 100;
	else if (year > 1900)
		year -= 1900;

	/* re-set date pointer */
	pdate = argv[1];

	if ((month == 0) || (day == 0) || (year == 0)) {
		printf ("Invalid date: %s\n\n", pdate);
		exit(1);
	}

	/* Tell the user what the parameters are.  (They told US) */
	printf ("Deleting files matching %s, dated on or before: %s\n\n", ppat, pdate);

	/* ask if they want to do this. Confirmation. */
	printf ("Continue (y/n)? ");
	answer = getche();
	printf("\n");                           /* output a newline to look nice. */

	if ((answer != 'y') && (answer != 'Y'))
		exit(0);

	/* Look for first file */
	done = findfirst(ppat, &fblk, 0);

	/* Loop until we have no more files */
	while (!done) {
		/* get file time, and convert to tm strcture */
		(void) stat(fblk.ff_name, &statbuf);
		filetime = localtime(&statbuf.st_atime);

		/* filetime->tm_mon is 0-11, we want 1-12 */
		filetime->tm_mon += 1;

		/* check to see if this file gets nuked */
		if ((filetime->tm_year < year) ||
		   ((filetime->tm_year == year) && (filetime->tm_mon < month)) ||
		   (((filetime->tm_year == year) && (filetime->tm_mon == month) &&
			 (filetime->tm_mday <= day)))) {

/*                      printf ("NUKING: %s, dated %d-%d-%d\n", fblk.ff_name,
						filetime->tm_mon,
						filetime->tm_mday,
						(filetime->tm_year + 1900));
*/
			remove(fblk.ff_name);
		}
		/* get next file */
		done = findnext(&fblk);
	}
	/* finished.  Get out of here! */
	exit (0);
}
