NAME
    DvpEdit - a DESQview Program Information (DVP) file editor

VERSION
    1.0  20 Oct 1991

SYNOPSIS
    dvpedit [-b] [-dpath] [-hpath] [-m] [-o] [-s] [-?] [<dvp_file>]

DESCRIPTION
    DvpEdit is a replacement for DESQview's Change a Program command, and, to
    some extent, for the Add a Program command: it allows one to create and
    edit DESQview Program Information (DVP) files, and to add DVP files to
    DESQview's Open Window menu.  DvpEdit does everything Change a Program
    does, and some of what Add a Program does, and in addition:

	- provides superior field editing and context-sensitive help
	- provides access to DVP fields which Change a Program conceals
	- can edit DVP files which are not on DESQview's Open Window menu
	- can edit DVP files which are not named something of the form
	    ``xx-PIF.DVP''
	- can be run from the command line.

OVERVIEW
    The command ``dvpedit -o'' produces a close simulation of DESQview's
    Change a Program command, with enhancements.  The command ``dvpedit''
    produces a list of DVP files in the current directory from which the
    user may select one to edit.  The command ``dvpedit <dvp_file>'' edits
    <dvp_file> directly.  See the ``COMMAND LINE OPTIONS'' section below
    for more information.

    To run DvpEdit from DESQview's Open Window menu, install any or all of
    the supplied DVP files.  EP-PIF.DVP runs the command ``dvpedit -o'' to
    simulate DESQview's Open Window menu for DVP file selection, ED-PIF.DVP
    runs the command ``dvpedit'' for selection of a DVP file by name, and
    MD-PIF.DVP runs the command ``dvpedit default'' to load DEFAULT.DVP,
    which can be edited and saved under a new name, thus creating a new DVP
    file.

    After a DVP file has been selected by one of these three methods,
    DvpEdit presents its main editing screen.  Here the values in each of
    the DVP file's fields may be changed, including several fields which
    Change a Program does not allow the user to manipulate (see the
    ``FIELDS'' section below for details).  To terminate the field editor,
    the user may press Control-Enter to exit with all changes preserved, or
    Escape to quit with all changes discarded (see the section on ``KEYS''
    below for additional keys which are available in the field editor,
    including an undo key which acts only on the current field).

    If the field edit was not aborted, the user is asked to confirm
    the name of the DVP file to be saved.  All the field editing keys are
    available, and the DVP file to be output may be changed; in addition,
    Enter provides a quick way to exit.

    Whenever DvpEdit is used to alter or create a DVP file in the DESQview
    system directory, DESQview's Open Window menu will be updated to reflect
    the changes, unless the user declines to do this when prompted.  (If
    DESQVIEW.DVO, the Open Window menu data, is changed, a backup copy is
    saved in DESQ-BAK.DVO).  This feature enables DvpEdit to be used instead
    of DESQview's Add a Program for some tasks: a DVP file can be loaded
    from some other directory (e.g. the directory into which a new piece of
    software has been unpacked), edited as required, and then saved into the
    DESQview system directory; DvpEdit will then add the DVP file to the Open
    Window menu if the user so wishes.

    As might be expected, DvpEdit is, in Quarterdeck's terms, a  ``DESQview-
    aware'' program.  This means that DvpEdit may be run in a small window
    or in the background without virtualization and without sacrificing
    video update speed, and that DvpEdit makes a DESQview API ``pause'' call
    whenever waiting for keyboard input, and so uses very little CPU time.
    DvpEdit is not, however, ``DESQview-specific'': it can be run outside of
    DESQview without difficulty.

CONFIGURATION
    The colours used by DvpEdit may be configured with the program
    DVPE-CFG.EXE.  DVPE-CFG.EXE allows the user to select colours, and saves
    the selections in a file named ``DVPEDIT.CFG''.  If DvpEdit, when
    executed, finds DVPEDIT.CFG in the directory in which DVPEDIT.EXE
    resides, it will use the colours found therein rather than the default
    blue and white colour scheme.

    The supplied EP-PIF.DVP, ED-PIF.DVP, and MD-PIF.DVP files contain
    settings appropriate for running DvpEdit on nearly any system.  In
    particular, the ``Max keypolls'' field in these DVP files should not be
    set to anything other than the default (blank).  This is because DvpEdit
    suspends itself whenever waiting for keyboard input, using almost no CPU
    time; this makes it unnecessary to have DESQview do this for it.  The
    interaction of the two features (i.e. if Max keypolls is nonzero) would
    result in reduced DvpEdit performance without significantly reducing
    system load.

COMMAND LINE OPTIONS
    -b	Don't make a backup copy of the DVP file.  Backups are named with
	the filename of the DVP file, with the extension changed to ``.BAK'',
	and are placed in the same directory as the DVP file.

    -dpath  Path of the DESQview system directory.  This must be specified
	if the environment variable DV is not set to the DESQview system
	directory, and the DESQview system directory is neither ``C:\DV''
	nor on the PATH.

	DvpEdit must always know the location of the DESQview system
	directory in case the user intends to save a file there, so that
	DESQVIEW.DVO can be updated.  If DvpEdit cannot find the DESQview
	system directory when it is executed, it will signal this and abort.

	The DESQview system directory is sought in the following places, in
	this order: first, the directory named with -d is checked if
	specified.  If -d is not specified, the directory named in the
	environment variable DV, if any, is checked.  If this fails,
	``C:\DV'' is checked.  If this fails, the PATH is searched.

    -hpath  Path to the help file, DVPEDIT.HLP.  If this is not specified,
	the help file is sought in the directory in which DVPEDIT.EXE
	resides.  Note that path should be a directory name without
	``DVPEDIT.HLP'' appended.

    -m	Use alternate mouse handling.  Without -m, DvpEdit provides a true
	free-roaming mouse cursor.  If -m is specified, however, mouse
	movements are treated as one or more presses of the cursor keys.
	This is provided mostly because of a problem with incorrect mouse
	position detection when using the default mouse handling on non-i386
	systems in DESQview's emulated-text modes (see the ``BUGS'' section
	below for details), but some users may prefer it.

    -o  Present the user with a list closely resembling DESQview's Open
	Window menu, from which she may choose a DVP file to edit based on
	its description and Open Window keys.

    -s	Assume that the desired DVP file resides in the DESQview system
	directory.  If <dvp_file> is specified, it is looked for there;
	otherwise a list all the DVP files in the DESQview system directory
	is presented.  Ignored if -o is specified.

    -?  Print a short help message about these command line options.

    <dvp_file>  The name or Open Window keys of the file to edit.  If
	<dvp_file> is one or two characters long, it is taken to be the
	Open Window keys of the desired DVP file, and an attempt is made to
	load the file named by appending ``-PIF.DVP'' (if <dvp_file> is two
	characters long) or ``_-PIF.DVP'' (if <dvp_file> is one character
	long) to <dvp_file>.  Otherwise, a filename is formed by appending
	``.DVP'' to <dvp_file> if necessary, and an attempt is made to load
	that.

	To edit a DVP file with a one or two character name, specify the
	``.DVP'' extension explicitly.

	If <dvp_file> is not specified, a list of all the DVP files in the
	current directory (or in the DESQview system directory if -s was
	specified) is presented, unless -o is specified, in which case a
	simulation of the Open Window menu is presented.

KEYS
    F1 provides context-sensitive help anywhere in the program.

    In the selection lists, Enter or the left mouse button selects the
    highlighted entry.  The highlight may be moved with the Up and Down
    cursor keys or the mouse, and the list may be scrolled with the cursor
    keys or PageUp and PageDown.  The selection process may be cancelled by
    pressing Escape or clicking the right mouse button.

    In the Open Window menu (the display produced by -o), you may select an
    item by its Open Window keys, just as in Change a Program.

    In the DVP file selection list, typing the first character of the name
    of a DVP file moves the highlight to that name.

    In the editing dialogues, the following keys are active:

    Left, Right:		    Movement within the current field
    Home, End:			    Beginning, end of field
    Up, Down, Tab, Shift-Tab:	    Movement between fields
    Control-Left, Control-Right:    Word left, right
    Control-Home, Control-End:	    First, last field
    Backspace, Control-Backspace:   Delete character, word to the left
    Insert:			    Toggle insert mode
    Delete:			    Delete character at cursor
    Control-R:			    Restore field to original contents
    Control-_:			    Restore field to original contents
    Control-U:			    Delete to end of field
    Control-K:			    Delete to end of field
    Alt-Backspace:		    Delete to end of screen
    Control-Enter:		    Save data and exit
    Escape:			    Quit without saving

    Clicking with the left mouse button also moves the current field highlight.
    Clicking the right mouse button is equivalent to pressing Escape, and quits
    the dialogue without saving any edited data.

    If invalid data is entered into a field, a beep will sound and the cursor
    will remain in that field until either valid data is entered or the edit is
    cancelled with Escape.

    Also, the user will not be allowed to leave the editing dialogue by
    pressing Control-Enter if one or more fields contain invalid values (see
    the section on ``VALID FIELD VALUES'' below for details).  In this case,
    an error message will appear, and the dialogue will not terminate.

FIELDS
    DvpEdit allows the user to edit several fields which are not available in
    DESQview's Change a Program.  These are:

    Max keypolls:	 The number of tests for keyboard input in one clock
			 tick the program should be allowed before it is
			 forced to give up the remainder of its time slice.
			 Default (blank) means the program is never suspended
			 before its slice ends.

			 Setting this field to a low value such as 1 is
			 useful in preventing programs which poll the
			 keyboard while idle from expending excessive
			 quantities of CPU time on this unproductive
			 activity.  If such a program is to be run in the
			 background, setting this value to 1 in its DVP
			 file will often dramatically improve the speed of
			 the foreground program.

			 This feature can also be used to control the
			 relative responsiveness of programs.  Programs which
			 are to be run primarily in the background can have
			 this set to a low value such as 1, while programs to
			 be run primarily in the foreground (especially those
			 which write to the screen using MS-DOS calls, since
			 these programs can be significantly slowed down by a
			 low Max keypolls value) are given a larger value (on
			 a fast machine such as an i386, a value of 100 is
			 often suitable) to improve responsiveness.

			 There is no need to use this feature for
			 DESQview-aware programs (such as DvpEdit itself)
			 which automatically suspend themselves when waiting
			 for keyboard input, or for most programs which read
			 the keyboard only through MS-DOS or the BIOS.

			 For those who have been using DVKPOLL.SHR: since
			 what DVKPOLL does is the equivalent of setting this
			 value to a small number, there is no need to use
			 DVKPOLL if you set this value in DvpEdit.

    Start hidden:	 If Yes, the program is started hidden.  Due to the way
		         DESQview interprets this setting, programs started
		         hidden in this way cannot later be unhidden.

    Start in background: If Yes, the program is started in the background.

    For information on the fields which DvpEdit has in common with Change a
    Program, please see the DESQview manuals, or DESQview's help on Change a
    Program.

    Future versions of DvpEdit will fully document these fields.

VALID FIELD VALUES
    Some fields must simply be non-empty.  These are Program name for menu,
    Script buf, and Keys.  Parameters, Directory, Shared Program, and Data
    may contain any text at all (including none).  The Y/N fields at the
    bottom of the screen may be left blank only if marked "Y/N/blank".

    Other fields have required ranges of values and/or special conditions:

    Min memory:		1-999
    Max memory:		0-999 or blank; if specified, must be greater than
			    or equal to Min memory
    Max exp memory:	0-9999 or blank
    System memory:	0-999
    Max height:		0-127
    Max width:		0-127
    Starting height:	0-127 or blank; if specified, must be less than or
			    equal to Max height
    Starting width:	0-127 or blank; if specified, must be less than or
			    equal to Max width
    Starting row:	0-127 or blank; if specified, must be less than or
			    equal to Max height
    Starting col:	0-127 or blank; if specified, must be less than or
			    equal to Max width
    Script buf:		0-32702
    Text pages:		1-9; but if Max height is not 25 or Max width is not
			    80, then only 1 is allowed
    Graphics pages:	0-9
    Initial mode:	2-22 hex or blank
    Max key polls:	0-65535
    Protection level:   0-3
    Keyboard conflict:  0-F hex
    Interrupts:		0-FF hex or blank; the last, if specified, must be
			    greater than or equal to the first.

FILES
    DVPEDIT.HLP	    - The online help text.  Expected to be in the directory
		      specified with -h, or in the same directory as
		      DVPEDIT.EXE.  Most, but not all, of the information in
		      this manual is duplicated in the online help.
    DVPEDIT.CFG	    - If this file exists in the directory in which DVPEDIT.EXE
       		      resides, DvpEdit reads it to obtain the screen colours
		      to use, rather than using its built-in defaults.
    DVPE-CFG.EXE    - The DvpEdit colour configuration program.  Creates
		      DVPEDIT.CFG.
    EP-PIF.DVP	    - DVP file which runs ``dvpedit -o''.
    ED-PIF.DVP	    - DVP file which runs ``dvpedit''.
    MD-PIF.DVP	    - DVP file which runs ``dvpedit default''.
    DEFAULT.DVP	    - DVP file used by MD-PIF.DVP to import default parameters
		      when creating a new DVP.
    DESQVIEW.DVO    - DESQview's Open Window menu data file.
    DESQ-BAK.DVO    - Backup copy of DESQVIEW.DVO, created whenever
		      DESQVIEW.DVO is changed.
    *.DVP	    - DESQview Program Information files.
    *.BAK	    - Backup copies of altered DVP files.

ENVIRONMENT VARIABLES
    DV		    - Path of DESQview system directory, e.g.
    		      ``C:\BIN\DESQVIEW''.
    PATH	    - Used to locate DESQview system directory if -d is
		      not given, $DV is not set, and the DESQview system
		      directory is not ``C:\DV''.

SEE ALSO
    DESQview's Change a Program command and the documentation on it.

DIAGNOSTICS
    DvpEdit exits with a return code of 0 upon successful completion.  If an
    error occurs, it displays a diagnostic message, waits for a keystroke,
    and exits with a return code of 1.

    The reported errors include the following.  Each group of messages is
    followed by an explanation.

	No files matched input spec.
	Path invalid or not found.
        Cannot open <filename>.

    A file or directory specified on the command line could not be found.
    Note that if an erroneous location for the help file is given with -h,
    it will not be detected until the user attempts to use the help
    facility.

	DESQview system directory not found.

    The DESQview system directory either was not given with -d and was not
    C:\DV and was not on the PATH, or the directory given with -d was
    erroneous.

	Memory Allocation Error.  Increase memory size.
	Cannot allocate enough memory to add to Open Window.
	Cannot allocate required memory.

    Insufficient memory was available for the attempted operation.  Increase
    the memory size in the DVP files used to run DvpEdit.  If this error
    occurs when using the EP-PIF.DVP, ED-PIF.DVP, or MD-PIF.DVP files
    supplied with DvpEdit, please contact the authors.  Note that under
    conditions of barely sufficient memory DvpEdit may run successfully,
    except for the help facility and the Open Window update feature, one or
    both of which may be inoperative.

	A DOS error occurred.

    MS-DOS has reported an error, such as a disk drive being not ready.

	File is not a DESQview DVP.

    An attempt has been made to load a file that is not a well-formed DVP file.
    
	This is a TopView PIF file.  Not all fields are used.
	This is a DESQview 1.0 DVP.  Not all fields are used.
	This is a DESQview 2.0 DVP.  Not all fields are used.

    These are warnings, indicating that an old-format DVP file has been
    loaded, and that therefore not all fields in the main edit screen will be
    meaningful.  When the file is saved, the old format will be preserved and
    the contents of the extraneous fields discarded.

	When saving xx-PIF.DVP in DV dir, xx must be same as KEYS field.

    An attempt has been made to save a DVP file into the DESQview system
    directory with its Keys field value not equal to the first two characters
    of its filename.  The attempt is disallowed.

	Cannot write DVP file.
	Cannot open DESQVIEW.DVO.
	Cannot CD to DV system directory.
	Cannot open DESQVIEW.DVO for write.

    An error occurred when attempting the named operation.  This may
    indicate a write-protected file, or a network problem.

	Internal DVPEDIT error.  Contact authors immediately, please.

    If this message is encountered, DvpEdit has malfunctioned.  Please do as
    the message asks.

LIMITATIONS
    Minimum memory required in DESQview:		120KB
    Maximum number of files in the filename picklist:	511

BUGS
    Unlike DESQview's Open Window menu, DvpEdit's menus and screens do not
    expand to the full height of the screen if a video mode greater than 25
    lines high is in use, but remain exactly 25 lines high.  This may be
    fixed eventually.

    If a DVP file which has a blank Directory field and a directory-less
    entry in the Program field is added to the Open Window menu, Add a
    Program changes these to reflect the program's location.  DvpEdit does
    not do this.

    In DESQview's emulated-text modes (on a VGA adapter, these are the 30-,
    50- and 60-line modes used to emulate multiple 25-line mode screens),
    incorrect mouse cursor display occurs if text virtualization is not on.
    This is because the mouse driver (MOUSE.COM or MOUSE.SYS) displays its
    cursor by directly accessing video memory.  i386 and i486 users may
    eliminate this problem by turning text virtualization on in ED-PIF.DVP,
    EP-PIF.DVP, and MD-PIF.DVP, and in any windows in which DvpEdit will be
    run from the command line.  For other users, the -m switch provides a
    reasonable workaround.

    The help system and this manual do not document the standard DVP fields.

    DvpEdit has not been tested with DVP files from versions of DESQview
    before 2.2, although it contains code that should enable it to handle
    these correctly.

    No other bugs are known; but as this is version 1.0 there are likely
    to be some.  Please contact the authors if you find one.

AUTHORS
    DvpEdit is the result of a collaboration over the Internet between
    Daniel J. Bodoh <bodoh@xraylith.wisc.edu>, and Richard Reiner
    <rreiner@nexus.yorku.ca>.  Dan wrote the internals, and Richard wrote
    the user interface (which depends heavily on the TCXL User Interface
    Development System, (c) 1991 IDC), and most of the documentation.

    Information on the structure of DVP files as well that of DESQVIEW.DVO
    was obtained from Ralf Brown's interrupt list.

CONTACTING THE AUTHORS
    The following lists several ways to get in touch with the authors of
    DvpEdit.

    From the Internet: write to ``dvpedit@xraylith.wisc.edu''.
    From Compuserve: write to ``>INTERNET:dvpedit@xraylith.wisc.edu''.
    From Envoy: write to
      ``[RFC-822=\"dvpedit(a)xraylith.wisc.edu\"]INTERNET/TELEMAIL/US''.
    From Fidonet: send mail to the user ``uucp'' at the nearest UUCP or
      Internet gateway; use ``To: dvpedit@xraylith.wisc.edu'' as the first
      line of the message.
    From Applelink: write to ``dvpedit@xraylith.wisc.edu@internet#''.

    It is currently not possible to send mail to the Internet from Genie or
    Prodigy.

    Please include a return address if sending email, as not all mailers
    generate correct reply addresses.

    You can also phone 416-538-3947 (Richard) or 608-255-3574 (Dan), or write
    to

      Richard Reiner
      1-547 Shaw st.
      Toronto, Ontario
      Canada  M6G 3L5

    or

      Daniel Bodoh
      1402 Regent St. #417
      Madison, WI
      USA  53711

DISTRIBUTION
    DvpEdit is copyright (c) 1991, Daniel J. Bodoh and Richard Reiner.  It
    may be distributed freely, but only if no fee other than a small copying
    fee is charged.  It may not be sold, or included with any product that
    is sold, and may be distributed only in unmodified form.  In particular,
    DvpEdit must be distributed with no files added to or removed from the
    distribution archive file.

    Source may be made available upon request.  If you are writing a program
    which will be released in freely distributable form and which needs to
    read, write, display, or edit DVP or DVO files, we'll be glad to share.
    We're sorry, but in order to protect ourselves from having altered and
    possibly malicious copies of DvpEdit or parts thereof in circulation, we
    will not release source for less definite purposes.

    DvpEdit and Dvpe-Cfg are built in the Medium model with Microsoft C 5.1
    and the TCXL libraries.
