/************************************************************************/
/*									*/
/*	DV-GLUE		DESQview and DESQview/X Function Library	*/
/*			(c) Copyright 1992, 1993 Ralf Brown		*/
/*			All Rights Reserved.				*/
/*									*/
/*	File DVGLUE.H	Types and Function Prototypes			*/
/*									*/
/************************************************************************/
/* LastEdit: 1/15/93							*/

#ifndef __DVGLUE_H
#define __DVGLUE_H

#include <alloc.h>
#include <dos.h>
#include <stdarg.h>

#define DVGLUE_version    171
#define DVGLUE_versionSTR "1.71"

/***********************************************************/

typedef unsigned char  BYTE;  /* 8-bit value */
typedef signed char SBYTE;    /* 8-bit signed value */
typedef unsigned short WORD;  /* 16-bit value */
typedef unsigned long DWORD;  /* 32-bit value */
typedef void far *OBJECT;     /* object handle */
#define OBJSEG FP_SEG         /* we often need only the segment of obj handle */
#define MK_OBJ(seg) ((OBJECT)((long)(seg) << 16)) /* sometimes have to build an obj handle */

/***********************************************************/
/* functions that need to override default library funcs   */
/***********************************************************/

#define malloc  DVGLUEmalloc
#define realloc DVGLUErealloc
#define free    DVGLUEfree

/***********************************************************/
/* Manifest constants for DVposwin()                       */
/***********************************************************/

/* select a horizontal position ... */
#define PW_HCURR     0
#define PW_HCENTER   1
#define PW_LEFT      2
#define PW_RIGHT     3
/* ... and a vertical position by ORing them together */
#define PW_VCURR     0
#define PW_VCENTER   4
#define PW_TOP       8
#define PW_BOTTOM   12
/* optionally, choose not to refresh the screen right away */
#define PW_NOREDRAW 16

/***********************************************************/
/* Constants for DVkbd_setflags() & DVkbd_clrflags()       */
/***********************************************************/

#define KBD_FIELDMODE   1
#define KBD_ACTIVE      2
#define KBD_INSERT      4
#define KBD_CONCURRENT  8
#define KBD_FILTERALL  16
#define KBD_EXCLINPUT  32  /* v2.20+ */

/***********************************************************/
/* Constants for DVptr_setflags() & DVptr_clrflags()       */
/***********************************************************/

#define PTR_BUTTON     1
#define	PTR_LEAVE      2	/* v2.23+ */
#define PTR_RELEASE    4
#define PTR_ABSOLUTE   8
#define PTR_SLOWCLICK 16
#define PTR_NOTFORE   32
#define PTR_NOTTOP    64
#define PTR_HIDDEN  0x80

/* bits to check for 'button_state' field of POINTER_MSG type */
#define BUTTON_PRESS    0x80
#define BUTTON_RELEASE  0x40
#define BUTTON_LEFT     1
#define BUTTON_RIGHT    2

/***********************************************************/
/* Constants for DVwin_scroll() and DVfld_scroll()         */
/***********************************************************/

#define SCRL_UP     0
#define SCRL_DOWN   1
#define SCRL_LEFT   2
#define SCRL_RIGHT  3

/***********************************************************/
/* Constants for DVfld_build_header() and type FT_HEADER   */
/***********************************************************/

/* screen types (OR together to get desired behavior) */
#define F_NOREAD         0
#define F_READARRAY      1
#define F_READALL        2
#define F_READNEW        3
/* the above are mutually exclusive */
#define F_CLRMODIFIED    4
#define F_NOFLAGS        8
#define F_B2STATUS    0x10
#define F_RIGHTBUTTON F_B2STATUS
#define F_B1STATUS    0x20
#define F_LEFTBUTTON  F_B1STATUS
#define F_ALLOWKBD    0x40

/***********************************************************/
/* Constants for DVfld_build_entry() and typedef FT_ENTRY  */
/***********************************************************/

/* field types */
#define F_NONENTRY  0x00
#define F_OUTPUT    0x40
#define F_MENUECHO  F_OUTPUT  /* must be first field for automatic menu key echo */
#define F_FILLIN    0x80
#define F_MENU      0xC0

/* field flags, OR with one of the above types */
#define F_PROGOUTPUT 0x20
#define F_SELECTED  2
#define F_MODIFIED  1

/* field modifiers for F_FILLIN (OR together) */
#define F_AUTOCR    0x80
#define F_BEEP F_AUTOCR
#define F_NEXT      0x40
#define F_NUMBER    0x20
#define F_UPPER     0x10
#define F_CLEAR     0x08
#define F_VALIDATE  0x04	/* return input when cursor leaves modified field */

/***********************************************************/
/*  Constants for QEMMget_state() and QEMMset_state()	   */
/***********************************************************/

/* OR together the following for AUTO OFF state */
#define QEMM_AUTO	2
#define QEMM_OFF	1

/***********************************************************/
/*  Constants for flags returned by DVprocessmem()	   */
/***********************************************************/

/* OR together */
#define PM_SYSMEM_SHARED   1
#define PM_PROCMEM_SWAPPED 2
#define PM_SYSMEM_SWAPPED  4

/***********************************************************/
/*  Other predefined constants                             */
/***********************************************************/

/* Predefined Message Numbers: */
#define OBJECT_MSG       0 /* Return Object Handle */
#define NEW_MSG          1 /* Create New Object */
#define FREE_MSG         2 /* Free Object */
#define ADDR_MSG         3 /* Return Handle of Object */
#define DIR_MSG          3 /* Get Panel File Directory */
#define CONNECT_MSG	 3 /* (v2.26+) Connect One Window to Another */
#define READ_MSG         4 /* Return Next Logical record (I/O) */
#define APPLY_MSG        4 /* Apply Panel to Window Object */
#define WRITE_MSG        5 /* Write String to Object */
#define SETPRI_MSG	 6 /* (v2.20+) Set Priority in ObjectQ */
#define GETPRI_MSG	 7 /* (v2.20+) Get Priority in ObjectQ */
#define SIZE_MSG         8 /* Return Size of Object */
#define LEN_MSG          9 /* Return Length of Object */
#define ADDTO_MSG       10 /* Add To Value of Object */
#define SUBFROM_MSG     11 /* Subtract From Value of Object */
#define OPEN_MSG        12 /* Open Object for Use (I/O) */
#define CLOSE_MSG       13 /* Close Object (I/O) */
#define ERASE_MSG       14 /* Erase Object (I/O) */
#define STATUS_MSG      15 /* Return Status of Object (I/O) */
#define EOF_MSG         16 /* Return Object End of File Status (I/O) */
#define AT_MSG          17 /* Position Object Cursor (I/O) */
#define SETSCALE_MSG    17 /* Set Pointer Scaling Factors */
#define SETNAME_MSG     17 /* Assign name to mailbox */
#define READN_MSG       18 /* Return Next n Byte from Object (I/O) */
#define GETSCALE_MSG    18 /* Get Pointer Scaling Factors */
#define GETNAME_MSG	18 /* (v2.50+) Get Mailbox's Name */
#define REDRAW_MSG      19 /* Redraw Object (WINDOW) */
#define SETICON_MSG     19 /* Specify Pointer Icon */
#define READINTO_MSG	19 /* (v2.50+) Read Mail Message into Specified Buffer */
#define SETESC_MSG      20 /* Define User Escape */
#define LOCK_MSG        20 /* Request Exclusive Access */
#define SETFLAGS_MSG	21 /* (v2.20+) Set Object Flags */
#define GETFLAGS_MSG	22 /* (v2.20+) Get Object Flags */

/* Object Modifiers: */
#define TOS             0  /* Use Contents of Top of Stack as Object */
#define ME              1  /* Use Requesting Task's WINDOW as Object */
#define MAILTOS         2  /* Use MAILBOX(tos) as Object */
#define MAILME          3  /* Use MAILBOX(me) as Object */
#define KEYTOS          4  /* Use KEYBOARD(tos) as Object */
#define KEYME           5  /* Use KEYBOARD(me) as Object */
#define OBJQTOS         6  /* Use OBJECTQ(tos) as Object */
#define OBJQME          7  /* Use OBJECTQ(me) as Object */
#define PARENTTOS	12 /* Use PARENT(tos) as Object (v2.26+) */
#define PARENTME	13 /* Use PARENT(me) as Object (v2.26+) */
/* the following are only for creating new objects */
#define WINDOW_CLASS    8  /* Use WINDOW Class as Object */
#define MAILBOX_CLASS   9  /* Use MAILBOX Class as Object */
#define KEYBOARD_CLASS  10 /* Use KEYBOARD Class as Object */
#define TIMER_CLASS     11 /* Use TIMER Class as Object */
#define OBJECTQ_CLASS   12 /* returned by DVobjtype()  -- v2.20+ */
#define POINTER_CLASS   15 /* Use POINTER Class as Object */
#define PANEL_CLASS     16 /* Use PANEL Class as Object */

/* Logical Text Attributes: */
#define NORMAL          1
#define NORMAL_HILITE	2
#define HELP            3
#define HELP_HILITE     4
#define ERROR           5
#define ERROR_HILITE	6
#define EMPHASIZED      7
#define MARK            8
/* ADD this to get reverse version of one of the above logical attributes */
#define REVERSE_VIDEO   8

/***********************************************************/
/*               useful shorthands                         */
/***********************************************************/

#ifndef NIL
#  define NIL (OBJECT) 0
#endif NIL

#ifndef FALSE
#  define FALSE 0
#endif FALSE

#ifndef TRUE
#  define TRUE !FALSE
#endif TRUE

#ifndef lengthof
#  define lengthof(x) (sizeof(x)/sizeof((x)[0]))
#endif lengthof

/***********************************************************/
/*  Type definitions used by library                       */
/***********************************************************/

typedef struct {
   WORD  num_args ;
   DWORD arg[9] ;
   } PARMLIST ;

typedef struct
   {
   BYTE numfields ;
   BYTE type ;
   BYTE cursor_last ;
   BYTE mouse_last ;
   BYTE curr_attr ;
   BYTE selected_attr ;
   } FT_HEADER ;

typedef struct    /* field table entry, one for each field on screen */
   {
   BYTE upleftrow, upleftcol, lowrightrow, lowrightcol ;
   BYTE type ;
   BYTE modifier ;
   BYTE status ;
   BYTE key2 ;
   } FT_ENTRY ;

typedef struct	  /* window info */
   {
   OBJECT ownerhandle ;
   WORD	mapcontext ;
   WORD	flags ;			/* FFFFh if unavailable (DV <2.50) */
   BYTE	tskflag ;		/* 00h = win, 01h = proc */
   BYTE procnumber ;		/* process number, FFh if not known */
   BYTE	tskstatus ;		/* 00h = waiting ... 11h = BldOpen */
   BYTE	fgonly ;		/* 00h = runs in bg, 01h = fgonly */
   BYTE logrows ;		/* logical window size, rows */
   BYTE logcols ;		/* logical window size, colums */
   BYTE physrows ;		/* physical window size, rows */
   BYTE physcols ;		/* physical window size, columns */
   BYTE posrow ;		/* window position, row */
   BYTE poscol ;		/* window position, col */
   } DVWININFO ;
   /* Note: procnumber, tskstatus, and fgonly are undefined if tskflag==00h */

typedef struct	/* registers for calling XDI driver's private subfn or QEMM's API */
   {
   WORD ax,bx,cx,dx,bp,si,ds,di,es ;  /* AX ignored on call, used only for return */
   } DVGREGS ;

typedef struct
   {
   DWORD DR0, DR1, DR2, DR3, dummy1, dummy2, DR6, DR7 ;
   } DEBUGREGS ;

typedef struct
   {
   unsigned int b0 : 1 ;	/* breakpoint 0 triggered */
   unsigned int b1 : 1 ;	/* breakpoint 1 triggered */
   unsigned int b2 : 1 ;	/* breakpoint 2 triggered */
   unsigned int b3 : 1 ;	/* breakpoint 3 triggered */
   unsigned int reserved1 : 9 ;
   unsigned int trap : 1 ;
   unsigned int singlestep : 1 ;
   unsigned int bd : 1 ;	/* next instruc accesses debug register */
   } DEBUGREG6 ;
   
typedef struct
   {
   unsigned int l0 : 1 ;	/* local enable breakpoint 0 */
   unsigned int g0 : 1 ;	/* global enable breakpoint 0 */
   unsigned int l1 : 1 ;
   unsigned int g1 : 1 ;
   unsigned int l2 : 1 ;
   unsigned int g2 : 1 ;
   unsigned int l3 : 1 ;
   unsigned int g3 : 1 ;
   unsigned int le : 1 ;	/* enable exact breakpoint matching */
   unsigned int ge : 1 ;
   unsigned int reserved : 6 ;
   unsigned int rw0  : 2 ;	/* 00 instruc, 01 data write, 11 data r/w */
   unsigned int len0 : 2 ;	/* 00 byte, 01 word, 11 dword */
   unsigned int rw1  : 2 ;
   unsigned int len1 : 2 ;
   unsigned int rw2  : 2 ;
   unsigned int len2 : 2 ;
   unsigned int rw3  : 2 ;
   unsigned int len3 : 2 ;
   } DEBUGREG7 ;
   
typedef struct
   {
   WORD have_shadowRAM ;	/* avoid alignment probs by expanding from byte */
   DWORD initconv, initext, initexp, inittop ;
   DWORD unavailconv, unavailext, unavailexp, unavailtop ;
   DWORD QEMMcode, QEMMdata, tasks, DMAbuffer, maps ;
   DWORD highRAM, mappedROM, convmem, rawext, poolmem ;
   DWORD unavailshadow, convmem_overhead ;
   } QEMM_USAGE ;
   
/*-------------------------------------------------------*/
/* format of message which is sent on async notification */
/* ANY module using this MUST have alignment set to byte */
/* (-a- for TCC)                                         */

#ifdef __BORLANDC__
#pragma option -a-
#endif

typedef struct
   {
   BYTE event ;  /* which event happened? */
   union {
      struct                 /* window was moved */
         {
         OBJECT window ;
         char   row ;
         char   col ;
         } movement ;
      struct                 /* window was resized */
         {
         OBJECT window ;
         BYTE   rows ;
         BYTE   cols ;
         } resizing ;
      struct                 /* window was scrolled */
         {
         OBJECT window ;
         char   mouse_row ;
         char   mouse_col ;
         char   unknown ;
         SBYTE  amount ;
         } scrolling ;
      struct                 /* window was requested to close */
         {
         OBJECT window ;
         char   mouse_row ;
         char   mouse_col ;
         char   unknown ;
         } closing ;
      struct                 /* help requested on window */
         {
         OBJECT window ;
         char   mouse_row ;
         char   mouse_col ;
         char   unknown ;
         } help ;
      BYTE video_mode ;      /* video mode changed */
      struct                 /* scissors selected */
         {
         OBJECT window ;
         BYTE   up_left_row ;
         BYTE   up_left_col ;
         char   unknown ;
         OBJECT mailbox ;
         BYTE   height ;
         BYTE   width ;
         } scissors ;
      } msg ;
   BYTE pad ;     /* needed for DVreadmail() */
   } NOTIFY_MSG ;

#ifdef __BORLANDC__
#pragma option -a.
#endif

/*-------------------------------------------------------*/
/* format of messages read from a pointer object         */

typedef struct
   {
   int row ;
   int column ;
   BYTE button_state ;
   } POINTER_MSG ;

/***********************************************************/
/*                    global variables                     */
/***********************************************************/

extern unsigned char _dvmajor ;
extern unsigned char _dvminor ;
extern int _dvversion ;
extern unsigned char pascal XDI_multiplex_number ;

extern char pascal DVsend_error_recovery ;

extern
#ifdef __cplusplus
"C"
#endif
void (*_DV_errfunc)(OBJECT obj,int errcode,void far *erraddr) ;

/***********************************************************/
/*  support functions which guard non-reentrant functions  */
/***********************************************************/

#ifdef __cplusplus
extern "C" {
#endif

void *DVGLUEmalloc(size_t size) ;
void *DVGLUErealloc(void *block, size_t size) ;
void DVGLUEfree(void *block) ;

#ifdef __cplusplus
}
#endif

/***********************************************************/
/*      the DESQview SEND interface glue functions         */
/***********************************************************/

#ifdef __cplusplus
extern "C" {
#endif

void pascal DVsendmsg(WORD msg_num,WORD modifier,OBJECT object_hdl,PARMLIST *msg_args) ;
void pascal DVsendmsg0(WORD msg_num,WORD modifier,OBJECT object_hdl) ;
DWORD pascal DVsendmsg1(WORD msg_num,WORD modifier,OBJECT object_hdl) ;

#ifdef __cplusplus
}
#endif

/***********************************************************/
/*                 the API function calls                  */
/***********************************************************/

#ifdef __cplusplus
extern "C" {
#endif

int pascal DVinit(int required_version) ;
void pascal DVexit(void) ;
int pascal DVXinit(int required_version) ;
void pascal DVXexit(void) ;
WORD pascal DVprogname(void) ;
int pascal DVappnum(void) ;
void pascal DVdbgpoke(char c) ;
int pascal DVapilevel(int level) ;
WORD pascal DVpushkey(int key, int scancode) ;
void pascal DVjustify(int justify) ;
void pascal DVcommon_mem(WORD *avail, WORD *largest, WORD *total) ;
void pascal DVconv_mem(WORD *avail, WORD *largest, WORD *total) ;
void pascal DVexp_mem(WORD *avail, WORD *largest, WORD *total) ;
WORD pascal DVver(void) ;
OBJECT pascal DVapp_start(const void *pif, int pif_size) ;
void pascal DVpanel_open(OBJECT panel, const char *file) ;
OBJECT pascal DVwin_stream(OBJECT window,BYTE *stream) ;
OBJECT pascal DVwin_new(OBJECT window,int rows,int cols) ;
OBJECT pascal DVmbx_sender(OBJECT mbx) ;
OBJECT pascal DVmbx_len(OBJECT mbx) ;
void pascal DVmbx_clear(OBJECT mbx) ;
void pascal DVunlock(OBJECT mbx) ;
void pascal DVmbx_close(OBJECT mbx) ;
int pascal DVmbx_eof(OBJECT mbx) ;
OBJECT pascal DVmbx_find(const char *name) ;
OBJECT pascal DVmbx_find_len(const char *name,int len) ;
void pascal DVmbx_free(OBJECT mbx) ;
OBJECT pascal DVmymbx(void) ;
OBJECT pascal DVmbx_of(OBJECT task) ;
void pascal DVmbx_name(OBJECT mbx,const char *name) ;
OBJECT pascal DVmbx_new(void) ;
void pascal DVmbx_open(OBJECT mbx) ;
int pascal DVreadmail(OBJECT mbx,char *buffer,int maxsize) ;
void pascal DVsendmail(OBJECT mbx,const char *msg,int length) ;
void pascal DVmbx_write(OBJECT mbx,int reference,int status,const char *msg,int length) ;
int pascal DVmbx_size(OBJECT mbx) ;
int pascal DVmbx_status(OBJECT mbx) ;
int pascal DVwin_read(OBJECT win,void *buffer,int maxsize) ;
int pascal DVwin_readn(OBJECT win,void *buffer,int n) ;
void pascal DVfld_attr(OBJECT win,int field,int attr) ;
void pascal DVfld_char(OBJECT win,int field,int c) ;
void pascal DVfld_clear(OBJECT win,int field) ;
void pascal DVfld_cursor(OBJECT win,int field) ;
void pascal DVfld_entry(OBJECT win,int field,FT_ENTRY *entry) ;
void pascal DVfld_header(OBJECT win,FT_HEADER *header) ;
void pascal DVfld_scroll(OBJECT win,int fld,int direction) ;
int pascal DVfld_swrite(OBJECT win,int field,const char *s) ;
void pascal DVfld_type(OBJECT win,int fld,int type) ;
int pascal DVfld_write(OBJECT win,int field,const char *s) ;
int pascal DVqry_field(OBJECT win,int fld,int bufsize,char *buffer) ;
void pascal DVqry_entry(OBJECT win,int fld,FT_ENTRY *entry) ;
void pascal DVqry_header(OBJECT win,FT_HEADER *header) ;
unsigned int pascal DVqry_fieldsize(OBJECT win,int fld) ;
int pascal DVqry_type(OBJECT win,int fld) ;
void pascal DVgetbuf(OBJECT win,char far **buffer, int *size, int *flag) ;
void pascal DVtimer_begin(OBJECT timer, DWORD time) ;
void pascal DVtimer_start(OBJECT timer) ;
void pascal DVtimer_stop(OBJECT timer) ;
void pascal DVtimer_set(OBJECT timer,int hour,int minute,int second,int hundredth) ;
DWORD pascal DVtimer_elapsed(OBJECT timer) ;
DWORD pascal DVtimer_len(OBJECT timer) ;
DWORD pascal DVtimer_wait(OBJECT timer) ;
OBJECT pascal DVtimer_new(void) ;
int pascal DVtimer_status(OBJECT timer) ;
WORD pascal DVgetbit(void far (*handler)(void)) ;
void pascal DVfreebit(WORD bit) ;
void pascal DVsetbit(WORD bit) ;
int pascal DVisobj(OBJECT obj) ;
void pascal DVapp_goback(OBJECT win) ;
void pascal DVapp_gofore(OBJECT win) ;
void pascal DVwin_paste(OBJECT win) ;
void pascal DVwin_orphan(OBJECT win) ;
void pascal DVapp_hide(OBJECT win) ;
void pascal DVapp_show(OBJECT win) ;
void pascal DVapp_suspend(OBJECT win) ;
void pascal DVkbd_setflags(OBJECT kbd,int flags) ;
void pascal DVkbd_clrflags(OBJECT kbd,int flags) ;
void pascal DVkbd_clear(OBJECT kbd) ;
void pascal DVkbd_close(OBJECT kbd) ;
void pascal DVkbd_setesc(OBJECT kbd,void far (*func)(void)) ;
void pascal DVkbd_free(OBJECT kbd) ;
void pascal DVkbd_open(OBJECT kbd,OBJECT win) ;
void pascal DVkbd_write(OBJECT kbd,const char *data,int size,int scancode) ;
OBJECT pascal DVmykbd(void) ;
OBJECT pascal DVkbd_of(OBJECT task) ;
OBJECT pascal DVkbd_new(void) ;
int pascal DVkbd_read(OBJECT kbd,char *buffer,int maxsize) ;
int pascal DVkbd_messages(OBJECT kbd) ;
int pascal DVkbd_status(OBJECT kbd) ;
int pascal DVerrormsg(OBJECT win,const char *string,int tone,int button,int rows,int cols) ;
OBJECT pascal DVlocate(OBJECT win,int row,int col) ;
void pascal DVlock(OBJECT mbx) ;
void pascal DVwin_allow(OBJECT win,int command) ;
void pascal DVwin_disallow(OBJECT win,int command) ;
int pascal DVwin_async(OBJECT win,void (*func)(OBJECT),int stacksize) ;
int pascal DVatexit(void (*func)(void)) ;
void pascal DVwin_notify(OBJECT win,int event) ;
void pascal DVwin_cancel(OBJECT win,int event,int release) ;
void pascal DVwin_bottom(OBJECT win) ;
void far * pascal TVgetmem(unsigned amt) ;
void pascal TVputmem(void far *block) ;
void pascal DVforeonly(OBJECT taskwin,int foreonly) ;
void pascal DVwin_minsize(OBJECT win,int rows,int cols) ;
void pascal DVwin_maxsize(OBJECT win,int rows,int cols) ;
void cdecl DVwin_reorder(OBJECT win,unsigned first,...) ;
void pascal DVwin_top(OBJECT win) ;
void pascal DVwin_topsys(OBJECT win) ;
void pascal DVobq_add(OBJECT obq, OBJECT item) ;
OBJECT pascal DVobject_handle(WORD which) ;
OBJECT pascal DVcanon_handle(OBJECT handle) ;
int pascal DVobq_size(OBJECT obq) ;
DWORD pascal DVobq_status(OBJECT obq) ;
void pascal DVobq_clear(OBJECT obq) ;
void pascal DVobq_close(OBJECT obq) ;
OBJECT pascal DVmyobq(void) ;
OBJECT pascal DVobq_of(OBJECT task) ;
OBJECT pascal DVowner_of(OBJECT obj) ;
void pascal DVobq_open(OBJECT obq) ;
OBJECT pascal DVobq_read(OBJECT obq) ;
void pascal DVobq_remove(OBJECT obq, OBJECT item) ;
OBJECT pascal DVpanel_new(void) ;
DWORD pascal DVpanel_status(OBJECT panel) ;
int pascal DVpanel_size(OBJECT panel) ;
void pascal DVptr_open(OBJECT pointer, OBJECT win) ;
void pascal DVptr_erase(OBJECT pointer) ;
void pascal DVptr_icon(OBJECT pointer, DWORD symbol) ;
OBJECT pascal DVptr_new(void) ;
void pascal DVptr_setflags(OBJECT pointer,WORD flags) ;
int pascal DVptr_messages(OBJECT pointer) ;
DWORD pascal DVptr_status(OBJECT pointer) ;
void pascal DVptr_clrflags(OBJECT pointer,WORD flags) ;
void pascal DVptr_goto(OBJECT ptr,int row,int col) ;
void pascal DVptr_setscale(OBJECT ptr,int rows,int cols) ;
void pascal DVptr_getscale(OBJECT ptr,int *rows,int *cols) ;
int pascal DVptr_read(OBJECT win,POINTER_MSG *msg) ;
void pascal DVposwin(OBJECT win, OBJECT parent, int pos, int row_offset, int col_offset) ;
void pascal DVputchar(OBJECT win, int c, int attribute) ;
void pascal DVwin_point(OBJECT win,OBJECT ptr) ;
int pascal DVqry_attr(OBJECT win) ;
int pascal DVqry_color(OBJECT win,int attr) ;
int pascal DVqry_ctrl(OBJECT win) ;
void pascal DVqry_cursor(OBJECT win,int *row, int *col) ;
int pascal DVqry_frattr(OBJECT win) ;
void pascal DVqry_frattrs(OBJECT win,char *attribs) ;
void pascal DVqry_frchar(OBJECT win,char *chars) ;
int pascal DVqry_frame(OBJECT win) ;
int pascal DVqry_hidden(OBJECT win) ;
int pascal DVqry_logattr(OBJECT win) ;
int pascal DVqry_leave(OBJECT win) ;
int pascal DVqry_fullframe(OBJECT win) ;
int pascal DVqry_progcolor(OBJECT win) ;
int pascal DVqry_scrollattr(OBJECT win) ;
void pascal DVqry_lsize(OBJECT win,int *rows, int *cols) ;
void pascal DVqry_origin(OBJECT win,int *row, int *col) ;
void pascal DVqry_position(OBJECT win,int *row, int *col) ;
void pascal DVqry_size(OBJECT win,int *rows,int *cols) ;
void far * pascal TVshadow(void) ;
void far * pascal DVshadow_start(int *rows,int *cols) ;
void pascal DVshadow_stop(void) ;
void pascal TVupdate(void far *first, WORD count) ;
void pascal DVsleep(DWORD time) ;
void pascal DVsound(int freq, int duration) ;
void pascal DVnosound(void) ;
void pascal DVtask_free(OBJECT task) ;
OBJECT pascal DVmytask(void) ;
void pascal DVtask_interrupt(OBJECT task,void far (*func)(void)) ;
OBJECT pascal DVtask_new(OBJECT parent,char *title,int row,int col,int rows,
                         int cols,char far *stack,int stacksize,
                         void (*startaddr)(int),int switch_menu) ;
OBJECT pascal DVspawnve(OBJECT win,int row,int col,int rows,int cols,
                        int switch_menu,char *program,va_list args,int env) ;
OBJECT cdecl DVapp_new(OBJECT win,int row,int col,int rows,int cols,
                       int switch_menu,char *program, ...) ;
void pascal DVapp_free(OBJECT task) ;
void pascal DVtask_post(OBJECT task) ;
void pascal DVtask_start(OBJECT task) ;
void pascal DVtask_stop(OBJECT task) ;
WORD pascal TVver(void) ;
void pascal DVwin_attach(OBJECT win) ;
void pascal DVwin_detach(OBJECT win) ;
void pascal DVwin_attr(OBJECT win,int attr) ;
void pascal DVwin_clear(OBJECT win) ;
void pascal DVwin_color(OBJECT win,int logattr,int physattr) ;
void pascal DVwin_ctrl(OBJECT win,int ctrl) ;
void pascal DVwin_cursor(OBJECT win,int row,int col) ;
int pascal DVwin_eof(OBJECT win) ;
void pascal DVwin_frattr(OBJECT win,int attr) ;
void pascal DVwin_frattrs(OBJECT win,char *attribs) ;
void pascal DVwin_frchar(OBJECT win,char *chars) ;
void pascal DVwin_fill(OBJECT win,char c) ;
void pascal DVwin_frame(OBJECT win,int frame) ;
void pascal DVwin_free(OBJECT win) ;
OBJECT pascal DVmywindow(void) ;
void pascal DVwin_hide(OBJECT win) ;
void pascal DVwin_unhide(OBJECT win) ;
OBJECT pascal DVwin_create(OBJECT win,char *title,int rows,int cols, int input_buffer) ;
void pascal DVwin_logattr(OBJECT win,int logical) ;
void pascal DVwin_scrollattr(OBJECT win,int attr_only) ;
void pascal DVwin_fullframe(OBJECT win,int full) ;
void pascal DVwin_progcolor(OBJECT win,int prog) ;
void pascal DVwin_leave(OBJECT win, int leave) ;
void pascal DVwin_lsize(OBJECT win,int rows,int cols) ;
void pascal DVwin_move(OBJECT win,int row,int col) ;
void pascal DVwin_origin(OBJECT win,int row,int col) ;
void pascal DVredrawwin(OBJECT win) ;
int cdecl DVprintf(OBJECT win,char *format, ...) ;
void pascal DVwin_redraw(OBJECT win) ;
void pascal DVwin_repattr(OBJECT win,int attr,int count) ;
void pascal DVwin_repchar(OBJECT win,int c,int count) ;
void pascal DVwin_resize(OBJECT win,int rows,int cols) ;
int pascal DVwin_size(OBJECT win) ;
void pascal DVwin_scroll(OBJECT win,int top,int left,int height,int width, int direction) ;
void pascal DVwin_swrite(OBJECT win,char *string) ;
void pascal DVwin_title(OBJECT win,char *title) ;
int pascal DVwin_width(OBJECT win) ;
void pascal DVwin_writea(OBJECT win,char *attr,int len) ;
void pascal DVwin_writeca(OBJECT win,char *chars,char *attr,int len) ;
OBJECT pascal DVwin_write(OBJECT win,char *string,int len) ;
void pascal DVqry_title(OBJECT win,char *title,int size) ;
void pascal DVwin_atread(OBJECT win,int read_attr) ;
int pascal DVqry_atread(OBJECT win) ;
void pascal DVwin_gotoxy(OBJECT win,int x,int y) ;
int pascal DVkbd_getc(OBJECT kbd) ;
void pascal DVfld_point(OBJECT win,int fld,int x,int y) ;
void pascal DVfld_reset(OBJECT win) ;
void pascal DVfld_altmode(OBJECT kbd,int altmode) ;
BYTE * pascal DVfld_build_header(int num_fields,int screen_type,int curr_attr,int selected_attr) ;
void pascal DVfld_build_entry(BYTE *stream,int field,int upleftrow,int upleftcol,
                              int lowrightrow,int lowrightcol,int type,int modifier,
                              int color,int key2) ;
void pascal DVfld_build_color(BYTE *stream,int field,int attr) ;
void pascal DVfld_build_cursor(OBJECT stream,int field) ;
void pascal DVfld_marker(OBJECT win,char marker) ;
int pascal DVqry_kmouse(void);
void pascal DVapi_kmouse(int active) ;
void pascal DVpanel_data(OBJECT panel,BYTE *data,unsigned length) ;
char far * pascal DVpanel_dir(OBJECT panel,int *size) ;
void pascal DVpanel_apply(OBJECT panel,char *name,OBJECT window,OBJECT *retwin,OBJECT *retkbd) ;
int pascal DVobjtype(OBJECT obj) ;
OBJECT pascal DVobjnext(OBJECT) ;
void pascal DVcstyle(int enable) ;
int pascal DVphys_screen_height(void) ;
int pascal DVphys_screen_width(void) ;
void pascal DVwin_connect(OBJECT win,OBJECT attach_to) ;
void pascal DVwin_info(OBJECT win,DVWININFO *info) ;
void pascal DVwin_setpri(OBJECT win,DWORD priority) ;
DWORD pascal DVwin_getpri(OBJECT win) ;
int pascal DVwin_getname(OBJECT win,BYTE *buffer,int buflen) ;
int pascal DVwin_getname(OBJECT win,BYTE *buffer,int buflen) ;
int pascal DVmbx_readinto(OBJECT mbx,BYTE *buffer,int buflen) ;
void pascal DVkbd_flags(OBJECT win,DWORD flags) ;
void pascal DVmbx_flags(OBJECT mbx,DWORD flags) ;
void pascal DVptr_flags(OBJECT ptr,DWORD flags) ;
DWORD pascal DVkbd_getflags(OBJECT kbd) ;
DWORD pascal DVmbx_getflags(OBJECT mbx) ;
DWORD pascal DVptr_getflags(OBJECT ptr) ;
void pascal DVkbd_setpri(OBJECT kbd,DWORD priority) ;
void pascal DVmbx_setpri(OBJECT mbx,DWORD priority) ;
void pascal DVptr_setpri(OBJECT ptr,DWORD priority) ;
void pascal DVtimer_setpri(OBJECT timer,DWORD priority) ;
DWORD pascal DVkbd_getpri(OBJECT kbd) ;
DWORD pascal DVmbx_getpri(OBJECT mbx) ;
DWORD pascal DVptr_getpri(OBJECT ptr) ;
DWORD pascal DVtimer_getpri(OBJECT timer) ;
void far * pascal DVallocmem(unsigned int size) ;
void pascal DVgetDVpath(char *pathbuf) ;
int pascal DVgetforeground(void) ;
int pascal DVassertvir(int newstate) ;
int pascal DVprocessmem(OBJECT task,unsigned *total,unsigned *sysmem,unsigned *maxblock) ;
void far * pascal DVgetcommon(unsigned int size) ;
void pascal DVputcommon(void far *block) ;
void pascal DVputkey(OBJECT task,int key,int scan) ;
int pascal DVscrninfo(int *rows, int *cols) ;
OBJECT pascal DVDOSuser(void) ;
int pascal DVgetcrit(void) ;
void pascal DVseterror(int type) ;
int pascal DVgeterror(void) ;
WORD pascal DVassertmap(WORD context) ;

void pascal DVpanel_free(OBJECT) ;
void pascal DVptr_free(OBJECT);
void pascal DVtimer_free(OBJECT);
void pascal DVpanel_close(OBJECT);
void pascal DVptr_close(OBJECT);
void pascal DVtimer_close(OBJECT);

OBJECT pascal DVXnewproc(BYTE far *DVPdata,int DVPlen,void far *unk,int unk_len) ;
int pascal DVXver(void) ;
int pascal DVXqry_displayname(OBJECT win,char *buf,int bufsize) ;

void pascal XDIinit(void) ;
void pascal XDIexit(void) ;
int  pascal XDIcall(DVGREGS *inregs, DVGREGS *outregs) ;

int  pascal DVeop_installed(void) ;
void pascal (*DVeop_callback(void (*callback)(void)))(void) ;

int  pascal QDPMI_installed(void) ;   /* returns 1 if installed, 0 if not */
int  pascal DVTXDI_installed(void) ;  /* returns 1 if installed, 0 if not */

int  pascal DVSI_installed(void) ;    /* returns version if inst, 0 if not */
long pascal DVSI_runtime(void) ;
int  pascal DVSI_taskswitches(long *total,int *last) ;

int  pascal QEMMinit(void) ;		/* returns version or 0 if not installed */
int  pascal QEMMcall(DVGREGS *inregs, DVGREGS *outregs) ;
int  pascal QEMMget_state(void) ;
int  pascal QEMMset_state(int state) ;
int  pascal QEMMmem_avail(unsigned int *total,unsigned int *available) ;
int  pascal QEMMget_debug(DEBUGREGS *regs) ;
int  pascal QEMMset_debug(int INT01handling,DEBUGREGS *regs) ;
long pascal QEMMget_CR0(void) ;
long pascal QEMMmax_physmem(void) ;
long pascal QEMMphysaddr(int pagenum) ;
int  pascal QEMMmemory_type(char *buffer) ;
int  pascal QEMMhiram(void) ;
int  pascal QEMMget_accessed(char *buffer) ;
int  pascal QEMMset_accessed(char *buffer) ;
int  pascal QEMMget_memusage(QEMM_USAGE *buffer) ;
int  pascal QEMMcheck_remapping(char far *startaddr,unsigned int pages) ;
int  pascal QEMMinportb(int portnumber) ;
int  pascal QEMMinportw(int portnumber) ;
int  pascal QEMMoutportb(int portnumber,unsigned value) ;
int  pascal QEMMoutportw(int portnumber,unsigned value) ;

int  pascal QOSinit(void) ;
WORD pascal QOShiram(void) ;

int  pascal MANIFEST_installed(void) ;

void far * pascal VIDRAM_entrypoint(void) ;
int  pascal VIDRAM_installed(void) ;
int  pascal VIDRAM_status(int *features,int *flags,int *monitor,unsigned *memtop,unsigned *hiram) ;
int  pascal VIDRAM_setup(int state,int features,int flags,int monitor,unsigned memtop) ;

/* not yet complete */
void pascal DVdispatchint(OBJECT task,void far (*func)(void),union REGS *regs) ;
void pascal DVdispatchintafterDOS(OBJECT task,void far (*func)(void),union REGS *regs) ;

#ifdef __cplusplus
}
#endif

/***********************************************************/
/* functions that are implemented inline                   */
/***********************************************************/

#ifdef __TURBOC__
#  define DVpause()      (_AX = 0x1000, geninterrupt(0x15))
#  define DVostack()     (_AX = 0x101A, geninterrupt(0x15))
#  define DVcrit_begin() (_AX = 0x101B, geninterrupt(0x15))
#  define DVcrit_dec()   (_AX = 0x111B, geninterrupt(0x15))
#  define DVcrit_end()   (_AX = 0x101C, geninterrupt(0x15))
#  define DVcrit_enter() (_AX = 0x111C, geninterrupt(0x15))
#  define DVustack()     (_AX = 0x1025, geninterrupt(0x15))
#  define DVenable()     (_AX = 0x110F, geninterrupt(0x15))
#else
  #ifdef __cplusplus
  extern "C" {
  #endif
   void pascal DVpause(void) ;
   void pascal DVostack(void) ;
   void pascal DVcrit_begin(void) ;
   void pascal DVcrit_dec(void) ;
   void pascal DVcrit_end(void) ;
   void pascal DVcrit_enter(void) ;
   void pascal DVustack(void) ;
   void pascal DVenable(void) ;
  #ifdef __cplusplus
  }
  #endif
#endif __TURBOC__

/***********************************************************/
/* functions that are just aliases of others               */
/***********************************************************/

#define DVwin_hcur(handle)       DVputchar(handle,0,0)
#define DVwin_blanks(win,count)  DVwin_repchar(win,' ',count)


#endif __DVGLUE_H

/* end of DVGLUE.H */
