/************************************************************************/
/*									*/
/*	DV-GLUE		DESQview and DESQview/X Function Library	*/
/*			(c) Copyright 1992 Ralf Brown			*/
/*			All Rights Reserved.				*/
/*									*/
/*	File DVCLASS.H		C++ class library definitions		*/
/*									*/
/************************************************************************/
/* LastEdit: 12/11/92							*/

#ifndef __DVCLASS_H
#define __DVCLASS_H

#include <fstream.h>
#include "dvglue.h"

/* class hierarchy:	*/
/*     DVObject		*/
/*	 DVWindow	*/
/*	   DVForm	*/
/*	 DVTask		*/
/*	 DVMailbox	*/
/*	 DVKeyboard	*/
/*	 DVTimer	*/
/*	 DVPointer	*/
/*	 DVPanel	*/
/*	 DVObjectQ	*/

typedef int classType ; /* for now */
typedef long hashValueType ; /* for now */

#ifdef BORLAND_CLASSLIB
class DVObject : Object
#else
class DVObject
#endif /* BORLAND_CLASSLIB */
   {
   private:
      OBJECT handle ;
   
   public:
#ifndef BORLAND_CLASSLIB
      virtual classType isA() const = 0 ;
      virtual char *nameOf() const = 0 ;
      virtual void printOn(ostream& outStream) const = 0 ;
      virtual int isEqual(const DVObject& testObj) const = 0 ;
#endif /* BORLAND_CLASSLIB */
      virtual hashValueType hashValue() const
	 {
	 return (hashValueType)handle ;
	 }
      
   } ;

class DVWindow : DVObject
   {
   public:
      char *nameOf(void) const
	 {
	 return "DVWindow" ;
	 }
      
   } ;

class DVForm : DVWindow
   {
   public:
      char *nameOf(void) const
	 {
	 return "DVForm" ;
	 }

   } ;

class DVTask : DVObject
   {
   public:
      char *nameOf(void) const
	 {
	 return "DVTask" ;
	 }

   } ;

class DVMailbox : DVObject
   {
   public:
      char *nameOf(void) const
	 {
	 return "DVMailbox" ;
	 }

   } ;

class DVKeyboard : DVObject
   {
   public:
      char *nameOf(void) const
	 {
	 return "DVKeyboard" ;
	 }

   } ;

class DVTimer : DVObject
   {
   public:
      char *nameOf(void) const
	 {
	 return "DVTimer" ;
	 }

   } ;

class DVPointer : DVObject
   {
   public:
      char *nameOf(void) const
	 {
	 return "DVPointer" ;
	 }

   } ;

class DVPanel : DVObject
   {
   public:
      char *nameOf(void) const
	 {
	 return "DVPanel" ;
	 }

   } ;

class DVObjectQ : DVObject
   {
   public:
      char *nameOf(void) const
	 {
	 return "DVObjectQ" ;
	 }

   } ;

#endif /* __DVCLASS_H */