;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File STRING.ASM		Internal string functions		*
;*									*
;************************************************************************
;LastEdit: 12/20/92

	INCLUDE RULES.ASI
	Header@

;========================================================================

CSeg@

public $DVG$STRLEN,$DVG$STRLEN_DXAX
public $DVG$STRNCPY

;------------------------------------------------------------------------

$DVG$STRLEN proc near
IF LDATA eq 0
	mov	dx,ds
ENDIF
	;; fall through to $DVG$STRLEN_DXAX ;;
$DVG$STRLEN endp

$DVG$STRLEN_DXAX proc near
	ASSUME	DS:DGROUP,ES:NOTHING
	push	es
	push	di
	mov	di,ax
	mov	es,dx
	ASSUME	ES:NOTHING
	xor	al,al
	mov	cx,0FFFFh
	cld
	repnz	scasb
	mov	ax,cx
	not	ax
	dec	ax
	pop	di
	pop	es
	ASSUME	ES:NOTHING
	ret
$DVG$STRLEN_DXAX endp

;------------------------------------------------------------------------
; entry: CX = length of destination buffer
;	 STACK: source
;		destination
;
$DVG$STRNCPY proc near
@dest = DPTR_ [bp+2+cPtrSize+dPtrSize]
@src = DPTR_ [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	push	es
	push	di
	push	si
	pushDS_
	cld
IF LDATA eq 0
	push	ds
	pop	es
ENDIF
	LES_	di,@src
	mov	si,di
	push	es
	pop	ds			; DS:SI -> source, as does ES:DI
	mov	dx,cx			; make copy of length in DX
	xor	al,al
	repnz	scasb			; search for terminating NUL
	sub	dx,cx			; find out how many chars in string
	xchg	dx,cx			; CX = length of string, DX = padding
	LES_	di,@dest
	rep	movsb
	mov	cx,dx			; CX = padding length
	rep	stosb			; pad out with NULs
	popDS_
	pop	si
	pop	di
	pop	es
	pop	bp
	ret	2*dPtrSize
$DVG$STRNCPY endp

CSegEnd@

	END
