;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File SEND.ASM			<Description>			*
;*									*
;************************************************************************
;LastEdit: 1/15/93

	INCLUDE API.INC
	MIN_VERSION 2,00

	Header@

;========================================================================

DSeg@
ExtSym@ DVSEND_ERROR_RECOVERY,BYTE,__PASCAL__
PubSym@ _DV_ERRNO,<db 0>,__PASCAL__

IFDEF __TP
IF LPROG
PubSym@ _DV_ERRFUNC,<dd __TEXT:default_errfunc>,__PASCAL__
ELSE
PubSym@ _DV_ERRFUNC,<dw __TEXT:default_errfunc>,__PASCAL__
ENDIF
ELSE ;__TP
IF LPROG
PubSym@ _DV_errfunc,<dd __TEXT:default_errfunc>,__CDECL__
ELSE
PubSym@ _DV_errfunc,<dw __TEXT:default_errfunc>,__CDECL__
ENDIF
ENDIF ;__TP

errmsg_stream label byte	; fake stream so that we can use existing funcs
	db 1Bh,00h
	dw default_errmsg_len
default_errmsg db "DESQview SEND error 00"
errmsg_errcode equ ($-default_errmsg-2)
	       db "detected at 0000:0000."
errmsg_erraddr equ ($-default_errmsg-10)
	       db "Press ESC to continue."
default_errmsg_len equ $-default_errmsg
errmsg_rows equ 3
DSegEnd@

;========================================================================

CSeg@

;------------------------------------------------------------------------
; $DVG$SEND_N
;	Internal function for use by DVSENDMSG, $DVG$SEND_NOARGS,
;	$DVG$SEND_RET1, $DVG$SEND_1_0, etc.
; entry: BH = message number
;	 BL = modifier
;	 CL = default modifier if object is NULL
;	 DS = DGROUP (important in Huge model)
;	 ES:DI = object handle or NULL
;	 STACK: parameters as needed by message
;	 SS:BP -> standard SEND stack frame:
;			BP+00h	old BP
;			BP+02h	2 WORDs (normally ES:DI)
;			BP+06h	return address
;		 (in huge model, add old DS after old BP)
; exit:  STACK: returned parameters
;	 AX,BX,CX,DX destroyed
;
public $DVG$SEND_N
$DVG$SEND_N proc near
	pop	dx			; get return address
	xchg	bl,cl			; BL <- NULL-mod, CL <- normal-mod
	cmp	DVSEND_ERROR_RECOVERY,0
	jz	send_norecov
	or	bh,80h			; turn on error recovery bit
send_norecov:
	cmp	bl,TOS			; no default?
	je	$sendn_check_valid
	mov	ax,es
	or	ax,di
	jz	$sendn_1		; don't check if valid when NULL
$sendn_check_valid:
	test	bh,80h			;   or if error recovery enabled
	jnz	$sendn_0
	cmp	word ptr es:[di+4],0FEDCh  ; is signature word correct?
	je	$sendn_0		; if yes, skip DV validity call
	push	bx			; save message number
	mov	ax,1016h		; ISOBJ
	int	15h
	inc	bx			; BX <- 0 if valid handle
	pop	bx			; retrieve message number
	stc				; assume invalid
	mov	al,4			; errno would be "invalid handle"
	jnz	$sendn_chkerror
$sendn_0:
	push	es			; push the object handle
	push	di
	xchg	bl,cl			; BL <- normal-mod, CL <- NULL-mod
$sendn_1:
	mov	ax,1200h
	clc
	int	15h
$sendn_chkerror:
	mov	_DV_ERRNO,al
	jc	$sendn_error
	jmp	dx			; return to caller

$sendn_error:
	push	dx			; remember return address
	push	bp			; remember frame pointer
	pushm	es,di
	PUSHCPTR32 [bp+SendOverhead-cPtrSize] ; return addr in std stack frame
	mov	ah,0			; AX <- errcode
	push	ax			; push error code
	pushm	es,di			; push object handle
	mov	bp,sp
	add	bp,10			; adjust for two far ptrs and an int
	CALL_NONNULL _DV_ERRFUNC@
	mov	sp,bp			; discard args if not done by func
	popm	di,es
	pop	bp			; restore frame pointer
	xor	ax,ax			; return DX:AX = 0:0 to make it easier
	mov	dx,ax			;  for callers expecting a return value
	stc				; signal error to caller
	ret				; (uses DX stacked at $sendn_error)
$DVG$SEND_N endp

;------------------------------------------------------------------------

public $DVG$HEX_WORD
public $DVG$HEX_BYTE
; entry: AX = word to convert to uppercase hex
;	 SS:BX -> buffer
; exit: BX -> past last char stored in buffer
$DVG$HEX_WORD proc near
	push	ax
	mov	al,ah
	call	$DVG$HEX_BYTE
	pop	ax
$DVG$HEX_BYTE:
	push	ax
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	call	print_hex_digit
	pop	ax
print_hex_digit:
	and	al,0Fh
	add	al,90h
	daa
	adc	al,40h
	daa
phd_store:
	mov	SS_[bx],al
	inc	bx
	ret
$DVG$HEX_WORD endp

;------------------------------------------------------------------------

default_errfunc proc DIST
@handle = dword ptr [bp+2+cPtrSize]
@errcode = word ptr [bp+6+cPtrSize]
@addr = dword ptr [bp+8+cPtrSize]
	push	bp
	mov	bp,sp
	STACK_STREAM errmsg_stream
	add	bx,4			; skip stream header
	push	ss
	pop	es
	mov	di,bx			; ES:DI -> error message
	add	bx,errmsg_errcode
	mov	al,byte ptr @errcode
	call	$DVG$HEX_BYTE
	add	bx,errmsg_erraddr-errmsg_errcode-2
	mov	ax,word ptr @addr+2
	call	$DVG$HEX_WORD
	inc	bx			; skip over colon
	mov	ax,word ptr @addr
	call	$DVG$HEX_WORD
	mov	ah,12h
	mov	bx,0001h		; get our window handle
	int	15h
	pop	cx			; discard offset of handle
	pop	dx			; get handle's segment
	mov	ax,101Fh		; DISPEROR
	mov	bx,8000h + default_errmsg_len  ; beep, either button
	mov	cx,(default_errmsg_len/errmsg_rows) shl 8 + errmsg_rows
	int	15h
	mov	sp,bp			; remove local variables from stack
	pop	bp
	ret
default_errfunc endp

CSegEnd@

	END

