;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File QEMM.ASM	Misc interface functions to QEMM-386		*
;*									*
;************************************************************************
;LastEdit: 1/15/93

	INCLUDE	API.INC
	Header@

.386

;========================================================================

CSeg@

extrn $DVG$QEMMCALL:near

;------------------------------------------------------------------------

PubProc@ QEMMGET_STATE,__PASCAL__
	mov	ah,0
	call	$DVG$QEMMCALL
	mov	ah,0			; return value in AX
	jnc	getstate_done
	mov	ax,-1
getstate_done:
	ret
EndProc@ QEMMGET_STATE,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMSET_STATE,__PASCAL__
@state = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	mov	ah,1
	mov	al,byte ptr @state
	call	$DVG$QEMMCALL
	mov	ax,0
	jc	setstate_done
	inc	ax			; AX <- 1 ("success")
setstate_done:
	pop	bp
	ret	2
EndProc@ QEMMSET_STATE,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMMEM_AVAIL,__PASCAL__
@total = DPTR_ [bp+2+cPtrSize+dPtrSize]
@avail = DPTR_ [bp+2+cPtrSize]
	mov	ah,0Ch			; func = get available memory
	call	$DVG$QEMMCALL
	mov	ax,0			; assume error
	jc	memavail_done
	cmp	bx,1
	jne	memavail_done
	push	bp
	mov	bp,sp
IF LDATA
	push	es
ENDIF
	LES_	bx,@total
	DPTR_NULL es,bx,ax
	jz	no_total
	mov	ES_[bx],cx
no_total:
	LES_	bx,@avail
	DPTR_NULL es,bx,ax
	jz	no_avail
	mov	ES_[bx],dx
no_avail:
IF LDATA
	pop	es
ENDIF
	pop	bp
	mov	ax,1			; return status "OK"
memavail_done:
	ret	2*dPtrSize
EndProc@ QEMMMEM_AVAIL,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMMAX_PHYSMEM,__PASCAL__
	mov	ax,1007h		; get maximum physical memory address
	call	$DVG$QEMMCALL
	jc	maxmem_error
	mov	ax,dx			; put low word into AX
	shr	edx,16			; and high word into DX
	or	ax,0FFFh		; DX:AX -> highest byte in highest 4K page
	ret

maxmem_error:
	xor	ax,ax
	mov	dx,ax
	ret
EndProc@ QEMMMAX_PHYSMEM,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMPHYSADDR,__PASCAL__
@logpage = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	mov	ax,1008h
	mov	cx,@logpage
	call	$DVG$QEMMCALL
	mov	ax,dx			; put low word into AX
	shr	edx,16			; and high word into DX
	pop	bp
	ret	2
EndProc@ QEMMPHYSADDR,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMMEMORY_TYPE,__PASCAL__
@buffer = DPTR_ [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	push	es
	push	di
	mov	ax,1100h
	LES_	di,@buffer
IF LDATA eq 0
	push	ds
	pop	es
ENDIF
	call	$DVG$QEMMCALL
	mov	ax,-1			; if error, return -1
	jc	memtype_done
	mov	al,bl			; AL <- return value
	mov	ah,0			;  zero-extend to word
memtype_done:
	pop	di
	pop	es
	pop	bp
	ret	dPtrSize
EndProc@ QEMMMEMORY_TYPE,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMHIRAM,__PASCAL__
	mov	ah,12h
	call	$DVG$QEMMCALL
	mov	ax,0			; return 0 on error
	jc	hiram_done
	mov	ax,bx			; BX -> first MCB of high memory chain
hiram_done:
	ret
EndProc@ QEMMHIRAM,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMGET_MEMUSAGE,__PASCAL__
	push	bp
	mov	bp,sp
	pushm	es,di
	LES_	di,@buffer
	DPTR_NULL es,di,ax
	stc				; assume NULL pointer
	jz	memusage_skip
	inc	di			; need to mess with first byte later
IF LDATA eq 0
	push	ds
	pop	es
ENDIF
	mov	ah,17h			; get memory usage stats
	call	$DVG$QEMMCALL
	mov	al,ES_[di]		; to avoid alignment probs, we expand
	mov	ah,0			;   the first byte field to a full
	mov	ax,ES_[di-1]		;   word
memusage_skip:
	mov	ax,0
	jc	memusage_done
	inc	ax			; indicate success
memusage_done:
	popm	di,es
	pop	bp
	ret	dPtrSize
EndProc@ QEMMGET_MEMUSAGE,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMCHECK_REMAPPING,__PASCAL__
@start = dword ptr [bp+4+cPtrSize]
@pages = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	push	es
	mov	ah,18h
	les	bx,@start
	mov	cx,@pages
	call	$DVG$QEMMCALL
	jc	check_remap_error
	cbw
	jmp short check_remap_done
check_remap_error:
	mov	ax,-1	
check_remap_done:
	pop	es
	pop	bp
	ret	6
EndProc@ QEMMCHECK_REMAPPING,__PASCAL__

;------------------------------------------------------------------------

CSegEnd@

	END
