* PROCEDURE  Atsay
* Author...: Tom Rettig
* Date ....: November 1, 1985
* Version..: dBASE III, The Developer's Release
* Note(s)..: Procedure for sending formatted output to an
*            ALTERNATE file.
*
PARAMETERS at_row, at_col, exp, pic
*
* ---Trap "out of range" errors.
IF at_row > max_row .OR. at_col > max_col
   * ---Message goes to screen only.
   SET ALTERNATE OFF
   IF at_row > max_row
      ? "Row is out of range -->", at_row
   ENDIF
   IF at_col > max_col
      ? "Column is out of range -->", at_col
   ENDIF
   SET ALTERNATE ON
   RETURN
ENDIF
*
SET CONSOLE OFF
*
* ---Branch if current row is less than previous row.
IF at_row < prev_row
   *
   * ---Do a formfeed in the file.
   at_count = 0
   DO WHILE at_count < ( max_row - prev_row )
      ?
      at_count = at_count+1
   ENDDO
   *
   prev_row = 0
ENDIF
*
* ---Skip to current row.
at_count = 0
DO WHILE at_count < ( at_row - prev_row )
   ?
   at_count = at_count+1
ENDDO
*
* ---Branch if current column is less than previous column.
IF at_col < prev_col
   * ---Do a linefeed in the file.
   ?
ENDIF
*
* ---Skip to current column.
?? SPACE( at_col )
*
* ---Output the expression in the format of the PICTURE.
?? TRANSFORM( exp, pic )
* ---Version 1.0 and 1.1 users remove the TRANSFORM() function.
*
* ---Save current row and column.
prev_row = at_row
prev_col = at_col + LEN( TRANSFORM( exp, pic ) )
* ---Version 1.0 and 1.1 users remove the TRANSFORM() function.
*
SET CONSOLE ON
RETURN
*
* EOP Atsay.PRG 
