Libname.a = SYLIBNAME
@ 10,0 ?? "Playing Script from AU_UTILS"
; Selected routines from GOLDUTL2
; Modified by A.cunningham, Manchester Business School
; ͻ
;                                                                           
;         Written By Harry Goldman                                          
;         DataBase Designs, Inc.                                            
;         (v) (708) 215-8318 (f) 708-215-0314 , Compuserve 72020,2321       
;         Copyright 1990                                                    
;         All Rights Resevered                                              
;                                                                           
;     This program  can be modifeid and enhanced freely as                  
;   long as the copyright and original program credits are maintained.      
;   If you enhance or modify this program, feel free to let me know,        
;   you will be credited in the next release. Resale of this program        
;   is prohibited without the written permission of the author              
;                                                                           
; ͹
; Special Thanks to Alan Zenreich, Dan Paolini and Phil Goulson for their   
; ideas and support.                                                        
; ͼ
; ---------------------------------------------------------------------------
;  Generic messaging proc, modified version originally
;  written by Dan Paolini, DP Solutions
; ---------------------------------------------------------------------------
Proc Message.u(color.n,         ; Color Attribute for Message
                msg.a,           ; Message
                beep.n,          ; How many times to Beep
                sleep.n,         ; Seconds to Sleep ( < 0 means pause)
                clear.l)         ; Whether to Clear after sleep
Private n                        ; Transient Loop counter
Canvas OFF                       ; Let us paint behind scenes
Switch
   Case Upper(Msg.a) = "W" : Msg.a = "Working, Please Wait "
   Case Upper(Msg.a) = "P" : Msg.a = "Printing, Please Wait ..."
   Case Upper(Msg.a) = "Q" : Msg.a = "Querying, This Will Take A Minute "
   Case Upper(Msg.a) = "J" : Msg.a = "Just A Minute"
Endswitch
Style ATTRIBUTE color.n
@ 0,0 ?? Format("w80,ac",msg.a); Centers message, colors entire line
@ 1,0
IF sleep.n < 0 THEN                   ; < 0 means Pause for a Keypress
   ?? Format("w80,ac","Press Any Key to Continue...")
ELSE
   ?? Fill("\205",80)                 ; IBM Graphics horizontal line
ENDIF
Style                                 ; Resets Style
Canvas ON                             ; Admire our work

IF beep.n > 0 AND beep.n < 5 THEN
   FOR n From 1 To beep.n             ; Beep number of beeps
     Beep Sleep 100                   ; Small sleep is helpful
   ENDFOR
ENDIF

WHILE CharWaiting()                   ; Clears any typed-ahead keys
   retval = GetChar()
ENDWHILE

SWITCH
   CASE sleep.n > 5 : Sleep 5000      ; We don't have all day
   CASE sleep.n < 0 :
      While Not CharWaiting()
         Beep Beep
         Sleep 500
      Endwhile
      retval = GetChar()               ; Pause for KeyPress
   CASE sleep.n = 0 :                  ; Don't do anything
   OTHERWISE        : Sleep (sleep.n * 1000)
ENDSWITCH

IF clear.l THEN                        ; Should we clear the message?
   Paintcanvas Fill " " Attribute 111 0,0,1,79
ENDIF
Return
ENDPROC
WriteLib libname.a Message.u
Release PROCS Message.u
?? "."
;---------------------------------------------------------------------
; Check The Printer, Annoy The Operator if the printer is not online
; Slightly modified version of routine from Alan Zenreich
;---------------------------------------------------------------------
Proc checkprinter.l ()
    ; RETURNS a True if printer is ready
    ;           False if printer is offline and user chooses Quit

    Private choice.a
    Message.u(RegMtr.n,"Checking Printer",0,0,False)

    While Not PrinterStatus()                 ; if printer is not ready
        Style Reverse
        Message.u(RevMtr.n,
            "Printer is not ready, press any key for options..",0,-1,True)

        ShowMenu
            "Continue" :
               "Turn On Printer, Then Make This Choice To Continue Printing",
            "Quit" : "Do Not Print"
        To choice.a
        Switch
            Case choice.a <> "Continue":
                Return False
            OtherWise:                           ; try again
                Message.u(RegMtr.n,"Checking Printer",0,0,False)
        EndSwitch
    EndWhile
    Return True
EndProc
WriteLib libname.a checkprinter.l
Release Procs checkprinter.l
?? "."
;------------------------------------------------------------------
; Create a list of all table names. Loop through the list and remove
; any Paradox temporary tables from the list.
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
;-------------------------------------------------------------------
Proc GetTblNames.u(Type.a)

{Tools} {Info} {Inventory}                        ; Get a list of all tables
If Type.a = "Tables" Then                         ; based on the type of
   Select Type.a Select DDir.a                    ; search requested
Else                                              ; (RDA, non RDA)
   {Files} Select DDir.a + Type.a                 ;
Endif                                             ;

If Isempty("List") Then                           ; No tables found
   Return                                         ; quit
Endif                                             ;

EditKey                                           ; Remove PDOX objects
Scan For Search(Upper([Name]),
   "ANSWER,CHANGED,INSERTED,DELETED,LIST,PROBLEMS,STRUCT,FAMILY,") > 0
     Del Up
Endscan
Do_It!                                            ; Save the changes
Clearall                                          ; Clear the workspace
Endproc
Writelib Libname.a GetTblNames.u
Release Procs GetTblNames.u
?? "."
; ---------------------------------------------------------------------------
; Menu.sc is a menuing system using overlaying menus
; Steps involved :
;
;   1) Paint the entire screen a background color
;   2) determine the location of the upper left hand corner
;   3) Determine the width of the menu
;   4) determine the depth of the menu
;   5) Paint the menu
;   6) Paint the screen for shadows
;
; Parameters used :
;
;  Col.n - Starting column
;  Row.n - Starting Row
;  Width.n - Width of the menu   - default to 20
;  Level.n - Menu level
;  Control.l - True = Allow user access to the menu
;            - False = Return to calling Proc
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
; Menuing 'engine'
; ---------------------------------------------------------------------------
Proc Menu.u(Row.n,               ; Starting Row
            Col.n,               ; Starting column
            Width.n,             ; Width of the menu   - default to 20
            Level.n,             ; Menu level
            Control.l,           ; Menu Access
            Last_sel,            ; Last line selected (AC 1.4.93)
            Menu_ptr)            ; pointer to start of menu in menuitems (AC)

   private RowCont.n                                  ; Counter

Procname.a = "Menu.u"                                 ; Verify the parameters
Menuopts.a=""         ;Mod AC
If Row.n < 1 Or Row.n > 23 Then Row.n = 5 Endif       ; passed to the routine
If Col.n < 1 Or Col.n > 79 Then Col.n = 10 Endif
If Width.n < 3 Or Width.n > 70 Then Width.n = 20 Endif
If Col.n + Width.n > 75 Then Col.n=75-Width.n Endif
If Level.n < 1 Or Level.n > 20 Then Level.n = 1 Endif
Canvas Off                                             ; Turn the screen off

@ Row.n, Col.n ?? Chr(201) + Fill(Chr(205),Width.n+2) + Chr(187)  ; Top Line

Buffer.n = Int((Width.n - Len(MenuItems.r[Menu_ptr])+2) / 2)

MenuItem.a = Spaces(Buffer.n) + MenuItems.r[Menu_ptr]
MenuItem.a = Menuitem.a+Spaces(Width.n-len(menuItem.a)+2)  ; Mod AC 5/4/93

@ Row.n + 1, Col.n ?? Chr(186) + MenuItem.a + Chr(186)
@ Row.n + 2, Col.n ?? Chr(204) + Fill(Chr(205),Width.n+2) + Chr(185)

RowCount.n = 3                                         ; Initialize

; As long as the array element is assigned loop through the following
; code and put a line on the screen

While True
   If Isassigned(Menuitems.r[(Menu_ptr)+RowCount.n-2]) and
      not isblank(Menuitems.r[(Menu_ptr)+RowCount.n-2]) Then  ;mod ac
      MenuItem.a = Menuitems.r[(Menu_ptr)+RowCount.n-2]
      Menuopts.a = Menuopts.a+substr(MenuItem.a,1,1) ; list of options - ac
      @ Row.n + RowCount.n, Col.n ?? Chr(186)+"  " +
                MenuItem.a + Fill(" ",Width.n-Len(MenuItem.a)) + Chr(186)
      RowCount.n = RowCount.n + 1
      If Row.n + RowCount.n > 22 Then         ; Did we hit the end of the
         Quitloop                             ; screen ? If so quit
      Endif
   Else
      Quitloop
   Endif
Endwhile

; Place the closing line on the screen

@ Row.n+RowCount.n, Col.n ?? Chr(200) + Fill(Chr(205),Width.n+2) + Chr(188)

PaintCanvas Attribute Level.n*16 Row.n,Col.n,          ; Level sensitive menu
  Row.n+RowCount.n, Col.n+Width.n+3                    ; background
PaintCanvas Attribute Level.n*16+15 Row.n+1,Col.n+1,   ; Level sensitive menu
  Row.n+RowCount.n-1, Col.n+Width.n+2                  ; foreground
PaintCanvas Attribute 8                                ; Create the shadow
  Row.n+1, Col.n+Width.n+4,
  Row.n+RowCount.n+1, Col.n+Width.n+4
PaintCanvas Attribute 8
  Row.n+RowCount.n+1, Col.n+1,
  Row.n+Rowcount.n+1, Col.n+Width.n+4
If Control.l Then
   Canvas On                                           ; Turn the screen on
   if Last_sel >0 then
       MenuCtl.u(2+last_sel,3)           ; Call the controller(AC)
   else
       MenuCtl.u(3,3)                    ; Call the controller
   endif
   Return Retval                                       ; Return a value to
Else                                                   ; the calling routine
   Return True
Endif

Endproc
Writelib Libname.a Menu.u
Release Procs Menu.u
?? "."
; ---------------------------------------------------------------------------
; Controller proc to control bounce bar menu
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
; Shift-F9 added to allowed keys as special edit for menu
; Mod: AC 31.3.93
; ---------------------------------------------------------------------------
Proc MenuCtl.u(CursorPos.n,TopLine.n)
   private Line.n,                           ; Current menu line
           Line1.n,                          ; Next menu line
           Charpress.n,                      ; User pressed key
           Optchar.l,                        ; True for option char
           M1.a,                             ; Storage for 'match'
           M2.a

Procname.a = "MenuCtl.u"

Help.l=false                    ; Set true if F1 pressed
If Not Isassigned(Roll.l) Then
   Roll.l = True
Endif
If Not Isassigned(Level.n) Then
   Level.n = 1
Endif
Line.n = CursorPos.n
Line1.n = 4                                   ; Initialize

; Stay in this loop until the user either presses [Esc] or [Enter]

While True
   If Level.n = 7 Then
      PaintCanvas Attribute 15 Row.n+Line.n, Col.n+1,     ; Highlight the
        Row.n+Line.n, Col.n+Width.n                       ; current line
   Else
      PaintCanvas Attribute 112 Row.n+Line.n, Col.n+1,    ; Highlight the
        Row.n+Line.n, Col.n+Width.n                       ; current line
   Endif
   Canvas On
   Charpress.n = Getchar()                             ; Wait for keystroke
   ; Check for option letter
   if Charpress.n >32 and charpress.n < 123 then
     Optchar.l=match(Menuopts.a,".."+chr(Charpress.n)+"..",M1.a,M2.a)
   else Optchar.l=false
   endif
   PaintCanvas Attribute Level.n*16+15 Row.n+Line.n ,Col.n+1,  ; Repaint
     Row.n+Line.n, Col.n+Width.n                               ; current line
   Switch
      Case Optchar.l : Line1.n=len(M1.a)+Topline.n         ; Opt char
      Case Charpress.n = 27 : Return 0                     ; Esc
      Case Charpress.n = 13 : Return Line.n-(Topline.n-1)  ; Enter
      Case Charpress.n = -71 : Line1.n = TopLine.n         ; Home
      Case Charpress.n = -79 : Line1.n = RowCount.n-1      ; End
      Case Charpress.n = -60 : Return Charpress.n          ; [F2]
      Case Charpress.n = -59 : Help.l=true Return Line.n-(Topline.n-1) ;*[F1]
      Case Charpress.n = -92 : Return Charpress.n          ;*SH-[F9] (Edit Mnu)
      Case Charpress.n = -72 : Line1.n = Line.n-1          ; Up
      Case Charpress.n = -80 : Line1.n = Line.n+1          ; Down
      Case Charpress.n = -73 : Return -3                   ; PgUp
      Case Charpress.n = -81 : Return -4                   ; PgDn
      Otherwise : Beep
                  Loop
   Endswitch

   Switch
      Case Line1.n < TopLine.n :                       ; Roll to end
         If Roll.l Then
            Line1.n = RowCount.n-1
         Else
            Return -1
         Endif
      Case Line1.n > RowCount.n-1 :                    ; Roll to top
         If Roll.l Then
            Line1.n = TopLine.n
         Else
            Return -2
         Endif
   EndSwitch
   Line.n = Line1.n                                            ; reset pointer
Endwhile
Endproc
Writelib Libname.a MenuCtl.u
Release Procs MenuCtl.u
?? "."
; ---------------------------------------------------------------------------
; Check if can place a full lock on table (AC)
; ---------------------------------------------------------------------------
Proc Checklock.l(Tbl.a)
   private Tbl.a

Procname.a = "Checklock.l"
Lock Tbl.a PFL
If Not Retval Then
   Message.u(BlkMtr.n,"Cannot Place Prevent Full Lock On Table "+
             Tbl.a,2,2,True)
   Return False
Endif
Return True
Endproc
Writelib Libname.a Checklock.l
Release Procs Checklock.l
?? "."
; ---------------------------------------------------------------------------
; Check If The User Has Access To A Table
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; Modified A.C 5/4/93
; ---------------------------------------------------------------------------
Proc CheckTbl.l(Tbl.a,Echo.l)
   private Tbl.a,
           Form.n, Echo.l

Procname.a = "CheckTbl.l"

PW.l = False
;Form.n = Form()
; Blank table name may exist and be valid or table may not exist
if not istable(Tbl.a) then return true
endif

If IsEncrypted(Tbl.a) Then
   Beep Sleep 100 Beep Sleep 100 Beep
   While True
      Canvas Off
      If Echo.l Then
         Echo Normal
         Echo Off
      Endif
      @ 0,0 ?? Fill(" ",160)
      Cursor Box
      @ 10,20 ?? "ͻ"
      @ 11,20 ?? "                                         "
      @ 12,20 ?? "         Is Password Protected           "
      @ 13,20 ?? "       Please Enter The Password Or      "
      @ 14,20 ?? "      Press [Esc] To Skip This Table     "
      @ 15,20 ?? "                                         "
      @ 16,20 ?? " Password :                              "
      @ 17,20 ?? "ͼ"

      @ 11,21 ?? Format("W40,AC","Table : " + Tbl.a)

      Paintcanvas Attribute 112 10,20,17,62
      PaintCanvas Border Attribute 79 10,20,17,62

      Style Attribute 51  ;cyan on cyan = invisible!
      @ 16, 34 ??
      Canvas On
      Accept "A15" To PW.a
      @ 16, 34 ??  "               "   ; ensure canvas cannnot show PW
      If Not Retval Then
         Message.u(BlkMtr.n,
                  "Table "+Tbl.a+" Is Pasword Protected, Cannot Access"
                  ,2,1,True)
         Return False
      Endif

      Password PW.a
      View Tbl.a

      Cursor Off
      If match(Tbl.a,".."+Table()) Then ; Mod AC
      PW.l = True
         ClearImage
         Quitloop
      Else
         Message.u(RevMtr.n,"Invalid Password",2,1,True)
      EndIf
   EndWhile
EndIf
Return True
Endproc
Writelib Libname.a CheckTbl.l
Release Procs CheckTbl.l
?? "."
; ---------------------------------------------------------------------------
; Display a header on the screen for menus
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; Adapted from Goldheader.u
;
; ---------------------------------------------------------------------------
Proc Menuheader.u(Menu_title)

Procname.a = "Menuheader.u"
Cursor Off                                     ; Turn the cusror off
Canvas Off                                     ; Turn the canvas off
Clear                                          ; Clear the canvas
Clearall                                       ; Clear the workspace
if len(menu_title)>0 then
@ 2,0 ?? Format("W80,AC",Menu_title)
@ 3,0 ?? Format("W80,AC","Choose menu item or [Esc] to Quit")
endif
PaintCanvas Attribute 111 0,0,24,79     ; Entire screen
Endproc
Writelib Libname.a Menuheader.u
Release Procs Menuheader.u
?? "."
; ---------------------------------------------------------------------------
;
; ---------------------------------------------------------------------------
Proc Initheader.u()

Procname.a = "Initheader.u"
Cursor Off                                     ; Turn the cusror off
Canvas Off                                     ; Turn the canvas off
Clear                                          ; Clear the canvas
Clearall                                       ; Clear the workspace
@ 2,0 ?? Format("W80,AC","Welcome To The Paradox Menu System")
@ 3,0 ?? Format("W80,AC","By Andrew Cunningham")
@ 4,0 ?? Format("W80,AC","====================")
@ 5,0 ?? Format("W80,AC","(Menu design by:- DataBase Designs Inc.)")
@ 7,0 ?? Format("W80,AC",Version.a)
PaintCanvas Border fill chr(219) Attribute 30 0,0,24,79  ; Border
PaintCanvas Attribute 30 0,0,24,79  ; Entire screen
Endproc
Writelib Libname.a Initheader.u
Release Procs Initheader.u
?? "."
