/*ͻ*\
   Filename:  FILE\CREATE.CPP                     
   Name:      John Wiggins                        
   Course:    Programming II                      
   Function:  Creates file and stores information 
              to the created file.                
\*ͼ*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "medusa.h"
#include "msi_wndw.h"
#include "mous.h"   // includes dos.h
#include "windw.h"  // includes string.h & event.h

void Create(int &DataExists)
{
  program_info NewProgram;
  int ExitFlag = FALSE;
  FILE *FilePtr;
  // Create a window to show the drive is being used.
  CapTWindw *DiskAccessWind;
  DiskAccessWind = new CapTWindw("Accessing Disk", "Please wait...", "");
  mouse.HideMouse();
  DiskAccessWind->DrawWindow();
  FilePtr = fopen("data\\program.dat", "wb");
  delete DiskAccessWind;
  mouse.ShowMouse();
  if (!FilePtr)
    FileError('O', "program.dat");
  do
  {
    if (GetData(NewProgram, DataExists) == FALSE)
      ExitFlag = TRUE;
    else
    {
      if (fwrite(&NewProgram, sizeof(program_info), 1, FilePtr) < 1)
	FileError('W', "program.dat");
      ExitFlag = FALSE;
    }
  } while (ExitFlag == FALSE);
  DiskAccessWind = new CapTWindw("Accessing Disk", "Please wait...", "");
  mouse.HideMouse();
  DiskAccessWind->DrawWindow();
  int CloseFile = fclose(FilePtr);
  delete DiskAccessWind;
  mouse.ShowMouse();
  if (CloseFile)
    FileError('C', "program.dat");
}

/*ͻ*\
   Function:  Get users input.  Used by create and may be 
              implimented for Edit function's use.        
\*ͼ*/

int GetData(program_info &NewProgram, int &DataExists)
{
  InputWindw *ProgNameWnd;
  // Make the new windows for the elements of the struct.
  ItemWindw *PubNameWnd, *CompTypeWnd, *ProgTypeWnd,
            *VersionWnd, *CopyRightWnd, *CostWnd;
  char TempBuf[20], WndTitle[81];
  strcpy(WndTitle, "Create Record");
  // Create the first window and prompt user on how to exit.
  ProgNameWnd = new InputWindw(WndTitle, "Program Name:",
                               "Example: Windows");
  ProgNameWnd->DrawWindow();
  ProgNameWnd->RunWindow();
  // Check to see if user has clicked on the 'ok' button
  // (which includes hiting the enter key.)
  if (ProgNameWnd->GetButton() == OK)
  {
    DataExists=TRUE;
    ProgNameWnd->GetInput(TempBuf);
    if (strlen(TempBuf) == 0)
    {
      delete ProgNameWnd;
      return 0;
    }
    else
    {
      strncpy(NewProgram.Title, TempBuf, TITLE_LENGTH);
      // I found out that strncpy doesn't add the null character at the end,
      // so I will.
      NewProgram.Title[strlen(TempBuf)+1] = '\0';
      delete ProgNameWnd;
    }
  }
  if (ProgNameWnd->GetButton() == CANCEL)
  {
    DataExists = FALSE;
    delete ProgNameWnd;
    return 0;
  }
  // Hide the mouse so user won't be tempted to use it.
  mouse.HideMouse();

  // Publishers name \\
  PubNameWnd = new ItemWindw(WndTitle, "Publisher Name:",
			     "Example: Microsoft");
  PubNameWnd->DrawWindow();
  PubNameWnd->RunWindow();
  PubNameWnd->GetInput(TempBuf);
  strncpy(NewProgram.PublisherName, TempBuf, PUBLISHER_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  NewProgram.PublisherName[strlen(TempBuf)+1] = '\0';
  delete PubNameWnd;

  // Computer Type \\
  CompTypeWnd = new ItemWindw(WndTitle, "Computer Type:", "Example: IBM");
  CompTypeWnd->DrawWindow();
  CompTypeWnd->RunWindow();
  CompTypeWnd->GetInput(TempBuf);
  strncpy(NewProgram.ComputerType, TempBuf, COMPUTER_TYPE_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  NewProgram.ComputerType[strlen(TempBuf)+1] = '\0';
  delete CompTypeWnd;

  // Disk Type \\
  char WhatMedia=MediaButtons("Create: ");
  switch (WhatMedia)
  {
      case 'A': strcpy(NewProgram.DiskType, "3.5 HD"); break;
      case 'B': strcpy(NewProgram.DiskType, "3.5 DD"); break;
      case 'C': strcpy(NewProgram.DiskType, "5.25 HD"); break;
      case 'D': strcpy(NewProgram.DiskType, "5.25 DD"); break;
      case 'E': strcpy(NewProgram.DiskType, "CD-ROM"); break;
      case 'F': strcpy(NewProgram.DiskType, "Hard Drive"); break;
  } // end switch
  mouse.HideMouse();
  // Program Type \\
  ProgTypeWnd = new ItemWindw(WndTitle, "Program Type:",
			      "Example: Operating System");
  ProgTypeWnd->DrawWindow();
  ProgTypeWnd->RunWindow();
  ProgTypeWnd->GetInput(TempBuf);
  strncpy(NewProgram.ProgramType, TempBuf, PROGRAM_TYPE_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  NewProgram.ProgramType[strlen(TempBuf)+1] = '\0';
  delete ProgTypeWnd;

  // Version \\
  VersionWnd = new ItemWindw(WndTitle, "Version:", "Example: 3.11");
  VersionWnd->DrawWindow();
  VersionWnd->RunWindow();
  VersionWnd->GetInput(TempBuf);
  strncpy(NewProgram.Version, TempBuf, VERSION_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  NewProgram.Version[strlen(TempBuf)+1] = '\0';
  delete VersionWnd;

  // Copyright \\
  CopyRightWnd = new ItemWindw(WndTitle, "Copyright Year:", "Example: 1992");
  CopyRightWnd->DrawWindow();
  CopyRightWnd->RunWindow();
  CopyRightWnd->GetInput(TempBuf);
  strncpy(NewProgram.Copyright, TempBuf, COPYRIGHT_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  NewProgram.Copyright[strlen(TempBuf)+1] = '\0';
  delete CopyRightWnd;

  // Program Cost \\
  CostWnd = new ItemWindw(WndTitle, "Cost of Program:", "Example: 157.25");
  CostWnd->DrawWindow();
  CostWnd->RunWindow();
  CostWnd->GetInput(TempBuf);
  strncpy(NewProgram.Cost, TempBuf, COST_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  NewProgram.Cost[strlen(TempBuf)+1] = '\0';
  delete CostWnd;
  mouse.ShowMouse();
  // Repeat the loop.
  return 1;
}
