/*			      SUPCLASS.CC
			 Class declaration for
			a C++ implementation of
			   "super precision".
			       Version 2
*/
//              Copyright (c) 1997 William T. Wyatt, Jr.

#include "super.h"

class super_precision					{ // CLASS DEFINITION
protected:
		// nonstatic data members:
	int32 sign_bias_exp;		// holds a sign and a biased exponent
	int32 *mantissa;		// points to integer array for mantissa
	int32 digits;			// no. significant digits in mantissa
						// = NDIGA
	short radix;			// number base of super_precision
						// = NBASE
	short validity;			// validity
	
		// default static values:
	static int32 def_digits;	// no. significant digits in mantissa
	static short def_radix;		// number base of super_precision object
	static short def_validity;	// validity (proper,infinite,NaN,etc.)

		// static object pointers:
	static super_precision *w;	// used in basic arithmetic (alias)
	static super_precision *zt;	// used in basic arithmetic (alias)
	static super_precision *zv;	// used in basic arithmetic (alias)
	static super_precision *zz;	// returnable obj for public fns (alias)
	static super_precision *pi;	// super_precision value for pi
	static super_precision *log_10;	// super_precision value for log10(e)
	static super_precision *log_radix;// super_precision log_def_radix(e)
	static int32 *zia;		// intermediate results
	static int32 *zib;		// intermediate results
	static int32 *t;		// unpacked intermediate results
	static int32 *v;		// unpacked intermediate results
	static double *dalt;		// fast_mult array pointer
	static char *output_result;	// result string in super_output
	static char *input_string;	// input string in operator>> overload

		// static variables
	static int32 rounding_method;	// rounding method flag = IROUND
	static int32 ndig;		// max no. of digits carried by mantissa
				// ndig is nf * nd and is >= digits.
	static int32 nd;		// no. of digits per mantissa word
	static int32 ind;		// equal to radix**nd
	static int32 bias;		// exponent bias = IBIAS
	static int32 nf;		// no. of 32-bit words in mantissa
	static int32 nfa;		// no. of words in repacked mult array
	static int32 nfah;		// no. of words in unpacked mult array
	static int32 nfahx;		// no. words used in unpacked mult array
	static int32 ndah;		// no. digits per unpacked mantissa word
	static int32 indah;		// equal to radix**ndah
	static int32 nda;		// nda = 2 * ndah
	static int32 inda;		// equal to indah**2
	static int32 naccum;		// equal to NDIG - 2*NDAH
	static int32 hdwr_base;		// hardware float-point arithmetic base
	static int32 nbit;		// number of bits in integer, less sign
	static int32 klip;		// if nonzero, is exact number of digits
	static int32 iklip;		// clipping factor to shorten mantissa
	static int32 indtrz;		// clipping factor for repacked array
	static int32 ndiv;		// no. digits in quotient estimator
	static int32 irbit;		// round bit, including trailing zeros
	static double baslog;		// log10 of def_radix
	static int32 orig_def_digits;	// save original value from setup
	static int32 orig_nf;		// save original value from setup
	static int32 max_output_string_size;	// max size of output_result
	static int32 max_input_string_size;	// max size of input_result
	static int32 block;		// length of blank-demarked digit string
	static int32 nblanks;		// max no. of blanks inserted in output
	static int32 output_base;	// output radix
	static int32 output_count;	// no. of digits in mantissa on output
	static int32 input_base;	// input radix
	static int32 fast_mult_digits;	// int32 = set_fast_multiply_threshold()
	static int32 dinda;		// scale factor in fast_mult array
	static int32 dnfa;		// no. words in combined fast_mult array
	static int32 dnda;		// no. digits/element in fast_mult array
	static int32 radix_powerof2;	// 0 for non-powerof2, else log2(radix)
	static int32 nfft;		// FFT size for fast_mult array
	static double double_fraction_max;	// largest integer in double
	static int32 double_fraction_digit_count;	// digits in double
	static int32 fast_div_digits;	// int32 = set_fast_divide_threshold ()
	static int32 log_Salamin_threshold;	// threshold for Salamin in log
	static int32 exp_Newton_threshold;	// threshold for Newton in exp
	static int32 atan_Salamin_threshold;	// threshold for Salamin in atan
	static int32 tan_Newton_threshold;	// threshold for Newton in tan
	static int pi_init;		// flag to signal need to initialize pi
	static int log_10_init;		// flag to initialize log_10
	static int log_radix_init;	// flag to initialize log_radix
	static int prev_radix;		// flag to record radix change
	static int32 radix_powers [32];	// powers of def_radix from 0 to nd
					
public:
	super_precision ( void);			// constructor
	~super_precision ( void);			// destructor
	super_precision ( const int32);			//conversion constructor
	super_precision ( const double);		//conversion constructor
	super_precision ( const char *);		//conversion constructor
	void *operator new ( size_t);			// overload new
	void operator delete ( void *);			// overload delete
#ifdef placement_new_array
	void *operator new [] ( size_t, int32);		// overload new []
	void operator delete [] ( void *);		// overload delete []
#endif
	super_precision ( const super_precision &);	// ovld copy-constructor
	static void setup ( const int32 digits, const short radix = 10);
							// initializer
	static void set_rounding_method ( const int32);	// change rounding mthd
	super_precision & operator= ( const super_precision &);	// overload a=b
	super_precision & operator= ( const int32); 		// overload a=i
	super_precision & operator= ( const double); 		// overload a=d
	super_precision & operator= ( const char *); 		// ovld a=string
	super_precision operator- ( void) const;		// overload -b
	super_precision operator+ ( void) const;		// overload +b
	super_precision operator+ ( const super_precision &) const; // ovld a+b
	super_precision & operator+=( const super_precision &);	// overload a+=b
	super_precision operator+ ( const int32) const; 	// overload a+i
	super_precision & operator+=( const int32); 		// overload a+=i
	super_precision operator- ( const super_precision &) const; // ovld a-b
	super_precision & operator-=( const super_precision &); // overload a-=b
	super_precision operator- ( const int32) const; 	// overload a-i
	super_precision & operator-=( const int32); 		// overload a-=i
	super_precision operator* ( const super_precision &) const; // ovld a*b
	super_precision & operator*=( const super_precision &); // overload a*=b
	super_precision operator* ( const int32) const; 	// overload a*i
	super_precision & operator*=( const int32); 		// overload a*=i
	super_precision operator/ ( const super_precision &) const; // ovld a/b
	super_precision & operator/=( const super_precision &);	// overload a/=b
	super_precision operator/ ( const int32) const;		// overload a/i
	super_precision & operator/=( const int32);		// overload a/=i
	super_precision operator% ( const super_precision &) const; // ovld a%b
	super_precision & operator%=( const super_precision &);	// overload a%=b
	super_precision operator% ( const int32) const;		// overload a%i
	super_precision & operator%=( const int32);		// overload a%=i
	super_precision & operator++( void);			// overload a++
	super_precision & operator++( int);			// overload ++a
	super_precision & operator--( void);			// overload a--
	super_precision & operator--( int);			// overload --a
	friend super_precision operator+ ( const int32,
				const super_precision &); 	// overload i+a
	friend super_precision operator- ( const int32,
				const super_precision &); 	// overload i-a
	friend super_precision operator* ( const int32,
				const super_precision &); 	// overload i*a
	friend super_precision operator/ ( const int32,
				const super_precision &); 	// overload i/a
	friend super_precision operator% ( const int32,
				const super_precision &); 	// overload i%a
	int operator< ( const super_precision &) const;		// overload a<b
	int operator> ( const super_precision &) const;		// overload a>b
	int operator==( const super_precision &) const;		// overload a==b
	int operator!=( const super_precision &) const;		// overload a!=b
	int operator<=( const super_precision &) const;		// overload a<=b
	int operator>=( const super_precision &) const;		// overload a>=b
	int operator! ( void) const;				// overload !a
	int operator&&( const super_precision &) const;		// overload a&&b
	int operator||( const super_precision &) const;		// overload a||b
	int operator< ( const int32) const;			// overload a<i
	int operator> ( const int32) const;			// overload a>i
	int operator==( const int32) const;			// overload a==i
	int operator!=( const int32) const;			// overload a!=i
	int operator<=( const int32) const;			// overload a<=i
	int operator>=( const int32) const;			// overload a>=i
	int operator&&( const int32) const;			// overload a&&i
	int operator||( const int32) const;			// overload a||i
	friend int operator< ( const int32,
				const super_precision &);	// overload i<a
	friend int operator> ( const int32,
				const super_precision &);	// overload i>a
	friend int operator==( const int32,
				const super_precision &);	// overload i==a
	friend int operator!=( const int32,
				const super_precision &);	// overload i!=a
	friend int operator<=( const int32,
				const super_precision &);	// overload i<=a
	friend int operator>=( const int32,
				const super_precision &);	// overload i>=a
	friend int operator&&( const int32,
				const super_precision &);	// overload i&&a
	friend int operator||( const int32,
				const super_precision &);	// overload i||a
	friend super_precision sqrt
				( const super_precision &);	// overload sqrt
	friend super_precision fabs
				( const super_precision &);	// overload fabs
	friend super_precision trunc
				( const super_precision &);	//overload trunc
	friend super_precision ceil
				( const super_precision &);	// overload ceil
	friend super_precision floor
				( const super_precision &);	//overload floor
	friend super_precision fmod ( const super_precision &,
				const super_precision &);	// overload fmod
	friend super_precision rint
				( const super_precision &);	// overload rint
	friend super_precision round_off ( const super_precision &,
				const int32);			// round off
	inline void super_neg ( void);				// *this=-*this
	super_precision & super_shift_public ( const int32);	// shift super
	super_precision & super_norm_public ( int32 &);		// norm super
	super_precision & super_klipr_public ( void);		// clip a
	void super_dump ( void) const;				// dump super
	void super_fill ( const int32, const int32);		// fill super
	friend void dump_tv ( const int32 tv []);		//dump t,v array
	friend int32 super_to_i ( const super_precision &);	// convert i=a
	friend double super_to_approx_double
				( const super_precision &);	// rough d = a
	friend double super_to_double
				( const super_precision &);	// exact d = a
	friend super_precision pow ( const super_precision &,
				const int32);			// overload pow
	friend super_precision pow ( const super_precision &,
				const super_precision &);	// overload pow
	friend super_precision pow ( const int32,
				const super_precision &);	// overload pow
	friend super_precision exp ( const super_precision &);	// overload exp
	friend super_precision log ( const super_precision &);	// overload log
	friend super_precision log10 ( const super_precision &);// overld log10
	friend super_precision log_Salamin
				( const super_precision &);	// Salamin algor
	friend void log_Salamin_complex
		( const super_precision &, const super_precision &,
		super_precision &, super_precision &);		// Salamin cplx
	void arithmetic_geometric_mean ( const super_precision &b);
								// get AGM
	void arithmetic_geometric_mean_cplx
			( super_precision &, super_precision &);// get cplx AGM
	friend super_precision pi ( void);			// returns pi
	friend super_precision log_10 ( void);			// rtn log10(e)
	friend super_precision log_radix ( void);	// rtn log_def_radix(e)
	friend super_precision sinh ( const super_precision &);	// overload sinh
	friend super_precision cosh ( const super_precision &);	// overload cosh
	friend super_precision tanh ( const super_precision &);	// overload tanh
	friend super_precision sin ( const super_precision &);	// overload sin
	friend super_precision cos ( const super_precision &);	// overload cos
	friend super_precision tan ( const super_precision &);	// overload tan
	friend super_precision tan_Salamin
				( const super_precision &);	// overload tan
	friend void sincos ( const super_precision &, super_precision &,
			super_precision &);			// sin(a),cos(a)
	friend super_precision asin ( const super_precision &);	// overload asin
	friend super_precision acos ( const super_precision &);	// overload acos
	friend super_precision atan ( const super_precision &);	// overload atan
	friend super_precision atan2 ( const super_precision &,
				const super_precision &);	//overload atan2
	friend super_precision asinh ( const super_precision &);//overload asinh
	friend super_precision acosh ( const super_precision &);//overload acosh
	friend super_precision atanh ( const super_precision &);//overload atanh
	friend super_precision hypot ( const super_precision &,
				const super_precision &);	//overload hypot
	friend super_precision max ( const super_precision &,
				const super_precision &);	// overload max
	friend super_precision min ( const super_precision &,
				const super_precision &);	// overload min
	friend super_precision nthrt ( const super_precision &,
				const int32);			// n'th root fn
	friend super_precision cbrt ( const super_precision &);	// overload cbrt
	friend super_precision frexp ( const super_precision &,
				int32 &);			//overload frexp
	friend super_precision ldexp ( const super_precision &,
				const int32);			//overload ldexp
	friend super_precision base_conv ( const super_precision &,
				const int32, const int32,
				const int32);			// convert base
	friend super_precision precision_conv ( const super_precision &);
								// conv. precis.
	friend char *super_output ( const super_precision &,
		const int32 count = 0,
		const int upper = 0, const int doplus = 0);	// make string
	friend super_precision super_convert_string ( const char *,
				int32 &);			//convert string
	friend ostream & operator<< ( ostream &,
				const super_precision &);	// overload <<
	friend istream & operator>> ( istream &,
				super_precision &);		// overload >>
	friend int32 super_set_output_block ( const int32 i = 0);// set blocking
	friend int32 super_set_output_base ( const int32 i = 0); // set o/p base
	friend int32 super_set_output_count ( const int32 i = 0);//set no. digit
	friend int32 super_set_input_base ( const int32 i = 0); //deflt i/p base
	static int conv_input_base;		// convert input to def_base?
	friend class super_precision_pool_ptr;			// friend class
	friend class super_precision_userpool;			// friend class
	static int std_ios_manip;			// follow ANSI usages
	static int show_output_base;	// show super_precision base on output
	static int32 set_fast_multiply_threshold ( const int32 i = -1);
							// set/show threshold
	static int32 set_fast_divide_threshold ( const int32 i = -1);
							// set/show threshold
	static int32 set_log_Salamin_threshold ( const int32 i = -1);
							// set/show threshold
	static int32 set_exp_Newton_threshold ( const int32 i = -1);
							// set/show threshold
	static int32 set_atan_Salamin_threshold ( const int32 i = -1);
							// set/show threshold
	static int32 set_tan_Newton_threshold ( const int32 i = -1);
							// set/show threshold
	static int perfect_fast_divide;				// switch to set
	super_precision increment_mantissa ( const int32 i = 1);// increase frac
	super_precision decrement_mantissa ( const int32 i = 1);// decrease frac
	int32 get_digit ( const int32) const;			// get digit(s)
	void put_digit ( const int32, const int32);		// put digit(s)
	int32 get_mantissa_word ( const int32) const;		// get frac word
	int disclose_radix ( void) const;			// show radix
	int32 disclose_digits ( void) const;			// show # digits
	int32 disclose_validity ( void) const;			// show validity
	int32 disclose_scale_factor ( void) const;		// show scale
	int32 disclose_mantissa_word_length ( void) const;	// show nf
	int32 *disclose_mantissa_pointer ( void) const;		// show mant ptr
	int32 disclose_long_div_threshold (void) const; 	// show indah
	int disclose_def_radix ( void) const;			//show def_radix
	int disclose_sign ( void) const;			// show sign
	friend int32 disclose_fftsize ( void);			// show nfft
	friend super_precision super_biggest ( void);		//retn biggest
	friend super_precision super_smallest ( void);		//retn smallest
	int32 leading_zero_count ( void) const;			//count left 0s
	int32 trailing_zero_count ( void) const;		//count right 0s
	int verify_scaling ( void) const;			//verify scaling
	static int permissive_error;	// if TRUE allows NaN,+Inf,-Inf,+-Inf
	friend super_precision super_NaN ( int i = 4);		// irreg forms
	friend super_precision super_Pinf ( void);		// sets +Inf
	friend super_precision super_Ninf ( void);		// sets -Inf
	friend super_precision super_PNinf ( void);		// sets +-Inf
	friend super_precision super_Unn ( void);		// sets Unnorm.
	int assert_invalid ( char *) const;			// test validity
	int assert_invalid ( const super_precision &, char *)
			const;					// test validity
	void assert_invalid_quit ( char *) const;		// test validity
	void assert_invalid_quit ( const super_precision &,
			char *) const;				// test validity
	static int32 debug_counter;
	static int32 debug_counter_divides;

protected:
	void super_move ( super_precision &a,
				const super_precision &b) const;  // set a=b
	void super_add ( super_precision &a, const super_precision &b,
			const super_precision &c) const;	// a = b + c
	void super_minus ( super_precision &a, const super_precision &b,
				const super_precision &c) const;// a = b - c
	void super_neg ( super_precision &a,
				const super_precision &b) const;  // a = -b
	void super_itoz ( super_precision &a, const int32 i) const;//convert a=i
	void super_mult ( super_precision &a, const super_precision &b,
				const super_precision &c) const;// a = b * c
	void super_multi ( super_precision &a, const super_precision &b,
				const int32 ia) const;		// a = b * i
	void super_div ( super_precision &a, const super_precision &b,
				const super_precision &c) const;// a = b / c
	void super_divi ( super_precision &a, const super_precision &b,
				const int32) const;		// a = b / i
	void super_shift ( super_precision &a, int32) const;	// shift a
	void super_norm ( super_precision &a, int32 &i) const;	// normalize a
	int super_test ( const super_precision &a,
				const super_precision &b) const;// compare a,b
	void super_klipr ( super_precision &a) const;		// clip a
	void super_zad ( super_precision &a, const super_precision &b,
				const super_precision &c) const;// >a = b + c
	void super_zmi ( super_precision &a, const super_precision &b,
				const super_precision &c) const;// >a = b - c
	void super_unpk ( const super_precision &a, int32 t[]) const;// >unpack
	void super_repk ( super_precision &a, int32 t[]) const;	// >repack
	void super_zmu ( super_precision &a, const super_precision &b,
				int32) const;			// >a = b * i
	void super_zqmnc ( int32 a[], int32, int32, int32) const;// inline-mnc
	void super_zqdnc ( int32 a[], int32, int32, int32, int32 &) const;
								// inline-dnc
	inline void super_zero ( super_precision &) const;	// a = 0
	void super_zqncc ( int32 a[], int32, int32, int32) const;// inline-ncc
	void super_zqanc ( int32 a[], int32 b[], int32 c[],
				int32, int32, int32 &) const;	// inline-anc
	void super_zqsnc ( int32 a[], int32 b[], int32 c[],
				int32, int32, int32 &) const;	// inline-snc
	void super_zqm1 ( int32 t[], int32 v[], int32,
				int32, int32 &, int32) const;	// inline-m1
	void super_zqm2 ( int32 t[], int32 v[], int32,
				int32 &) const;			// inline-m2
	void super_zqm2lsh ( int32 t[], int32 v[], int32,
				int32 &, int32) const;		// inline-m2lsh
	void super_zqnc	( int32 t[], int32, int32, int32 &,
				int32) const;			// inline-nc
	void super_zqupk ( int32 t [], int32 a [], int32, 
				int32) const;			// inline-unpk
	void super_zqrpk ( int32 a [], int32 t [], int32,
				int32 &, int32 &, int32 &,
				int32) const;			// inline-repk
	void super_zqdi ( int32 t [], int32, int32, int32) const;// inline-di
	void super_zqd1 ( int32 v [], int32 ia [], int32 ib [],
				int32 &, int32, int32, int32) const;// inline-d1
	void super_zqd2 ( int32 t [], int32 v [], int32 ia [],
				int32 &, int32, int32, int32) const;// inline-d2
	void super_zqncb ( int32 a [], int32, int32, int32) const;// inline-ncb
	static void change_mantissa_length
			( int32 nf = 0, int32 ndg = 0);	// change default length
	void super_chop_register ( void);		// chop reg precision
	super_precision convert_precision
			(const super_precision &) const;	//cnvt precision
	int32 super_ztoi ( const super_precision &) const;	// convert i=a
	double super_ztod_approx ( const super_precision &) const;// convert d=a
	super_precision super_dtoz_approx ( const double) const;  // convert a=d
	super_precision super_base_conv ( const super_precision &,
			const int32, const int32,
			const int32) const; 			// convert base
	double super_ztod_exact ( const super_precision &) const;
								// convert d=a
	super_precision super_dtoz_exact ( const double) const;	// convert a=d
	void super_dunpk ( const int32 a [], double t [],
			const int32, const int32, const int32) const;
								// fast_mult
	void super_drepk ( int32 t [], const double dalt [],
			const int32, const int32) const;	// fast_mult
	void super_fft_convol ( const super_precision &,
			const super_precision &, int32 t []) const;
							// FFT convolution
	void array_fft_convol ( int32 t [], int32 v [],
			int32 zia [], int32, int32, int32)
			const;				      // FFT convolution
	static char *validity_type_string ( int);		// return descrp
	static int super_irreg_fsa ( char *, int, int32 sgn = 0,
				int i = -2, int32 is = 0);	// irreg ops 

};			// END OF super_precision CLASS DEFINITION

class sp_int32						{ // CLASS DEFINITION
private:
	int32 element;					// only data element
	void * operator new ( size_t);			// overload new
	void operator delete ( void *);			// overload delete
#ifdef placement_new_array
	void * operator new [] ( size_t, int32);	// overload new []
	void operator delete [] ( void *);		// overload delete []
#endif
	friend class super_precision;		// permit use by friend class

};			// END OF sp_int32 CLASS DEFINITION

class super_precision_pool_ptr {			// CLASS DEFINITION
protected:
	super_precision *pointer;	// pointer to super_precision
	int pool_index;			// index to pool
	static int max_members;		// maximum pool size
	static int n_members;		// current pool size
	static int idle_top;		// index to top of idle stack
	static int idle [MAXPOOLSIZE];	// idle stack for pool pointers
	static super_precision *pool [MAXPOOLSIZE];	// pool pointer array
	static int32 pool_checksum;	// checksum for pool pointers
public:
	super_precision_pool_ptr ( void);			// constructor
	~super_precision_pool_ptr ( void);			// destructor
	static void pool_ptr_setup ( const int32 i = 0);	// initializer
	super_precision & operator* ( void);			// unary *
	static int32 checksum_pool_ptr ( void);		// check pool integrity
	static int32 disclose_pool_allocation_count ( void); //show ptrs alloc'd
};			// END OF super_precision_pool_ptr CLASS DEFINITION

class super_precision_userpool {			// CLASS DEFINITION
protected:
	super_precision *pointer;	// pointer to super_precision
	static int max_members;		// maximum pool size
	static int n_members;		// current pool size
	static int idle_top;		// index to top of idle stack
//	static super_precision *idle [MAXPOOLSIZE];//idle stack for pool ptrs
	static super_precision **idle;	//idle stack for pool ptrs
public:
	super_precision_userpool ( void);			// constructor
	~super_precision_userpool ( void);			// destructor
	static void setup ( const int32 i = 0);			// initializer
	super_precision & operator* ( void);			// unary *
	static int32 disclose_userpool_allocation_count ( void);
							//show ptrs alloc'd
};			// END OF super_precision_userpool CLASS DEFINITION

//
// CLASSLESS PROTOTYPES.
//
// Here are prototypes for two classless functions used for fast multiplies.
int f4t ( double *w, int32 ntotal, int32 n, int32 nprev, int32 is);
int jamcor ( double *w, int32 n, int32 ii);

