/* Power Render Terrain Rendering */

#ifndef _PRTERRAIN_
#define _PRTERRAIN_

#ifdef __cplusplus
  extern "C" {
#endif

#define TERRAIN_PLAIN           1
#define TERRAIN_SHADING         2
#define TERRAIN_REFLECTION      4
#define TERRAIN_2LEVEL          8
#define TERRAIN_3LEVEL          16


/* Used internally */
#define TERRAIN_FRONT_VISIBLE 1
#define TERRAIN_BACK_VISIBLE 2


typedef struct
 {
  PR_OBJECT *level1;
  PR_OBJECT *level2;
  PR_OBJECT *level3;
  PR_ENTITY *level1_entity;
  PR_ENTITY *level2_entity;
  PR_ENTITY *level3_entity;

  block level1_heightpic;
  block level1_shadepic;
  wgtmap level1_colorpic;

  block level2_heightpic;
  block level2_shadepic;
  wgtmap level2_colorpic;

  block level3_heightpic;
  block level3_shadepic;
  wgtmap level3_colorpic;

  PR_DWORD flags;
  PR_DWORD radius;
  PR_DWORD width;
  PR_DWORD height;
  PR_REAL  shades;

  PR_DWORD world_scale;
  PR_DWORD height_scale;
  PR_REAL maxx;
  PR_REAL maxy;
  PR_REAL  slide_x, slide_y;         /* Position within tile */
  PR_DWORD centerx, centery;         /* Pixel on image maps */
  PR_DWORD old_readx, old_ready;     /* Last center */
  PR_DWORD base_terrain_material;
 } PR_TERRAIN;


PR_TERRAIN *PR_AllocateTerrain (PR_DWORD radius, PR_DWORD flags,
                PR_DWORD world_scale, PR_DWORD height_scale,
                PR_DWORD base_terrain_material);
/* Creates a terrain structure */


PR_OBJECT *PR_AllocateTerrainMesh (PR_TERRAIN *terrain, PR_DWORD radius,
                                   PR_DWORD flags);
/* Allocate a terrain object with a given 'radius' */


void PR_ReadTerrain (PR_TERRAIN *terrain, PR_DWORD level,
                     PR_DWORD x, PR_DWORD y);
/* Reads from the heightfield and modifies the land object with new z
   coordinates and texture coordinates. */


PR_UCHAR PR_GetTerrainByte (PR_TERRAIN *terrain, PR_DWORD x,
                            PR_DWORD y, block pic);
/* Reads a byte from the heightfield. (height or shade)
 X and Y are pixel coordinates from the image */


PR_UWORD PR_GetTerrainWord  (PR_TERRAIN *terrain, PR_DWORD x,
                             PR_DWORD y, wgtmap colorpic);
/* Reads a word from the color bitmap.
 X and Y are pixel coordinates from the image */


PR_REAL PR_GetTerrainHeight (PR_TERRAIN *terrain,
                PR_REAL x, PR_REAL y, block heightpic, wgtmap colorpic);
/* Returns the height of the terrain at the given world coordinate */


void PR_LoadTerrain (PR_TERRAIN *terrain, PR_DWORD level,
                     char *heightname, char *colorname,
                     char *shadename, PR_DWORD shades);
/* Loads the data for a heightfield */


void PR_RotateTerrain (PR_TERRAIN *terrain, PR_REAL x, PR_REAL y,
                       PR_REAL z);
/* Rotate the terrain levels */

void PR_TransformTerrain (PR_TERRAIN *terrain);
/* Rotates a grid of vertices using a custom (fast) method of rotation */


void PR_RenderTerrain (PR_TERRAIN *terrain);
/* Renders the polygons from a terrain mesh */


void PR_UpdateTerrain (PR_TERRAIN *terrain);
/* Updates the position of the terrain */


void PR_GenerateShading1 (PR_TERRAIN *terrain);
/* Uses a simple method for creating the shading map.  If the pixel above
   is higher, the current pixel is dark. */

void PR_GenerateShading2 (PR_TERRAIN *terrain);

void PR_TerrainWaveFunction (PR_WORD *col, PR_WORD *hgt, PR_WORD *shd,
                             PR_DWORD x, PR_DWORD y);

void PR_TerrainModify (PR_TERRAIN *terrain);
/* Tells the rendering engine that the landscape has changed */

#ifdef __cplusplus
}
#endif

#endif

