/* Power Render Mystique Interface */

#ifndef _PRMYST_
#define _PRMYST_

#ifdef __cplusplus
  extern "C" {
#endif

PR_DWORD PR_AddTextureMystique (char *filename, block image);
/* -----------------------------------------------------------------------
   Function:   PR_AddTextureMystique
   Purpose:    Adds a texture to the PR_WorldTextures array
   Parameters: filename - Filename of the texture (must be present)
               image - 8 bit texture image, or NULL if 3DF is used
   Return:     Texture number
   ----------------------------------------------------------------------- */


void PR_AllocTexturesMystique (PR_DWORD maxtexture);
/* -----------------------------------------------------------------------
   Function:   PR_AllocTexturesMystique
   Purpose:    Allocates room for a list of textures
   Parameters: maxtexture - Number of textures positions to allocate
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_BarMystique (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_BarMystique
   Purpose:    Draws a bar (filled rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle to fill with a solid color
   Return:     None
   ----------------------------------------------------------------------- */


void PR_BeginScreenMystique (void);
/* -----------------------------------------------------------------------
   Function:   PR_BeginScreenMystique
   Purpose:    Initializes a buffer for direct access
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ClearScreenMystique (void);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ClearScreenMystique
   Purpose:    Clears the current screen 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ClipMystique (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ClipMystique
   Purpose:    Sets the clipping region in device coordinates
   Parameters: x0, y0, x1, y1 - Clipping rectangle
   Return:     None
   ----------------------------------------------------------------------- */


void PR_DeleteAllTexturesMystique (void);
/* -----------------------------------------------------------------------
   Function:   PR_DeleteAllTexturesMystique
   Purpose:    Deletes all the textures from the PR_WorldTextures array
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_DetectMystique (void);
/* -----------------------------------------------------------------------
   Function:   PR_DetectMystique
   Purpose:    Looks for the presence of 3D accelerated hardware 
   Parameters: None
   Return:     TRUE if found
   ----------------------------------------------------------------------- */


void PR_EndScreenMystique (void);
/* -----------------------------------------------------------------------
   Function:   PR_EndScreenMystique
   Purpose:    Closes a screen after direct access
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PR_FlipMystique (PR_DWORD retrace);
/* -----------------------------------------------------------------------
   Function:   PR_FlipMystique
   Purpose:    Swaps front and back buffers
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_HLineMystique (PR_DWORD x0, PR_DWORD x1, PR_DWORD y0);
/* -----------------------------------------------------------------------
   Function:   PRGFX_HLineMystique
   Purpose:    Draws a horizontal line
   Parameters: x0, x1 - endpoints
               y0     - scan line
   Return:     None
   ----------------------------------------------------------------------- */


void PR_InitializeMystique (void);
/* -----------------------------------------------------------------------
   Function:   PR_InitializeMystique
   Purpose:    Initializes the Mystique hardware routines
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_LineMystique (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_LineMystique
   Purpose:    Draws a diagonal line
   Parameters: x0, y0, x1, y1 - Endpoints of line
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_LoadTextureMystique (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_LoadTextureMystique
   Purpose:    Loads the texture if it hasn't been already
   Parameters: filename - Filename of the texture to load
   Return:     Texture number
   ----------------------------------------------------------------------- */


PR_UDWORD PRGFX_MakeColorMystique (PR_DWORD r, PR_DWORD g, PR_DWORD b);
/* -----------------------------------------------------------------------
   Function:   PRGFX_MakeColorMystique
   Purpose:    Returns a color value for the RGB value given
   Parameters: r,g,b - Red, green, blue components (0-64)
   Return:     Packed color value (RGBA8888)
   ----------------------------------------------------------------------- */


block PRGFX_NewBlockMystique (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_NewBlockMystique
   Purpose:    Grabs a section of the render buffer into memory
   Parameters: x0, y0, x1, y1 - Rectangular region to grab
   Return:     A block of memory in the format of the render buffer.
               (8 bit, RGB565 etc)
   ----------------------------------------------------------------------- */


void PR_OpenScreenMystique (PR_DWORD screen);
/* -----------------------------------------------------------------------
   Function:   PR_OpenScreenMystique
   Purpose:    Selects a buffer to render on 
   Parameters: screen - PR_FRONTBUFFER or PR_BACKBUFFER
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PRGFX_outcharMystique (short asc, PR_DWORD xc, PR_DWORD yc, wgtfont font);
/* -----------------------------------------------------------------------
   Function:   PRGFX_outcharMystique
   Purpose:    Displays a single character
   Parameters: asc - Ascii code
               xc - X coordinate
               yc - Y coordinate
               font - Pointer to font
   Return:     width of character
   ----------------------------------------------------------------------- */


void PRGFX_OutTextXYMystique (PR_DWORD x, PR_DWORD y, wgtfont font, char *string);
/* -----------------------------------------------------------------------
   Function:   PRGFX_OutTextXYMystique
   Purpose:    Draws an unformatted string
   Parameters: x, y - Screen location
               font - Font to use
               string - String to display
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlockMystique (PR_DWORD x, PR_DWORD y,
                         PR_DWORD width, PR_DWORD height,
                         block buffer);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlockMystique
   Purpose:    Pastes a block of conventional memory to video memory
   Parameters: x,y - Location on screen
               width - Width of source block
               height - Height of source block
               src - Block containing source data
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlock8bitMystique (PR_DWORD x, PR_DWORD y, block src, color *pal,
                             PR_DWORD method);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlock8bitMystique
   Purpose:    Pastes an image in 8 bit color indexed format to the screen
   Parameters: x,y - Location on screen
               src - Block containing source data
               pal - Palette used
               method - NORMAL or XRAY
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutTextureMystique (PR_DWORD x, PR_DWORD y, PR_DWORD texnum, PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutTextureMystique
   Purpose:    Displays a texture at (x,y)
   Parameters: x, y - Location on screen
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ReadRegionMystique (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1, block image);
/* ------------------------------------------------------------------------
   Function:   PRGFX_ReadRegionMystique
   Purpose:    Grabs a section of the render buffer into memory
               Used internally by newblock and mouse routines
   Parameters: x0, y0, x1, y1 - Rectangular region to grab
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_RectangleMystique (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_RectangleMystique
   Purpose:    Draws a rectangle (hollow rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle coordinates
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ResizeTextureMystique (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1,
                           PR_DWORD texnum, PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ResizeTextureMystique
   Purpose:    Resizes the texture into the specified area on the screen 
   Parameters: x0, y0, x1, y1 - Rectangular region
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_SetColorMystique (PR_DWORD col);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetColorMystique
   Purpose:    Sets the current drawing color
   Parameters: col - Color index or packed value
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_SetModeMystique (PR_DWORD width, PR_DWORD height, PR_DWORD refrate);
/* -----------------------------------------------------------------------
   Function:   PR_SetModeMystique
   Purpose:    Attempts to initialize a video mode 
   Parameters: width - Width of screen
               height - Height of screen
               refrate - Refresh rate
   Return:     MODE_INVALID, MODE_OPEN_ERROR, MODE_SUCCESS
   ----------------------------------------------------------------------- */


void PR_ShutdownMystique (void);
/* -----------------------------------------------------------------------
   Function:   PR_ShutdownMystique
   Purpose:    Shuts down a display device 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_VLineMystique (PR_DWORD x0, PR_DWORD y0, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_VLineMystique
   Purpose:    Draws a vertical line
   Parameters: x0 - X Coordinate
               y0, y1 - Endpoints
   Return:     None
   ----------------------------------------------------------------------- */



void PR_RenderFrameMystique (void);
/* Renders all faces in the rendering list to the viewport */

void PR_ComputeVertexLightingMystique (void);

void PR_AddElementMystique (PR_FACE *elemptr, PR_VERTEX *pointlist,
                        PR_VERTEX_DATA *pointdata, PR_DWORD count);
/* Adds a face to the rendering list if it is visible */

void PR_SetFogColorMystique (PR_DWORD col);

void PR_SetFogStateMystique (PR_DWORD state);
/* Sets the global fog rendering state (0 or 1) */

void PR_SetFogRangeMystique (PR_REAL near_dist, PR_REAL far_dist);
/* Sets the range of fog */

void PR_SetDefaultMSIParameters(T_msiParameters *msiParameters);

void PRGFX_SelectTexture (PR_DWORD texnum);

void PRGFX_LoadTriangleMystique (PR_VERTEX_DATA *a,
                                 PR_VERTEX_DATA *b,
                                 PR_VERTEX_DATA *c);

extern unsigned char far * PR_MystiqueLFBptr;
extern T_msiInfo *         PR_pInfo;   
extern T_msiParameters     PR_msiParameters;
extern T_msiVertex         PR_msiVertex[3];

#ifdef __cplusplus
}
#endif

#endif

