//--------------------------------------------------------------------------
//
//      EXAMPLE4.CPP: example for DOS multithreading library.
//      Copyright (c) J.English 1993.
//      Author's address: je@unix.brighton.ac.uk
//
//      Permission is granted to use copy and distribute the
//      information contained in this file provided that this
//      copyright notice is retained intact and that any software
//      or other document incorporating this file or parts thereof
//      makes the source code for the library of which this file
//      is a part freely available.
//
//--------------------------------------------------------------------------
//
//      This example shows the use of a bounded buffer.  It starts
//      two threads, each of which repeatedly gets a character from
//      the buffer and either displays it or displays an asterisk.
//      The main program is responsible for getting characters from
//      the keyboard and putting them in the buffer.
//
//--------------------------------------------------------------------------

#include <stdio.h>
#include <conio.h>
#include "threads.h"
#include "buffers.h"

BoundedBuffer<char> buffer (20);        // a buffer of 20 characters

class Example4a : public DOSThread
{
  public:
    Example4a ()            { }
    ~Example4a ();

  protected:
    virtual void main ();
};

void Example4a::main ()
{
    char c;
    for (;;)
    {   if (!buffer.get (c))
            return;
        putchar (c);
    }
}

Example4a::~Example4a ()
{
    wait ();
    fputs ("\nEnd of thread A\n", stdout);
}

class Example4b : public DOSThread
{
  public:
    Example4b ()            { }
    ~Example4b ();

  protected:
    virtual void main ();
};

void Example4b::main ()
{
    char c;
    for (;;)
    {   if (!buffer.get (c))
            return;
        putchar ('*');
    }
}

Example4b::~Example4b ()
{
    wait ();
    fputs ("\nEnd of thread B\n", stdout);
}

void main ()
{
    Example4a A;
    Example4b B;

    if (A.run ())
        puts ("Thread A started");
    if (B.run ())
        puts ("Thread B started");

    puts ("Press ESC to terminate");

    char c;
    for (;;)
    {   c = getch ();
        if (c == 0x1B)
        {   buffer.close ();
            puts ("\nTerminating...");
            break;
        }
        else
            buffer.put (c);
    }
}
