#ifndef  __BUFF_H
#define  __BUFF_H

#include "public.h"


// 
// Written by: RAM MACHNESS                                                   
// Started on: 24-11-1991                                                     
// 


enum BUFF_OP {BUFF_FAILURE= 0,
              BUFF_UNDERFLOW,
              BUFF_OVERFLOW,
              BUFF_OK_START_POINT,
              BUFF_EMPTY,
              BUFF_FULL,
              BUFF_SINGLE_ITEM,
              BUFF_READY };

class BUFF
{
private:
    BYTE* buff;                 //the array of items.
    BOOLEAN    self_allocated;  //was the array allocated by any constructor.
    INDEX      head;            //head of the buffer pointing first item.
    unsigned   current_length;  //current number of items on array.
    unsigned   buff_len;        //max number of items may be in buff.
    unsigned   alloc_len;       //max number of bytes allocated to the array.

public:
       BUFF();                                  // default constructor
       BUFF(const unsigned length);             // regular constructor
       BUFF(const BUFF&    source_buff);        // copy constructor

       //ͻ
       //blocking constructor- based on other buff.   
       //this constructor creates   "virtual" buffer  
       //zero represents first item                   
       //defult is last item                          
       //ͼ
       BUFF(const BUFF&    source_buff,
            const INDEX    block_start= 0,
            const INDEX    block_len= 0xFF);

       ~BUFF();                                 // destructor


       // ͻ
       // function to copy one buff to another 
       // ͼ
       void     operator=  (const BUFF& source_buff);

       // ͻ
       // function returning the current length of the buffer.            
       // Pay attention- function may be used recoursively(by interrupts) 
       // ͼ
       unsigned len    (void) const;

       // ͻ
       // function to insert a byte to the buff.                           
       // Can't be operate on virtual buffer.                              
       // ͼ
       BUFF_OP  operator<< (const BYTE in_byte);

       // ͻ
       // function to get the byte on the head of the queue.                
       // Can't be operate on virtual buffer.                               
       // ͼ
       BUFF_OP  operator>> (BYTE& out_byte);

       // ͻ
       // function to see the byte on the head of the queue without 
       // poping it out.                                            
       // ͼ
       BUFF_OP  operator>  (BYTE& out_byte);

       // ͻ
       // function to add another buff to the sertain buffer. 
       // Can't be operate on virtual buffer.                 
       // (but virtual buffer may be a parameter)             
       // ͼ
       BUFF_OP  operator<< (const BUFF& other_buff);

       // ͻ
       // function to empty the buff.         
       // Can't be operate on virtual buffer. 
       // ͼ
       void     empty_buff (void);

       // ͻ
       // function to see an item according to its' index.                
       // you may enter any index.                                        
       // Pay attention- function may be used recoursively(by interrupts) 
       // ͼ
       BYTE     operator[] (const INDEX index) const;

       // ͻ
       // function to see and change an item according to its' index.     
       // you may enter any index.                                        
       // Pay attention- function may be used recoursively(by interrupts) 
       // ͼ
       BYTE&    operator[] (const INDEX index) ;

       // ͻ
       // function to change buffer size and to reset the buffer. 
       // Can't be operate on virtual buffer.                     
       // ͼ
       BUFF_OP  reset_size (const unsigned new_size,
                            const  BOOLEAN  reset= FALSE);

       // OOLA.
       int buff_size(void) const { return buff_len; };
};
#endif /* __BUFF_H */
