{$U-,C-,R-}
FUNCTION scan(VAR extend : BOOLEAN; VAR code : Byte) : BOOLEAN;
{
 Uses BIOS service 16 to get a keystroke w/o echo. Sets 'extend' true
 for extended codes from PC-Clone keyboards, and returns ASCII/Scan code
 in 'code'.  Returns true if a character exists, false if none is in the
 buffer.
}
TYPE
    regs = RECORD
	  ax,bx,cx,dx,bp,si,di,ds,es,flags : INTEGER;
    END;
VAR
   r : regs;
   c : INTEGER;
BEGIN
     code := 0;
     r.ax := 1 ShL 8;	 {AH := 1}
     Intr($16,r);
     IF r.flags AND 64 <> 64 THEN
     BEGIN
	r.ax := 0;
	Intr($16,r);	 {Get character and clear from buffer}
	code := Lo(r.ax);
	scan := TRUE;
	extend := FALSE;
	if  code = 0 THEN
	begin
	   extend := TRUE;
	   code := Hi(r.ax)
	end;
     END
     ELSE
	scan := FALSE;
END;

FUNCTION exists(fname :  bigstring) : BOOLEAN;
VAR
   f : FILE;
BEGIN
     Assign(f, fname);
     {$I-}
     RESET(f);
     {$I+}
     IF IOResult = 0 THEN
	begin
	     exists := TRUE;
	     CLOSE(f)
	end
     ELSE
	exists := FALSE
END;

PROCEDURE supcase(VAR s);
VAR
   ss : bigstring Absolute s;
   i : INTEGER;
BEGIN
     FOR i := 1 TO LENGTH(ss) DO
	 ss[i] := UpCase(ss[i])
END;
