/*
 * File......: PRTSCR.C
 * Author....: Ted Means
 * Date......: $Date:   15 Aug 1991 23:08:24  $
 * Revision..: $Revision:   1.2  $
 * Log file..: $Logfile:   E:/nanfor/src/prtscr.c_v  $
 * 
 * This is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/prtscr.c_v  $
 * 
 *    Rev 1.2   15 Aug 1991 23:08:24   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   14 Jun 1991 19:53:54   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   01 Apr 1991 01:02:58   GLENN
 * Nanforum Toolkit
 * 
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FT_PRTSCR()
 *  $CATEGORY$
 *     Keyboard/Mouse
 *  $ONELINER$
 *     Enable or disable the Print Screen key
 *  $SYNTAX$
 *     FT_PRTSCR( [ <lSetStat> ] ) -> lCurStat
 *  $ARGUMENTS$
 *     <lSetStat> set to .T. will enable the Print Screen key,
 *     .F. will disable it.  If omitted, leaves status as is.
 *  $RETURNS$
 *     The current state: .T. if enabled, .F. if disabled.
 *  $DESCRIPTION$
 *     This function is valuable if you have a need to disable the
 *     printscreen key.  It works by fooling the BIOS into thinking that
 *     a printscreen is already in progress.  The BIOS will then refuse
 *     to invoke the printscreen handler.
 *  $EXAMPLES$
 *     FT_PRTSCR( .F. )       && Disable the printscreen key
 *     FT_PRTSCR( .T. )       && Enable the printscreen key
 *     MemVar := FT_PRTSCR()  && Get the current status
 *  $SEEALSO$
 *     FT_CAPLOCK() FT_CTRL() FT_NUMLOCK() FT_SHIFT() FT_ALT()
 *  $END$
 */

#include <extend.h>

#define pbyte *((char *) 0x00000500)

CLIPPER FT_PRTSCR(void)
{
   if ( PCOUNT && ISLOG( 1 ) )
   {
      if ( _parl( 1 ) )
          pbyte = 0;
      else
          pbyte = 1;
   }
   if ( pbyte == 1)
      _retl( FALSE );
   else
      _retl( TRUE );

   return;
}
