; File......: HANDCNT.ASM
; Author....: Bob Clarke
; CIS ID....: 72621,3563
; Date......: $Date:   15 Aug 1991 23:06:52  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   E:/nanfor/src/handcnt.asv  $
; 
; This is an original work by Bob Clarke and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/handcnt.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:06:52   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:36   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   07 Jun 1991 21:58:52   GLENN
;  Initial revision.
;

; $DOC$
; $FUNCNAME$
;    FT_HANDCNT()
; $CATEGORY$
;    DOS/BIOS
; $ONELINER$
;    Count number of available DOS (not network) file handles
; $SYNTAX$
;    FT_HANDCNT() -> nHandles
; $ARGUMENTS$
;    None
; $RETURNS$
;    numeric, long integer
; $DESCRIPTION$
;    FT_HANDCNT() finds the internal DOS Device Control Blocks used for 
;    storing file information and counts the number of DCB entries.  The
;    DCB is set up by reading the FILES= line in CONFIG.SYS, and there
;    is one DCB entry for each file handle.
;
;    NOTE: For Novell networks, the number of network file handles is
;          controlled by SHELL.CFG.  To date, I know where this information
;          is stored after SHELL.CFG has been read, but have not come up
;          with a reliable way to retrieve the information.  There is no
;          public variable associated with the storage location, and the
;          location can change from version to version of NETx.EXE.
;          Novell Tech Support's response, though friendly, was "Nope, we 
;          don't know of a way for you to do it, either.  Good luck."
; $EXAMPLES$
;    nHandles := FT_HANDCNT()
;    ? "This PC has " + LTRIM( STR( nHandles ) ) + " set by CONFIG.SYS."
; $SEEALSO$
;
; $INCLUDE$
;
; $END$
;
;

Public   FT_HANDCNT
Extrn    __RETNL:Far

_NanFor  Segment  Word Public 'CODE'
         Assume CS:_Nanfor

FT_HANDCNT    Proc Far

         push bp
         push es
         push ds
         push si
         push di
         mov  ah,52h                   ;Get Configuration Variable Table
         push es
         push ds
         int  21h

; ES:BX now contains pointer to CVT (Configuration Variable Table)


;
;CVT structure for DOS 3.x:
;
;    (The ampersand indicates the address in ES:BX)
;
;offset byte        field length        description
;-----------        ------------        ------------
;
;    -08h           double word         current buffer in BUFFERS= chain
;    -04h           word                offset within current buffer
;    -02h           word                segment of first memory control block
;&    00h           double word         pointer to first Drive Parameter Block
;     04h           double word         Pointer to first DCB (system file table
;                                       Device Control Block)
;     08h           double word         pointer to CLOCK$ device driver
;     0Ch           double word         pointer to CON device driver
;     10h           word                maximum bytes per sector on any block
;                                       device
;     12h           double word         pointer to start of disk buffer chain
;     16h           double word         pointer to Logical Drive Table
;     1Ah           double word         pointer to start of DOS's FCB chain
;     1Eh           word                number of FCBs to keep when swapping
;     20h           byte                number of block devices
;     21h           byte                number of logical drives, set by value
;                                       of LASTDRIVE in CONFIG.SYS (defaults
;                                       to 5 if not specified)
;     22h                               Beginning of NUL device driver;
;                                       first device in the device-driver
;                                       chain
;
; For DOS 4.x, the only change in the CVT was the item at offset 12h.  It is 
; now a double word pointer to EMS link record that leads to the DOS buffer
; chain.  All other items and addresses are the same as for DOS 3.x.
;
; The number of DCBs in a system is established by the FILES= line in
; CONFIG.SYS.  The default number is 8 if no FILES= line is found.
; DCBs are grouped in "links" and each link is preceded by a 3-word header.
;
;Structure of device control block header:
;
;offset byte        field length        description
;-----------        ------------        ------------
;    00h            double word         Far pointer to next link header,
;                                       or xxxx:FFFFh to indicate that this
;                                       is final link in chain.
;    04h            word                number of blocks in this link
;
;
; For more detailed information, see "DOS Programmer's Reference: 2nd Edition"
; by Que Corporation, pages 807-818.
;


         add  bx,4                     ;move to address of first DCB
         mov  si,word ptr es:[bx]      ;get offset of DCB
         mov  ds,word ptr es:[bx+2]    ;get segment of DCB

; DS:SI now contains a pointer to header of first DCB

         xor  ax,ax                    ;use as a count holder
         xor  dx,dx                    ;use as a count holder
hand1:   add  ax,word ptr [si+4]       ;adjust running total
         adc  dx,0
         mov  cx,word ptr [si]         ;offset of next link header
         mov  bx,word ptr [si+2]       ;segment of next link header
         mov  si,cx
         mov  ds,bx
         cmp  cx,0ffffh                ;possible end of list?
         jne  hand1                    ;if not, keep looking
         pop  ds
         pop  es

; sum of dcbs from all links is now in DX:AX

         pop  di                  ;restore registers before returning value
         pop  si
         pop  ds
         pop  es
         pop  bp
         push dx
         push ax
         call __retnl
         add  sp,4
         ret

FT_HANDCNT    Endp
_NanFor       Ends
              End


