; File......: ENDCAP.ASM
; Author....: James R. Zack
; CIS ID....: 75410,1567
; Date......: $Date:   17 Aug 1991 15:27:42  $
; Revision..: $Revision:   1.3  $
; Log File..: $Logfile:   E:/nanfor/src/endcap.asv  $
;
; This is an original work by James R. Zack and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/endcap.asv  $
;  
;     Rev 1.3   17 Aug 1991 15:27:42   GLENN
;  Don Caton fixed some spelling errors in the doc
;  
;     Rev 1.2   15 Aug 1991 23:06:44   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:26   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:16   GLENN
;  Nanforum Toolkit
;  
;

; File......: ENDCAP.ASM
; Author....: James R. Zack
; CIS ID....: 75410,1567
; Date......: $Date:   17 Aug 1991 15:27:42  $
; Revision..: $Revision:   1.3  $
; Log File..: $Logfile:   E:/nanfor/src/endcap.asv  $
;
; This is an original work by James R. Zack and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;  
;     Rev 1.1   14 Jun 1991 19:54:26   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:16   GLENN
;  Nanforum Toolkit
;  
;

; $DOC$
; $FUNCNAME$
;     FT_ENDCAP()
; $CATEGORY$
;     NetWare
; $ONELINER$
;     Cancel a specific NetWare print queue capture
; $SYNTAX$
;     FT_ENDCAP( [ <nLPTPortNumber> ] ) -> lResult
; $ARGUMENTS$
;     <nLPTPortNumber> is the captured LPT port to cancel.  If the
;     parameter is omitted, the default port of LPT1: is used.
; $RETURNS$
;     .T. if successful
; $DESCRIPTION$
;    This routine is used to close a specific capture on the specified LPT
;    port.  When this command is issued, the LPT port is no longer redirected
;    to the print queue, and any information waiting in queue to be printed
;    will be printed.
;
;    This routine was designed and written for Advanced NetWare 286 v 2.1 or
;    NetWare 386 v 3.0 or better.  It has been tested on Advanced NetWare 286
;    v 2.15 rev A & C and NetWare 386 v 3.0.
;
;    This source code was written for Microsoft Macro Assembler v 5.1.  It
;    should work with any assembler with minor modifications.
; $EXAMPLES$
;    (in DOS)
;    F:>CAPTURE S=ServerName Q=PrintQueueName T=0 L=2
;    Device LPT2: re-routed to queue PrintQueueName on server ServerName.
;    F:>CAPTURE S=ServerName Q=PrintQueueName T=0 L=1
;    Device LPT1: re-routed to queue PrintQueueName on server ServerName.
;
;    (in your Clipper application)
;    FT_ENDCAP(2) // Closes LPT2: capture, and flushes print buffer
;    ...
;    ...
;    FT_ENDCAP()  // Closes LPT1: (default) capture, and flushes
;                 //    print buffer
; $END$

PUBLIC   FT_ENDCAP                   ; DECLARE ROUTINE PUBLIC
EXTRN    __RET:FAR                   ; DECLARE EXTERNALS: THESE ARE FOUND
EXTRN    __PARNI:FAR                 ;                          IN EXTEND
EXTRN    __RETL:FAR                  ;                          LIBRARY.
EXTRN    __PARINFO:FAR               ;

_NANFOR SEGMENT 'CODE'               ; CODE SEGMENT
          ASSUME  CS:_NANFOR         ; POINT SEGMENT REGS TO RIGHT PLACE
FT_ENDCAP PROC    FAR                ; DECLARE ROUTINE FAR
          PUSH    BP                 ; SAVE BASE POINTER
          MOV     BP,SP              ; POINT TO TOP OF STACK
          PUSH    DS                 ; SAVE DATA SEGMENT
          PUSH    ES                 ; SAVE EXTRA SEGMENT
          PUSH    SI                 ; SAVE SOURCE INDEX
          PUSH    DI                 ; SAVE DESTINATION INDEX
          XOR     AX,AX              ; MAKE SURE AX IS CLEAR
          PUSH    AX                 ; PUSH IT ONTO THE STACK
          CALL    __PARINFO          ; GET NUMBER OF PARMS PASSED
          ADD     SP,2               ; RESET STACK POINTER
          CMP     AX,0               ; ANYTHING PASSED?
          JLE     DEFAULT            ; NO, USE DEFAULTS, OTHERWISE, CHECK PARMS
          MOV     AX,1               ; POINT TO FIRST PARM ON STACK
          PUSH    AX                 ; SAVE IT
          CALL    __PARINFO          ; SEE WHAT TYPE OF PARM WAS PASSED
          ADD     SP,2               ; RESTORE THE STACK
          CMP     AX,2               ; WAS IT A NUMERIC?
          JNE     DEFAULT            ; NO, USE DEFAULTS
          MOV     AX,1               ; POINT TO FIRST PARM ON STACK
          PUSH    AX                 ; SAVE IT
          CALL    __PARNI            ; GET PARM
          ADD     SP,2               ; RESET STACK
          MOV     DH,AL              ; PUT PORT NUMBER INTO DH
          CMP     DH,00              ; IS THIS A VALID PORT NUMBER
          JLE     DEFAULT            ; NO, USE DEFAULT PRINTER
          CMP     DH,03H             ; IS IT HIGHER THAN LPT3?
          JG      DEFAULT            ; YES, USE DEFAULTS
          JMP     CANCEL             ; OTHERWISE, CANCEL QUEUE
DEFAULT:  MOV     DH,00              ; STORE LPT1: AS THE DEFAULT PRINTER
CANCEL:   MOV     AH,0DFH            ; NetWare API INT 21H, FUNCTION DFH
          MOV     DL,06H             ; SUBFUNCTION 06H - CANCEL SPECIFIC CAPTURE
          DEC     DH                 ; SUBTRACT 1 FROM PORT NUMBER
          INT     21H                ; CALL API FUNCTION
          CMP     AL,00              ; CHECK FOR SUCCESSFUL RETURN
          JE      RET_OK             ; YES, IT WAS SUCCESSFUL
          XOR     AX,AX              ; OTHERWISE, BLANK OUT AX (False)
          jmp     JUMPOUT            ; Goto clean up and return
RET_OK:   mov     ax,01h             ; Return a true
JUMPOUT:  push    ax                 ; push reg onto stack
          call    __RETL             ; pass it back to clipper
          add     sp,2               ; Reset stack
          pop     di                 ; Restore environment
          pop     si
          pop     es
          pop     ds
          pop     bp
          call    __RET              ; Get outta here and back to clipper
          ret                        ; Pass control back to clipper
FT_ENDCAP ENDP

_NanFor   ENDS

          END

