* Program  WHATKEY.PRG
* Author   D. Morgan
* Date     September 1986
* Notes    Displays keystroke output two ways. First, output of
*          Clipper INKEY() function; second, output of PC
*          keyboard, obtained from PC ROM call INT 16 via
*          accompanying assembly function PCKEY().  Use <Alt-T>
*          to toggle between them with glimpse of <Alt-T> output
*          first; <Alt-T> twice in quick succession for
*          immediate toggle.

CLEAR
SET ESCAPE OFF
toggle = 1		     && 1=Clipper INKEY()  0=PC keyboard

text
                                       
                                               
                                      
                                          
                                      
endtext

empty_frame = "Ŀ "                      && Draw two boxes
@ 8,2 SAY 'IBM PC Keyboard Output'
@ 9,2,21,35 BOX empty_frame
@ 8,42 SAY 'Clipper INKEY() Function Output'
@ 9,42,21,75 BOX empty_frame

@ 11,65 SAY 'Dec   Hex'		&& Fill Clipper box with prompts
@ 13,45 SAY 'Clipper INKEY(): '
@ 15,45 SAY 'Printed character: '
@ 22,42 SAY '<Alt-T> to Toggle to IBM output'
@ 23,42 SAY '<Alt-Q> to Quit'
@ 15,65 SAY ''

key = 0
DO WHILE .NOT.((toggle=1.AND.key=272);
 .OR. (toggle=0.AND.key=4096))                && <Alt-Q> to quit 
 key = 0

 IF toggle = 1                 && Get/display Clipper key output
  trash = INKEY(0)
  key = LASTKEY()
  IF  key>=0
   hex_str = DECTOHEX(key)
  ELSE
   hex_str='    '
  ENDIF
  hex_str = SUBSTR('0000'+hex_str,LEN(hex_str)+1,4)
  @ 13,62 SAY STR(key,6)+'  '+hex_str
  @ 15,65 SAY CHR(key)
 ELSE                               && Get/display PC key output
  key = PCKEY()
  hex_str = DECTOHEX(key)
  hex_str = SUBSTR('0000'+hex_str,LEN(hex_str)+1,4)
  @ 13,21 SAY STR(INT(key/256),6)+'    '+SUBSTR(hex_str,1,2)
  @ 16,21 SAY STR(key%256,6)+'    '+SUBSTR(hex_str,3,2)
  @ 19,25 SAY CHR(key%256)
 ENDIF :toggle=1

 IF (toggle=1.AND.key=276);
  .OR. (toggle=0.AND.key = 5120)            && <Alt-T> to toggle
  trash = INKEY(1)  && Let user glimpse Alt-T toggle char output
  toggle = 1 - toggle && Toggle to other state, 1-to-0 or 0-to-1
  IF toggle = 1
   @ 9,2,21,35 BOX empty_frame   && Blank PC box to show INKEY()
   @ 11,65 SAY 'Dec   Hex'        && and paint prompts in PC box
   @ 13,45 SAY 'Clipper INKEY(): '
   @ 15,45 SAY 'Printed character:  '
   @ 22,0
   @ 23,0
   @ 22,42 SAY '<Alt-T> to Toggle to IBM output'
   @ 23,42 SAY '<Alt-Q> to Quit'
   @ 15,65 SAY ''
  ELSE
   @ 9,42,21,75 BOX empty_frame	 && Blank INKEY() box to show PC
   @ 11,24 SAY 'Dec   Hex'   && and paint prompts in INKEY() box
   @ 13,5 SAY 'Auxiliary byte: '
   @ 14,6 SAY '(scan code)'
   @ 16,5 SAY 'Main byte:      '
   @ 17,6 SAY '(ASCII value)'
   @ 19,5 SAY 'Printed character:  '
   @ 22,0
   @ 23,0
   @ 22,2 SAY '<Alt-T> to Toggle to Clipper output'
   @ 23,2 SAY '<Alt-Q> to Quit'
   @ 19,25 SAY ''
  ENDIF :toggle = 1
 ENDIF :toggle.AND.key .OR. toggle.AND.key
ENDDO :toggle.AND.key .OR. toggle.AND.key
@ 22,0 CLEAR
RETURN


FUNCTION DECTOHEX
*
* Syntax: DECTOHEX(<expN>)
* Return: <expC>, a string consisting of as many hexadecimal
*         digits as required to represent in hex the value of
*         the input

PRIVATE dec,hex_str,power,no_times
PARAMETERS dec
hex_str = ''
power = 0
DO WHILE INT( dec/(16^(power+1)) ) > 0 && find highest dividable
  power = power + 1                               && power of 16
ENDDO
DO WHILE power >= 0                     && find how many of each
 no_times = INT(dec/(16^power))
 hex_str = hex_str +;
  IF(no_times<10,CHR(48+no_times),CHR(55+no_times))
 dec = dec - no_times * (16^power)
 power = power - 1
ENDDO
RETURN(hex_str)
