;
;   Title:    TURNIT3.ASM
;   Author:   F. Ho
;   Date:     8th July 1986
;   Syntax:   ? TURN(expC)
;             where: -expC is the character string expression 
;                     to be reversed
;   Note:     - reverses the order of the string passed
;             - can only process a MAX of 60 characters
;
public   TURN           ; this public statement makes this
;                       ; routine accessible to the 'public'
;
extrn    _PARC:far      ; Clipper's character 'getter'
extrn    _RETC:far      ; Clipper's character 'returner'
;
;
DGROUP   GROUP     datasg    ; Clipper's Data Segment

; the 'public' in the next statement combines the datasg
; to Clipper's DGROUP group
datasg   segment   public    'DATA'

RETVAL   db   60   dup(" ")  ; init with 60 spaces
VAL1     dw   00             ; init with 0
VAL2     dw   00             ; init with 0

datasg   ends                ; end of datasg (in DGROUP)
;
;
_prog    segment
         assume     cs:_prog,ds:DGROUP,es:DGROUP

TURN     proc far       ; far process

         push bp        ; preserve return address
         mov  bp,sp     ; move stack pointer
		
         mov  ax,1      ; get first para
         push ax        ; push AX
         call _PARC     ; call Chara "getter"
         add  sp,2      ; restore stack
         mov  VAL1,bx   ; get OFFSET address 
         mov  VAL2,ax   ; get SEGMENT address 
	
         push ds        ; preserve DS
         push es        ; preserve ES
         cld            ; clear direction flag (L-R)
         mov  di,offset DGROUP:RETVAL  ; get RETVAL's offset
                                       ; from DGROUP
         mov  ax,DGROUP                ; get DGROUP segment
         mov  es,ax                    ; and place in ES

; in the next three statements, the order that it appears is
; important because the values of SI & AX must first be taken 
; from the DATASG extension before assigning the DGROUP segment
; address to DS

         mov  si,VAL1
         mov  ax,VAL2
         mov  ds,ax
				
	
         xor  ax,ax          ; zero out AX
         mov  al,[si]        ; move first SI value to AL
         cmp  al,0           ; if NUL (zero)
         jz   C3             ; jump to C3

         mov  cx,3ch         ; set CX for max 60 loops
         xor  bx,bx          ; zero-out BX
         xor  ax,ax          ; zero-out AX

A1:      mov  al,[si]        ; move SI value to AL
         cmp  al,0           ; compare with zero
         jz   A2             ; if zero, jump to A2:
         inc  si             ; increment SI
         inc  bx             ; increment BX
         loop A1             ; loop to A1:

A2:      dec  si             ; decrement SI
         mov  cx,bx          ; move BX to CX
         xor  ax,ax          ; zero-out AX

A3:      mov  al,[si]        ; move	SI val to AL
         mov  es:[di],al     ; move	AL to DI
         dec  si             ; decrement SI
         inc  di             ; increment DI
         loop A3             ; loop
	
C3:      xor  ax,ax          ; zero-out AX
         mov  es:[di],al     ; add null terminator to end
                             ; of RETVAL

         pop  es             ; restore
         pop  ds             ; restore

         pop  bp             ; restore

         mov  ax,DGROUP      ; get DGROUP address
         mov  ds,ax          ; assign to DS
         push ds             ; push segment address

         mov  ax,offset DGROUP:RETVAL  ; get RETVAL's offset
         push ax             ; push offset address
         call _RETC          ; Clipper's  "returner"
         pop  ax             ; restore
         pop  ds             ; restore

         ret                 ; actual ret to caller
TURN     endp                ; end of process

_prog    ends                ; end of segment
         end                 ; end of programme
;
;
