Version 1.00
BEGIN MDIForm frmMdi
	AutoRedraw   = 0
	BackColor    = QBColor(8)
	BorderStyle  = 0
	Caption      = ""
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(25)
	Left         = Char(0)
	MousePointer = 0
	Tag          = ""
	Top          = Char(0)
	Visible      = -1
	Width        = Char(80)
	BEGIN Menu mnuFile
		Caption      = "&File"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu mnuFilePrint
			Caption      = "&Print"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuFileExit
			Caption      = "E&xit"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
	END
	BEGIN Menu mnuMove
		Caption      = "&Move"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu mnuMovePosition
			Caption      = "D&ependent"
			Checked      = 0
			Enabled      = -1
			Index        = 0
			Separator    = 0
			Shortcut     = ^E
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuMovePosition
			Caption      = "&Top Left"
			Checked      = 0
			Enabled      = -1
			Index        = 1
			Separator    = 0
			Shortcut     = ^T
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuMovePosition
			Caption      = "T&op Middle"
			Checked      = 0
			Enabled      = -1
			Index        = 2
			Separator    = 0
			Shortcut     = ^O
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuMovePosition
			Caption      = "To&p Right"
			Checked      = 0
			Enabled      = -1
			Index        = 3
			Separator    = 0
			Shortcut     = ^P
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuMovePosition
			Caption      = "Bottom &Left"
			Checked      = 0
			Enabled      = -1
			Index        = 4
			Separator    = 0
			Shortcut     = ^L
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuMovePosition
			Caption      = "Bottom &Middle"
			Checked      = 0
			Enabled      = -1
			Index        = 5
			Separator    = 0
			Shortcut     = ^M
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuMovePosition
			Caption      = "Bottom &Right"
			Checked      = 0
			Enabled      = -1
			Index        = 6
			Separator    = 0
			Shortcut     = ^R
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuMoveSeparator
			Caption      = ""
			Checked      = 0
			Enabled      = -1
			Separator    = -1
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuMoveConnect
			Caption      = "&Connect to"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
			BEGIN Menu mnuMoveConnectToForm
				Caption      = "&gram <--> mole"
				Checked      = 0
				Enabled      = -1
				Index        = 0
				Separator    = 0
				Tag          = ""
				Visible      = -1
			END
			BEGIN Menu mnuMoveConnectToForm
				Caption      = "&Density"
				Checked      = 0
				Enabled      = -1
				Index        = 1
				Separator    = 0
				Tag          = ""
				Visible      = 0
			END
			BEGIN Menu mnuMoveConnectToForm
				Caption      = "M&olarity"
				Checked      = 0
				Enabled      = -1
				Index        = 2
				Separator    = 0
				Tag          = ""
				Visible      = 0
			END
			BEGIN Menu mnuMoveConnectToForm
				Caption      = "&Percent"
				Checked      = 0
				Enabled      = -1
				Index        = 3
				Separator    = 0
				Tag          = ""
				Visible      = 0
			END
			BEGIN Menu mnuMoveConnectToForm
				Caption      = "D&ilution"
				Checked      = 0
				Enabled      = -1
				Index        = 4
				Separator    = 0
				Tag          = ""
				Visible      = 0
			END
			BEGIN Menu mnuMoveConnectToForm
				Caption      = "&Titration"
				Checked      = 0
				Enabled      = -1
				Index        = 5
				Separator    = 0
				Tag          = ""
				Visible      = 0
			END
			BEGIN Menu mnuMoveConnectToForm
				Caption      = "Ga&s Change"
				Checked      = 0
				Enabled      = -1
				Index        = 6
				Separator    = 0
				Tag          = ""
				Visible      = 0
			END
			BEGIN Menu mnuMoveConnectToForm
				Caption      = "Ide&al Gas"
				Checked      = 0
				Enabled      = -1
				Index        = 7
				Separator    = 0
				Tag          = ""
				Visible      = 0
			END
			BEGIN Menu mnuMoveConnectToForm
				Caption      = "&Reactions"
				Checked      = 0
				Enabled      = -1
				Index        = 8
				Separator    = 0
				Tag          = ""
				Visible      = 0
			END
		END
		BEGIN Menu mnuMoveDisconnect
			Caption      = "&Disconnect"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Shortcut     = ^X
			Tag          = ""
			Visible      = -1
		END
	END
	BEGIN Menu mnuWindow
		Caption      = "&Window"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu mnuWindowLines
			Caption      = "More &Lines"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowSeparator
			Caption      = ""
			Checked      = 0
			Enabled      = -1
			Separator    = -1
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowForm
			Caption      = "&Molar Mass"
			Checked      = 0
			Enabled      = -1
			Index        = 0
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowForm
			Caption      = "&gram <--> mole"
			Checked      = 0
			Enabled      = -1
			Index        = 1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowForm
			Caption      = "&Density"
			Checked      = 0
			Enabled      = -1
			Index        = 2
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowForm
			Caption      = "M&olarity"
			Checked      = 0
			Enabled      = -1
			Index        = 3
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowForm
			Caption      = "&Percent"
			Checked      = 0
			Enabled      = -1
			Index        = 4
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowForm
			Caption      = "D&ilution"
			Checked      = 0
			Enabled      = -1
			Index        = 5
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowForm
			Caption      = "&Titration"
			Checked      = 0
			Enabled      = -1
			Index        = 6
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowForm
			Caption      = "Ga&s Change"
			Checked      = 0
			Enabled      = -1
			Index        = 7
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowForm
			Caption      = "Ide&al Gas"
			Checked      = 0
			Enabled      = -1
			Index        = 8
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowSep
			Caption      = ""
			Checked      = 0
			Enabled      = -1
			Separator    = -1
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuWindowReaction
			Caption      = "&Reactions"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
	END
	BEGIN Menu mnuHelp
		Caption      = "&Help"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu mnuHelpInfo
			Caption      = "&Help"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Shortcut     = {F1}
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu mnuHelpAbout
			Caption      = "&About..."
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
	END
END
' Updated:  October, 1996 by Christopher King
'
' ------------------------------------------------------------------------
'               Copyright (C) 1996 by Christopher King
'
' You have a royalty-free right to use, modify, reproduce and distribute
' the OneOhOne Files (and/or any modified version) in any way you find
' useful, provided that you agree that Christopher King has no warranty,
' obligations or liability for any OneOhOne Files.
' ------------------------------------------------------------------------
DECLARE SUB ChooseReactant ()
' Save as MDI.FRM when compile.
'$FORM frmReaction
DECLARE SUB PrintAForm3 (Src AS FORM, BYVAL nvGroup%)
DECLARE SUB PrintLabel (BYVAL svLabel AS STRING, BYVAL nvCenterAbout%, BYVAL nbCenter%)
DECLARE SUB PrintAForm2 (Src AS FORM, BYVAL nvGroup%)
DECLARE SUB PrintAForm (Src AS FORM, BYVAL nvGroup%)
'$FORM frmHelp
DECLARE SUB InfoShow (LastControl AS CONTROL, BYVAL svInfo AS STRING, BYVAL nvColor%)
'$FORM frmIdealGas
DECLARE SUB mnuWindowForm_Click (Index AS INTEGER)
DECLARE SUB DragDropPct (Source AS CONTROL, X AS SINGLE, Y AS SINGLE, BYVAL sSize AS STRING, BYVAL nvGroup%, Target AS FORM)
DECLARE SUB DragDrop4 (Source AS CONTROL, X AS SINGLE, Y AS SINGLE, BYVAL sSize AS STRING, BYVAL nvGroup%, Target AS FORM)
DECLARE SUB DragDrop3 (Source AS CONTROL, X AS SINGLE, Y AS SINGLE, BYVAL sSize AS STRING, BYVAL nvGroup%, Target AS FORM)
'$FORM frmGas
'$FORM frmTitration
'formGone'$FORM frmDilution
DECLARE SUB Disconnect (BYVAL nvIndex%)
DECLARE SUB ScreenSizeChange (BYVAL nvSize%)
'$FORM frmPercent
'formgone'$FORM frmMolarity
DECLARE SUB FormPosition (BYVAL nvGroup%, Source AS FORM)
DECLARE FUNCTION nGroupOfIndex (BYVAL Index AS INTEGER) AS INTEGER
DECLARE SUB InitialValues ()
'formGone'$FORM frmDensity
'$FORM frmAbout
'$FORM frmMolarMass
'$FORM frmGramMole
OPTION EXPLICIT
DEFINT A-Z
'$INCLUDE: 'common.bi'

CONST BRIGHT_WHITE = 15
CONST TITLEBAR_BACKCOLOR = 16
CONST YELLOW = 14
CONST MAGENTA = 5
CONST DESKTOP_PATTERN = 7               ' Desktop fill pattern (ASCII 0-255).

DEFSNG A-Z
SUB Form_Load ()
   Screen.ControlPanel(TITLEBAR_BACKCOLOR) = MAGENTA
   'Screen.ControlPanel(DESKTOP_PATTERN) = 32 ' (space)
   frmMdi.SHOW
   InitialValues
   ' Set initial form positions.
   mnuWindowForm_Click (1)  ' Loads frmGramMole
   LOAD frmMolarMass
   InfoShow Screen.ActiveControl, "  Welcome to OneOhOne!  ", YELLOW
END SUB

SUB mnuFileExit_Click ()
   END
END SUB

DEFINT A-Z
SUB mnuFilePrint_Click ()
DIM N, bFlag, nXPos, nYPos, sTemp AS STRING, nTemp
ON LOCAL ERROR GOTO DateTimePrintError

IF mnuWindowForm(0).Checked THEN
   frmMolarMass.cmdPrint.Value = -1
   IF mnuFilePrint.Tag = "1" THEN
      mnuFilePrint.Tag = ""
      EXIT SUB
   END IF
END IF
IF mnuWindowForm(1).Checked THEN
   PrintAForm frmGramMole, 1
END IF
'formGoneIF mnuWindowForm(2).Checked THEN
'formGone   PrintAForm frmDensity, 2
'formGoneEND IF
'formgoneIF mnuWindowForm(3).Checked THEN
'formgone   PrintAForm frmMolarity, 3
'formgoneEND IF
IF mnuWindowForm(4).Checked THEN
   PrintAForm frmPercent, 4
END IF
IF mnuWindowForm(5).Checked THEN
'formGone   PrintAForm2 frmDilution, 5
END IF
IF mnuWindowForm(6).Checked THEN
   PrintAForm3 frmTitration, 6
END IF
IF mnuWindowForm(7).Checked THEN
   PrintAForm2 frmGas, 7
END IF
IF mnuWindowForm(8).Checked THEN
   PrintAForm3 frmIdealGas, 8
END IF
IF mnuWindowReaction.Checked THEN
   Printer.PRINT "REACTIONS"
   FOR N = 0 TO 2                                     ' Limiting Reagent
      IF frmReaction.lblLRFlag(N).Visible THEN
         Printer.PRINT TAB(N * 19 + 1);
         Printer.PRINT "Limiting Reagent";
         bFlag = TRUE
      END IF
   NEXT N
   IF bFlag THEN Printer.PRINT   ' Go to new line if printed Limiting Reagent.

   Printer.PRINT TAB(1); frmReaction.txtLRMol(0).Text;           ' Lim. Reag. moles
   Printer.PRINT TAB(20); frmReaction.txtLRMol(1).Text;
   Printer.PRINT TAB(39); frmReaction.txtLRMol(2).Text;
   Printer.PRINT TAB(56); frmReaction.lblMolPerCoef.Caption

   FOR N = 0 TO 1
      IF gnConnected(44 - N) THEN
         sTemp = "C"
      ELSE
         sTemp = " "
      END IF
      Printer.PRINT sTemp; frmReaction.txtVariable(44 - N).Text; ' Grams needed
      IF gnConnected(50 - N) THEN
         sTemp = "C"
      ELSE
         sTemp = " "
      END IF
      Printer.PRINT TAB(18); sTemp; frmReaction.txtVariable(50 - N).Text;
      IF gnConnected(56 - N) THEN
         sTemp = "C"
      ELSE
         sTemp = " "
      END IF
      Printer.PRINT TAB(38); sTemp; frmReaction.txtVariable(56 - N).Text; TAB(56);
      SELECT CASE N
         CASE 0
            Printer.PRINT frmReaction.lblNeededG.Caption
         CASE 1
            Printer.PRINT frmReaction.lblNeededMole.Caption
      END SELECT
   NEXT N

   Printer.PRINT TAB(1); frmReaction.txtVariable(42).Text;   ' Coefficient
   Printer.PRINT TAB(6); LEFT$(frmReaction.txtCompound(0).Text, 11); ' Name
   Printer.PRINT TAB(18); "+ "; frmReaction.txtVariable(48).Text;
   Printer.PRINT TAB(25); LEFT$(frmReaction.txtCompound(1).Text, 11);
   Printer.PRINT TAB(37); "+ "; frmReaction.txtVariable(54).Text;
   Printer.PRINT TAB(45); LEFT$(frmReaction.txtCompound(2).Text, 11);
   Printer.PRINT TAB(56); "-------->"

   Printer.PRINT TAB(1); frmReaction.txtVariable(41).Text;
   Printer.PRINT TAB(20); frmReaction.txtVariable(47).Text;
   Printer.PRINT TAB(39); frmReaction.txtVariable(53).Text;
   Printer.PRINT TAB(56); "moles used"

   FOR N = 0 TO 2
      IF frmReaction.cmdMolUse(N).Tag = "1" THEN
         sTemp = "V"
      ELSE
         sTemp = "T"
      END IF
      Printer.PRINT TAB(9 + N * 19); sTemp;
   NEXT N
   Printer.PRINT

   Printer.PRINT TAB(1); frmReaction.txtVariable(40).Text;
   Printer.PRINT TAB(20); frmReaction.txtVariable(46).Text;
   Printer.PRINT TAB(39); frmReaction.txtVariable(52).Text;
   Printer.PRINT TAB(56); "mass used, g"

   Printer.PRINT TAB(1); frmReaction.txtVariable(39).Text;
   Printer.PRINT TAB(20); frmReaction.txtVariable(45).Text;
   Printer.PRINT TAB(39); frmReaction.txtVariable(51).Text;
   Printer.PRINT TAB(56); "molar mass"

   Printer.PRINT                       ' Blank line

   FOR N = 0 TO 1
      SELECT CASE N
         CASE 0
            Printer.PRINT TAB(1); frmReaction.lblTheorYieldG.Caption;
         CASE 1
            Printer.PRINT TAB(1); frmReaction.lblTheorYieldMole.Caption;
      END SELECT
      IF gnConnected(62 - N) THEN
         sTemp = "C"
      ELSE
         sTemp = " "
      END IF
      Printer.PRINT TAB(21); sTemp; frmReaction.txtVariable(62 - N).Text; ' Grams needed
      IF gnConnected(68 - N) THEN
         sTemp = "C"
      ELSE
         sTemp = " "
      END IF
      Printer.PRINT TAB(40); sTemp; frmReaction.txtVariable(68 - N).Text;
      IF gnConnected(74 - N) THEN
         sTemp = "C"
      ELSE
         sTemp = " "
      END IF
      Printer.PRINT TAB(59); sTemp; frmReaction.txtVariable(74 - N).Text; TAB(56);
   NEXT N

   Printer.PRINT TAB(22); frmReaction.txtVariable(60).Text;   ' Coefficient
   Printer.PRINT TAB(28); LEFT$(frmReaction.txtCompound(3).Text, 11); ' Name
   Printer.PRINT TAB(39); "+ "; frmReaction.txtVariable(66).Text;
   Printer.PRINT TAB(45); LEFT$(frmReaction.txtCompound(4).Text, 11);
   Printer.PRINT TAB(58); "+ "; frmReaction.txtVariable(72).Text;
   Printer.PRINT TAB(64); LEFT$(frmReaction.txtCompound(5).Text, 11)

   Printer.PRINT TAB(3); "actual yield, mol";
   Printer.PRINT TAB(22); frmReaction.txtVariable(59).Text;
   Printer.PRINT TAB(41); frmReaction.txtVariable(65).Text;
   Printer.PRINT TAB(60); frmReaction.txtVariable(71).Text

   FOR N = 3 TO 5
      IF frmReaction.cmdMolUse(N).Tag = "1" THEN
         sTemp = "V"
      ELSE
         sTemp = "T"
      END IF
      Printer.PRINT TAB(30 + (N - 3) * 19); sTemp;
   NEXT N
   Printer.PRINT

   Printer.PRINT TAB(3); "actual yield, g";
   Printer.PRINT TAB(22); frmReaction.txtVariable(58).Text;
   Printer.PRINT TAB(41); frmReaction.txtVariable(64).Text;
   Printer.PRINT TAB(60); frmReaction.txtVariable(70).Text

   Printer.PRINT TAB(10); "molar mass";
   Printer.PRINT TAB(22); frmReaction.txtVariable(57).Text;
   Printer.PRINT TAB(41); frmReaction.txtVariable(63).Text;
   Printer.PRINT TAB(60); frmReaction.txtVariable(69).Text

   Printer.PRINT TAB(13); "% yield";
   Printer.PRINT TAB(22); frmReaction.lblPctYield(0).Text;
   Printer.PRINT TAB(41); frmReaction.lblPctYield(1).Text;
   Printer.PRINT TAB(60); frmReaction.lblPctYield(2).Text

   sTemp = "Reactant"
   FOR N = 0 TO 5                                              ' Full names
      IF LEN(frmReaction.txtCompound(N).Text) > 11 THEN
         IF N > 2 THEN
            sTemp = " Product"
            nTemp = N - 2
         ELSE
            nTemp = N + 1
         END IF
         Printer.PRINT sTemp + STR$(nTemp) + ":  " + frmReaction.txtCompound(N).Text
      END IF
   NEXT N
   Printer.PRINT
END IF

' Date & Time
Printer.PRINT FORMAT$(NOW, "ddd") + ", " + FORMAT$(NOW, "mmmm d, yyyy") + "    " + FORMAT$(NOW, "h:mmA/P")
Printer.ENDDOC
EXIT SUB

DateTimePrintError:
   MSGBOX "There was a problem printing to your printer:" + CHR$(13) + """" + ERROR$(ERR) + """", 0, "Printing"
   EXIT SUB
END SUB

SUB mnuHelpAbout_Click ()
   frmAbout.SHOW 1
END SUB

'  The tag indicates which help screen to show.
SUB mnuHelpInfo_Click ()

DIM nGroup
IF Screen.ActiveForm.Caption = "Molar Mass" THEN
   mnuHelpInfo.Tag = "1"                       ' Molar Mass
ELSEIF Screen.ActiveForm.Caption = "Custom Element" THEN
   EXIT SUB    ' Can't show help while modal form showing.
ELSEIF Screen.ActiveForm.Caption = "Gas Variables" THEN
   EXIT SUB                                     ' Gas Variables
ELSEIF Screen.ActiveForm.Tag = "Choose" THEN
   EXIT SUB                                     ' Choose
ELSE
   mnuHelpInfo.Tag = "5"                        ' MDI form
END IF
frmHelp.SHOW
END SUB

SUB mnuMolarmass_Click ()
frmMolarMass.SHOW
IF frmMolarMass.WindowState = 1 THEN frmMolarMass.WindowState = 0
END SUB

' Connects dependent variable on source to
' independent variable on target.
SUB mnuMoveConnectToForm_Click (Index AS INTEGER)
DIM nSourceIndex, sTag AS STRING
DIM nIndex, nGroup
IF Screen.ActiveForm.Caption = "Molar Mass" THEN
   sTag = "The molar mass module cannot connect to other modules."
   MSGBOX sTag, 0, "Connecting Modules"
ELSEIF NOT Screen.ActiveForm.Caption = "Help" THEN
   IF TYPEOF Screen.ActiveControl IS TextBox THEN

      ' Get source's group and dependent variable.
      nIndex = VAL(Screen.ActiveForm.Tag) ' Last variable to have focus on form.
      nGroup = nGroupOfIndex(nIndex)
      ' Don't attempt to connect form to itself.
      IF nGroup - 1 = Index THEN
         sTag = "A module cannot be connected to itself."
         MSGBOX sTag, 0, "Connecting Modules"
         EXIT SUB
      END IF

      IF Screen.ActiveForm.Caption = "Reactions" THEN
         IF (nIndex - 43) MOD 6 = 0 OR (nIndex - 43) MOD 6 = 1 THEN
            gOccupantIndex(nGroup, 0) = nIndex
         END IF
      END IF
      nSourceIndex = gOccupantIndex(nGroup, 0)  ' Dependent variable.

      ' Compose the tag for the label.
      sTag = FORMAT$(nSourceIndex, "0#") + FORMAT$(nGroup, "0#") + Screen.ActiveForm.txtVariable(nSourceIndex).Tag
      Screen.ActiveForm.lblDragDrop.Tag = sTag
      SELECT CASE Index
         CASE 0
            DragDrop3 Screen.ActiveForm.lblDragDrop, 0, 0, frmGramMole.cmdSize.Tag, 1, frmGramMole
            IF frmGramMole.WindowState = 1 THEN frmGramMole.WindowState = 0
         CASE 1
    'formGone        DragDrop3 Screen.ActiveForm.lblDragDrop, 0, 0, frmDensity.cmdSize.Tag, 2, frmDensity
    'formGone        IF frmDensity.WindowState = 1 THEN frmDensity.WindowState = 0
         CASE 2
     'formgone       DragDrop3 Screen.ActiveForm.lblDragDrop, 0, 0, frmMolarity.cmdSize.Tag, 3, frmMolarity
     'formgone       IF frmMolarity.WindowState = 1 THEN frmMolarity.WindowState = 0
         CASE 3
            DragDropPct Screen.ActiveForm.lblDragDrop, 0, 0, frmPercent.cmdSize.Tag, 4, frmPercent
            IF frmPercent.WindowState = 1 THEN frmPercent.WindowState = 0
         CASE 4
     'formGone       DragDrop4 Screen.ActiveForm.lblDragDrop, 0, 0, frmDilution.cmdSize.Tag, 5, frmDilution
     'formGone       IF frmDilution.WindowState = 1 THEN frmDilution.WindowState = 0
         CASE 5
            DragDrop4 Screen.ActiveForm.lblDragDrop, 0, 0, frmTitration.cmdSize.Tag, 6, frmTitration
            IF frmTitration.WindowState = 1 THEN frmTitration.WindowState = 0
         CASE 6
            DragDrop4 Screen.ActiveForm.lblDragDrop, 0, 0, frmGas.cmdSize.Tag, 7, frmGas
            IF frmGas.WindowState = 1 THEN frmGas.WindowState = 0
         CASE 7
            DragDrop4 Screen.ActiveForm.lblDragDrop, 0, 0, frmIdealGas.cmdSize.Tag, 8, frmIdealGas
            IF frmIdealGas.WindowState = 1 THEN frmIdealGas.WindowState = 0
         CASE 8
            IF frmReaction.WindowState = 1 THEN frmReaction.WindowState = 0
            ChooseReactant
            IF gnUserChoice = 0 THEN
               EXIT SUB
            ELSE
               nGroup = gnUserChoice + 8
            END IF
            DragDrop4 Screen.ActiveForm.lblDragDrop, 0, 0, "2", nGroup, frmReaction
      END SELECT
   END IF
END IF
END SUB

' Menu item that allows the user to disconnect a variable.
' Enabled by mnuMove_Click if the formula is valid.
'
SUB mnuMoveDisconnect_Click ()
DIM nIndex, nGroup
' This command is always visible on the move menu so that it will always
' be available.
IF NOT Screen.ActiveForm.Caption = "Molar Mass" THEN
   IF TYPEOF Screen.ActiveControl IS TextBox THEN
      ' Last variable to have focus on form.
      nIndex = VAL(Screen.ActiveForm.Tag)
      nGroup = nGroupOfIndex(nIndex)
      IF gnConnected(nIndex) THEN
         ' Pass the independent variable end of the connection to sub Disconnect.
         IF gOccupantIndex(nGroup, 0) = nIndex THEN
            nIndex = gnConnected(nIndex)
         END IF
         Disconnect nIndex
      END IF
   END IF
END IF

END SUB

SUB mnuMovePosition_Click (Index AS INTEGER)
DIM nIndex, nGroup
ON LOCAL ERROR GOTO RearrangeFormulaError
IF Screen.ActiveForm.cmdSize.Tag = "2" THEN
   ' Form is correct size for moving position.

   ' Last variable to have focus on form is to be moved.
   nIndex = VAL(Screen.ActiveForm.Tag)
   nGroup = nGroupOfIndex(nIndex)

   ' Can't directly call a procedure on a different form.  However,
   ' changing the caption of a label on a different form causes the
   ' "change" event to occur, even when the label is not visible.
   Screen.ActiveForm.lblDragDrop.Caption = "M" + FORMAT$(Index)
END IF
EXIT SUB

RearrangeFormulaError:
   ' This handles user pressing ctrl-t (or opelmr) on a form without cmd.Size.
   IF ERR <> 422 THEN BEEP    ' 422 = Property not found.
   EXIT SUB
EXIT SUB

END SUB

SUB mnuWindowForm_Click (Index AS INTEGER)
DIM N
SELECT CASE Index
   CASE 0
      frmMolarMass.SHOW
      IF frmMolarMass.WindowState = 1 THEN frmMolarMass.WindowState = 0
   CASE 1
      ' Don't reset the initial position of the form if it is visible.
      IF NOT frmGramMole.Visible THEN FormPosition 1, frmGramMole
      frmGramMole.SHOW
      IF frmGramMole.WindowState = 1 THEN frmGramMole.WindowState = 0
   CASE 2
'formGone      IF NOT frmDensity.Visible THEN FormPosition 2, frmDensity
'formGone      frmDensity.SHOW
'formGone      IF frmDensity.WindowState = 1 THEN frmDensity.WindowState = 0
   CASE 3
'formgone      IF NOT frmMolarity.Visible THEN FormPosition 3, frmMolarity
'formgone      frmMolarity.SHOW
'formgone      IF frmMolarity.WindowState = 1 THEN frmMolarity.WindowState = 0
   CASE 4
      IF NOT frmPercent.Visible THEN FormPosition 4, frmPercent
      frmPercent.SHOW
      IF frmPercent.WindowState = 1 THEN frmPercent.WindowState = 0
   CASE 5
'formGone      IF NOT frmDilution.Visible THEN FormPosition 5, frmDilution
'formGone      frmDilution.SHOW
'formGone      IF frmDilution.WindowState = 1 THEN frmDilution.WindowState = 0
   CASE 6
      IF NOT frmTitration.Visible THEN FormPosition 6, frmTitration
      frmTitration.SHOW
      IF frmTitration.WindowState = 1 THEN frmTitration.WindowState = 0
      ' Don't allow the bottom to be off screen.
      IF frmTitration.Height + frmTitration.Top > Screen.Height - 1 THEN
         frmTitration.Top = Screen.Height - frmTitration.Height - 2
      END IF
   CASE 7
      IF NOT frmGas.Visible THEN FormPosition 7, frmGas
      frmGas.SHOW
      IF frmGas.WindowState = 1 THEN frmGas.WindowState = 0
   CASE 8
      IF NOT frmIdealGas.Visible THEN FormPosition 8, frmIdealGas
      frmIdealGas.SHOW
      IF NOT mnuMoveConnectToForm(Index - 1).Enabled THEN
         InfoShow Screen.ActiveControl, "C and F are converted internally to K, matching the units of R.", BRIGHT_WHITE
      END IF
      IF frmIdealGas.WindowState = 1 THEN frmIdealGas.WindowState = 0
END SELECT

' Enable the "move" menu items.
IF Index THEN  ' Skips index = 0, molar mass.
   mnuMoveConnectToForm(Index - 1).Visible = TRUE
   IF NOT mnuMoveConnect.Enabled THEN
      ' One other menu item is visible and shouldn't be, unless it's this one.
      mnuMoveConnect.Enabled = TRUE
      mnuMoveDisconnect.Enabled = TRUE
      FOR N = 0 TO 8
         IF N <> (Index - 1) THEN
            IF mnuMoveConnectToForm(N).Visible THEN
               mnuMoveConnectToForm(N).Visible = FALSE
            END IF
         END IF
      NEXT N
   END IF
END IF
END SUB

SUB mnuWindowLines_Click ()
' Hiding and reshowing frmMdi causes the form with the focus to change.
' Since the previous form isn't redrawn completely, the focus needs to
' be set back to the original form.

DIM sCaption AS STRING, nOriginalFocus
   ' Find form with focus initially.
   sCaption = Screen.ActiveForm.Caption
   IF sCaption = "" THEN
      nOriginalFocus = -1   ' frmMdi has the focus.
   ELSEIF sCaption = "Molar Mass" THEN
      nOriginalFocus = 0
   ELSEIF sCaption = "Reactions" THEN
      nOriginalFocus = 9
   ELSE
      nOriginalFocus = nGroupOfIndex(VAL(Screen.ActiveForm.Tag))
   END IF

   IF mnuWindowForm(0).Checked THEN
      frmMolarMass.cmdMore.Value = TRUE
   ELSEIF mnuWindowLines.Caption = "More &Lines" THEN
      frmMdi.HIDE ' Which hides all forms on it.
      ON LOCAL ERROR GOTO ManyLinesError
      WIDTH 80, 43
      ON LOCAL ERROR GOTO 0
      mnuWindowLines.Caption = "Fewer &Lines"
      ScreenSizeChange 1   ' Changes sizes of "visible" forms.
      frmMdi.SHOW
   ELSEIF mnuWindowLines.Caption = "Fewer &Lines" THEN
      frmMdi.HIDE ' Width requires no forms be visible.
      WIDTH 80, 25
      mnuWindowLines.Caption = "More &Lines"
      ScreenSizeChange 0   ' Changes sizes of "visible" forms.
      frmMdi.SHOW
   END IF

   ' Return focus to form which had it initially.
   SELECT CASE nOriginalFocus
      CASE -1
      CASE 0
         frmMolarMass.SETFOCUS
      CASE 1
         frmGramMole.SETFOCUS
      CASE 2
'formGone         frmDensity.SETFOCUS
      CASE 3
'formgone         frmMolarity.SETFOCUS
      CASE 4
         frmPercent.SETFOCUS
      CASE 5
'formGone         frmDilution.SETFOCUS
      CASE 6
         frmTitration.SETFOCUS
      CASE 7
         frmGas.SETFOCUS
      CASE 8
         frmIdealGas.SETFOCUS
      CASE 9
         frmReaction.SETFOCUS
   END SELECT
   EXIT SUB

ManyLinesError:
   WIDTH 80, 25
   mnuWindowLines.Visible = FALSE
   mnuWindowSeparator.Visible = FALSE
   frmMdi.SHOW
   MSGBOX "Your computer does not support 43 lines on the screen.", 0, "More Button"
   EXIT SUB

END SUB

SUB mnuWindowReaction_Click ()
   DIM N
   frmReaction.SHOW
   IF frmReaction.WindowState = 1 THEN frmReaction.WindowState = 0
   mnuMoveConnectToForm(8).Visible = TRUE
   IF NOT mnuMoveConnect.Enabled THEN
      ' One other menu item is visible and shouldn't be, unless it's this one.
      mnuMoveConnect.Enabled = TRUE
      mnuMoveDisconnect.Enabled = TRUE
      FOR N = 0 TO 7
         IF mnuMoveConnectToForm(N).Visible THEN
            mnuMoveConnectToForm(N).Visible = FALSE
         END IF
      NEXT N
   END IF
END SUB

SUB PrintAForm (Src AS FORM, BYVAL nvGroup)
DIM nIndex0, nIndex1, nIndex2, nIndex4
DIM sLabel AS STRING, nAndLoc

IF gbBadFormula(nvGroup) THEN EXIT SUB
nIndex0 = gOccupantIndex(nvGroup, 0)
IF gdNumber(nIndex0) = 0 THEN EXIT SUB
nIndex1 = gOccupantIndex(nvGroup, 1)
nIndex2 = gOccupantIndex(nvGroup, 2)
nIndex4 = gOccupantIndex(nvGroup, 4)

Printer.PRINT Src.Caption

IF nIndex4 = -1 THEN
   Printer.PRINT Src.txtVariable(nIndex0).Text; TAB(20);
   PrintLabel Src.lblVariable(nIndex0).Caption, 0, 0
   Printer.PRINT TAB(26); "= ";
END IF
IF nIndex1 > -1 THEN
   Printer.PRINT TAB(28); Src.txtVariable(nIndex1).Text; TAB(47);
   PrintLabel Src.lblVariable(nIndex1).Caption, 0, 0
END IF
IF nIndex2 > -1 THEN
   Printer.PRINT TAB(52); "X"; Src.txtVariable(nIndex2).Text; TAB(72);
   PrintLabel Src.lblVariable(nIndex2).Caption, 0, 0
END IF
Printer.PRINT

IF nIndex4 > -1 THEN
   Printer.PRINT Src.txtVariable(nIndex0).Text; TAB(20);
   PrintLabel Src.lblVariable(nIndex0).Caption, 0, 0
   Printer.PRINT TAB(26); "= ";
   Printer.PRINT "------------------------"
   Printer.PRINT TAB(28); Src.txtVariable(nIndex4).Text; TAB(47);
   PrintLabel Src.lblVariable(nIndex4).Caption, 0, 0
END IF
Printer.PRINT
Printer.PRINT
END SUB

SUB PrintAForm2 (Src AS FORM, BYVAL nvGroup)
DIM nIndex0, nIndex1, nIndex2, nIndex4, nIndex5
DIM sLabel AS STRING, nAndLoc, nNextTab

IF gbBadFormula(nvGroup) THEN EXIT SUB
nIndex0 = gOccupantIndex(nvGroup, 0)
IF gdNumber(nIndex0) = 0 THEN EXIT SUB
nIndex1 = gOccupantIndex(nvGroup, 1)
nIndex2 = gOccupantIndex(nvGroup, 2)
nIndex4 = gOccupantIndex(nvGroup, 4)

Printer.PRINT Src.Caption

PrintLabel Src.lblVariable(nIndex1).Caption, 33, TRUE
PrintLabel Src.lblVariable(nIndex2).Caption, 55, TRUE
Printer.PRINT
PrintLabel Src.lblVariable(nIndex0).Caption, 11, TRUE
Printer.PRINT TAB(24); Src.txtVariable(nIndex1).Text;
Printer.PRINT TAB(43); " X "; Src.txtVariable(nIndex2).Text

Printer.PRINT " "; Src.txtVariable(nIndex0).Text;
Printer.PRINT TAB(22); "= -----------------------------------------"
IF nIndex4 > -1 THEN
   Printer.PRINT TAB(24); Src.txtVariable(nIndex4).Text
   PrintLabel Src.lblVariable(nIndex4).Caption, 33, TRUE
ELSE
   nIndex5 = gOccupantIndex(nvGroup, 5)
   Printer.PRINT TAB(46); Src.txtVariable(nIndex5).Text
   PrintLabel Src.lblVariable(nIndex5).Caption, 55, TRUE
END IF
Printer.PRINT
IF nvGroup = 5 THEN
   IF Src.cmdSize.Tag = "1" THEN
      Printer.PRINT TAB(8); "Volume Units:  "; Src.cboVolumeUnit.Text;
   END IF
   Printer.PRINT TAB(28); "moles in vessel:  "; Src.lblMoles.Caption
ELSEIF nvGroup = 7 THEN
   nNextTab = 16
   IF Src.cboVolumeUnit.Visible THEN
      Printer.PRINT TAB(nNextTab); "volume Units:  "; Src.cboVolumeUnit.Text;
      nNextTab = 43
   END IF
   IF Src.cboPressureUnit.Visible THEN
      Printer.PRINT TAB(nNextTab); "pressure Units:  "; Src.cboPressureUnit.Text;
      nNextTab = 43
   END IF
   IF Src.cboTempUnit.Visible THEN
      Printer.PRINT TAB(nNextTab); "temperature Units:  "; Src.cboTempUnit.Text;
   END IF
   Printer.PRINT
END IF
Printer.PRINT
END SUB

SUB PrintAForm3 (Src AS FORM, BYVAL nvGroup)
DIM nIndex0, nIndex1, nIndex2, nIndex3, nIndex4, nIndex5, nIndex6
DIM sLabel AS STRING, nAndLoc
DIM nTab1, nTab2, nTab3, nOffset
DIM sDash3 AS STRING, sSpace AS STRING

IF gbBadFormula(nvGroup) THEN EXIT SUB
nIndex0 = gOccupantIndex(nvGroup, 0)
IF gdNumber(nIndex0) = 0 THEN EXIT SUB
nIndex1 = gOccupantIndex(nvGroup, 1)
nIndex2 = gOccupantIndex(nvGroup, 2)
nIndex3 = gOccupantIndex(nvGroup, 3)
nIndex4 = gOccupantIndex(nvGroup, 4)
nIndex5 = gOccupantIndex(nvGroup, 5)
nIndex6 = gOccupantIndex(nvGroup, 6)

Printer.PRINT Src.Caption
IF nvGroup = 8 THEN
   nTab1 = 21
   nTab2 = 41
   nTab3 = 61
   nOffset = -7
   sDash3 = "----"
ELSE
   nTab1 = 24
   nTab2 = 46
   nTab3 = 68
   nOffset = -8
   sSpace = " "
END IF

PrintLabel Src.lblVariable(nIndex1).Caption, nTab1 - nOffset, TRUE
PrintLabel Src.lblVariable(nIndex2).Caption, nTab2 - nOffset, TRUE
IF nIndex3 > -1 THEN
   PrintLabel Src.lblVariable(nIndex3).Caption, nTab3 - nOffset + 5 * (nvGroup = 6), TRUE
END IF
Printer.PRINT

PrintLabel Src.lblVariable(nIndex0).Caption, 8 - 2 * (nvGroup = 6), TRUE
Printer.PRINT TAB(nTab1); Src.txtVariable(nIndex1).Text;
Printer.PRINT TAB(nTab2 - 2); "X "; Src.txtVariable(nIndex2).Text;
IF nIndex3 > -1 THEN
   Printer.PRINT TAB(nTab3 - 2); "X "; Src.txtVariable(nIndex3).Text
ELSE
   Printer.PRINT
END IF

Printer.PRINT sSpace; Src.txtVariable(nIndex0).Text;
Printer.PRINT TAB(nTab1 - 2); "= -----------------------------------------------------"; sDash3;
IF nIndex4 > -1 THEN
   Printer.PRINT TAB(nTab1); Src.txtVariable(nIndex4).Text;
END IF
IF nvGroup = 8 THEN
   IF Src.lblXB1.Visible THEN
      Printer.PRINT TAB(nTab2 - 3); " X ";
   END IF
END IF
IF nIndex5 > -1 THEN
   Printer.PRINT TAB(nTab2); Src.txtVariable(nIndex5).Text;
END IF
IF nIndex6 > -1 THEN
   Printer.PRINT TAB(nTab3); Src.txtVariable(nIndex6).Text;
END IF
Printer.PRINT

IF nIndex4 > -1 THEN
   PrintLabel Src.lblVariable(nIndex4).Caption, nTab1 - nOffset, TRUE
END IF
IF nIndex5 > -1 THEN
   PrintLabel Src.lblVariable(nIndex5).Caption, nTab2 - nOffset, TRUE
END IF
IF nIndex6 > -1 THEN
   PrintLabel Src.lblVariable(nIndex6).Caption, nTab3 - nOffset + 5 * (nvGroup = 6), TRUE
END IF
IF nvGroup = 6 THEN
   Printer.PRINT
   IF Src.cmdSize.Tag = "1" THEN
      Printer.PRINT TAB(8); "Volume Units:  "; Src.cboVolumeUnit.Text;
   END IF
   PrintLabel Src.lblVariable(24).Caption, 15, TRUE
   Printer.PRINT "  "; Src.txtVariable(24).Text;
   Printer.PRINT TAB(44); Src.lblVariable(25).Caption; "  "; Src.txtVariable(25).Text
   Printer.PRINT "coefficients:  ";
   Printer.PRINT Src.txtCoLb2(0).Text;
   Printer.PRINT TAB(32); Src.txtCoLb2(1).Text;
   Printer.PRINT TAB(48); Src.txtCoLb2(2).Text;
   Printer.PRINT TAB(64); Src.txtCoLb2(3).Text
   Printer.PRINT "compound 2:    ";
   Printer.PRINT Src.txtCoef2(0).Text;
   Printer.PRINT TAB(32); Src.txtCoef2(1).Text;
   Printer.PRINT TAB(48); Src.txtCoef2(2).Text;
   Printer.PRINT TAB(64); Src.txtCoef2(3).Text
       sDash3 = "-------------"
   Printer.PRINT "------------"; " = "; sDash3; " X "; sDash3; " X "; sDash3; " X "; sDash3
   Printer.PRINT "compound 1:    ";
   Printer.PRINT Src.txtCoef1(0).Text;
   Printer.PRINT TAB(32); Src.txtCoef1(1).Text;
   Printer.PRINT TAB(48); Src.txtCoef1(2).Text;
   Printer.PRINT TAB(64); Src.txtCoef1(3).Text
   Printer.PRINT TAB(16); Src.txtCoLb1.Text;
   Printer.PRINT TAB(32); Src.lblCoefLbl1(0).Caption;
   Printer.PRINT TAB(48); Src.lblCoefLbl1(1).Caption;
   Printer.PRINT TAB(64); Src.lblCoefLbl1(2).Caption;
END IF
Printer.PRINT
Printer.PRINT
END SUB

SUB PrintLabel (BYVAL svLabel AS STRING, BYVAL nvCenterAbout, BYVAL nbCenter)
DIM sTemp AS STRING, nAndLoc
   nAndLoc = INSTR(svLabel, "&")
   IF nAndLoc = 0 THEN
      sTemp = svLabel
   ELSE
      sTemp = LEFT$(svLabel, nAndLoc - 1) + MID$(svLabel, nAndLoc + 1)
   END IF
   IF nbCenter = TRUE THEN
      Printer.PRINT TAB(nvCenterAbout - LEN(sTemp) \ 2);
   END IF
   Printer.PRINT sTemp;

END SUB

