#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

/* Returns the cdrom drive letter on your system     */
/* It uses calls to MSCDEX to determine drive letter */

char *findcdrom()
{
       union  REGS      inregs;
       union  REGS      outregs;
       static char	buf[3];

       inregs.x.ax = 0x1500;   /* Get Number of CDROM drive letters    */
       inregs.x.bx = 0;        /* Init to zero                         */

       int86(0x2f, &inregs, &outregs);

       /* If no CDROM drives are found or MSCDEX not present return */
       /* error messages                                            */

       if (outregs.x.bx == 0)
       {
	       printf ("No cdrom drive found\n");
	       printf ("Use set CDROM=q: to assign drive letter anyway \n");
	       exit (1);
       }

       /* If you have more than one drive use environment variable CDROM */
       /* for the drive to use						 */

       if (outregs.x.bx > 1)
       {
		printf ("You have more than 1 cdrom drive in your system\n");
		printf ("Use set CDROM=q: to the drive letter you want to use\n");
		exit (1);
       }

       buf[0] = 'a' + outregs.x.cx;
       buf[1] = ':';
       buf[2] = '\0';

       return buf;
}

char	*cdrom()

{
	static char buf[BUFSIZ];

	if (getenv("CDROM") != NULL)
	{
		/* If CDROM found in environment use this */
		strcpy (buf,getenv("CDROM"));
	}
	else
	{
		/* Try to find the cdrom drive letter */
		strcpy (buf,findcdrom());
	}

	return buf;
}




