{                                                                             }
{                                                                             }
{    Program     LABELER                                                      }
{                                                                             }
{    Author      Ken Buetow             CIS [71001,613]                       }
{                Guardian Software                                            }
{                26 Rose Street                                               }
{                Baltic, Ct  06330-1028                                       }
{                                                                             }
{    Phone       (203) 822-9212 [Voice]                                       }
{                                                                             }
{    Date        February 1, 1986       Last revised  July 20, 1989           }
{                                                                             }
{    Language    TURBO Pascal version 5                                       }
{                                                                             }
{    Remarks                                                                  }
{                                                                             }
{                Utility to print disk labels on standard size                }
{                one-up labels.                                               }
{                                                                             }
{                Portions (c) Borland International                           }

{$V-}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}

program labeler;


Uses
  Crt,
  Dos;

const
  version   = '4.20';
  double    = '';
  single    = '';
  long      = '----------------------------------------------------------------';
  max_files = 4096;
  init_str     :string = ^N^R^T^['F'^['H'^['T'^['9'^['2';
  line_spacing :string = #27'3'#18;
  sub_on       :string = #27'S'#0;
  sub_off      :string = #27'T';
  emp_on       :string = #27'E';
  emp_off      :string = #27'F';
  dbl_on       :string = #14;
  dbl_off      :string = #20;
  cond_on      :string = #15;
  cond_off     :string = #18;
  dbl_st_on    :string = #27'G';
  dbl_st_off   :string = #27'H';

  type_over : boolean = true;
  registered: boolean = false;
  labels = 10;

type
  str_10 = string[10];
  str_12 = string[13];
  str_45 = string[65];
  cmt_ptr= ^str_45;
  fs_ptr = ^str_12;

var
  test:integer;
  lst,
  cnf_file  :text;
  key       :char;
  reg       :registers;
  max_drive,
  drive,
  curr_dr   :byte;
  d_size,
  used,
  free      :LongInt;
  copies,
  i,j,k,x,y,
  count,
  start,
  printer,
  num_files :integer;
  temp_str,
  disk_name,
  library,
  line,
  mask_fs   :string[255];
  mask_file :text;
  temp,
  spaces,
  blank_fs  :str_12;
  blank_cmt :str_45;
  temp_fs   :fs_ptr;
  temp_cmt  :cmt_ptr;
  filespec  :array[1..max_files] of record
                                      name:fs_ptr;
                                      cmt:cmt_ptr
                                    end;
  cont,
  again,
  abort,
  blank     :boolean;
  s_rec     :SearchRec;
  size,
  sizes     :byte;
  tcols     :integer;
  label_size:array[0..labels] of string;
  wrap      :array[0..labels] of boolean;
  cols      :array[0..labels] of integer;
  rows      :array[0..labels] of integer;
  filler    :array[0..labels] of integer;
  feeds     :array[0..labels] of integer;
  dbl       :array[0..labels] of boolean;
  width     :array[0..labels] of integer;
  path      :string;


function value(s:string):integer;
var i,c:integer;
begin
  val(s,i,c);
  value := i
end;

function parse(s:string):string;
var st:string;
begin
  st := '';
  while s[1] in ['0'..'9'] do
    begin
      st := st + chr(value(copy(s,1,pos(' ',s)-1)));
      s := copy(s,pos(' ',s)+1,255)
    end;
  parse := st
end;


function Flop(c:char):string;
begin
  case ord(c) of
      0: flop := #27#76#9#0#0#0#0#0#0#0#0#0#0;
      1: flop := #27#76#9#0#60#66#149#177#177#149#66#60#0;
      2: flop := #27#76#9#0#60#126#235#207#207#235#126#60#0;
      3: flop := #27#76#9#0#0#14#31#62#124#62#31#14#0;
      4: flop := #27#76#9#0#0#8#28#62#127#62#28#8#0;
      5: flop := #27#76#9#0#28#28#74#127#127#74#28#28#0;
      6: flop := #27#76#9#0#8#28#94#127#127#94#28#8#0;
      7: flop := #27#76#9#0#0#0#60#60#60#60#0#0#0;
      8: flop := #27#76#9#0#255#255#195#195#195#195#255#255#0;
      9: flop := #27#76#9#0#0#126#66#66#66#66#126#0#0;
     10: flop := #27#76#9#0#255#129#189#189#189#189#129#255#0;
     11: flop := #27#76#9#0#15#7#127#249#136#136#248#112#0;
     12: flop := #27#76#9#0#0#0#78#95#241#241#95#78#0;
     13: flop := #27#76#9#0#7#7#5#5#127#254#224#192#0;
     14: flop := #27#76#9#0#63#127#101#5#5#127#254#192#0;
     15: flop := #27#76#9#0#219#219#60#231#231#60#219#219#0;
     16: flop := #27#76#9#0#0#8#8#28#62#62#127#127#0;
     17: flop := #27#76#9#0#0#127#127#62#62#28#8#8#0;
     18: flop := #27#76#9#0#0#0#36#102#255#255#102#36#0;
     19: flop := #27#76#9#0#0#0#95#95#0#95#95#0#0;
     20: flop := #27#76#9#0#127#127#1#127#127#17#31#14#0;
     21: flop := #27#76#9#0#0#88#253#165#165#191#26#0#0;
     22: flop := #27#76#9#0#0#112#112#112#112#112#112#112#0;
     23: flop := #27#76#9#0#0#148#182#255#255#182#148#0#0;
     24: flop := #27#76#9#0#0#0#4#6#127#127#6#4#0;
     25: flop := #27#76#9#0#0#0#16#48#127#127#48#16#0;
     26: flop := #27#76#9#0#0#8#28#62#8#8#8#8#0;
     27: flop := #27#76#9#0#0#8#8#8#8#62#28#8#0;
     28: flop := #27#76#9#0#0#16#16#16#16#16#28#28#0;
     29: flop := #27#76#9#0#8#28#42#8#8#42#28#8#0;
     30: flop := #27#76#9#0#0#48#56#60#62#60#56#48#0;
     31: flop := #27#76#9#0#0#6#14#30#62#30#14#6#0;
     32: flop := #27#76#9#0#0#0#0#0#0#0#0#0#0;
     33: flop := #27#76#9#0#0#0#0#95#95#0#0#0#0;
     34: flop := #27#76#9#0#0#0#7#7#0#0#7#7#0;
     35: flop := #27#76#9#0#0#21#63#126#85#63#126#84#0;
     36: flop := #27#76#9#0#0#18#58#43#107#106#46#36#0;
     37: flop := #27#76#9#0#0#99#102#12#24#48#99#67#0;
     38: flop := #27#76#9#0#0#80#114#55#93#79#122#48#0;
     39: flop := #27#76#9#0#0#0#0#0#3#7#4#0#0;
     40: flop := #27#76#9#0#0#0#65#99#62#28#0#0#0;
     41: flop := #27#76#9#0#0#0#28#62#99#65#0#0#0;
     42: flop := #27#76#9#0#0#8#42#62#28#62#42#8#0;
     43: flop := #27#76#9#0#0#8#8#62#62#8#8#0#0;
     44: flop := #27#76#9#0#0#0#0#96#224#128#0#0#0;
     45: flop := #27#76#9#0#0#8#8#8#8#8#8#0#0;
     46: flop := #27#76#9#0#0#0#0#96#96#0#0#0#0;
     47: flop := #27#76#9#0#0#3#6#12#24#48#96#64#0;
     48: flop := #27#76#9#0#0#62#127#71#77#89#127#62#0;
     49: flop := #27#76#9#0#0#64#64#127#127#66#64#0#0;
     50: flop := #27#76#9#0#0#102#111#73#89#81#115#98#0;
     51: flop := #27#76#9#0#0#54#127#73#73#65#99#34#0;
     52: flop := #27#76#9#0#0#16#127#127#19#22#28#24#0;
     53: flop := #27#76#9#0#0#57#125#69#69#69#103#39#0;
     54: flop := #27#76#9#0#0#48#121#73#73#75#126#60#0;
     55: flop := #27#76#9#0#0#3#7#13#121#113#3#3#0;
     56: flop := #27#76#9#0#0#54#127#73#73#73#127#54#0;
     57: flop := #27#76#9#0#0#30#63#105#73#73#79#6#0;
     58: flop := #27#76#9#0#0#0#0#102#102#0#0#0#0;
     59: flop := #27#76#9#0#0#0#0#102#230#128#0#0#0;
     60: flop := #27#76#9#0#0#0#65#99#54#28#8#0#0;
     61: flop := #27#76#9#0#0#36#36#36#36#36#36#0#0;
     62: flop := #27#76#9#0#0#8#28#54#99#65#0#0#0;
     63: flop := #27#76#9#0#0#6#15#89#81#3#2#0#0;
     64: flop := #27#76#9#0#0#30#95#93#93#65#127#62#0;
     65: flop := #27#76#9#0#0#124#126#19#17#19#126#124#0;
     66: flop := #27#76#9#0#0#54#127#107#73#127#127#65#0;
     67: flop := #27#76#9#0#0#99#65#65#65#99#62#28#0;
     68: flop := #27#76#9#0#0#62#62#99#65#127#127#65#0;
     69: flop := #27#76#9#0#0#99#65#73#73#127#127#65#0;
     70: flop := #27#76#9#0#0#3#1#9#73#127#127#65#0;
     71: flop := #27#76#9#0#0#115#113#81#65#99#62#28#0;
     72: flop := #27#76#9#0#0#127#127#8#8#8#127#127#0;
     73: flop := #27#76#9#0#0#0#65#127#127#65#0#0#0;
     74: flop := #27#76#9#0#0#1#63#127#65#64#96#32#0;
     75: flop := #27#76#9#0#0#67#103#60#24#127#127#65#0;
     76: flop := #27#76#9#0#0#96#96#64#65#127#127#65#0;
     77: flop := #27#76#9#0#0#127#127#6#12#6#127#127#0;
     78: flop := #27#76#9#0#0#127#127#56#4#127#127#0;
     79: flop := #27#76#9#0#0#62#127#65#65#65#127#62#0;
     80: flop := #27#76#9#0#0#6#15#9#9#127#127#65#0;
     81: flop := #27#76#9#0#0#94#127#49#57#33#63#30#0;
     82: flop := #27#76#9#0#0#70#111#57#25#127#127#65#0;
     83: flop := #27#76#9#0#0#50#115#89#73#77#103#38#0;
     84: flop := #27#76#9#0#0#3#65#127#127#65#3#0#0;
     85: flop := #27#76#9#0#0#63#127#64#64#127#63#0#0;
     86: flop := #27#76#9#0#0#31#63#96#96#63#31#0#0;
     87: flop := #27#76#9#0#0#127#127#48#56#48#127#127#0;
     88: flop := #27#76#9#0#0#97#115#30#12#30#115#97#0;
     89: flop := #27#76#9#0#0#7#79#120#120#79#7#0#0;
     90: flop := #27#76#9#0#0#97#99#71#77#89#115#99#0;
     91: flop := #27#76#9#0#0#0#65#65#127#127#0#0#0;
     92: flop := #27#76#9#0#0#64#96#48#24#12#6#3#0;
     93: flop := #27#76#9#0#0#0#127#127#65#65#0#0#0;
     94: flop := #27#76#9#0#0#4#6#3#3#6#4#0#0;
     95: flop := #27#76#9#0#128#128#128#128#128#128#128#128#0;
     96: flop := #27#76#9#0#0#0#4#7#3#0#0#0#0;
     97: flop := #27#76#9#0#0#64#120#60#84#84#112#32#0;
     98: flop := #27#76#9#0#0#48#120#72#72#63#127#64#0;
     99: flop := #27#76#9#0#0#0#108#68#68#68#124#56#0;
    100: flop := #27#76#9#0#0#64#127#63#72#72#120#48#0;
    101: flop := #27#76#9#0#0#0#88#92#84#84#124#56#0;
    102: flop := #27#76#9#0#0#0#2#11#9#127#126#72#0;
    103: flop := #27#76#9#0#0#4#252#248#164#164#188#24#0;
    104: flop := #27#76#9#0#0#112#120#8#8#127#127#1#0;
    105: flop := #27#76#9#0#0#0#0#64#125#125#4#0#0;
    106: flop := #27#76#9#0#0#0#125#253#132#128#224#96#0;
    107: flop := #27#76#9#0#0#68#108#56#16#127#127#1#0;
    108: flop := #27#76#9#0#0#0#0#64#127#127#1#0#0;
    109: flop := #27#76#9#0#0#120#124#12#24#8#124#124#0;
    110: flop := #27#76#9#0#0#120#124#4#4#120#124#4#0;
    111: flop := #27#76#9#0#0#56#124#68#68#124#56#0#0;
    112: flop := #27#76#9#0#0#24#60#36#36#248#252#132#0;
    113: flop := #27#76#9#0#0#132#252#248#36#36#60#24#0;
    114: flop := #27#76#9#0#0#8#12#4#12#120#124#4#0;
    115: flop := #27#76#9#0#0#0#32#116#84#84#92#8#0;
    116: flop := #27#76#9#0#0#0#32#68#127#62#4#0#0;
    117: flop := #27#76#9#0#0#64#124#60#64#64#124#124#0;
    118: flop := #27#76#9#0#0#28#60#96#96#60#28#0#0;
    119: flop := #27#76#9#0#0#60#124#96#48#96#124#60#0;
    120: flop := #27#76#9#0#0#0#68#108#56#56#108#68#0;
    121: flop := #27#76#9#0#0#0#252#252#160#160#188#28#0;
    122: flop := #27#76#9#0#0#0#68#76#92#116#100#68#0;
    123: flop := #27#76#9#0#0#65#65#119#62#8#8#0#0;
    124: flop := #27#76#9#0#0#0#0#0#119#119#0#0#0;
    125: flop := #27#76#9#0#0#8#8#62#119#65#65#0#0;
    126: flop := #27#76#9#0#0#2#6#4#6#2#6#4#0;
    127: flop := #27#76#9#0#0#120#124#70#67#70#124#120#0;
    128: flop := #27#76#9#0#0#0#74#251#177#145#159#14#0;
    129: flop := #27#76#9#0#0#64#122#122#64#64#122#58#0;
    130: flop := #27#76#9#0#0#0#25#93#85#84#124#56#0;
    131: flop := #27#76#9#0#66#123#125#85#85#117#35#2#0;
    132: flop := #27#76#9#0#0#64#121#125#84#84#117#33#0;
    133: flop := #27#76#9#0#0#64#120#124#84#85#117#33#0;
    134: flop := #27#76#9#0#0#64#120#124#87#87#116#32#0;
    135: flop := #27#76#9#0#0#0#64#228#164#164#60#24#0;
    136: flop := #27#76#9#0#2#27#93#85#85#125#59#2#0;
    137: flop := #27#76#9#0#0#0#25#93#84#84#125#57#0;
    138: flop := #27#76#9#0#0#0#24#92#84#85#125#57#0;
    139: flop := #27#76#9#0#0#0#1#65#124#124#69#1#0;
    140: flop := #27#76#9#0#0#2#67#125#125#69#3#2#0;
    141: flop := #27#76#9#0#0#0#0#64#124#125#69#1#0;
    142: flop := #27#76#9#0#0#121#125#22#18#22#125#121#0;
    143: flop := #27#76#9#0#0#0#112#120#43#43#120#112#0;
    144: flop := #27#76#9#0#0#0#69#85#85#124#124#68#0;
    145: flop := #27#76#9#0#84#84#124#124#84#84#116#32#0;
    146: flop := #27#76#9#0#0#73#127#127#9#11#126#124#0;
    147: flop := #27#76#9#0#0#0#50#123#73#73#123#50#0;
    148: flop := #27#76#9#0#0#0#50#122#72#72#122#50#0;
    149: flop := #27#76#9#0#0#0#48#120#72#74#122#50#0;
    150: flop := #27#76#9#0#0#64#122#123#65#65#123#58#0;
    151: flop := #27#76#9#0#0#64#120#120#64#66#122#58#0;
    152: flop := #27#76#9#0#0#0#122#250#160#160#186#154#0;
    153: flop := #27#76#9#0#1#25#60#102#102#60#25#1#0;
    154: flop := #27#76#9#0#0#0#61#125#64#64#125#61#0;
    155: flop := #27#76#9#0#0#36#36#231#231#36#60#24#0;
    156: flop := #27#76#9#0#0#32#102#67#73#127#126#104#0;
    157: flop := #27#76#9#0#0#0#43#47#252#252#47#43#0;
    158: flop := #27#76#9#0#160#248#246#47#9#9#255#255#0;
    159: flop := #27#76#9#0#2#3#9#127#254#136#192#64#0;
    160: flop := #27#76#9#0#0#64#121#125#85#84#116#32#0;
    161: flop := #27#76#9#0#0#0#0#65#125#125#68#0#0;
    162: flop := #27#76#9#0#0#0#50#122#74#72#120#48#0;
    163: flop := #27#76#9#0#0#64#122#122#66#64#120#56#0;
    164: flop := #27#76#9#0#0#0#112#122#10#10#122#122#0;
    165: flop := #27#76#9#0#0#0#125#125#49#25#125#125#0;
    166: flop := #27#76#9#0#0#40#47#47#41#47#38#0#0;
    167: flop := #27#76#9#0#0#0#38#47#41#47#38#0#0;
    168: flop := #27#76#9#0#0#0#32#96#69#77#120#48#0;
    169: flop := #27#76#9#0#0#0#8#8#8#8#56#56#0;
    170: flop := #27#76#9#0#0#0#56#56#8#8#8#8#0;
    171: flop := #27#76#9#0#145#187#238#204#24#48#111#79#0;
    172: flop := #27#76#9#0#249#251#118#108#24#48#111#79#0;
    173: flop := #27#76#9#0#0#0#0#123#123#0#0#0#0;
    174: flop := #27#76#9#0#34#54#28#8#34#54#28#8#0;
    175: flop := #27#76#9#0#8#28#54#34#8#28#54#34#0;
    176: flop := #27#76#9#0#0#85#0#170#0#85#0#170#0;
    177: flop := #27#76#9#0#85#170#85#170#85#170#85#170#0;
    178: flop := #27#76#9#0#119#255#170#221#119#170#255#221#0;
    179: flop := #27#76#9#0#0#0#0#255#255#0#0#0#0;
    180: flop := #27#76#9#0#0#0#0#255#255#16#16#16#0;
    181: flop := #27#76#9#0#0#0#0#255#255#20#20#20#0;
    182: flop := #27#76#9#0#0#255#255#0#255#255#16#16#0;
    183: flop := #27#76#9#0#0#240#240#16#240#240#16#16#0;
    184: flop := #27#76#9#0#0#0#0#252#252#20#20#20#0;
    185: flop := #27#76#9#0#0#255#255#0#247#247#20#20#0;
    186: flop := #27#76#9#0#0#255#255#0#255#255#0#0#0;
    187: flop := #27#76#9#0#0#252#252#4#244#244#20#20#0;
    188: flop := #27#76#9#0#0#31#31#16#23#23#20#20#0;
    189: flop := #27#76#9#0#0#31#31#16#31#31#16#16#0;
    190: flop := #27#76#9#0#0#0#0#31#31#20#20#20#0;
    191: flop := #27#76#9#0#0#0#0#240#240#16#16#16#0;
    192: flop := #27#76#9#0#16#16#16#31#31#0#0#0#0;
    193: flop := #27#76#9#0#16#16#16#31#31#16#16#16#0;
    194: flop := #27#76#9#0#16#16#16#240#240#16#16#16#0;
    195: flop := #27#76#9#0#16#16#16#255#255#0#0#0#0;
    196: flop := #27#76#9#0#16#16#16#16#16#16#16#16#0;
    197: flop := #27#76#9#0#16#16#16#255#255#16#16#16#0;
    198: flop := #27#76#9#0#20#20#20#255#255#0#0#0#0;
    199: flop := #27#76#9#0#16#255#255#0#255#255#0#0#0;
    200: flop := #27#76#9#0#20#23#23#16#31#31#0#0#0;
    201: flop := #27#76#9#0#20#244#244#4#252#252#0#0#0;
    202: flop := #27#76#9#0#20#23#23#16#23#23#20#20#0;
    203: flop := #27#76#9#0#20#244#244#4#244#244#20#20#0;
    204: flop := #27#76#9#0#20#247#247#0#255#255#0#0#0;
    205: flop := #27#76#9#0#20#20#20#20#20#20#20#20#0;
    206: flop := #27#76#9#0#20#247#247#0#247#247#20#20#0;
    207: flop := #27#76#9#0#20#20#20#23#23#20#20#20#0;
    208: flop := #27#76#9#0#16#31#31#16#31#31#16#16#0;
    209: flop := #27#76#9#0#20#20#20#244#244#20#20#20#0;
    210: flop := #27#76#9#0#16#240#240#16#240#240#16#16#0;
    211: flop := #27#76#9#0#16#31#31#16#31#31#0#0#0;
    212: flop := #27#76#9#0#20#20#20#31#31#0#0#0#0;
    213: flop := #27#76#9#0#20#20#20#252#252#0#0#0#0;
    214: flop := #27#76#9#0#16#240#240#16#240#240#0#0#0;
    215: flop := #27#76#9#0#16#255#255#16#255#255#16#16#0;
    216: flop := #27#76#9#0#20#20#20#255#255#20#20#20#0;
    217: flop := #27#76#9#0#0#0#0#31#31#16#16#16#0;
    218: flop := #27#76#9#0#16#16#16#240#240#0#0#0#0;
    219: flop := #27#76#9#0#255#255#255#255#255#255#255#255#0;
    220: flop := #27#76#9#0#240#240#240#240#240#240#240#240#0;
    221: flop := #27#76#9#0#0#0#0#0#255#255#255#255#0;
    222: flop := #27#76#9#0#255#255#255#255#0#0#0#0#0;
    223: flop := #27#76#9#0#15#15#15#15#15#15#15#15#0;
    224: flop := #27#76#9#0#0#68#108#56#108#68#124#56#0;
    225: flop := #27#76#9#0#0#0#20#62#42#42#254#252#0;
    226: flop := #27#76#9#0#0#0#6#6#2#2#126#126#0;
    227: flop := #27#76#9#0#0#2#126#126#2#126#126#2#0;
    228: flop := #27#76#9#0#0#0#99#99#73#93#119#99#0;
    229: flop := #27#76#9#0#0#4#4#60#124#68#124#56#0;
    230: flop := #27#76#9#0#0#30#62#32#32#126#254#128#0;
    231: flop := #27#76#9#0#0#2#6#124#126#2#6#4#0;
    232: flop := #27#76#9#0#0#0#153#189#231#231#189#153#0;
    233: flop := #27#76#9#0#0#28#62#107#73#107#62#28#0;
    234: flop := #27#76#9#0#0#76#126#115#1#115#126#76#0;
    235: flop := #27#76#9#0#0#0#57#125#79#74#120#48#0;
    236: flop := #27#76#9#0#24#60#36#60#60#36#60#24#0;
    237: flop := #27#76#9#0#24#61#39#62#60#100#252#152#0;
    238: flop := #27#76#9#0#0#0#0#73#73#107#62#28#0;
    239: flop := #27#76#9#0#0#0#126#127#1#1#127#126#0;
    240: flop := #27#76#9#0#0#0#42#42#42#42#42#42#0;
    241: flop := #27#76#9#0#0#0#68#68#95#95#68#68#0;
    242: flop := #27#76#9#0#0#0#64#68#78#91#81#64#0;
    243: flop := #27#76#9#0#0#0#64#81#91#78#68#64#0;
    244: flop := #27#76#9#0#6#7#1#255#254#0#0#0#0;
    245: flop := #27#76#9#0#0#0#0#127#255#128#224#96#0;
    246: flop := #27#76#9#0#0#0#8#8#107#107#8#8#0;
    247: flop := #27#76#9#0#0#18#54#36#54#18#54#36#0;
    248: flop := #27#76#9#0#0#0#6#15#9#15#6#0#0;
    249: flop := #27#76#9#0#0#0#0#24#24#0#0#0#0;
    250: flop := #27#76#9#0#0#0#0#16#16#0#0#0#0;
    251: flop := #27#76#9#0#1#1#255#255#192#112#48#16#0;
    252: flop := #27#76#9#0#0#0#30#31#1#31#31#0#0;
    253: flop := #27#76#9#0#0#0#0#18#23#29#25#0#0;
    254: flop := #27#76#9#0#0#0#60#60#60#60#0#0#0;
    255: flop := #27#76#9#0#0#0#0#0#0#0#0#0#0
  end
end;

procedure edit(var s:string; l:integer);
const fill = '';
var
  p,x,y:integer;
  c:char;
  done:boolean;

  procedure cursor(cursor_type:char);
  begin
    reg.ah := 1;
    reg.cl := 7;
    case cursor_type of
      '_': reg.ch := 6;
      '': reg.ch := 1
    end;
    Intr($10,reg)
  end;

  function ConstStr(c:char; n:integer):string;
  var
    i:integer;
    s:string;
  begin
    s := '';
    for i := 1 to n do s := s + c;
    ConstStr := s
  end;

begin
  done := false;
  x := whereX;
  y := whereY;
  write(s,ConstStr(fill,l-length(s)));
  p := 0;
  repeat
    gotoXY(x+p,y);
    if type_over then
      cursor('_')
    else
      cursor('');
    c := readkey;
    case c of
      #0 : begin
             c := readkey;
             case c of
               #71: p := 0;
               #79: p := length(s);
               #75: if p > 0 then p := p - 1;
               #77: if p < length(s) then p := p + 1;
               #83: if p < length(s) then
                      begin
                        delete(s,p+1,1);
                        write(copy(s,p+1,l),fill)
                      end;
               #82: type_over := not type_over;
               #72: done := true;
               #80: done := true;
             end
           end;
      ^H : if p > 0 then
             begin
               delete(s,p,1);
               Write(^H,copy(s,p,l),fill);
               p := p - 1
             end;
      ^Y : begin
             p := 0;
             s := '';
             gotoxy(x,y);
             write(constStr(fill,l))
           end;
      ^M,#27 : begin
                 p := length(s);
                 gotoxy(x+p,y);
                 write('':l-p);
                 done := true
               end;
      #32..#255: if p < l then
                   begin
                     p := p + 1;
                     if type_over then
                       delete(s,p,1);
                     insert(c,s,p);
                     write(copy(s,p,l-p+1))
                   end
    else
      write(^G)
    end
  until done;

  cursor('_');
  key := c;
  s := copy(s,1,l)
end;


function lpt_ready:boolean;
begin
  reg.ah := 2;
  reg.dx := printer - 1;
  intr($17,reg);
  lpt_ready := (reg.ah and $90) = $90;
end;

function exist(fs:string):boolean;
var b:boolean;
begin
  assign(mask_file,fs);
  {$I-}
  reset(mask_file);
  {$I+}
  b := IOResult = 0;
  if b then
    close(mask_file);
  exist := b
end;

function date:str_10;
var day,month,year:str_10;
begin
  reg.ah := $2a;
  MsDos(reg);
  str(reg.dl,day);
  str(reg.dh,month);
  str(reg.cx-1900,year);
  if length(day) = 1 then day := '0' + day;
  if length(month) = 1 then month := '0' + month;
  if length(year) = 1 then year := '0' + year;
  date := month + '/' + day + '/' + year
end;

procedure SetPrinter;
begin

  {$I-}
  close(lst);           { Don't care if it's not presently open }
  System.InOutRes := 0; { Pretend it worked }
  {$I+}

  case printer of
    1: assign(lst,'lpt1');
    2: assign(lst,'lpt2');
    3: assign(lst,'lpt3');
  end;

  append(lst);
  gotoxy(x + 30,y + 6);
  write(printer)

end;

procedure SetSize;
begin
  gotoxy(x+30,y+9);
  clreol;
  write(label_Size[size]);
  if wrap[size] then
    write(' Wrap');
  disk_name := copy(disk_name,1,width[size]);
  gotoxy(x+30,y+5);
  clreol;
  write(disk_name);
end;

procedure clear_array;
begin
  for i := 1 to max_files do
    if not (filespec[i].name = @blank_fs) then
      begin
        dispose(filespec[i].name);
        filespec[i].name := @blank_fs
      end;
  for i := 1 to max_files do
    if not (filespec[i].cmt = @blank_cmt) then
      begin
        dispose(filespec[i].cmt);
        filespec[i].cmt := @blank_cmt
      end;
  count := 0;
end;

procedure Display_choices;
begin
  for i := 5 to 22 do begin gotoXY(1,i); clreol end;
  x := 20; y := 8;
  gotoxy(x,y);      writeln('B - Blank label        ');
  gotoxy(x,y + 1);  writeln('C - Continuation Labels');
  gotoxy(x,y + 2);  writeln('D - Disk drive selected');
  gotoxy(x,y + 3);  writeln('L - Library of         ');
  gotoxy(x,y + 4);  writeln('M - Mask File Loaded   ');
  gotoxy(x,y + 5);  writeln('N - Name for disk/label');
  gotoxy(x,y + 6);  writeln('O - Output Printer Port');
  gotoxy(x,y + 7);  writeln('P - Print label        ');
  gotoxy(x,y + 8);  writeln('R - Registration Form  ');
  gotoxy(x,y + 9);  writeln('S - Size of label      ');
  gotoxy(x,y + 10); writeln('W - Write Configuration');
  gotoxy(x,y + 12); writeln('Q - Quit               ');
  SetSize;
  SetPrinter;
  gotoxy(x+30,y+5); write(disk_name);
  gotoxy(x+30,y+4); if mask_fs[1] <> '.' then write(mask_fs);
  gotoxy(x+30,y+3); write(library);
  gotoxy(x+30,y+2); write(chr(drive + 65),':');
  gotoxy(x+30,y+1); if cont then write('Yes') else write('No ');
  gotoxy(1,24)
end;

procedure init_welcome;
begin
  test := 0;
  copies := 0;
  clrscr;
  TextColor(White);
  LowVideo;
  blank_fs := '            ';
  blank_cmt:= '                                             ';
  for i := 1 to max_files do filespec[i].name := @blank_fs;
  for i := 1 to max_files do filespec[i].cmt := @blank_cmt;
  clear_array;

  spaces := '            ';

  cont    := false;
  drive   := 0;
  library := '';
  printer := 1;
  size    := 4;
  Disk_Name := '';


  reg.ah := $19;
  MsDos(Reg);
  reg.ah := $0e;
  reg.dl := reg.al;
  MsDos(Reg);
  max_Drive := reg.al;

  mask_fs := '';
  clrscr;
  gotoXY(1,2); write(double);
  gotoXY(1,4); write(double);
  gotoXY(1,23); write(single);
  gotoXY(1,25); write(single);
  gotoXY(1,1); write('Labeler');
  gotoXY(72,1); write(date);
  gotoXY(1,3);  write('Disk Label Generator          Version ',version);
  gotoXY(51,3); write('(c) Guardian Software 1986,89');
  gotoXY(1,6);
  writeln('                Copyright    Ken Buetow');
  writeln('                             Guardian Software');
  writeln('                             PO Box 39');
  writeln('                             St. Clair Shores, MI  48080-0039');
  writeln;
  writeln('         LABELER is distributed as shareware.  As such, you are given');
  writeln('         30 days to evaluate LABELER, after which you must register to');
  writeln('         continue using it.');
  writeln;
  writeln;
  writeln('         You are free to copy and share Labeler with others on these ');
  writeln('         conditions:');
  writeln;
  writeln('           1. This program is not distributed in modified form.     ');
  writeln('           2. No fee or consideration is paid for Labeler itself.   ');
  writeln('           3. This notice is not bypassed or removed.               ');
  writeln('           4. Commercial Distrribution must have prior permission.  ');
  gotoXY(1,24);


  { get dir of labeler }



  GetDir(0,temp_str);

  temp_str := temp_str + ';';

  path := GetEnv('path');

  if path <> '' then
    temp_str := temp_str + path;

  repeat
    if temp_str = '' then
      begin
        clrscr;
        write('Unable to locate LABELER.EXE',#13,#10,#10);
        halt(1);
      end;
    path := copy(temp_str,1,pos(';',temp_str)-1);
    if path[length(path)] <> '\' then
      path := path + '\labeler.'
    else
      path := path + 'labeler.';
    delete(temp_str,1,pos(';',temp_str));
  until exist(path + 'exe');


  { read lbl file }

  {$I-}
  assign(cnf_file,path + 'lbl');
  reset(cnf_file);
  sizes := 0;
  gotoxy(1,24); clreol; write('Reading .LBL file');
  while not eof(cnf_file) do
    begin
      readln(cnf_file,temp_str);
      if length(temp_str) <> 37 then
        system.InOutRes := 1;
      label_size[sizes] := copy(temp_str,1,17);
      wrap[sizes] := Upcase(temp_str[18]) = 'Y';
      val(copy(temp_str,20,2),cols[sizes],i);
      val(copy(temp_str,23,2),rows[sizes],i);
      val(copy(temp_str,26,2),filler[sizes],i);
      val(copy(temp_str,29,2),feeds[sizes],i);
      dbl[sizes] := UpCase(temp_str[33]) = 'Y';
      val(copy(temp_str,36,2),width[sizes],i);
      sizes := sizes + 1;
    end;
  close(cnf_file);
  gotoxy(1,24);
  clreol;
  {$I+}

  if 0 <> IOResult then
    begin
      write('Problem reading LABELER.LBL',#13,#10,#10);
      halt(1);
    end;

  { read drv file }

  if exist(path + 'drv') then
    begin
      gotoxy(1,24); clreol; write('Reading .DRV file');
      {$I-}
      assign(cnf_file,path + 'drv');
      reset(cnf_file);
      readln(cnf_file,temp_str);
      init_str := parse(temp_str);
      readln(cnf_file,temp_str);
      line_spacing := parse(temp_str);
      readln(cnf_file,temp_str);
      sub_on := parse(temp_str);
      readln(cnf_file,temp_str);
      sub_off := parse(temp_str);
      readln(cnf_file,temp_str);
      emp_on := parse(temp_str);
      readln(cnf_file,temp_str);
      emp_off := parse(temp_str);
      readln(cnf_file,temp_str);
      dbl_on := parse(temp_str);
      readln(cnf_file,temp_str);
      dbl_off := parse(temp_str);
      readln(cnf_file,temp_str);
      cond_on := parse(temp_str);
      readln(cnf_file,temp_str);
      cond_off := parse(temp_str);
      readln(cnf_file,temp_str);
      dbl_st_on := parse(temp_str);
      readln(cnf_file,temp_str);
      dbl_st_off := parse(temp_str);
      close(cnf_file);
      gotoxy(1,24); clreol
    end;
    {$I+}

  if 0 <> IOResult then
    begin
      write('Problem reading ' + path + 'drv',#13,#10,#10); delay(2000);
      halt(1);
    end;



  { read cfg file }

  if exist(path + 'cfg') then
    begin
      {$I-}
      assign(cnf_file,path + 'cfg');
      reset(cnf_file);
      gotoxy(1,24); clreol; write('Reading .CFG file');
      readln(cnf_file,temp);
      readln(cnf_file,drive);
      readln(cnf_file,library);
      readln(cnf_file,printer);
      readln(cnf_file,size);
      close(cnf_file);
      gotoxy(1,24);
      clreol;
      if temp = 'FALSE' then
        cont := false
      else
        cont := true;
      {$I+}
      if 0 <> IOResult then
        begin
          gotoxy(1,24);
          clreol;
          write('Problem reading ' + path + 'cfg' + ' ... Press any key to continue.');
          while not keypressed do;
          key := readkey
        end
    end;

  disk_name := '';
  copies :=0;

  { Comamnd Line Parameters }
  i := 1;
  while i <= paramcount do
    begin
      if copy(paramstr(i),1,1) <> '/' then
        begin
          clrscr;
          writeln('Error in parameter');
          writeln('usage:   LABELER [/D=d] [/L=l] [/S=s] [/M=m] [/N=n] [/O=o] [/P=p]');
          writeln('Example: labeler /d=b /l=Guardian Software /s=1 /m=labeler /n=Ken Buetow /o=2 /p=10');
          halt
        end
      else
        begin
          temp_str := copy(paramstr(i),2,255);
          case upcase(temp_str[1]) of
            'D': drive := ord(UpCase(temp_str[3])) - 65;
            'S': size := ord(temp_str[3]) - 48;
            'L': begin
                   library := copy(temp_str,3,255);
                   while (copy(paramstr(i+1),1,1) <> '/') and (i < paramcount) do
                     begin
                       i := i + 1;
                       library := library + ' ' + paramstr(i)
                     end
                 end;
            'M': mask_fs := copy(temp_str,3,255);
            'N': begin
                   disk_name := copy(temp_str,3,255);
                   while (copy(paramstr(i+1),1,1) <> '/') and (i < paramcount) do
                     begin
                       i := i + 1;
                       disk_name := disk_name + ' ' + paramstr(i)
                     end
                 end;
            'O': printer := ord(Upcase(temp_str[3]));
            'P': val(copy(temp_str,3,255),copies,j)
          end
        end;
      i := i + 1
    end;
  if copies = 0 then
    begin
      gotoxy(1,24); clreol; write('Press any key to continue ...');
      key := readkey
    end;
  Display_choices
end;

procedure read_disk_info;

  function masked:boolean;
  var i:integer;

    function expand(s:str_12):str_12;
    var left,right:str_12;
        i,j:integer;
    begin
      for i := 1 to length (s) do
        s[i] := upcase(s[i]);
      if pos('.',s) <> 0 then
        begin
          left := copy (s,1,pos('.',s)-1);
          left := copy (left + '         ',1,8);
          right := copy (s,pos('.',s)+1,255);
          right := copy (right+'    ',1,3)
        end
      else
        begin
          left := copy(s,1,255);
          left := copy(left+'        ',1,8);
          right := '   '
        end;
      for i := 1 to 8 do
        if left[i] = '*' then
          for j := i to 8 do
            left[j] := '?';
      for i := 1 to 3 do
        if right[i] = '*' then
          for j := i to 3 do
            right[j] := '?';
      expand := left + '.' + right
    end;

    function matched(s1,s2:str_12):boolean;
    var i:integer;
    begin
      matched := false;
      for i := 1 to length(s1) do
        if not ((s1[i] = s2[i]) or (s2[i] = '?')) then
          exit;
      matched := true
    end;

  begin
    masked := true;
    for i := 1 to count do
      if matched(expand(s_rec.name),expand(filespec[i].name^)) then
        exit;
    masked := false;
  end;

  procedure read_dir;

  var
    mask       :string[13];
    error      :boolean;

  begin
    num_files := 0;
    gotoxy(x+30,y+7); write('Reading');
    FindFirst(chr(drive+65)+':\*.*',anyfile-volumeid,s_rec);
    if DosError = 0 then
      begin
        num_files := num_files + 1;
        if not masked then
          begin
            count := count + 1;
            new(filespec[count].name);
            filespec[count].name^ := s_rec.name
          end
      end;
    while DosError = 0 do
      begin
        FindNext(s_rec);
        if DosError = 0 then
          begin
            num_files := num_files + 1;
            if not masked then
              begin
                count := count + 1;
                new(filespec[count].name);
                filespec[count].name^ := s_rec.name
              end
          end
      end;
    for i := 1 to count do
      filespec[i].name^ := copy(filespec[i].name^+'             ',1,12);
    gotoxy(x+30,y+7);
    write('Sorting');
    again := true;
    delay(500);
    while again do
      begin
        again := false;
        for i := start + 1 to count - 1 do
          if filespec[i].name^ > filespec[i + 1].name^ then
            begin
              temp_fs := filespec[i].name;
              filespec[i].name := filespec[i + 1].name;
              filespec[i + 1].name := temp_fs;
              temp_cmt := filespec[i].cmt;
              filespec[i].cmt := filespec[i + 1].cmt;
              filespec[i + 1].cmt := temp_cmt;
              again := true
            end
      end
  end;

begin
  free := diskfree(drive+1);
  while not ((free <> -1) or abort) do
    begin
      free := DiskFree(drive+1);
      key := ' ';
      gotoXY(1,24);
      clreol;
      write('Disk drive ',chr(drive + 65),': not ready ... Press <ESC> to abort',^G);
      delay(2000);
      if keypressed then key := readkey;
      if key = #27 then abort := true;
    end;
  if abort then exit;
  d_size := disksize(drive + 1);
  used := d_size - free;
  read_dir;
end;

procedure edit_mask_file;
var bottom:integer;
    offset:integer;
    current:integer;
begin
  offset  := 0;
  bottom  := 0;
  current := 1;
  if exist(mask_fs) then
    begin
      assign(mask_file,mask_fs);
      {$I-}
      reset(mask_file);
      while not eof(mask_file) do
        begin
          readln(mask_file,line);
          bottom := bottom + 1;
          new(filespec[bottom].cmt);
          filespec[bottom].cmt^ := line;
          if bottom = 1 then
            temp_str := line
        end;
      close(mask_file);
      {$I+}
      if ioresult <> 0 then
        begin
          gotoxy(1,24); clreol;
          write('Unable to read ... ',mask_fs,'  Press any key to continue.');
          key := readkey
        end
    end;
  if bottom = 0 then
    begin
      bottom := 1;
      new(filespec[current].cmt);
      filespec[current].cmt^ := ''
    end;

  gotoxy(1,24); clreol;
  write('Press <ESC> to end editing mask file.');

  for i := 5 to 22 do begin gotoXY(1,i); clreol end;

  window(1,5,80,22);

  repeat
    clrscr;
    if current < 19 then
      offset := 0
    else
      offset := current - 18;
    for i := 1 to 18 do
      begin
        gotoxy(7,i); clreol;
        write(filespec[offset+i].cmt^);
      end;
    gotoxy(7,current+offset); clreol;
    edit(filespec[current].cmt^,65);
    if (filespec[current].cmt^ = '') and (bottom > 1) then
      begin
        temp_cmt := filespec[current].cmt;
        for i := current + 1 to bottom do
          filespec[i - 1].cmt := filespec[i].cmt;
        filespec[bottom].cmt := temp_cmt;
        filespec[bottom].cmt^ := '';
        bottom := bottom - 1
      end;
    case key of
      #72 : if current > 1 then
              current := current - 1;
      ^M  : begin
              if type_over then
                current := current + 1
              else
                begin
                  current := current + 1;
                  bottom := bottom + 1;
                  new(filespec[bottom].cmt);
                  filespec[bottom].cmt^ := '';
                  temp_cmt := filespec[bottom].cmt;
                  for i := bottom downto current + 1 do
                    filespec[i].cmt := filespec[i-1].cmt;
                  filespec[current].cmt := temp_cmt
                end
            end;
      #80 : begin
              current := current + 1;
            end;
    end;
    if current > bottom then
      begin
        bottom := current;
        new(filespec[bottom].cmt);
        filespec[current].cmt^ := '';
      end;
  until key = #27;

  window(1,1,80,25);

  gotoxy(1,24); clreol;
  write('Press <ESC> to record changes ... any other aborts.');
  key := readkey;
  if key = #27 then
    begin
      {$I-}
      assign(mask_file,mask_fs);
      rewrite(mask_file);
      i := 1;
      disk_name := copy(filespec[i].cmt^,1,width[size]);
      while (i < bottom + 1) do
        begin
          writeln(mask_file,filespec[i].cmt^);
          i := i + 1;
        end;
      close(mask_file);
      {$I+}
      if ioresult <> 0 then
        begin
          gotoxy(1,24); clreol;
          write('Unable to create ... ',mask_fs,'  Press any key to continue.');
          key := readkey
        end
    end;
  clear_array;
  if mask_fs[1] = '.' then
    mask_fs := '';
  display_choices
end;

procedure read_mask_file;
begin
  start := 0;
  count := 0;
  if pos('.',mask_fs) = 0 then
    mask_fs := mask_fs + '.msk';
  if exist(mask_fs) then
    begin
      assign(mask_file,mask_fs);
      reset(mask_file);
      readln(mask_file,temp_str);
      disk_name := copy(temp_str,1,width[size]);
      while not eof(mask_file) do
        begin
          readln(mask_file,line);
          count := count + 1;
          if pos(':',line) <> 0 then
            begin
              new(filespec[count].name);
              new(filespec[count].cmt);
              start := count + 1;
              filespec[count].name^ := copy(line,1,pos(':',line)-1);
              filespec[count].name^ := copy(filespec[count].name^+'             ',1,12);
              filespec[count].cmt^  := copy(line,pos(':',line)+1,255);
              for i := 1 to length(filespec[count].name^) do
                filespec[count].name^[i] := UpCase(filespec[count].name^[i])
            end
          else
            if line <> '' then
              begin
                new(filespec[count].name);
                filespec[count].name^ := line;
                for i := 1 to length(filespec[count].name^) do
                filespec[count].name^[i] := UpCase(filespec[count].name^[i]);
                for i := 1 to length(filespec[count].name^) do
                  filespec[count].name^[i] := UpCase(filespec[count].name^[i])
              end
        end;
      close(mask_file)
    end;
  display_choices
end;

procedure print_label;

var cr,cf : integer;

begin

  if abort then exit;
  if blank then gotoxy(x+30,y) else gotoxy(x+30,y+7); write('Printing');
  while not (lpt_ready or abort) do
    begin
      key := ' ';
      gotoxy(1,24);
      clreol;
      write('Printer not ready ... Press <ESC> to abort',^G);
      delay(2000);
      if keypressed then key := readkey;
      if key = #27 then abort := true;
      if (copies > 0) and abort then halt
    end;
  if abort then exit;

  cf := 1;

  while not abort do

    begin
      write(lst,init_str,line_spacing);
      if wrap[size] then
        begin
          write(lst,#13,#10,#10,'       ');
          for i := width[size] downto 1 do    { need to print this backwards }
            if (i > length (disk_name)) then
              write(lst,flop(' '))
            else
              write(lst,flop(disk_name[i]));
          writeln(lst,#13,#10,#10,#10,'-                       -',#10,
                      sub_on,disk_name,sub_off,#10,#10)
        end;

      if dbl[size] then
        write(lst,dbl_on);

      writeln(lst,emp_on,dbl_st_on,disk_name,emp_off,dbl_st_off,dbl_off,sub_on,cond_on,#10);

      line := long;
      if not (library = '') then
        begin
          insert('Library of ',line,1);
          insert(' '+library,line,(((cols[size] * 12)+((cols[size] - 1) * filler[size]))-length(library)));
        end;
      line := copy(line,1,(cols[size] * 12)+((cols[size] - 1) * filler[size]));
      writeln(lst,line);

      cr := 0;

      repeat
        if cf < start then
          begin
            if filespec[cf].name^[1] <> ' ' then
              writeln(lst,filespec[cf].name^,' ',filespec[cf].cmt^)
            else
              writeln(lst,filespec[cf].cmt^);
            cf := cf + 1;
            if cf = start then
              cf := cf + 1;
            cr := cr + 1
          end
        else
          begin
            for i := 0 to rows[size] - cr - 1 do
              begin
                for k := 0 to cols[size] - 1 do
                  write(lst,filespec[cf+k*(rows[size]-cr)+i].name^,'':filler[size]);
                writeln(lst)
              end;
            cf := cf+k*(rows[size]-cr)+i+1;
            cr := rows[size]
          end
      until cr = rows[size];

      line := copy(long,1,(cols[size] * 12)+((cols[size] - 1) * filler[size]));
      writeln(lst,line);
      if blank then
        writeln(lst,date,'':(-38+cols[size]*12+(cols[size]-1)*filler[size]),'Self Loading .... Non DOS disk')
      else
        if ((cols[size] * 12) + ((cols[size] - 1) * filler[size])) < 31 then
          writeln(lst,date,'':(-20+cols[size]*12+(cols[size]-1)*filler[size]),
                      free:7,' FREE')
        else
          if ((cols[size] * 12) + ((cols[size] - 1) * filler[size])) < 44 then
            writeln(lst,date,'':(-31+cols[size]*12+(cols[size]-1)*filler[size]),
                        num_files:4,' FILES ',free:7,' FREE')
          else
            writeln(lst,date,'':(-44+cols[size]*12+(cols[size]-1)*filler[size]),
                        num_files:4,' FILES ',used:7,' USED ',free:7,' FREE');
      for k := 1 to feeds[size] do
        writeln(lst);
      write(lst,init_str);
      if (not cont) or (cf > count) or blank then
        abort := true
    end;

end;


procedure registration;
begin
  writeln(lst);
  writeln(lst,'                                                                   Ŀ');
  writeln(lst,'__________________________                                         Place');
  writeln(lst,'                                                                   Stamp');
  writeln(lst,'__________________________                                         Here ');
  writeln(lst,'                                                                   ');
  writeln(lst,'__________________________');
  writeln(lst,'');
  writeln(lst,'__________________________');
  writeln(lst,'');
  writeln(lst,'(______) _____ - _________');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,'                                         GUARDIAN SOFTWARE');
  writeln(lst,'                                         PO BOX 39');
  writeln(lst,'                                         ST. CLAIR SHORES, MI');
  writeln(lst,'                                                              48080-0039');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,'Labeler ',version);
  writeln(lst,'');
  writeln(lst,'_______________________________________________________________________________');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,'                 For easy VISA / Master Card Registration');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,' Work Phone (____) ____ - ________           Home Phone (____) ____ - ________');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,' CARD # ______________________________________________  Expires ______________');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,' Name of Card Holder  ________________________________________________________');
  writeln(lst,'');
  writeln(lst,'');
  writeln(lst,' Signature  __________________________________________________________________');
  writeln(lst,'');
  writeln(lst,'                 (use reverse for suggestions/comments/problems)');
  writeln(lst,'__________________________________________________________[curr_____________________');
  writeln(lst,'');
  writeln(lst,'                            Labeler Registration Form');
  writeln(lst,'S');
  writeln(lst,'T');
  writeln(lst,'A          Remit to: Guardian Software');
  writeln(lst,'P');
  writeln(lst,'L');
  writeln(lst,'E');
  writeln(lst,'           ____  Labeler Registration for current copy      $10.00   ______');
  writeln(lst,'C');
  writeln(lst,'H          ____  Labeler Registration and latest version    $15.00   ______');
  writeln(lst,'E');
  writeln(lst,'C                            3 1/2" disk vice 5 1/4" add    $ 5.00   ______');
  writeln(lst,'K');
  writeln(lst,'                                                   Total             ______');
  writeln(lst,'H');
  writeln(lst,'E          Fold the page letter style at the lines, exposing the mailing');
  writeln(lst,'R          address and hiding your information.  Staple your check inside,');
  writeln(lst,'E          then staple or tape the sides and top.');
  writeln(lst,'');
  writeln(lst,'-')
end;

begin
  init_welcome;
  repeat
    abort := false;
    blank := false;
    if copies <> 0 then
      begin
        clear_array;
        read_mask_file;
        read_disk_info;
        repeat
          abort := false;
          print_label;
          gotoxy(x+30,y+7);
          clreol;
          copies := copies - 1
        until copies = 0;
        clrscr; exit
      end;
    gotoxy(1,24); clreol; write('Please enter your selection ?',^H);
    key := readkey;
    write(upcase(key));
    case key of
      'q','Q': begin
                 clrscr;
                 exit
               end;
      'p','P': begin
                 clear_array;
                 read_mask_file;
                 read_disk_info;
                 print_label;
                 gotoxy(x+30,y+7); clreol;
               end;
      's','S': begin
                 size := (size + 1) mod sizes;
                 SetSize
               end;
      'm','M': begin
                 gotoxy(x+30,y+4); clreol;
                 edit(mask_fs,25);
                 if pos('.',mask_fs) = 0 then
                   mask_fs := mask_fs + '.msk';
                 if not (mask_fs[1] = '.') then
                   edit_mask_file
                 else
                   mask_fs := '';
                 display_choices
               end;
      'n','N': begin
                 gotoxy(x+30,y+5); clreol;
                 edit(disk_name,width[size])
               end;
      'o','O': begin
                 printer := printer mod 3 + 1;
                 SetPrinter
               end;
      'l','L': begin
                 gotoxy(x+30,y+3); clreol;
                 edit(library,22)
               end;
      'd','D': begin
                 drive := (drive + 1) mod max_drive;
                 gotoxy(x+30,y+2);
                 write(chr(drive + 65),':')
               end;
      'c','C': begin
                 cont := not cont;
                 gotoxy(x+30,y+1);
                 if cont then write('Yes') else write('No ')
               end;
      'b','B': begin
                 blank := true;
                 clear_array;
                 read_mask_file;
                 print_label;
                 gotoxy(x+30,y); clreol;
               end;
      'r','R': begin
                 abort := false;
                 gotoxy(x+30,y+8);
                 write('Printing');
                 while not (lpt_ready or abort) do
                   begin
                     key := ' ';
                     gotoxy(1,24);
                     clreol;
                     write('Printer not ready ... Press <ESC> to abort',^G);
                     delay(2000);
                     if keypressed then key := readkey;
                     if key = #27 then abort := true;
                   end;
                 if not abort then registration;
                 gotoxy(x+30,y+8);
                 clreol
               end;
      'w','W': begin
                 gotoxy(x+30,y+10);
                 write('Writing');
                 assign(cnf_file,path + 'cfg');
                 {$I-}
                 rewrite(cnf_file);
                 writeln(cnf_file,cont);
                 writeln(cnf_file,drive);
                 writeln(cnf_file,library);
                 writeln(cnf_file,printer);
                 writeln(cnf_file,size);
                 close(cnf_file);
                 gotoxy(x+30,y+10);
                 write('       ');
                 {$I+}
                 if 0 <> IOResult then
                   begin
                     gotoxy(1,24);
                     clreol;
                     write('Problem writing '+
                            copy(paramstr(0),1,pos('.',paramstr(0)))+'cfg'+
                            ' ... Press any key to continue.');
                     while not keypressed do;
                     key := readkey
                   end
               end
    end;  {case}
  until false
end.
