@echo off
cls
echo ** Introductory tutorial to Q scientific Command Line Calculator ** 
echo                             version 1.92
echo.
echo This tutorial batch file will run Q with various examples which will   
echo guide you to write your own Q applications.
echo.
echo Q is a command line calculator.  This means that you work directly
echo from DOS or from a batch file, like this one, and can use 
echo all DOS resources.  Once an expression is calculated, the command
echo goes back to DOS.
echo.
echo To run the tutorial the following files should be present:
echo q.exe (the program), 
echo egavga.bgi (or equivalent graphic driver in the path or in \clc), 
echo a.dat, b.dat (example files used by the tutorial)
echo During the run of the tutorial several files with the extension *.q
echo are generated and may be deleted later.
echo.
echo Press space bar when prompt to do so and the tutorial will guide you
echo through the basic steps.  To EXIT the tutorial press CTRL-break (^c).
pause
echo    -2-
echo Let's start with the simplest calculation.  To calculate 2+3 enter: q 2+3
echo Note that every line starts with q which is the program's name.
echo Everything to the right of // is a comment
echo q 2+3   // My first expression
pause
q 2+3   // My first expression
echo Note the points above the result. They help in reading long numbers.
echo.
echo    -3-
echo To use results in next expressions save them using ">"  
echo with almost all exressions you may use ":" instead of ">".
echo If you use ":" the result is displayed too.
echo For example 2+3>a.q and 3+4>b.q will save 5 in a.q and 7 in b.q 
echo To use saved results put the file names between two $ signs as in the 
echo following example:
echo q 2+3:a.q
echo q 3+4:b.q
echo q $a.q$+$b.q$
pause
q 2+3:a.q
q 3+4:b.q
q $a.q$+$b.q$
pause
echo    -4-
echo To compute -pi(3+4)5 where pi is the constant 3.14... enter: q -pi(3+4)5
echo q -pi(3+4)5     // Note that you don't have to write -pi*(3+5)*5
pause
q -pi(3+4)5      // Note that you don't have to write -pi*(3+5)*5
echo    -5-
echo To obtain a table of x^3 with x from 0 to 100 write: q x^3 
echo To redefine this range or change the number of points use RNG().
echo e.g. q rng(20)x^3 will run through 20 point for x= 0 to 100,
echo q rng(-5,5)x^3 will make x run through 101 points from -5 to 5,
echo and q rng(-5,5,200)x^3 will make x run through 200 points from -5 to 5.
echo Using "| more" will show one page at a time.
pause
@echo on
q x^3 | more
@echo off
echo    -6-
echo Substitution is simple.  For example Jack=4; Jim=6; Jack+Jim; Jack-Jim
echo will result in ...
pause
echo q Jack=4; Jim=6;  Jack+Jim;  Jack-Jim
q Jack=4;  Jim=6;  Jack+Jim;  Jack-Jim
echo    -7-
echo To solve an equation with one unknown x just write it.
echo Later you will see how to solve equations with several unknowns.
echo You may want use rng() to redefine the range of x in which to look 
echo for a solution.  For example  rng(-10,10)2x+x^3=1/3
echo If there is more than one solution - the program will always display 
echo the smallest solution in that range. 
echo If you don't use rng, the range is 0 to 100.
pause
echo q rng(-10,10)2x+x^3=1/3
q rng(-10,10)2x+x^3=1/3
echo    -8-
echo Let's examine the expression: q rng(0,360,361)x;sin(dr(x));cos(dr(x))
echo here sine and cosine functions are calculated for each degree (0 to 360).
echo x is in degrees from 0 to 360, defined by rng().
echo Note that dr() transfers x from degrees to radians.  We have to use dr() 
echo because the sine and cosine accept only radians.
echo A semicolon ; is used to separate outputs.  To write the resulting
echo table to a file "A.q" add the ">A.q" as in the following 
pause
@echo on
q rng(0,360,361)x;sin(dr(x));cos(dr(x)) > a.q
@echo off
echo DONE!
echo You may use \DOS\EDIT to see the file "a.q". 
echo Reminder: press ALT-f, x to exit when you are done.
echo This is a typical data file.  The two first lines are headers skipped
echo by the program, and the data is arrayed in rows and columns like a 
echo matrix.  In this case, in the 1st column are the degrees, and in the 
echo 2nd the sine and in the 3rd cosine. 
pause
echo \dos\edit a.q
\dos\edit a.q
echo.
echo    -9-
echo Q provides for several methods to use the data in this type of file. 
echo The simplest is to read just one number.  This is explained by 
echo an example:
echo z(2,1)~(1,3)a.q
echo ~ means to read from a file. (1,3) means to read 3 columns 
echo starting at column 1. (1,3) actually, defines a sub file (sub matrix).
echo z(2,1) reads the element (2,1), that is 2nd column and 1st row of  
echo this sub-file. 
echo If you don't use (i,j) in ~(i,j)file, the default is ~(1,1)file.
echo Let's do something more complicated.  The following expression will read
echo first 3 elements diagonally and add this to the corner element.
echo rng(3)z(i+1,i+1)+z(1,1)~(1,3)a.q  (i starts at zero)
pause
q rng(3)z(i+1,i+1)+z(1,1)~(1,3)a.q
echo    -10-
echo It is possible to use whole columns. 
echo For example, rng(4)clmn(3);clmn(2);clmn(1)~a.q will display the
echo 4 rows of the 3 columns rearranged.
echo rng(4)clmn(3);clmn(2);clmn(1)~a.q
pause
q rng(4)clmn(3);clmn(2);clmn(1)~a.q
echo rng(3)clmn(i+1) has same effect as rng(3)z(i+1,i+1) because clmn() reads
echo one row at a time while z() causes to load first the whole sub-file.
echo    -11-
echo If you want to use just one column there is a simpler way 
echo than z(,)~(,)file which is y~//file.  // indicates how many columns 
echo to skip.  y~//file has same effect as z(1,i+1)~(3,1)file. 
echo q rng(5)2x*y~/a.q will of course result in a table where y is obtained 
echo from  column 2, x runs from 0 to 4.  Lets save the output in b.q
pause
q rng(5)2x*y~/a.q>b.q
echo    -12-
echo To use data from two files you have first to combine them side by side.
echo This is done using file1&file2.  3 spaces are added between the two
echo files to show the seam.  To save the output use file1&file2:file3
echo The following will multiply the same b.q file.
echo q b.q&b.q:c.q
echo type b.q
pause
q b.q&b.q:c.q
type c.q
echo    -13-
echo Q provides for several methods to display the contents of a file
echo as a graph.  These are p~f, g~f and ~f where f is the filename
echo and ~ means to read a file, as before.  grf() provides more flexibility.
echo To see the sine column in the  previous "a.q" as a function of the angle 
echo column type: q g~a.q
echo This will display the second column as a function of the first.
echo Note: when done watching a graph press any key to continue.
pause
q g~a.q
echo To display the 3rd column as a function of the 2nd skip a column 
echo using one / and enter q g~/a.q.  A circle (ellipse) will result.
pause
q g~/a.q
echo to see just the cosine (column 3) in file "a.q" enter q p~//a.q, 
echo this will display the 3rd column as a function of the index.
pause
q p~//a.q
echo To see all columns as a function of the first column enter q ~a.q
pause
q ~a.q
echo    -14-
echo To display an output table without storing it first in a file
echo use grf().  grf() will display up to 101 points if rng() is not used.  
echo For example, to see the log of x, x running from 0.00001 to 1 through 
echo 200 points, enter q rng(0.0001,1,200)grf(log(x)) // first value 0.0001:
pause
q rng(0.0001,1,200)grf(log(x)) // The first value is 0.0001 to avoid zero
echo    -15-
echo To do statistics with data from a file use s~filespec.  As an example
echo we prepared the file B.DAT which contains school grades. 
echo Go ahead to see the contents of B.DAT.
pause
type b.dat  
echo The first 2 lines are always ignored by the program and may be used
echo as headers.  To do statistics on the 2nd column use: q s~/b.dat
pause
echo s~/b.dat
q s~/b.dat
echo To see the high correlation between column 3 (gym) and column 4 (history)
echo we use q s~//b.dat
pause
echo q s~//b.dat
q s~//b.dat
pause
echo    -16-
echo To use, say, the sum of squares in a later calculation, first save 
echo the results to the file d.q and then read the 1st column, 6th row 
echo of data with z(1,6)
q s~//b.dat>d.q
q z(1,6)~(1,1)d.q
echo as expected.
echo    -17-
echo To obtain a 4 slot distribution histogram of column 3 
echo enter hstgrm(4)~//b.dat
echo If the number of points is larger then 100 use rng(points)hstgrm(slots) 
pause
echo q hstgrm(4)~//b.dat
q hstgrm(4)~//b.dat
echo    -18-
echo r is a random variable in the range 0 to 1.  We can use r to simulate a
echo noisy sine wave.  q grf(sin(x/10)+0.3(0.5-r)) will do. 
pause
q grf(sin(x/10)+0.3(0.5-r))
echo    -19-
echo Q enables to estimate uncertainty propagation using "Monte-Carlo" 
echo methods.
echo As an example, Suppose we have the expression a+b^2, with a=3(0.2) and
echo b=4(0.1), where the values in parentheses are the uncertainties.
echo We wish to know the uncertainty of a+b^2.  The following expression
echo a=3+0.2(0.5-r)sqrt(12);b=4+0.1(0.5-r)sqrt(12);rng(1000)a+b^2
echo will generate output with the right distribution because (0.5-r)sqrt(12)
echo generates sigma=1 distribution.  The final sigma is obtained using s~.
echo rng(1000) will generate 1000 random points ensuring 3 percent error.
echo Let's do it and send the output to file a.q
pause
@echo on
q a=3+0.2(0.5-r)sqrt(12);b=4+0.1(0.5-r)sqrt(12);rng(1000)a+b^2>a.q
q s~a.q
@echo off
echo Compare the sample standard deviation to the theoretical value 0.8246...
echo.
echo    -20-
echo Let's play more with random numbers.  The expression 2(0.5-r)
echo will generate a table of random numbers +/- 1 around zero.  If we sum 
echo the echo numbers we get a "random walk".  Use Ysum to generate 
echo a summation of a file column.  The following two steps store 401 random 
echo numbers in the file "a.q" and then a graph of the "random walk" is 
echo displayed.
pause
@echo on
q rng(401)2(0.5-r)>a.q 
@echo off
echo DONE, next step:
pause
q rng(401)grf(ysum)~a.q
echo    -21-
echo To obtain the Allan variance of the random data in the previous file A.q
echo assuming 10s difference between the points use rng(401)avar(10)~a.q
echo q rng(401)avar(10)~a.q
q rng(401)avar(10)~a.q
echo To obtain the Log(tau)-Log(sigma) graph use g~//C.q assuming you stored
echo the previous result table in file C.q (This was not done and is left
echo as an exercise).
echo.
echo    -22-
echo Q provides for change of base (2-36) and bitwise operations.
echo To read a number in a base n add [n] in from of that number.
echo To display a result in a specific base n, add [n] at the end of the 
echo expression.  For example, [2]10001001000100100110101[16] will convert
echo from binary to hex bases.
pause 
echo q [2]10001001000100100110101[16]
q [2]10001001000100100110101[16]
echo to read data in a different base n from a file add [n] in front of the
echo file-name.
echo    -23-
echo Let's prepare a binary file and read it later.
echo The following expression i;2x^3[2] will write the indexed table
echo into file C.q (we use the greater than sign in front of "C.q" to 
echo save to).
pause 
@echo on
q i;2x^3[2] > c.q
@echo off
echo DONE!
echo Let's call \DOS\EDIT to see how it looks like.
pause
echo \dos\edit c.q
\dos\edit c.q
echo Now let's use it in a graph.  grf(y)~/[2]c.q will read the data in the 
echo 2nd column and plot.
pause
q grf(y)~/[2]c.q
echo    -24-
echo Bitwise operators may be put into [] to prevent confusion.
echo For example [2]100100010001000 [_and] [2]100101010[2] will perform 
echo bitwise AND and display the result in binary format.
pause
echo q [2]100100010001000 [_and] [2]100101010[2]
q [2]100100010001000 [_and] [2]100101010[2]
echo    -25-
echo You can test logical expressions.  The convention is that 0 is FALSE
echo and anything else is TRUE.
echo For example: not( (2 GT 1) and ( 3 [EQ] 7 ) ) should result with 1. 
echo We used [] otherwise the E in EQ is confused with an exponent.
pause
echo not( (2 gt 1) and ( 3 [eq] 7 ) )
q not( (2 gt 1) and ( 3 [eq] 7 ) )
echo    -26-
echo You may use this TUTOR.BAT batch file as a model for your batch files
echo to run multi-step calculations or prepare demos.
echo.
echo If an expression is longer than 128 characters you cannot run it 
echo from DOS.  To overcome this problem you may use a script file.  A script 
echo file is just a text file where you right the expressions one in a line,
echo without adding the q at the beginning of the line.
echo To run a script file add @ in front of the file name. 
echo For example, the file a.dat is a script file.  Let's see its contents:
echo type a.dat
pause
type a.dat
echo and then
echo q @a.dat
pause
q @a.dat
pause
echo    -27-
echo In the following you will see how to use the optimization 
echo parameters v(n).
echo If an expression includes a parameter v(n), (n is just the parameter's 
echo index, and should start at zero) echo the program will change the 
echo parameters' values so that the expression's echo result will approach 
echo minimum.
echo.
echo All that we need to solve an equation is to transform it to a new form
echo whose minimum is the solution.  For example, to solve x+y=3 and x-y=9
echo we can write rng(2,4)(v(0)+v(1)-3)^2+(v(0)-v(1)-9)^2 
echo We have used v(0) for x and v(1) for y.
echo The meaning of range here is different (only when v(n) is present).
echo It defines the initial values of v(n) from where to start the process.
echo Up to 30 parameters can be used, and rng() will accept all of them.
echo In this example v(0)=2 and v(1)=4.  If you use rng(2;4) instead of
echo rng(2,4), there will be more iterations.  When the program runs it 
echo displays the internal counter and the temporary result.  If you see that
echo the process is too slow you may stop it by pressing any key and try
echo with new initial values.
echo let's try it.  If the final result is zero then you have reached
echo an exact solution, otherwise the result tells you how close you are.
echo q rng(2,4)(v(0)+v(1)-3)^2+(v(0)-v(1)-9)^2
pause
q rng(2,4)(v(0)+v(1)-3)^2+(v(0)-v(1)-9)^2
pause
echo    -28-
echo To find a maximum instead of a minimum use the negative of an expression.
echo For example, to find the maximum of the parabola y=-2x^+10x-3
echo try rng(1,1)-(-2v(0)^2+10v(0)-3), If you are lucky, then the result
echo is very close to minimum.  Let's try it with v(0)=x:
echo q rng(1)-(-2v(0)^2+10v(0)-3)
pause 
q rng(1)-(-2v(0)^2+10v(0)-3)
pause
echo The value of the maximum is of course the minus of this result, 
echo that is 9.5.
pause
echo    -29-
echo Another example of what can v(n) do is to fit an equation to data.
echo We have seen already that s~FILE computes linear regression (straight
echo line fit).  Let's try here to fit a parabola.  First we prepare a 20 
echo point data file (a.q) with a parabola, for example rng(-5,10,20)x^2+x+1 
echo and then watch it with g~a.q to see how it looks like,
echo q rng(-5,10,20)x;x^2+x+1>a.q
echo q g~a.q
pause
q rng(-5,10,20)x;x^2+x+1>a.q
q g~a.q
pause
echo    -30-
echo The following expression will do the job of approaching the parabola 
echo coefficients so that the parabola fits best the data:
echo q rng(1,2,3)sum((v(0)z(1,i+1)^2+v(1)z(1,i+1)+v(2)-z(2,i+1))^2)~(1,2)a.q
echo This expression reads the first two columns of a.q, which are x and
echo the parabola.  Then the sum() function finds the sum of squares of the 
echo difference between the equation and data.  The x is presented by
echo z(1,i+1) which is the 1st column and the data by z(2,i+1), 
echo the 2nd column of a.q.  The initial values are 1,2,3 defined by rng().
echo The user might already identify this method as the least square fit.
echo let's go for it...  NOTE: this process may be slow, please be patient.
echo q rng(1,2,3)sum((v(0)z(1,i+1)^2+v(1)z(1,i+1)+v(2)-z(2,i+1))^2)~(1,2)a.q
pause
q rng(1,2,3)sum((v(0)z(1,i+1)^2+v(1)z(1,i+1)+v(2)-z(2,i+1))^2)~(1,2)a.q
echo If you did not obtain a close to zero result then you did not obtain the
echo right 1,1,1, values for the parameters.  Try again with different 
echo initial values or use rng(1;2;3) for a longer loop.  You may want 
echo to use the last values for the paramreters as initial values for 
echo the next trial.
pause
echo    -31-
echo To find more about the Q scientific Command Line Calculator 
echo and how it can help you with your applications
echo run it and read the help screens. 
echo For example, to display the cover page enter q
echo q
pause 
q
echo To display the help directory enter q ? and follow the instructions.
pause
echo q ?
q ?
echo.
echo This concludes our little tour.
echo If you have any nice ideas and would like to see them in the next
echo version, contact the author (enter q ?r to see info).
echo Enjoy.
echo The author.
