/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import de.admadic.calculator.modules.indxp.core.Pair;
import de.admadic.calculator.modules.indxp.ui.FloatingPointFormatter;
import de.admadic.ui.util.ColorGradient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class GradientCellRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    boolean on = false;
    Insets borderInsets;
    int rangeId;
    public static final int RANGE_HORZ = 0;
    public static final int RANGE_VERT = 1;
    public static final Insets BORDER_BOX = new Insets(1, 1, 1, 1);
    public static final Insets BORDER_BOTTOM = new Insets(0, 0, 2, 0);
    public static final Insets BORDER_RIGHT = new Insets(0, 0, 0, 2);
    public static final Insets BORDER_TOP = new Insets(2, 0, 0, 0);
    public static final Insets BORDER_LEFT = new Insets(0, 2, 0, 0);
    ColorGradient colorGradient;
    Hashtable<Integer, Pair<Double, Double>> cellRanges;
    FloatingPointFormatter fpf;

    public GradientCellRenderer(ColorGradient colorGradient, Insets insets, int n) {
        this.colorGradient = colorGradient;
        this.borderInsets = insets;
        this.rangeId = n;
        if (this.borderInsets == null) {
            this.borderInsets = BORDER_BOX;
        }
        this.setOpaque(true);
        this.setHorizontalAlignment(4);
        this.cellRanges = new Hashtable();
    }

    public void addCellRange(int n, double d, double d2) {
        this.addCellRange((Integer)n, (Double)d, (Double)d2);
    }

    public void addCellRange(Integer n, Double d, Double d2) {
        this.cellRanges.put(n, new Pair<Double, Double>(d, d2));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Double d;
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component == null) {
            // empty if block
        }
        String string = (d = (Double)object) != null ? (this.fpf != null ? this.fpf.format(d) : String.format("%f", d)) : "./.";
        this.setText(string);
        if (d == null || !this.isOn()) {
            return this;
        }
        int n3 = this.rangeId == 0 ? n : n2;
        if (!this.cellRanges.containsKey(n3)) {
            return this;
        }
        double d2 = this.normalizeForCellId(d, n3);
        Color color = this.colorGradient.calculateColorAtPos(d2);
        Border border = this.getBorder();
        MatteBorder matteBorder = BorderFactory.createMatteBorder(this.borderInsets.top, this.borderInsets.left, this.borderInsets.bottom, this.borderInsets.right, color);
        border = BorderFactory.createCompoundBorder(border, matteBorder);
        this.setBorder(border);
        return this;
    }

    private double normalizeForCellId(double d, int n) {
        Integer n2 = n;
        if (this.cellRanges.containsKey(n2)) {
            double d2;
            Pair<Double, Double> pair = this.cellRanges.get(n2);
            if (pair.getFirst() == null || pair.getSecond() == null) {
                return 0.5;
            }
            double d3 = pair.getFirst();
            if (d3 == (d2 = pair.getSecond().doubleValue())) {
                return 0.5;
            }
            return (d - d3) / (d2 - d3);
        }
        return 0.5;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean bl) {
        this.on = bl;
    }

    public void clearRanges() {
        this.cellRanges.clear();
    }

    public void setFloatingPointFormatter(FloatingPointFormatter floatingPointFormatter) {
        this.fpf = floatingPointFormatter;
    }
}

