/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.indxp.core.DataEvent;
import de.admadic.calculator.modules.indxp.core.DataEventDispatcher;
import de.admadic.calculator.modules.indxp.core.DataEventListener;
import de.admadic.calculator.modules.indxp.core.DataEventServer;
import de.admadic.calculator.modules.indxp.core.DataItemStatus;
import de.admadic.calculator.modules.indxp.core.Factor;
import de.admadic.calculator.modules.indxp.core.FactorsTableModel;
import de.admadic.calculator.modules.indxp.ui.DataPanel;
import de.admadic.ui.util.VetoableToggleButtonModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactorsPanel
extends DataPanel
implements ActionListener,
DataEventListener {
    JTable tableFactors;
    JScrollPane scrollFactors;
    FactorsTableModel tableModelFactors;
    JPanel panelButtons;
    JButton btnAdd;
    JButton btnRemove;
    JButton btnUp;
    JButton btnDown;
    JToggleButton btnLock;
    static final String CMD_ADD = "factor.add";
    static final String CMD_REMOVE = "factor.remove";
    static final String CMD_UP = "factor.up";
    static final String CMD_DOWN = "factor.down";
    static final String CMD_LOCK = "factor.lock";
    ArrayList<Factor> factorsLink;
    private static final long serialVersionUID = 1L;

    protected void initContents(boolean bl) {
        FormLayout formLayout = bl ? new FormLayout("0px, p:grow, 5px, p, 12px", "0px, p:grow, 0px") : new FormLayout("12px, p:grow, 5px, p, 12px", "12px, p:grow, 12px");
        this.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.tableModelFactors = new FactorsTableModel();
        this.tableFactors = new JTable();
        this.tableFactors.setModel(this.tableModelFactors);
        this.scrollFactors = new JScrollPane();
        this.add((Component)this.scrollFactors, cellConstraints.xy(2, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.scrollFactors.setViewportView(this.tableFactors);
        this.scrollFactors.setHorizontalScrollBarPolicy(32);
        this.scrollFactors.setVerticalScrollBarPolicy(22);
        this.tableFactors.setPreferredScrollableViewportSize(new Dimension(300, 75));
        this.panelButtons = new JPanel();
        this.add((Component)this.panelButtons, cellConstraints.xy(4, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        FormLayout formLayout2 = new FormLayout("0px, p, 0px", "0px, p, 5px, p, 5px, p, 5px, p, 5px, p, 0px");
        this.panelButtons.setLayout((LayoutManager)formLayout2);
        CellConstraints cellConstraints2 = new CellConstraints();
        this.btnAdd = new JButton("Add");
        this.btnAdd.setActionCommand(CMD_ADD);
        this.btnAdd.addActionListener(this);
        this.btnRemove = new JButton("Del");
        this.btnRemove.setActionCommand(CMD_REMOVE);
        this.btnRemove.addActionListener(this);
        this.btnUp = new JButton("Up");
        this.btnUp.setActionCommand(CMD_UP);
        this.btnUp.addActionListener(this);
        this.btnDown = new JButton("Down");
        this.btnDown.setActionCommand(CMD_DOWN);
        this.btnDown.addActionListener(this);
        this.btnLock = new JToggleButton("Lock");
        this.btnLock.setActionCommand(CMD_LOCK);
        VetoableToggleButtonModel vetoableToggleButtonModel = new VetoableToggleButtonModel();
        vetoableToggleButtonModel.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                if (!string.equals("selected")) {
                    return;
                }
                if (propertyChangeEvent.getSource() != FactorsPanel.this.btnLock.getModel()) {
                    return;
                }
                Boolean bl = (Boolean)propertyChangeEvent.getOldValue();
                Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                if (!FactorsPanel.this.allowLockOp(bl, bl2)) {
                    throw new PropertyVetoException(string, propertyChangeEvent);
                }
            }
        });
        this.btnLock.setModel((ButtonModel)vetoableToggleButtonModel);
        this.btnLock.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                FactorsPanel.this.doLock(bl);
            }
        });
        this.panelButtons.add((Component)this.btnAdd, cellConstraints2.xy(2, 2));
        this.panelButtons.add((Component)this.btnRemove, cellConstraints2.xy(2, 4));
        this.panelButtons.add((Component)this.btnUp, cellConstraints2.xy(2, 6));
        this.panelButtons.add((Component)this.btnDown, cellConstraints2.xy(2, 8));
        this.panelButtons.add((Component)this.btnLock, cellConstraints2.xy(2, 10));
    }

    public FactorsPanel() {
        this.initContents(false);
    }

    public FactorsPanel(boolean bl) {
        this.initContents(bl);
    }

    public void linkData(ArrayList<Factor> arrayList) {
        this.factorsLink = arrayList;
        this.tableModelFactors.setData(arrayList);
    }

    @Override
    public void setDataEventDispatcher(DataEventDispatcher dataEventDispatcher) {
        super.setDataEventDispatcher(dataEventDispatcher);
        this.tableModelFactors.setDataEventDispatcher(dataEventDispatcher);
    }

    @Override
    public void setDataEventServer(DataEventServer dataEventServer) {
        if (this.getDataEventServer() != null) {
            this.getDataEventServer().removeDataListener(this.tableModelFactors);
            this.getDataEventServer().removeDataListener(this);
        }
        super.setDataEventServer(dataEventServer);
        if (this.getDataEventServer() != null) {
            this.getDataEventServer().addDataListener(this.tableModelFactors);
            this.getDataEventServer().addDataListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_ADD)) {
            this.doAdd();
        } else if (string.equals(CMD_REMOVE)) {
            this.doRemove();
        } else if (string.equals(CMD_UP)) {
            this.doUp();
        } else if (string.equals(CMD_DOWN)) {
            this.doDown();
        }
    }

    private void doAdd() {
        int n = this.tableFactors.getSelectedRow();
        Factor factor = new Factor();
        if (n < 0) {
            this.factorsLink.add(factor);
        } else {
            this.factorsLink.add(n, factor);
        }
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 1);
        }
    }

    private void doRemove() {
        int n = this.tableFactors.getSelectedRow();
        if (n < 0) {
            JOptionPane.showMessageDialog(null, "No factor selected.\nYou must select a factor which shall be removed.", "No factor selected", 0);
            return;
        }
        Factor factor = this.factorsLink.get(n);
        int n2 = JOptionPane.showConfirmDialog(null, "Do you want to delete the following factor?\n" + factor.getName() + ", " + factor.getEntity() + " [" + factor.getUnit() + "], " + factor.getValueHigh() + ", " + factor.getValueLow(), "Confirm removal of factor", 0);
        if (n2 != 0) {
            return;
        }
        this.factorsLink.remove(n);
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 1);
        }
    }

    private void doUp() {
        int n = this.tableFactors.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (n < 1) {
            return;
        }
        Collections.swap(this.factorsLink, n, n - 1);
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 2);
        }
        this.tableFactors.setRowSelectionInterval(n - 1, n - 1);
    }

    private void doDown() {
        int n = this.tableFactors.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (n >= this.factorsLink.size() - 1) {
            return;
        }
        Collections.swap(this.factorsLink, n, n + 1);
        if (this.getDataEventDispatcher() != null) {
            this.getDataEventDispatcher().notifyEvent(this, 2);
        }
        this.tableFactors.setRowSelectionInterval(n + 1, n + 1);
    }

    protected void doLock(boolean bl) {
        DataItemStatus dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(0);
        DataPanel.enableComponents((Container)this.panelButtons, !bl, this.btnLock);
        this.tableModelFactors.setLocked(bl);
        if (bl) {
            dataItemStatus.lock(3);
        } else {
            dataItemStatus.unlock(3);
        }
    }

    protected boolean allowLockOp(boolean bl, boolean bl2) {
        int n;
        DataItemStatus dataItemStatus;
        return this.getDataItemStatusServer() == null || !(dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(0)).isLocked() || !bl || bl2 || (n = JOptionPane.showConfirmDialog(null, "Are you sure, that you want to unlock the data?\nIf you unlock, the data may be changed which may\ninfluence subsequent calculations.\nThe results of these calculations may then be invalid.", "Confirm data unlock", 0)) != 1;
    }

    @Override
    public void dataEventSignalled(DataEvent dataEvent) {
        if (dataEvent.getSource() == this) {
            return;
        }
        if ((dataEvent.getMask() & 1) != 0 && this.getDataItemStatusServer() != null) {
            DataItemStatus dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(0);
            this.btnLock.setSelected(dataItemStatus.isLocked());
        }
    }
}

