/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.core;

import de.admadic.calculator.modules.indxp.core.FactorInteraction;
import de.admadic.calculator.modules.indxp.core.MathHelper;
import de.admadic.calculator.modules.indxp.core.Run;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LevelAnalysis {
    ArrayList<FactorInteraction> factorInteractionsLink;
    ArrayList<Run> runsLink;
    String name;
    public static final int RES_LEV_HIGH = 0;
    public static final int RES_LEV_LOW = 1;
    public static final int RES_LEV_DELTA = 2;
    Hashtable<FactorInteraction, Double> levelHighResults;
    Hashtable<FactorInteraction, Double> levelLowResults;
    Hashtable<FactorInteraction, Double> levelResultsDelta;

    public LevelAnalysis(ArrayList<FactorInteraction> arrayList, ArrayList<Run> arrayList2) {
        this.factorInteractionsLink = arrayList;
        this.runsLink = arrayList2;
        this.levelHighResults = new Hashtable();
        this.levelLowResults = new Hashtable();
        this.levelResultsDelta = new Hashtable();
    }

    public abstract Double getValue(int var1);

    public void calculate() {
        this.levelHighResults.clear();
        this.levelLowResults.clear();
        this.levelResultsDelta.clear();
        this.calculateAvgsAtLevel(this.levelHighResults, 1);
        this.calculateAvgsAtLevel(this.levelLowResults, -1);
        this.calculateDelta();
    }

    private void calculateAvgsAtLevel(Hashtable<FactorInteraction, Double> hashtable, Integer n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (FactorInteraction factorInteraction : this.factorInteractionsLink) {
            arrayList.clear();
            for (int i = 0; i < this.runsLink.size(); ++i) {
                Run run = this.runsLink.get(i);
                Integer n2 = run.getFiLevel(factorInteraction);
                if (n2.intValue() != n.intValue()) continue;
                arrayList.add(this.getValue(i));
            }
            Double d = MathHelper.calcAvg(arrayList);
            hashtable.put(factorInteraction, d);
        }
    }

    private void calculateDelta() {
        for (FactorInteraction factorInteraction : this.factorInteractionsLink) {
            Double d = null;
            Double d2 = null;
            if (this.levelHighResults.containsKey(factorInteraction)) {
                d = this.levelHighResults.get(factorInteraction);
            }
            if (this.levelLowResults.containsKey(factorInteraction)) {
                d2 = this.levelLowResults.get(factorInteraction);
            }
            if (d == null || d2 == null) continue;
            Double d3 = d - d2;
            this.levelResultsDelta.put(factorInteraction, d3);
        }
    }

    public Double getHighValue(FactorInteraction factorInteraction) {
        return this.levelHighResults.get(factorInteraction);
    }

    public Double getLowValue(FactorInteraction factorInteraction) {
        return this.levelLowResults.get(factorInteraction);
    }

    public Double getDeltaValue(FactorInteraction factorInteraction) {
        return this.levelResultsDelta.get(factorInteraction);
    }

    public Double getStatValue(int n, FactorInteraction factorInteraction) {
        Hashtable<FactorInteraction, Double> hashtable;
        switch (n) {
            case 0: {
                hashtable = this.levelHighResults;
                break;
            }
            case 1: {
                hashtable = this.levelLowResults;
                break;
            }
            case 2: {
                hashtable = this.levelResultsDelta;
                break;
            }
            default: {
                throw new Error("invalid selector passed for getStatValue");
            }
        }
        return hashtable.get(factorInteraction);
    }

    public void setStatValue(int n, FactorInteraction factorInteraction, Double d) {
        Hashtable<FactorInteraction, Double> hashtable;
        switch (n) {
            case 0: {
                hashtable = this.levelHighResults;
                break;
            }
            case 1: {
                hashtable = this.levelLowResults;
                break;
            }
            case 2: {
                hashtable = this.levelResultsDelta;
                break;
            }
            default: {
                throw new Error("invalid selector passed for setStatValue");
            }
        }
        if (d == null) {
            if (hashtable.containsKey(factorInteraction)) {
                hashtable.remove(factorInteraction);
            }
        } else {
            hashtable.put(factorInteraction, d);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void resetData() {
        this.levelHighResults.clear();
        this.levelLowResults.clear();
        this.levelResultsDelta.clear();
    }

    public Double[] getRange(int n) {
        Hashtable<FactorInteraction, Double> hashtable;
        Double[] doubleArray = new Double[]{null, null};
        switch (n) {
            case 0: {
                hashtable = this.levelHighResults;
                break;
            }
            case 1: {
                hashtable = this.levelLowResults;
                break;
            }
            case 2: {
                hashtable = this.levelResultsDelta;
                break;
            }
            default: {
                throw new Error("invalid selector passed for getRange");
            }
        }
        for (Double d : hashtable.values()) {
            if (doubleArray[0] == null || d < doubleArray[0]) {
                doubleArray[0] = d;
            }
            if (doubleArray[1] != null && !(d > doubleArray[1])) continue;
            doubleArray[1] = d;
        }
        return doubleArray;
    }
}

