/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.core;

import de.admadic.calculator.modules.indxp.core.DataEvent;
import de.admadic.calculator.modules.indxp.core.DataEventDispatcher;
import de.admadic.calculator.modules.indxp.core.DataEventListener;
import de.admadic.calculator.modules.indxp.core.DataEventServer;
import de.admadic.calculator.modules.indxp.core.DataItemStatus;
import de.admadic.calculator.modules.indxp.core.DataItemStatusServer;
import de.admadic.calculator.modules.indxp.core.ExpResults;
import de.admadic.calculator.modules.indxp.core.Factor;
import de.admadic.calculator.modules.indxp.core.FactorInteraction;
import de.admadic.calculator.modules.indxp.core.FactorInteractionBuilder;
import de.admadic.calculator.modules.indxp.core.LevelAnalysisSigma;
import de.admadic.calculator.modules.indxp.core.LevelAnalysisYAvg;
import de.admadic.calculator.modules.indxp.core.Pair;
import de.admadic.calculator.modules.indxp.core.Run;
import de.admadic.calculator.modules.indxp.core.RunsBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InDXpData
implements DataEventDispatcher,
DataEventServer,
DataItemStatusServer,
DataEventListener {
    static final boolean DBG = false;
    boolean dirty;
    File fileName;
    ArrayList<Factor> factors;
    ArrayList<FactorInteraction> factorInteractions;
    ArrayList<Run> runs;
    int replicateCount = 3;
    ArrayList<ExpResults> expResults;
    LevelAnalysisYAvg levelAnalysisYAvg;
    LevelAnalysisSigma levelAnalysisSigma;
    Hashtable<Integer, DataItemStatus> dataItemStatus;
    FactorInteractionBuilder factorInteractionBuilder;
    RunsBuilder runsBuilder;
    EventListenerList listenerList = new EventListenerList();

    public InDXpData() {
        this.factors = new ArrayList();
        this.factorInteractions = new ArrayList();
        this.runs = new ArrayList();
        this.expResults = new ArrayList();
        this.levelAnalysisYAvg = new LevelAnalysisYAvg(this.factorInteractions, this.runs, this.expResults);
        this.levelAnalysisSigma = new LevelAnalysisSigma(this.factorInteractions, this.runs, this.expResults);
        this.factorInteractionBuilder = new FactorInteractionBuilder(this.factors, this.factorInteractions);
        this.runsBuilder = new RunsBuilder(this.factorInteractions, this.factors, this.runs);
        this.dataItemStatus = new Hashtable();
        this.dataItemStatus.put(0, new DataItemStatus());
        this.dataItemStatus.put(1, new DataItemStatus());
        this.dataItemStatus.put(2, new DataItemStatus());
        this.dataItemStatus.put(3, new DataItemStatus());
        this.setDirty(false);
        this.addDataListener(this);
    }

    public void resetData() {
        this.factors.clear();
        this.factorInteractions.clear();
        this.runs.clear();
        this.expResults.clear();
        this.levelAnalysisYAvg.resetData();
        this.levelAnalysisSigma.resetData();
        this.dataItemStatus.get(0).reset();
        this.dataItemStatus.get(1).reset();
        this.dataItemStatus.get(2).reset();
        this.dataItemStatus.get(3).reset();
        this.notifyEvent(this, 1);
        this.notifyEvent(this, 4);
        this.notifyEvent(this, 16);
        this.notifyEvent(this, 64);
        this.notifyEvent(this, 256);
        this.setDirty(false);
    }

    @Override
    public DataItemStatus getDataItemStatus(int n) {
        if (!this.dataItemStatus.containsKey(n)) {
            return null;
        }
        return this.dataItemStatus.get(n);
    }

    public void setDataItemStatus(int n, DataItemStatus dataItemStatus) {
        this.dataItemStatus.put(n, dataItemStatus);
    }

    public FactorInteractionBuilder getFactorInteractionBuilder() {
        return this.factorInteractionBuilder;
    }

    public RunsBuilder getRunsBuilder() {
        return this.runsBuilder;
    }

    public void addFactor(Factor factor) {
        this.factors.add(factor);
        this.fireDataEvent(null, 1);
    }

    public void removeFactor(Factor factor) {
        this.factors.remove(factor);
        this.fireDataEvent(null, 1);
    }

    public Factor getFactor(String string) {
        for (Factor factor : this.factors) {
            String string2 = factor.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return factor;
        }
        return null;
    }

    public ArrayList<Factor> getFactorList() {
        return this.factors;
    }

    public ArrayList<FactorInteraction> getFactorInteractionList() {
        return this.factorInteractions;
    }

    public ArrayList<Run> getRunList() {
        return this.runs;
    }

    public ArrayList<ExpResults> getExpResultsList() {
        return this.expResults;
    }

    public LevelAnalysisSigma getLevelAnalysisSigma() {
        return this.levelAnalysisSigma;
    }

    public LevelAnalysisYAvg getLevelAnalysisYAvg() {
        return this.levelAnalysisYAvg;
    }

    public void createFullFactorialInteractions() {
        this.factorInteractionBuilder.createFullFactorialInteractions();
        this.fireDataEvent(null, 4);
    }

    public void createRuns() {
        ArrayList<Pair<Factor, Integer>> arrayList = new ArrayList<Pair<Factor, Integer>>();
        this.runs.clear();
        this.createRunAtLevel(arrayList, 0, this.factors.size());
        this.fireDataEvent(null, 16);
    }

    private void createRunAtLevel(ArrayList<Pair<Factor, Integer>> arrayList, int n, int n2) {
        if (arrayList.size() == n2) {
            Run run = new Run(this.factors, this.factorInteractions);
            for (Pair<Factor, Integer> pair : arrayList) {
                run.setLevel(pair.getFirst(), pair.getSecond());
            }
            run.updateFactorInteractionLevels();
            run.setId(String.valueOf(this.runs.size() + 1));
            this.runs.add(run);
        } else {
            arrayList.add(new Pair<Factor, Integer>(this.factors.get(n), -1));
            this.createRunAtLevel(arrayList, n + 1, n2);
            arrayList.remove(arrayList.size() - 1);
            arrayList.add(new Pair<Factor, Integer>(this.factors.get(n), 1));
            this.createRunAtLevel(arrayList, n + 1, n2);
            arrayList.remove(arrayList.size() - 1);
        }
    }

    public void createExpResults() {
        this.expResults.clear();
        for (int i = 0; i < this.runs.size(); ++i) {
            this.expResults.add(new ExpResults(this.replicateCount));
        }
        this.fireDataEvent(null, 64);
    }

    public void createRandomResults() {
        for (ExpResults expResults : this.expResults) {
            for (int i = 0; i < expResults.getReplicateCount(); ++i) {
                expResults.setResult(i, (double)Math.round(Math.random() * 100.0) / 20.0);
            }
        }
        this.fireDataEvent(null, 128);
    }

    public void calculateYS() {
        for (ExpResults expResults : this.expResults) {
            expResults.calculate();
        }
        this.fireDataEvent(null, 128);
    }

    public void calculateLA() {
        this.levelAnalysisYAvg.calculate();
        this.levelAnalysisSigma.calculate();
        this.fireDataEvent(null, 512);
    }

    @Override
    public void addDataListener(DataEventListener dataEventListener) {
        this.listenerList.add(DataEventListener.class, dataEventListener);
    }

    @Override
    public void removeDataListener(DataEventListener dataEventListener) {
        this.listenerList.remove(DataEventListener.class, dataEventListener);
    }

    protected void fireDataEvent(Object object, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        DataEvent dataEvent = null;
        if (object == null) {
            object = this;
        }
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataEventListener.class) continue;
            if (dataEvent == null) {
                dataEvent = new DataEvent(object, n);
            }
            ((DataEventListener)objectArray[i + 1]).dataEventSignalled(dataEvent);
        }
    }

    @Override
    public void notifyEvent(Object object, int n) {
        this.fireDataEvent(object, n);
    }

    @Override
    public void dataEventSignalled(DataEvent dataEvent) {
        if (dataEvent.getMask() != 0) {
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public File getFileName() {
        return this.fileName;
    }

    public void setFileName(File file) {
        this.fileName = file;
    }
}

