/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp;

import de.admadic.calculator.modules.indxp.InDXpItf;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InDXpActions {
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    Vector<Action> actions = new Vector();

    public void initialize(InDXpItf inDXpItf) {
        this.actions.add(new SingleButtonAction(inDXpItf));
        this.actions.add(new ShowAction(inDXpItf));
        this.actions.add(new HideAction(inDXpItf));
        this.actions.add(new SettingsAction(inDXpItf));
        this.actions.add(new RegisterAction(inDXpItf));
        this.actions.add(new AboutAction(inDXpItf));
    }

    public Vector<Action> getActions() {
        return this.actions;
    }

    public Action[] getActionArray() {
        Action[] actionArray = new Action[this.actions.size()];
        actionArray = this.actions.toArray(actionArray);
        return actionArray;
    }

    public ImageIcon loadIcon(String string) {
        String string2 = "de/admadic/calculator/modules/indxp/res/" + string;
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            if (this.logger != null) {
                this.logger.warning("could not get url for " + string2 + " (icon name = " + string + ")");
            }
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image == null) {
            if (this.logger != null) {
                this.logger.warning("could not get image for " + uRL.toString() + " (icon name = " + string + ")");
            }
            return null;
        }
        return new ImageIcon(image);
    }

    public class AboutAction
    extends ModuleAction {
        private static final long serialVersionUID = 1L;

        public AboutAction(InDXpItf inDXpItf) {
            super(inDXpItf);
            this.putValue("Name", "About");
            this.putValue("ShortDescription", "About the InDXp Module");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().cmdAbout();
        }
    }

    public class RegisterAction
    extends ModuleAction {
        private static final long serialVersionUID = 1L;

        public RegisterAction(InDXpItf inDXpItf) {
            super(inDXpItf);
            this.putValue("Name", "Register");
            this.putValue("ShortDescription", "Register the InDXp Module");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().cmdRegister();
        }
    }

    public class SettingsAction
    extends ModuleAction {
        private static final long serialVersionUID = 1L;

        public SettingsAction(InDXpItf inDXpItf) {
            super(inDXpItf);
            this.putValue("Name", "Settings");
            this.putValue("ShortDescription", "Change Settings of InDXp Module");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().cmdSettings();
        }
    }

    public class HideAction
    extends ModuleAction {
        private static final long serialVersionUID = 1L;

        public HideAction(InDXpItf inDXpItf) {
            super(inDXpItf);
            this.putValue("Name", "Hide");
            this.putValue("ShortDescription", "Hide InDXp Window");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().cmdHide();
        }
    }

    public class ShowAction
    extends ModuleAction {
        private static final long serialVersionUID = 1L;

        public ShowAction(InDXpItf inDXpItf) {
            super(inDXpItf);
            this.putValue("Name", "Show");
            this.putValue("ShortDescription", "Show InDXp Window");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().cmdShow();
        }
    }

    public class SingleButtonAction
    extends ModuleAction {
        private static final long serialVersionUID = 1L;

        public SingleButtonAction(InDXpItf inDXpItf) {
            super(inDXpItf);
            this.putValue("Name", "");
            this.putValue("ShortDescription", "Module 'Industrial Designed Experiments'");
            this.putValue("SmallIcon", InDXpActions.this.loadIcon("icon-16.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().cmdSingleButton();
        }
    }

    public static abstract class ModuleAction
    extends AbstractAction {
        InDXpItf itf;

        public ModuleAction(InDXpItf inDXpItf) {
            this.setItf(inDXpItf);
        }

        public InDXpItf getItf() {
            return this.itf;
        }

        public void setItf(InDXpItf inDXpItf) {
            this.itf = inDXpItf;
        }
    }
}

