/***************************************************************************
*   xmstest2.c                                                             *
*   MODULE:  XMSIF                                                         *
*   OS:      DOS                                                           *
*   VERSION: 1.0                                                           *
*   DATE:    12/08/91                                                      *
*                                                                          *
*   Copyright (c) 1991 James W. Birdsall. All Rights Reserved.             *
*                                                                          *
*   Requires xmsif.h, testutil.h, and xmstest.h to compile.                *
*   Compiles under Borland C++ 2.0, Turbo C 2.0, or MSC 6.00A.             *
*                                                                          *
*   Regression test and example for XMSIF. See XMSTEST.C for more detail.  *
*                                                                          *
***************************************************************************/

/*
** system includes <>
*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>


/*
** custom includes ""
*/

#include "xmsif.h"
#include "xmstest.h"

#include "testutil.h"


/*
** local #defines
*/

/*
** misc: copyright strings, version macros, etc.
*/

/*
** typedefs
*/

/*
** global variables
*/

extern int testno;
extern char *gblmsg;


/*
** static globals
*/

/*
** function prototypes
*/

static void do_ncopy2_tests(void);


/*
** functions
*/


/***************************************************************************
*   FUNCTION: DO_COPY_TESTS                                                *
*                                                                          *
*   DESCRIPTION:                                                           *
*                                                                          *
*       Dispatcher function for copy test functions.                       *
*                                                                          *
*   ENTRY:                                                                 *
*                                                                          *
*       None.                                                              *
*                                                                          *
*   EXIT:                                                                  *
*                                                                          *
*       Void.                                                              *
*                                                                          *
*   CONSTRAINTS/SIDE EFFECTS:                                              *
*                                                                          *
***************************************************************************/
void do_copy_tests(void)
{
    do_ncopy1_tests();
    do_ncopy2_tests();
    do_icopy_tests();

    return;
} /* end of do_copy_tests() */


/***************************************************************************
*   FUNCTION: DO_NCOPY2_TESTS  (STATIC)                                    *
*                                                                          *
*   DESCRIPTION:                                                           *
*                                                                          *
*       Tests normal copy functions (_XMMcopy() and macros).               *
*                                                                          *
*   ENTRY:                                                                 *
*                                                                          *
*       None.                                                              *
*                                                                          *
*   EXIT:                                                                  *
*                                                                          *
*       Void.                                                              *
*                                                                          *
*   CONSTRAINTS/SIDE EFFECTS:                                              *
*                                                                          *
***************************************************************************/
static void do_ncopy2_tests(void)
{
    int handle;
    unsigned char far *realbuf;
    unsigned char far *guard1, far *guard2, far *guard3;
    unsigned char far *testbuf;
    unsigned char far *testbuf2;
    int status;
    unsigned long start, stop, total;
    unsigned char huge *temp;
    unsigned long loop;

    /* first, allocate some XMS to test with */
    handle = XMMalloc(MINFREE);
    weirdcodechk("XMMalloc", 0, (void far *) NULL, 0, 0);

    /* next, allocate a conventional memory buffer */
    realbuf = (unsigned char far *) LMALLOC((MINFREE/1024L) + 3);
    if (realbuf == (unsigned char far *) NULL)
    {
        printf("Can't allocate conventional buffer. Aborting.\n");
        XMMfree(handle);
        exit(3);
    }

    /* set up guard zones, etc. */
    guard1 = realbuf;
    FMEMSET(guard1, GUARDVAL, 1024);
    testbuf = (unsigned char far *) normptr(guard1 + 1024);
    guard2 = (unsigned char far *) normptr(testbuf + HALFLEN);
    FMEMSET(guard2, GUARDVAL, 1024);
    testbuf2 = (unsigned char far *) normptr(guard2 + 1024);
    guard3 = (unsigned char far *) normptr(testbuf2 + HALFLEN);
    FMEMSET(guard3, GUARDVAL, 1024);

    /* set up patterns */
    farincwordfill(testbuf, HALFLEN, 0);
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);


    /*
    ** Now, try various copies to EMB, then copy HALFLEN of EMB back to
    ** testbuf2 for checking.
    */
    gblmsg = "  COPY TESTS CONVENTIONAL-EMB";

    /* try an even-length copy from offset 0 to offset 0 */
    TESTHEADER();
    printf("XMMcopyto(): even-length copy from offset 0 to offset 0.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(50, testbuf, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    SRCWORDCHECK(testbuf, HALFLEN);
    GUARDCHECK(handle);
    CPYWORDCHECK(testbuf2, 50);
    ZEROCHECK((testbuf2 + 50), (HALFLEN - 50));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try an even-length copy from offset 0 to arbitrary offset */
    TESTHEADER();
    printf("XMMcopyto(): even-length copy from offset 0 to arbitrary offset.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(50, testbuf, handle, 477L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, 477);
    MEMCMP(testbuf, (testbuf2 + 477), 50);
    ZEROCHECK((testbuf2 + 477 + 50), ((HALFLEN - 477) - 50));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try an even-length copy from offset 0 to just before the end */
    TESTHEADER();
    printf("XMMcopyto(): even-length copy from offset 0 to just before end.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(50, testbuf, handle, (HALFLEN - 50));
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, (HALFLEN - 50));
    CPYWORDCHECK((testbuf2 + HALFLEN - 50), 50);
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try an even-length copy from arbitrary offset to arbitrary offset */
    TESTHEADER();
    printf("XMMcopyto(): even-length copy from arbitrary offset to ");
    printf("arbitrary offset.\nShould succeed.");
    status = XMMcopyto(50, (testbuf + 384), handle, 33333L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, 33333U);
    MEMCMP((testbuf + 384), (testbuf2 + 33333U), 50);
    ZEROCHECK((testbuf2 + 33333U + 50), ((HALFLEN - 33333U) - 50));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try an even-length copy from just before the end to arbitrary offset */
    TESTHEADER();
    printf("XMMcopyto(): even-length copy from just before end to arbitrary.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(50, (testbuf+HALFLEN-50), handle, 7676L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, 7676);
    MEMCMP((testbuf + HALFLEN - 50), (testbuf2 + 7676), 50);
    ZEROCHECK((testbuf2 + 7676 + 50), ((HALFLEN - 7676) - 50));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);


    /* try an odd-length copy from offset 0 to offset 0 */
    TESTHEADER();
    printf("XMMcopyto(): odd-length copy from offset 0 to offset 0.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(111, testbuf, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    MEMCMP(testbuf, testbuf2, 111);
    ZEROCHECK((testbuf2 + 111), (HALFLEN - 111));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try an odd-length copy from offset 0 to offset misc */
    TESTHEADER();
    printf("XMMcopyto(): odd-length copy from offset 0 to arbitrary offset.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(111, testbuf, handle, 477L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, 477);
    MEMCMP(testbuf, (testbuf2 + 477), 111);
    ZEROCHECK((testbuf2 + 477 + 111), ((HALFLEN - 477) - 111));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try an odd-length copy from offset 0 to just before the end */
    TESTHEADER();
    printf("XMMcopyto(): odd-length copy from offset 0 to just before end.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(111, testbuf, handle, (HALFLEN - 111));
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, (HALFLEN - 111));
    MEMCMP(testbuf, (testbuf2 + HALFLEN - 111), 111);
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try an odd-length copy from arbitrary offset to arbitrary offset */
    TESTHEADER();
    printf("XMMcopyto(): odd-length copy from arbitrary offset to ");
    printf("arbitrary offset.\nShould succeed.\n");
    status = XMMcopyto(111, (testbuf + 384), handle, 33333L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, 33333U);
    MEMCMP((testbuf + 384), (testbuf2 + 33333U), 111);
    ZEROCHECK((testbuf2 + 33333U + 111), ((HALFLEN - 33333U) - 111));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try an odd-length copy from just before the end to arbitrary offset */
    TESTHEADER();
    printf("XMMcopyto(): odd-length copy from just before end to arbitrary.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(111, (testbuf + HALFLEN - 111), handle, 7676L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, 7676);
    MEMCMP((testbuf + HALFLEN - 111), (testbuf2 + 7676), 111);
    ZEROCHECK((testbuf2 + 7676 + 111), ((HALFLEN - 7676) - 111));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);


    /* try a one-byte copy from offset 0 to offset 0 */
    TESTHEADER();
    printf("XMMcopyto(): one-byte copy from offset 0 to offset 0.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(1L, testbuf, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    MEMCMP(testbuf, testbuf2, 1);
    ZEROCHECK((testbuf2 + 1), (HALFLEN - 1));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try a one-byte copy from offset 0 to offset misc */
    TESTHEADER();
    printf("XMMcopyto(): one-byte copy from offset 0 to arbitrary offset.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(1L, testbuf, handle, 477L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, 477);
    MEMCMP(testbuf, (testbuf2 + 477), 1);
    ZEROCHECK((testbuf2 + 477 + 1), ((HALFLEN - 477) - 1));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try a one-byte copy from offset 0 to just before the end */
    TESTHEADER();
    printf("XMMcopyto(): one-byte copy from offset 0 to just before end.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(1L, testbuf, handle, (HALFLEN - 1));
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, (HALFLEN - 1));
    MEMCMP(testbuf, (testbuf2 + HALFLEN - 1), 1);
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try a one-byte copy from arbitrary offset to arbitrary offset */
    TESTHEADER();
    printf("XMMcopyto(): one-byte copy from arbitrary offset to ");
    printf("arbitrary offset.\nShould succeed.");
    status = XMMcopyto(1L, (testbuf + 384), handle, 33333L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, 33333U);
    MEMCMP((testbuf + 384), (testbuf2 + 33333U), 1);
    ZEROCHECK((testbuf2 + 33333U + 1), ((HALFLEN - 33333U) - 1));
    TESTTAILER();

    /* restore destination pattern */
    FMEMSET(testbuf2, 0, HALFLEN);
    status = XMMcopyto(HALFLEN, testbuf2, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);

    /* try a one-byte copy from just before the end to arbitrary offset */
    TESTHEADER();
    printf("XMMcopyto(): one-byte copy from just before end to arbitrary.\n");
    printf("Should succeed.\n");
    status = XMMcopyto(1L, (testbuf + HALFLEN - 1), handle, 7676L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    status = XMMcopyfrom(HALFLEN, handle, 0L, testbuf2);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    GUARDCHECK(handle);
    SRCWORDCHECK(testbuf, HALFLEN);
    ZEROCHECK(testbuf2, 7676);
    MEMCMP((testbuf + HALFLEN - 1), (testbuf2 + 7676), 1);
    ZEROCHECK((testbuf2 + 7676 + 1), ((HALFLEN - 7676) - 1));
    TESTTAILER();


    /*
    ** Try some copies with bad offsets, etc., just to make sure _XMMcopy()
    ** is passing along error data from driver OK. _XMMcopy() does no
    ** size checking on its own because it has no idea what the size of
    ** the block is.
    */
    gblmsg = "  COPY TESTS CONVENTIONAL-EMB ERRORS";

    /* try a copy to a bad offset */
    TESTHEADER();
    printf("XMMcopyto(): copying to bad offset.\n");
    printf("Should fail.\n");
    status = XMMcopyto(50L, testbuf, handle, (MINFREE + 1L));
    nofailcheck("XMMcopyto()", status, (void far *) realbuf, handle, 0);
    weirdretchk("XMMcopyto()", status, (void far *) realbuf, handle, 0);
    weirdcodechk("XMMcopyto()", XMM_BADDESTOFF, (void far *) realbuf,handle,0);
    SRCWORDCHECK(testbuf, HALFLEN);
    TESTTAILER();

    /* try a copy with an excessively long length */
    TESTHEADER();
    printf("XMMcopyto(): copying a block that runs off end of EMB.\n");
    printf("Should fail.\n");
    status = XMMcopyto((MINFREE + 1L), realbuf, handle, 0L);
    nofailcheck("XMMcopyto()", status, (void far *) realbuf, handle, 0);
    weirdretchk("XMMcopyto()", status, (void far *) realbuf, handle, 0);
    weirdcodechk("XMMcopyto()", XMM_BADLENGTH, (void far *) realbuf, handle,0);
    SRCWORDCHECK(testbuf, HALFLEN);
    TESTTAILER();


    /*
    ** Now, let's do some speed tests (and make sure that we can handle
    ** blocks > 64K). We're going to have to write over the middle
    ** guard block to do it, and move the upper guard block.
    */
    gblmsg = "  COPY TESTS CONVENTIONAL-EMB SPEED";

    guard2 = (unsigned char far *) normptr(testbuf2 + HALFLEN - 1024);
    FMEMSET(guard2, GUARDVAL, 1024);
    LFMEMSET(testbuf, 0, MINFREE);
    status = XMMcopyto(MINFREE, testbuf, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    lfarincwordfill(testbuf, MINFREE, 0);

    /* first, copy MINFREE bytes straight */
    TESTHEADER();
    printf("XMMcopyto(): copy %lu bytes as a block.\n", MINFREE);
    printf("Should succeed.\n");
    start = get_tick();
    status = XMMcopyto(MINFREE, testbuf, handle, 0L);
    stop = get_tick();
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    if ((farmemcheck(guard1, 1024, GUARDVAL) != 0) ||
        (farmemcheck(guard2, 1024, GUARDVAL) != 0))
    {
        printf("Copy corrupted guard buffers.\n");
        XMMfree(handle);
        LFREE(realbuf);
        exit(3);
    }
    status = XMMcopyfrom(MINFREE, handle, 0L, testbuf);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    if ((farmemcheck(guard1, 1024, GUARDVAL) != 0) ||
        (farmemcheck(guard2, 1024, GUARDVAL) != 0))
    {
        printf("Copy corrupted guard buffers.\n");
        XMMfree(handle);
        LFREE(realbuf);
        exit(3);
    }
    CPYWORDCHECK(testbuf, MINFREE);
    printf("Succeeded. Took %lu ticks.\n", (stop - start));
    TESTTAILER();

    /* restore patterns */
    LFMEMSET(testbuf, 0, MINFREE);
    status = XMMcopyto(MINFREE, testbuf, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    lfarincwordfill(testbuf, MINFREE, 0);

    /* now, copy MINFREE bytes by words */
    TESTHEADER();
    printf("XMMcopyto(): copy %lu bytes by words.\n", MINFREE);
    printf("Should succeed.\n");
    total = 0L;
    temp = (unsigned char huge *) testbuf;
    for (loop = 0; loop < MINFREE; loop += 2L, temp += 2)
    {
        start = get_tick();
        status = XMMcopyto(2L, temp, handle, loop);
        stop = get_tick();
        total += (stop - start);
        TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    }
    if ((farmemcheck(guard1, 1024, GUARDVAL) != 0) ||
        (farmemcheck(guard2, 1024, GUARDVAL) != 0))
    {
        printf("Copy corrupted guard buffers.\n");
        XMMfree(handle);
        LFREE(realbuf);
        exit(3);
    }
    status = XMMcopyfrom(MINFREE, handle, 0L, testbuf);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    if ((farmemcheck(guard1, 1024, GUARDVAL) != 0) ||
        (farmemcheck(guard2, 1024, GUARDVAL) != 0))
    {
        printf("Copy corrupted guard buffers.\n");
        XMMfree(handle);
        LFREE(realbuf);
        exit(3);
    }
    CPYWORDCHECK(testbuf, MINFREE);
    printf("Succeeded. Took %lu ticks.\n", total);
    TESTTAILER();

    /* restore patterns */
    LFMEMSET(testbuf, 0, MINFREE);
    status = XMMcopyto(MINFREE, testbuf, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    lfarincwordfill(testbuf, MINFREE, 0);

    /* now, copy MINFREE bytes by fives */
    TESTHEADER();
    printf("XMMcopyto(): copy %lu bytes by groups of five bytes.\n", MINFREE);
    printf("Should succeed.\n");
    total = 0L;
    temp = (unsigned char huge *) testbuf;
    for (loop = 0; loop < MINFREE; loop += 5L, temp += 5)
    {
        start = get_tick();
        status = XMMcopyto(5L, temp, handle, loop);
        stop = get_tick();
        total += (stop - start);
        TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    }
    if ((farmemcheck(guard1, 1024, GUARDVAL) != 0) ||
        (farmemcheck(guard2, 1024, GUARDVAL) != 0))
    {
        printf("Copy corrupted guard buffers.\n");
        XMMfree(handle);
        LFREE(realbuf);
        exit(3);
    }
    status = XMMcopyfrom(MINFREE, handle, 0L, testbuf);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    if ((farmemcheck(guard1, 1024, GUARDVAL) != 0) ||
        (farmemcheck(guard2, 1024, GUARDVAL) != 0))
    {
        printf("Copy corrupted guard buffers.\n");
        XMMfree(handle);
        LFREE(realbuf);
        exit(3);
    }
    CPYWORDCHECK(testbuf, MINFREE);
    printf("Succeeded. Took %lu ticks.\n", total);
    TESTTAILER();

    /* restore patterns */
    LFMEMSET(testbuf, 0, MINFREE);
    status = XMMcopyto(MINFREE, testbuf, handle, 0L);
    TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    lfarincwordfill(testbuf, MINFREE, 0);

    /* now, copy MINFREE bytes by single bytes */
    TESTHEADER();
    printf("XMMcopyto(): copy %lu bytes individually.\n", MINFREE);
    printf("Should succeed.\n");
    total = 0L;
    temp = (unsigned char huge *) testbuf;
    for (loop = 0; loop < MINFREE; loop++, temp++)
    {
        start = get_tick();
        status = XMMcopyto(1L, temp, handle, loop);
        stop = get_tick();
        total += (stop - start);
        TRIPLECHECK("XMMcopyto()", status, 0, (void far *) realbuf, handle, 0);
    }
    if ((farmemcheck(guard1, 1024, GUARDVAL) != 0) ||
        (farmemcheck(guard2, 1024, GUARDVAL) != 0))
    {
        printf("Copy corrupted guard buffers.\n");
        XMMfree(handle);
        LFREE(realbuf);
        exit(3);
    }
    status = XMMcopyfrom(MINFREE, handle, 0L, testbuf);
    TRIPLECHECK("XMMcopyfrom()", status, 0, (void far *) realbuf, handle, 0);
    if ((farmemcheck(guard1, 1024, GUARDVAL) != 0) ||
        (farmemcheck(guard2, 1024, GUARDVAL) != 0))
    {
        printf("Copy corrupted guard buffers.\n");
        XMMfree(handle);
        LFREE(realbuf);
        exit(3);
    }
    CPYWORDCHECK(testbuf, MINFREE);
    printf("Succeeded. Took %lu ticks.\n", total);
    TESTTAILER();


    /*
    ** Clean up.
    */
    LFREE(realbuf);
    test_XMMfree(handle);

    return;
} /* end of static do_ncopy2_tests() */

