#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <wgt5.h>

/*
m
ͻ
             ۲ WordUp Graphics Toolkit V5.0               
         Source Code    Copyright 1995 Egerter Software          
Ķ
 Module:       wgtmenu.c                                         
 Contains:     showmenubar, removemenubar, initdropdowns,        
               checkmenu                                         
                                                                 
 Last Revised: April 25, 1995                                    
                                                                 
 Written by:   Chris Egerter            WATCOM PROTECTED MODE!   
ͼ
*/

static struct {
  char patch_id[8];
  char fname[12];
  float version;
} patch_struct = {"WGTPATCH", "wgtmenu", 1.0} ;

block menubarsave = NULL;       /* saves area at top of screen where
				   menu bar will go*/

block dropsave = NULL;          /* saves area where drop down menus go */

short curchoice;
short oldy;       
extern char *menubar[10];       /* your menubar structure */

typedef struct {
	char  choice[10][30];
	short menux,menuy;
	short color;
	short bordercolor;
	short textcolor;
	} menulist; 

menulist dropdown[10];          /* the drop down list */

void initdropdowns (void);       
void removemenubar (void);
void showmenubar (void);
short  checkmenu (void);
void displaydrop (short, short);    /* show the drop down menu */
void menusetto (short, short);      /* go to drop down (keyboard mode) */
void wmouseon (void);
void wmouseoff (void);          /* mouse on and off with installed checked */

short menubarcolor;
short menubartextcolor;
short bordercolor;

short     menubarheight;
short     menubarlengths[10];
wgtfont menufont;
short     olddropx;
short     highlightcolor;
static short px;                  /* Local mouse variables */
static short py;
static short pbut;
short     mouseinstalled = 0;
short     currentdropdown = 11;
char    menuhotkey = 0x44;      /* F10 */


void menustart (void)
{
  /* set up of defaults */
  short i;
  short i2;

  for (i = 0; i < 10; i++)
    for (i2 = 0; i2 < 10; i2++)
    {
      dropdown[i].color = 254;
      dropdown[i].bordercolor = 255;
      dropdown[i].textcolor = 1;
    }
  i = minit ();
  if (i > 0)
    mouseinstalled = 1;
  else mouseinstalled = 0;
  mouse.mx=WGT_SYS.xres - 1; mouse.my=WGT_SYS.yres - 1; mouse.but=0;
}



void showmenubar (void)
{
  short mh;
  short th;
  short i;

  mh = 0;
  for (i = 0; i < 10; i++)
  {
    if (menubar[i] != NULL) 
    {
      th = wgettextheight (menubar[i], menufont);
      if (th > mh) 
	mh = th;
    }
  }
  menubarheight = mh + 2;
  if (menubarsave != NULL)
    wfreeblock (menubarsave);
  menubarsave = wnewblock (0, 0, WGT_SYS.xres - 1, mh + 2);

  wsetcolor (menubarcolor);
  wbar (0, 0, WGT_SYS.xres - 1,mh + 2);
  wsetcolor (bordercolor);
  wline (0, mh + 2, WGT_SYS.xres - 1, mh + 2);
  wsetcolor (menubartextcolor);
  wtexttransparent (0);
  th = 0;

  /* display the menu bar titles */
  for (i = 0; i < 10; i++)
  {
    if (menubar[i] != NULL)
    {
      wouttextxy (th, 1, menufont, menubar[i]);
      menubarlengths[i] = wgettextwidth (menubar[i], menufont);
      th += menubarlengths[i];
    }
  }
}



void removemenubar (void)
{
  if (menubarsave != NULL)
  {
    wputblock(0, 0, menubarsave, 0);
    wfreeblock (menubarsave);
    menubarsave = NULL;
  }
  if (dropsave != NULL)
  {
    wfreeblock (dropsave);
    dropsave = NULL;
  }
}


short checkmenu(void)
{
  short  i;
  short  j;
  short  menuc;
  char ink;
  short  temp = 0;

  menuc =- 1;
  if (mouseinstalled == 1) 
  {
    px = mouse.mx;
    py = mouse.my;
    pbut = mouse.but;
  }
  else if (kbhit ())
  {
    ink = getch ();
    if (ink == 0)
      ink = getch ();
    if (ink == menuhotkey)
      menusetto (0, 20);
    if ((ink == 77) & (currentdropdown != 11))
      menusetto (currentdropdown + 1, 20);
    if ((ink == 75) & (currentdropdown != 11))
      menusetto (currentdropdown - 1, 20);
    if ((ink == 72) & (currentdropdown != 11))
      menusetto (currentdropdown, curchoice - 1);
    if ((ink == 80) & (currentdropdown != 11))
      menusetto (currentdropdown, curchoice + 1);
    if (ink == 13)      /* return */
      mouse.but = 1;
    if (ink == 27)      /* ESC */
    { 
      mouse.mx=WGT_SYS.xres - 1; mouse.my=WGT_SYS.yres - 1; 
    }
  }

  if (currentdropdown != 11)
  {
    if ((px >= olddropx) & (px < olddropx + dropdown[currentdropdown].menux)
      && (py < dropdown[currentdropdown].menuy + menubarheight + 3))
    {
      temp = menubarheight + 5;
      for (j = 0; j < 10; j++)
      {
	if ((dropdown[currentdropdown].choice[j][0] != 0) && (py >= temp))
	{ 
	  i = temp;
	  temp += wgettextheight (dropdown[currentdropdown].choice[j], menufont) + 2;
	  if (py < temp)
	  {
	    if (curchoice != j)
	    {
	      if (curchoice != -1)      /* erase old */
	      {
		wmouseoff ();
		wtextcolor (dropdown[currentdropdown].textcolor);
		wouttextxy (olddropx + 4, oldy, menufont, dropdown[currentdropdown].choice[curchoice]);
		wmouseon ();
	      }
	      wmouseoff ();
	      wtextcolor (highlightcolor);
	      wouttextxy (olddropx + 4, i, menufont, dropdown[currentdropdown].choice[j]);
	      wmouseon ();
	      curchoice = j;
	      oldy = i;
	    }
	    if (mouse.but != 0)
	    {
	      menuc = currentdropdown * 10 + j;
	      wmouseoff ();
	      wputblock (olddropx, menubarheight + 1, dropsave, 0);
	      wfreeblock (dropsave);
	      dropsave = NULL;
	      currentdropdown = 11;
	      wmouseon ();
	      mouse.but = 0;
	    }
	  }
	}
      }
    }
      else 
    {
      wmouseoff ();
      if (dropsave != NULL)
      {
	wputblock (olddropx, menubarheight + 1, dropsave, 0);
	wfreeblock (dropsave);
	dropsave = NULL;
      }
      currentdropdown = 11;
      wmouseon ();
    }
  }
  temp = 0;
  if (py <= menubarheight)
  {
    for (i = 0; i < 10; i++)
    {
      if (menubar[i] != NULL)
      {
	if ((px >= temp) && (px < temp + menubarlengths[i]))
	{
	  if (currentdropdown != i)
	    displaydrop (i, temp);
	}
	temp += menubarlengths[i];
      }
    }
  }
  return menuc;
}



void initdropdowns(void)
{
  short i;
  short j;
  short mew;
  short meh;
  short temp;

  menustart ();
  for (i = 0; i < 10; i++)
  {
    mew = 0;
    meh = 0;
    for (j = 0; j < 10; j++)
    {
      temp = wgettextwidth (dropdown[i].choice[j], menufont);
      if (temp > mew) 
	mew = temp;
      temp = wgettextheight (dropdown[i].choice[j], menufont);
      meh += temp;
      if (dropdown[i].choice[j] != NULL)
	meh += 2;
    }
    meh += 10;
    mew += 10;
    dropdown[i].menux = mew;
    dropdown[i].menuy = meh;
  }
}



void displaydrop (short menudrop, short startat)
{
  short dat;
  short j;
  short x1;
  short y1;
  short x2;
  short y2;

  currentdropdown = menudrop;
  curchoice =- 1;
  wmouseoff ();
  if (dropsave != NULL)
  {
    wputblock (olddropx, menubarheight + 1, dropsave, 0);
    wfreeblock (dropsave);
  }

  if (startat + dropdown[menudrop].menux > WGT_SYS.xres - 1)
    dat = (WGT_SYS.xres - 1) -dropdown[menudrop].menux;
  else dat = startat;

  x1 = dat;
  y1 = menubarheight + 1;
  x2 = dat + dropdown[menudrop].menux;
  y2 = menubarheight + 1 + dropdown[menudrop].menuy;
  olddropx = dat;

  dropsave = wnewblock (x1, y1, x2, y2);
  wsetcolor (dropdown[menudrop].color);
  wbar (x1, y1, x2, y2);
  wsetcolor (dropdown[menudrop].bordercolor);
  wrectangle (x1, y1, x2, y2);

  dat = y1 + 4;
  for (j = 0; j < 10; j++)
  {
    if (dropdown[menudrop].choice[j][0] != 0)
    {
      wtextcolor (dropdown[menudrop].textcolor);
      wouttextxy (olddropx + 4, dat, menufont, dropdown[menudrop].choice[j]);
      dat += wgettextheight (dropdown[menudrop].choice[j],menufont) + 2;
    }
  }
  wmouseon ();
}



void menusetto (short menu, short choice)
{
  short i;
  short j;
  short  temp = 0;

  if (menu < 0)
    menu = 0;
  if (menu > 9)
    menu = 9;

  if (choice < 0)
    choice = 0;
  if ((choice > 9) && (choice != 20))
    choice = 9;

  /* set the menu */
  for (i = 0; i < 10; i++)
  {
    if ((menubar[i] != NULL) && (i == menu))
    {
      px = temp;
      py = 0;
      if (currentdropdown != i)
      curchoice =- 1;   
    }
    temp += menubarlengths[i];
  }

  /* set the choice */
  if (choice != 20)
  {
    temp = menubarheight + 6;
    for (j = 0; j < 10; j++)
    {
      if (choice == j)
	py = temp;
      temp += wgettextheight (dropdown[currentdropdown].choice[j], menufont) + 2;
    }
  }
}



void wmouseon (void)
{
  if (mouseinstalled == 1)
  mon ();
}


void wmouseoff (void)
{
  if (mouseinstalled == 1)
  moff ();
}
