/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 70
                                                                              
 Use a graphical display to calibrate the joystick.
                                                                              
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.   
                                                                              
 *** DATA FILES ***                                                          
 LITTLE.WFN
                                                        WATCOM C++ VERSION 
==============================================================================
*/


#include <stdlib.h>
#include <conio.h>
#include <wgt5.h>
#include <wgtjoy.h>

void main (void)
{
  joystick joya;                        /* Structure for joystick A */
  joystick joyb;                        /* Structure for joystick B */
  int lastx_a, lastx_b;                 /* Previous joystick values */
  int lasty_a, lasty_b;                 /* Previous joystick values */
  int result;                           /* Result of joystick detection */
  int joya_found = 0;                   /* 1 if joystick is found */
  int joyb_found = 0;                   /* 1 if joystick is found */
  wgtfont little;
  short oldmode;  

  oldmode = wgetmode ();
  if (!vgadetected ())
  {
    printf ("VGA is required to run this program...");
    exit (1);
  }

  printf ("WGT Example #70\n\n");
  printf ("This program uses the joystick library to demonstrate the proper calibration\n");
  printf ("techniques. Once the detected joysticks have been calibrated you may move the\n");
  printf ("sticks around and press joystick buttons to see how the system reacts.\n");
  printf ("Press any key to exit.\n");
  printf ("\nPress any key to begin.\n");
  getch ();

  little = wloadfont ("little.wfn");

  vga256 ();
  wtextcolor (15);
  wtexttransparent (TEXTFGBG);
  
  wouttextxy (0, 190, little, "Demonstrating joystick calibration system........");
  wsetcolor (15);
  wline (0, 188, 319, 188);
  wsetcolor (2);
  wbar (0, 0, 319, 187);
  
  wtextbackground (2);
  if (!( result = wcheckjoystick () ))
  {
    wouttextxy (0, 0, NULL, "Joysticks not found. Program aborted.");
    getch ();
    wsetmode (3);
    exit (0);
  }

  if (result & 1)
  {
    joya_found = 1;                             /* It's there */
    wouttextxy (0, 0, little, "Joystick A detected.");
    winitjoystick (&joya, 0);                   /* Initialize it */
    wouttextxy (0, 8, little, "Calibrate joystick A by swirling it and then pressing ENTER.");
    wcalibratejoystick (&joya);
    wouttextxy (0, 16, little, "Joystick A calibrated.");
  }

  if (result & 2)
  {
    joyb_found = 1;                             /* It's there */
    wouttextxy (0, 32, little, "Joystick B detected.");
    winitjoystick (&joyb, 1);                   /* Initialize it */
    wouttextxy (0, 40, little, "Calibrate joystick B by swirling it and then pressing ENTER.");
    wcalibratejoystick (&joyb);
    wouttextxy (0, 48, little, "Joystick B calibrated.");
  }

  wbar (0, 0, 319, 187);
  wouttextxy (0, 0, little, "Now reading joystick values. Press any key to end program.");

  joya.scale = 100;
  joyb.scale = 100;
  wsetcolor (15);
  if (joya_found)
  {
    wtextcolor (6);
    wouttextxy (0, 30, little, "Joystick A");
    wouttextxy (0, 40, little, "X AXIS");
    wouttextxy (0, 60, little, "Joystick A");
    wouttextxy (0, 70, little, "Y AXIS");
    wline (60, 40, 260, 40);
    wline (160, 41, 160, 44);
    wtextcolor (1);
    wouttextxy (157, 46, little, "0");
    wline (60, 41, 60, 44);
    wouttextxy (48, 46, little, "-100");
    wline (260, 41, 260, 44);
    wouttextxy (253, 46, little, "100");
  
    wline (60, 70, 260, 70);
    wline (160, 71, 160, 74);
    wouttextxy (158, 76, little, "0");
    wline (60, 71, 60, 74);
    wouttextxy (47, 76, little, "-100");
    wline (260, 71, 260, 74);
    wouttextxy (253, 76, little, "100");
  }
  if (joyb_found)
  {
    wtextcolor (6);
    wouttextxy (0, 130, little, "Joystick B");
    wouttextxy (0, 140, little, "X AXIS");
    wouttextxy (0, 160, little, "Joystick B");
    wouttextxy (0, 170, little, "Y AXIS");
    wline (60, 140, 260, 140);
    wline (160, 141, 160, 144);
    wtextcolor (1);
    wouttextxy (157, 146, little, "0");
    wline (60, 141, 60, 144);
    wouttextxy (48, 146, little, "-100");
    wline (260, 141, 260, 144);
    wouttextxy (253, 146, little, "100");
  
    wline (60, 170, 260, 170);
    wline (160, 171, 160, 174);
    wouttextxy (158, 176, little, "0");
    wline (60, 171, 60, 174);
    wouttextxy (47, 176, little, "-100");
    wline (260, 171, 260, 174);
    wouttextxy (253, 176, little, "100");
  }

  wtextcolor (15);
  while (!kbhit ())
  {
    if (joya_found)
    {
      wreadjoystick (&joya);            /* Read values into structures */
      if (joya.x != lastx_a)
      {
        wsetcolor (2);
        wbar (60, 30, 260, 39);
        wsetcolor (0);
        wline (160 + joya.x, 30, 160 + joya.x, 39);
        lastx_a = joya.x;
      }
      if (joya.y != lasty_a)
      {
        wsetcolor (2);
        wbar (60, 60, 260, 69);
        wsetcolor (0);
        wline (160 + joya.y, 60, 160 + joya.y, 69);
        lasty_a = joya.y;
      }
      wgtprintf (265, 60, little, "Buttons: %2d", joya.buttons & 0x03);
    }
    if (joyb_found)
    {
      wreadjoystick (&joyb);
      if (joyb.x != lastx_b)
      {
        wsetcolor (2);
        wbar (60, 130, 260, 139);
        wsetcolor (0);
        wline (160 + joyb.x, 130, 160 + joyb.x, 139);
        lastx_b = joyb.x;
      }
      if (joyb.y != lasty_b)
      {
        wsetcolor (2);
        wbar (60, 160, 260, 169);
        wsetcolor (0);
        wline (160 + joyb.y, 160, 160 + joyb.y, 169);
        lasty_b = joyb.y;
      }
      wgtprintf (265, 160, little, "Buttons: %2d", (joyb.buttons & 0x0c) >> 2);
    }
  }
  getch ();
  wsetmode (3);
}
