/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 5                          
									      
 Draws vertical lines of different colours, and rotates the colours           
 until you hit a key.                                                         
									      
 Note: Fast colour rotation with many colours causes 'snow' on slower         
       computers.  If this occurs, limit the number of colours you rotate     
       at once.                                                               
									      
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.
									      
 *** DATA FILES ***                                                          
 NONE                                                                        
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>


void main(void)
{
  short y;
  short oldmode;
  color palette[256];
  
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }

  printf ("WGT Example #5\n\n");
  printf ("This program will rotate the color palette in various index positions\n");
  printf ("until you hit a key to end that set. There are 5 sets in this demo.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();
  vga256 ();

  for (y = 0; y < 64; y++)
    wsetrgb(y, y, y, y, palette);            /* sets first 64 colours to grey */
  for (y = 0; y < 64; y++)
    wsetrgb (y + 64, y, 0, 0, palette);      /* next 64 to red */
  for (y = 0; y < 64; y++)
    wsetrgb (y + 128, 0, y, 0, palette);     /* green */
  for (y = 0; y < 64; y++)
    wsetrgb (y + 192, 0, 0, y, palette);     /* blue */

  wsetpalette (0, 255, palette);           /* and finally change them
					      all at once */

  for (y = 0; y < 200; y++)             /* draw lines down the screen */
  {
    wsetcolor (y);
    wline (0, y, 319, y);
  }

  while (!kbhit ())
  {
    wretrace ();         /* Reduces the amount of snow on slow computers */
    wcolrotate (1, 200, 0, palette);
    wsetpalette (1, 200, palette);
  }
  getch ();

  /* Now rotate it the other way */
  while (!kbhit ())
  {
    wretrace ();
    wcolrotate (1, 200, 1, palette);
    wsetpalette (1, 200, palette);
  }
  getch ();

  /* Now rotate it in two directions at once. */
  while (!kbhit ())
  {
    wretrace ();
    wcolrotate (1, 100, 1, palette);
    wcolrotate (100, 200, 0, palette);
    wsetpalette (1, 200, palette);
  }
  getch ();

  /* Now the middle of the screen. */
  while (!kbhit ())
  {
    wretrace ();
    wcolrotate (66, 134, 1, palette);
    wsetpalette (66, 134, palette);
  }
  getch ();

  /* Now mix all the colours up by overlapping rotation areas! */
  while (!kbhit ())
  {
    wretrace ();
    wcolrotate (1, 200, 0, palette);
    wcolrotate (20, 180, 0, palette);
    wcolrotate (40, 160, 0, palette);
    wcolrotate (60, 120, 0, palette);
    wcolrotate (80, 100, 0, palette);
    wsetpalette (1, 200, palette);
  }
  getch ();
  wsetmode (oldmode);
}
