#include "c:\xlib\xlib.h"
#include "c:\xlib\xpoint.h"
#include "c:\xlib\xrect.h"
#include "c:\xlib\xpal.h"
#include "c:\xlib\xpbitmap.h"
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <alloc.h>

/* WGT sprite file to Xlib sprite file converter
  
 This program was compiled with xlib v3.  One bug was noticed in this
 version:  The x_put_pix routine hangs the system.  I have drawn
 a line to the same point instead and this works fine.   Themie has 
 probably fixed this, since Xlib is currently at version 6. Therefore
 you may need to change some of this code depending on what has 
 changed in Xlib.


 */


void far *sprites[2001];
void convertsprites(char *,char *);
void loadsprites(char *,void far *loadspr[]);
void testsprites();
void freesprites(void far *freespr[]);

int main(void)
{
   /* Note that you may select whichever mode you please */
   x_set_mode(X_MODE_320x480,320);
   /*       mode,width of in pixels */

   convertsprites("sprtconv.spr","out.spr");
   loadsprites("out.spr",sprites);
   testsprites();
   freesprites(sprites);


   /* clean up */
   x_text_mode();
   return 0;
}

void convertsprites(char *infile,char *outfile)
{
FILE *in;   /* 256 color sprite file */
FILE *out;  /* converted sprite file */
unsigned char palette[768]; 		/* 256 * 3 (RGB values) */
int maxcolor;
int maxsprite;
long size;
unsigned char far *temp;
int a,b,i,j,spritemade;
int col;
char buf[14];
int x,y;
int startingsprite;

    /* Open the files */
    if ((in = fopen (infile, "rb")) == NULL)
	   {
	   x_text_mode();
	   printf("Could not open 256 color sprite file");
	   exit(1);
	   }
    if ((out = fopen (outfile, "wb")) == NULL)
	   {
	   x_text_mode();
	   printf("Could not open converted sprite file");
	   exit(1);
	   }

     fread(&a, 1, 2, in);
     /* Get the version number, and change the startingsprite accordingly.
     If version <= 3, maxsprite contains the maximum number of sprites
     that can be stored in a file.  If version > 4, maxsprite contains
     the number of the highest sprite in the file. (empty sprites at
     the end are not kept in the file. */
 if (a <= 3)
   startingsprite = 1;
 else startingsprite = 0;    /* Version 4 starts at sprite 0 */

    fread (buf, 1, 13, in); /* sprite header */
    if (0 == strnicmp (" Sprite File ", buf, 13)) /* see if it is a sprite file */
    {
	fread(palette,1,768,in); /* Read in 256 color palette */
	maxcolor=256;
	putw(maxcolor,out);  /* Write the number of colors stored in file */

	for (i = 0; i < maxcolor; i++) /* read in the palette */
        {
	   fputc(palette[i*3],out);    /* Write out Red */
	   fputc(palette[i*3+1],out);  /* Green */
	   fputc(palette[i*3+2],out);  /* And Blue color values */

        }
        
	maxsprite = getw (in);   /* maximum sprites in this file */
	putw(maxsprite,out);
	for (i = startingsprite; i <= maxsprite; i++) /* load them in */
	{
	    spritemade = getw (in); /* flag to see if sprite exists */
	    putw(spritemade,out); 
	    if (spritemade == 1)
	    {
		x_rect_fill(0,0,319,199,0,0); /* Clear the previous sprite */
		a = getw (in); /* get width and height */
		b = getw (in);
		putw(a,out); /* Put width and height */
		putw(b,out);

		/* Read in the image data. Each byte represents a color
		from 0-255. Obviously converting sprites that use more colors
		than the current mode allows will not work. Draw sprites using
		only the first colors (eg 0-16), up to maxcolors of the mode you're using. */
		for (y=0; y<b; y++)
		  for (x=0; x<a; x++)
		     {
		     col=fgetc(in);
		     x_line(x,y,x,y,col,0);
		     }

		size = a*b+2; /* get byte size of image */
		if ((temp = farmalloc(size)) == NULL)
		    {
		      x_text_mode();
		      printf("Error: not enough heap space in convertsprites.\n");
		      exit(1);
		   }
		x_get_pbm(0,0,a/4,b,0,temp); /* Get the image in new mode */
		fwrite(temp,size,1,out); /* Write the data in getimage format */
		farfree(temp);
	    }
        }
    }
    fclose (in);
    fclose (out);
}

void loadsprites (char *infile, void far *loadspr[])
{
FILE *in;   /* converted color sprite file */
int maxsprite;
long size;

unsigned char *temp;
int a,b,i,j,spritemade;
char buf[14];
int x,y,maxcolor;
unsigned char pal[768];

    /* Open the files */
    if ((in = fopen (infile, "rb")) == NULL)
	   {
	   closegraph();
	   printf("Could not load converted color sprite file");
	   exit(1);
	   }

	maxcolor=getw(in);

	for (i = 0; i < maxcolor; i++) /* read in the palette */
	   { 
	   pal[i*3]=fgetc(in);
	   pal[i*3+1]=fgetc(in);
	   pal[i*3+2]=fgetc(in);
	   }
	x_put_pal_raw(pal,256,0);
	
	maxsprite = getw (in);   /* maximum sprites in this file */

	for (i = 0; i < maxsprite; i++) /* load them in */
	{
	    spritemade = getw (in); /* flag to see if sprite exists */
	    if (spritemade == 1)
	    {
		a = getw (in); /* get width and height */
		b = getw (in);

		size = a*b+2; /* get byte size of image */
		if ((loadspr[i] = farmalloc(size)) == NULL)
		    {
		      closegraph();
		      printf("Error: not enough heap space in loadsprites().\n");
		      freesprites(loadspr);
		      exit(1);
		   }
		fread(loadspr[i],size,1,in);
	    } 
	    else loadspr[i]=NULL;
	
    }
    fclose(in);
}




void testsprites(void)
/* Loops through 10 sprites, displaying them on the screen
   using the putimage method. Press a key to go to the next sprite. */
{
int i,j;

for (i=0; i<10; i++) 
  {
  x_rect_fill(0,0,ScrnPhysicalPixelWidth,ScrnPhysicalHeight,0,0);
  
   if (sprites[i] !=NULL)
     {
     for (j=1; j<20; j++)
	x_put_masked_pbm(rand() % ScrnPhysicalPixelWidth,
		rand() % ScrnPhysicalHeight,0,sprites[i]); 
       /* Put the converted image on the screen */
     getch();
     }
  }
}

void freesprites(void far *freespr[])
{
int i;

for (i=0; i<2001; i++)
  {
  if (freespr[i] !=NULL)
    farfree(freespr[i]);
  }
}
