/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 15                        
                                                                            
This program shows how to use virtual graphics pages and tells how          
they are used in animation.                                                 
                                                                            
  PROJECT                                                             
 This program requires the file WGT45.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <conio.h>
#include <wgt45.h>


void main (void)
{
short x, y;
short oldmode;
block screen1;
  
  printf ("WGT Example #15\n\n");
  printf ("This program demonstrates virtual screen buffers.\n");
  printf ("Press a key after the tone is heard, then again to end the demo.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  oldmode = wgetmode ();
  vga256 ();

  screen1 = wnewblock (0, 0, 119, 129);
  /* Virtual screens can now be any size, as long as they fit within one
     segment (64k) */

  wtextcolor (15);
  wouttextxy (0, 0, NULL, "Press a key at the tone");
  wsetscreen (screen1);		/* sets to screen1 */

  for (y = 0; y < 200; y++)
    {
     wsetcolor (y);
     wline (0, 0, 319, y);	/* draw something on another screen */
     wline (319, 199, 0, y);
    }

  sound (500);		/* This is to let you know when it is finished */
  delay (100);
  nosound ();
  getch ();		/* there is nothing on the screen yet */

  /* now use putblock to show what happened on the other screen */

  wnormscreen ();		/* make the putblock go onto the default screen */
  wputblock (0, 0, screen1, 0);

  getch ();		/* now everything is shown! */

  wfreeblock (screen1);
  /* remember to free that memory (64004 bytes for a screen) */

  wsetmode (oldmode);
}