/*/

  Q BIND Utility v1.00b

  Used to add/remove stub EXEs from LE/PE/NE/PM EXE-images

  NEW : v1.00a : Fixed some bugs
  NEW : v1.00b : Fixed some more bugs

/*/

#include <qlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <process.h>
#include <string.h>
#include <alloc.h>
#include <stdlib.h>

#include <misc.h>
#include "parse.h"
#include <lefile.h>

int hi=0,ho=0,hs=0,hnull;
byte ignore=0;  //ignore warning message
void *buf;
byte *path;     //%PATH%
dword pathsiz;  //sizeof(path)
char fn[0x80];  //main filename
char stubfn[0x80];  //stub filename
char tempfn[0x80];  //temp filename (to rename later)
char newfn[0x80];   //new filename (new filename /N option)
char tn[0x80];      //temp usage
char cmd=0;
byte _tempfn=0;
dword EXEsiz;
dword EXEpad;
dword addtoDataPages=0;   //patch for LE images (LEDataPages)
word imgsig;
byte zeros[0x7]={0,0,0,0,0,0,0};  //max padding is 0x7

struct {  //64 bytes
  word sig;
  word siz1;
  word siz2;
  word relocsiz;
  word headsiz;  //# of paras (usually 2 for unbound stub and 4 for bound)
  word memmin;
  word memmax;
  word _ss;
  word _sp;
  word checksum;
  word _ip;
  word _cs;
  word reloctab;
  word overlay;
  byte resv[32-28];
  byte zero[32-4];
  dword imageoff; //image offset
} EXE;

struct LEHeader lehdr;

void cleanup(void) {   //cleanup on failure
  if (hi) close(hi);
  if (ho) close(ho);
  if (hs) close(hs);

  if (_tempfn) unlink(tempfn);

}

void usage(void) {
  printf("\nUsage : QBIND command [options] <infile[.exe | .le | .pe | .ne | .pm]>\n\n");
  printf("Commands:\n");
  printf("---------\n");
  printf(" /B=<filename>   - Bind an EXE stub to image\n");
  printf(" /U[=<filename>] - Unbind EXE stub from image\n");
  printf("      filename = stub output (default is to discard stub)\n");
  printf(" /R=<filename>   - Replace EXE stub in image\n");
  printf(" /X=<filename>   - Extract EXE stub from image\n");
  printf(" /I              - Ignore warning for PE,NE,PM images\n");
  printf("Note(s):\n");
  printf("  - QBIND supports LE,PE,NE and PM images\n");
  printf("  - QBIND supports the faulty default Watcom stub\n");
  printf("  - QBIND does not know how to patch PE,NE,PM images\n");
  printf("    and will issue a warning with these formats\n");
  exit(0);
}

void warning(void) {
  if (ignore) return;
  printf("QBIND will work with PE,NE and PM images but it will not patch them\n");
  printf("  so their contents (ie: pointers) may become invalid (I don't know).\n");
  printf("Press a key to continue...\n");
  getch();
}

word ReadHeader(int h) {
  word sig;
  if (read(h,&sig,2)!=2) error("Could not read file Header");
  lseek(h,-2,SEEK_CUR);
  return sig;
}

int OpenStub(void) {
  int h;
  char t1[0x80];
  char t2[0x80];
  char str[0x80];
  word pathoff;
  word p;

  strcpy(t1,stubfn);

  h=open(t1,O_BINARY|O_RDONLY);
  if (h==-1) {
    if (path!=NULL) {
      pathoff=0;
      while (h==-1) {
        if (!(*(path+pathoff))) break;
        p=0;
        while (*(path+pathoff)) {
          t2[p++]=*(path+pathoff++);
          if ((*(path+pathoff))==';') {pathoff++;break;}
        }
        t2[p]=0;
        strcat(t2,"\\");
        strcat(t2,t1);
        h=open(t2,O_BINARY|O_RDONLY);
      }
    }   
        
    if (h==-1) {
      sprintf(str,"Could not open file : %s\n",stubfn);
      error(str);
    }     
  }       

  return h;

}

int CreatTemp(void) {
  char str[0x80];
  word a;
  int h;

  for (a=0;a<=999;a++) {
    sprintf(str,"$QBIND$.%03d",a);
    h=_creat(str,FA_ARCH);
    if (h!=-1) {
      strcpy(tempfn,str);
      _tempfn=1;  //cleanup() will now delete tempfn on error
      return h;
    }
  }

  error("Could not create a tempfile");

  return 0;  //just to shut-up compiler

}

int CreatStub(void) {
  int h;
  int acc;

  if (!strlen(stubfn)) return hnull;

  h=_creat(stubfn,FA_ARCH);
    
  if (h==-1) error("Could not create stub output");

  return h;

}

void CopyFile(int hdest,int hsrc,byte chkheader) {
  sdword a;

  imgsig=ReadHeader(hsrc);  //reads sig  (also used in RenameFile())

  if (chkheader)
  switch (imgsig) {
    case 'LE':
      if (read(hsrc,&lehdr,sizeof(lehdr))!=sizeof(lehdr)) error("Could not read LE header");
      lehdr.LEDataPages += addtoDataPages;
      if (write(hdest,&lehdr,sizeof(lehdr))!=sizeof(lehdr)) error("Write error?");
      break;
    case 'PE':
    case 'PM':
    case 'NE':
      warning();
      break;
  }

  //now copy rest of file

  while (1) {
    a=read(hsrc,buf,bufsiz);
    if (a==-1) error("Read error?");
    if (a==0) break;
    if (write(hdest,buf,a)!=a) error("Write error?");
  }

}

void CopyFileMax(int hdest,int hsrc,dword max) {
  sdword a;
  dword am;

  while (max) {
    if (bufsiz<max) am=bufsiz; else am=max;
    a=read(hsrc,buf,am);
    if (a!=am) {
      printf("Read = %d\n",a);  //BUG!
      error("Read error? (max)");
    }
    max-=a;
    if (write(hdest,buf,a)!=a) error("Write error?");
  }

}

void CopyEXE(int hdest,int hsrc) {
  dword offset;
  word sig;

  if (read(hsrc,&EXE,sizeof(EXE))!=sizeof(EXE)) error("Could not read Header");

  if (EXE.sig != 'MZ') goto bad;
  if (EXE.headsiz<4) goto bad;

  EXEsiz=(EXE.siz2-1)*512;   //(EXE.siz2-1)*512+EXE.siz1;
  EXEsiz+=EXE.siz1;
  offset=EXE.imageoff;

  EXEpad=offset-EXEsiz;

  lseek(hsrc,offset,SEEK_SET);

  //check for LE/PE/NE/PM
  sig=ReadHeader(hsrc);
  if ((sig=='LE') || (sig=='PE') || (sig=='NE') || (sig=='PM')) {
    //fixup if a bad Watcom EXE
    if (EXEsiz > offset) {
      //faulty Watcom EXE
      //must fix this cause some LEOffset Detection code may not work
      EXEsiz-=0x10;
      if (EXE.siz1 < 0x10) {
        EXE.siz1+=0x200;
        EXE.siz2--;
      }
      EXE.siz1-=0x10;
      EXEsiz=(EXE.siz2-1)*512;   //(EXE.siz2-1)*512+EXE.siz1;
      EXEsiz+=EXE.siz1;
      EXEpad=offset-EXEsiz;
      if (EXEsiz > offset) goto bad;
      printf("Warning : Compensating for faulty Watcom EXE stub\n");
    }

    //copy stub now and any padding
    lseek(hsrc,0,SEEK_SET);
    CopyFileMax(hdest,hsrc,EXEsiz + EXEpad);
    return;
  }

bad:
  error("Invalid stub");

}

void CopyStub(int hdest,int hsrc) {
  dword offset;

  //Stub will be given an expanded header with the offset of image

  if (read(hsrc,&EXE,32)!=32) error("Could not read Stub Header");

  if (EXE.sig != 'MZ') goto bad;

  switch (EXE.headsiz) {
    case 2:
      //Increase header size
      EXE.headsiz+=2;
      EXE.reloctab+=2;
      EXE.siz1 += 0x20;
      if (EXE.siz1 >= 0x200) {
        EXE.siz1-=0x200;
        EXE.siz2++;
      }
      break;
    case 4:
      //read rest of header
      if (read(hsrc,&EXE+32,32)!=32) error("Could not read Stub Header");
      break;
    default:
      error("Invalid stub file");
  }

  EXEsiz=(EXE.siz2-1)*512;   //(EXE.siz2-1)*512+EXE.siz1;
  EXEsiz+=EXE.siz1;
  offset=(EXEsiz + 0x7) & 0xfff8;
  EXE.checksum=0;  //just in case

  EXEpad=offset-EXEsiz;  //EXE is not / by 8 so we must PAD stub

  EXE.imageoff=offset;

  memset(&EXE.zero,0,sizeof(EXE.zero));

  //Write Header
  if (write(hdest,&EXE,sizeof(EXE))!=sizeof(EXE)) error("Write error?");

  //copy rest of EXE stub
  CopyFileMax(hdest,hsrc,EXEsiz - sizeof(EXE));

  //write padding
  if (EXEpad)
    if (write(hdest,&zeros,EXEpad)!=EXEpad) error("Write error?");

  return;

bad:
  error("Invalid Stub");

}

void RenameFile(void) {
  char ext[4];

  close(hi);
  close(hs);
  close(ho);

  fsplit(fn,NULL,newfn,NULL);
  switch (cmd) {
    case 'R':
      unlink(fn);   //Delete original EXE file
      strcat(newfn,".EXE");
      break;
    case 'B':
      strcat(newfn,".EXE");
      break;
    case 'U':
      //imgsig = LE, NE, PE, PM
      ext[0]='.';
      ext[1]=(char)(imgsig & 0xff);
      ext[2]=(char)((imgsig & 0xff00) >> 8);
      ext[3]=0;
      strcat(newfn,ext);
      if (!stricmp(newfn,fn)) unlink(fn);
      break;
  }

  unlink(newfn);   //Just in case

  printf("Output = %s\n",newfn);

  rename(tempfn,newfn);
  _tempfn=0;

}

void main(void) {
  word a;
  word t1;
  word sig;

  errno=0;

  printf("\nQBIND Utility  v1.00b  (by : Peter Quiring)\n");
  buf=(byte*)malloc(bufsiz);
  if (buf==NULL) error("No RAM for buffers");
  if ((hnull=open("nul",O_BINARY | O_WRONLY))==ERROR) error("NUL Device error");
  path=(byte*)getenv("PATH");
  pathsiz=strlen(path);

  if (_argc<3) usage();
  parse_args();
  if (arg_namesc!=1) usage();
  if (arg_optsc<1) usage();

  strcpy(fn,arg_names[0]);  //filename

  stubfn[0]=0;
  for (a=0;a<arg_optsc;a++) {
    if (!stricmp(arg_opts[a][0],"B")) {
      if ((arg_opts[a][1]==NULL)||(cmd)) usage();
      cmd='B';
      strcpy(stubfn,arg_opts[a][1]);  //stub filename
    } else if (!stricmp(arg_opts[a][0],"U")) {
      if (cmd) usage();
      cmd='U';
      if (arg_opts[a][1]!=NULL) strcpy(stubfn,arg_opts[a][1]);  //stub filename
    } else if (!stricmp(arg_opts[a][0],"R")) {
      if ((arg_opts[a][1]==NULL)||(cmd)) usage();
      cmd='R';
      strcpy(stubfn,arg_opts[a][1]);  //stub filename
    } else if (!stricmp(arg_opts[a][0],"X")) {
      if ((arg_opts[a][1]==NULL)||(cmd)) usage();
      cmd='X';
      strcpy(stubfn,arg_opts[a][1]);  //stub filename
    } else if (!stricmp(arg_opts[a][0],"I")) {
      if ((arg_opts[a][1]!=NULL)||(ignore)) usage();
      ignore=1;
    }
  }

  if (!cmd) usage();

  hi=open(fn,O_BINARY|O_RDONLY);
  while (hi==-1) {
    if ((cmd=='R') || (cmd=='U') || (cmd=='X')) {
      strcpy(fn,arg_names[0]);
      strcat(fn,".EXE");
      hi=open(fn,O_BINARY|O_RDONLY);
      if (hi!=-1) break;
    }
    if (cmd=='B') {
      strcpy(fn,arg_names[0]);
      strcat(fn,".LE");
      hi=open(fn,O_BINARY|O_RDONLY);
      if (hi!=-1) break;
      strcpy(fn,arg_names[0]);
      strcat(fn,".PE");
      hi=open(fn,O_BINARY|O_RDONLY);
      if (hi!=-1) break;
      strcpy(fn,arg_names[0]);
      strcat(fn,".NE");
      hi=open(fn,O_BINARY|O_RDONLY);
      if (hi!=-1) break;
    }
    sprintf(tn,"Unable to open %s",fn);
    error(tn);
  }

  printf("\nWorking with : %s\n",fn);

  switch (cmd) {
    case 'B':
    case 'R':
      printf("Adding : %s\n",stubfn);
      sig=ReadHeader(hi);    //load MZ/LE/PE/NE header to make sure it's valid
      switch (sig) {
        case 'LE':
          hs=OpenStub();   //open stub (looks thru PATH)
          ho=CreatTemp();  //create temp file for output
          CopyStub(ho,hs); //add stub
          addtoDataPages += (EXEsiz + EXEpad);
          break;
        case 'MZ':
          hs=OpenStub();   //open stub (looks thru PATH)
          ho=CreatTemp();  //create temp file for output
          CopyStub(ho,hs); //add stub
          addtoDataPages += (EXEsiz + EXEpad);
          CopyEXE(hnull,hi);//Remove EXE (compensates for Watcom WLINK bug)
          addtoDataPages -= (EXEsiz + EXEpad);
          break;
        case 'PE':
        case 'NE':
        case 'PM':
          hs=OpenStub();   //open stub (looks thru PATH)
          ho=CreatTemp();  //create temp file for output
          CopyStub(ho,hs); //add stub
          break;
        default:
          error("Invalid input file");
      }
      CopyFile(ho,hi,1); //Copys rest of file over
      RenameFile();      //rename temp to filename (/N could override)
      break;
    case 'U':
      if (stubfn[0]!=0) printf("Removing stub to : %s\n",stubfn);
        else printf("Removing stub\n");
      sig=ReadHeader(hi);    //load EXE header to make sure it's valid
      if (sig!='MZ') error("Invalid file(MZ)");
      hs=CreatStub();    //create stub if <filename> used with /U option
      ho=CreatTemp();    //create temp file for output
      CopyEXE(hs,hi);    //Copy over EXE (compensates for Watcom WLINK bug)
      addtoDataPages -= (EXEsiz + EXEpad);
      CopyFile(ho,hi,1); //Copys rest of file over.
      RenameFile();      //rename temp to filename (/N could override)
      break;
    case 'X':
      printf("Extracting stub to : %s\n",stubfn);
      sig=ReadHeader(hi);    //load EXE header to make sure it's valid
      if (sig!='MZ') error("Invalid file(MZ)");
      hs=CreatStub();    //create stub
      CopyEXE(hs,hi);    //Copy over EXE (compensates for Watcom WLINK bug)
      close(hs);
      close(hi);
      break;
  }

  printf("Complete!\n");

}
