/*/

Binary file to S19 conversion utility.

For the HC11 EVB project.

Created : Sept 3/97

/*/

#include <qlib.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>

#include "misc.h"

void cleanup(void) {}

//#define debug

/*/

 S record Format

Type(2) - Length (1) - Addr (2) - data/code (x) - Checksum(2)

Types: S0 = Header
       S1 = data/code
       S9 = EOF  (no addr,data)  (addr may be used to specify startup addr)

Length = # of bytes (pairs of hex #s) in addr + data/code + checksum

Addr = address to start uploading line (required on each line)

data/code = pairs of hex #s

Checksum = least sig. byte of 2's complement of the sum of the values
           in the length + addr + data/code

/*/

int hi,ho;                 // file handles in/out
byte *bufi;                // in buffer
byte *bufo;                // out buffer
word bpi,bpo;              // buffer pos in/out
word bsi;                  // buffer size in (amount of data in inbuffer)
byte enter[]={13,10,0};    // enter string
word checksum;             // S19 checksum
byte os[100];              // out string
byte osp;                  // 16bytes max
byte a,c;                  // a=temp  c=start of line?
byte tmpstr[10];           // temp string
word addr;                 // output address

void flush(void)
{
  //flush output
  write(ho,bufo,bpo);
  bpo=0;
}

void outstr(byte *s)
{
  while (*s)
  {
    if (bpo==bufsiz) flush();
    bufo[bpo++]=*s;
    s++;
  }
}  

void addstr(byte *s) {
  strcat(os,s);
}

void addcs(void) {
  checksum += c;
#ifdef debug
  printf("Addr=%x c=%i precheck=%x\n",addr,c,checksum);
#endif
  checksum ^= 0xffff;  //find 1s complement
  checksum &= 0xff;    //keep low byte only
  sprintf(tmpstr,"%02X",checksum);
  addstr(tmpstr);
}

void main(byte _argc,byte **_argv)
{
  if (_argc!=4)
  {
    printf("Binary 2 S19 Converter v1.00 (32bit) by : Peter Quiring\n");
    printf("BIN2S19 <binary_filename> <s19_filename> <starting_addr>\n");
    printf("  Note : starting_addr must be in hex\n");
    return;
  }

  hi=open(_argv[1],O_BINARY|O_RDONLY);
  ho=open(_argv[2],O_BINARY|O_CREAT|O_TRUNC|O_RDWR, S_IWRITE);

  addr=str2num(_argv[3],16);

  if (hi==-1 || ho==-1)
  {
    printf("File I/O Error!");
    exit(0);
  }

  bpi=0;
  bsi=0;

//  outstr("S00600004844521B");   //not needed
//  outstr(enter);
  c=0;
  os[0]=0;
  addstr("S1xx");   //xx = length (fix later)
  sprintf(tmpstr,"%04X",addr);
  addstr(tmpstr);
  checksum=(addr & 0xff);
  checksum+=((addr & 0xff00) >> 8);
#ifdef debug
  printf("1)Addr=%x c=%i precheck=%x\n",addr,c,checksum);
#endif

  do
  {
    if (bpi==bsi)
    {
      bpi=0;
      bsi=read(hi,bufi,bufsiz);
      if (!bsi) break;
    }

    a=bufi[bpi++];
    checksum+=a;
    sprintf(tmpstr,"%02X",a);
    addstr(tmpstr);
    c++;
    if (c==16)
    {
      c+=3;  //include addr+checksum for size
      os[2]='1';   //fixup length
      os[3]='3';
      addcs();
      addstr(enter);
      outstr(os);
      strcpy(os,"S1xx");
      addr += 16;
      sprintf(tmpstr,"%04X",addr);
      addstr(tmpstr);
      c=0;
      checksum=(addr & 0xff);
      checksum+=((addr & 0xff00) >> 8);
#ifdef debug
      printf("2)Addr=%x c=%i precheck=%x\n",addr,c,checksum);
#endif
    }
  } while (1);
  if (c>0)
  {
    c+=3;  //include addr+checksum
    if (c>=16) {       //fixup length
      os[2]='1';
      os[3]='0'+c-16;  // will not exceed 3
    } else {
      os[2]='0';
      if (c>=10)
        os[3]='A'+c-10;
      else
        os[3]='0'+c;
    }
    addcs();
    addstr(enter);
    outstr(os);
  }
  outstr("S9030000FC");   //output EOF

  flush();
  close(ho);
  close(hi);
}

