#include <stddef.h>
#include <dos.h>

#ifndef __STDIO_H__
#define __STDIO_H__

typedef struct {
  word flags;   // ANSI-C flags
  word buftyp;  // Buffer type (_IO...)
  //Input/Output Buffers to cache data
  char *buf;    // Buffer
  char *dbuf;   // Default assigned buffer
  dword bufsiz; // Size of the buffers
  dword ipos;   // When this reaches isiz then all input data is exhausted
  dword isiz;   // increased each time more data is read
  dword osiz;   // Amount of data in output buffer that needs to be flushed
  dword cpos;   // Current file pos
  word handle;  // DOS handle
  byte lastop;  // Last operation. Must fseek() if last is not the same
                // as what is being done.
} FILE;

typedef dword fpos_t;

#define BUFSIZ (4*1024)

#ifdef __cplusplus
  extern "C" {
#endif

extern word _fmode;

extern char * gets(char *s);
extern void puts(char *s);

extern void print(char * s1);
extern void fprint(FILE *stream,char * s1);
extern void printxy(word x,word y,char * s1);
extern void printf(char *,...);
extern void vprintf(char * str1,void * args);
extern void fprintf(FILE *stream,char * str1,...);
extern void vfprintf(FILE *stream,char * str1,void * args);

extern void sprintf(char * d,char * str1,...);
extern void vsprintf(char * d,char * str1,void * args);

extern void scanf(char * format,...);
extern void vscanf(char * format,void * args);
extern void sscanf(char * buf,char * format,...);
extern void vsscanf(char * buf,char * format,void * args);

extern int getchar(void);
extern int putchar(int c);

extern FILE *fopen(char *,char *);
extern int fclose(FILE *);
size_t fread(void *ptr, size_t size, size_t n, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t n, FILE*stream);
extern sdword fseek(FILE *,dword,byte);
extern long ftell(FILE *);
extern int fflush(FILE *);
extern int feof(FILE *);
extern int fgetc(FILE *);
extern int fgetchar(void);
extern int fputc(int,FILE *);
extern int fputchar(int);
extern int fscanf(FILE *,char *,...);
extern int vfscanf(FILE *,char *,void * args);
extern int fputs(char *,FILE *);
extern char *fgets(char *,int n,FILE *);
extern int ungetc(int,FILE *);
extern int _putch(int);
extern void setbuf(FILE *,char *buf);
extern void setvbuf(FILE *,char *buf,int type,size_t size);
#define fileno(f) ((f)->handle)

extern dword _printf_siz(char * str,...);
extern dword _vprintf_siz(char * str,dword args);

extern sword unlink(char * strg);

extern word errno;    //error code returned by DOS

#ifdef __cplusplus
  }
#endif

#define _LO_READ  0x1     //last operations
#define _LO_WRITE 0x2

#define _F_READ  0x0001            // Read only file
#define _F_WRIT  0x0002            // Write only file
#define _F_RDWR  0x0003            // Read/write flag
#define _F_BUF   0x0004            // Malloc'ed Buffer data
#define _F_LBUF  0x0008            // line-buffered file
#define _F_ERR   0x0010            // Error indicator
#define _F_EOF   0x0020            // EOF indicator
#define _F_BIN   0x0040            // Binary file indicator
#define _F_IN    0x0080            // Data is incoming
#define _F_OUT   0x0100            // Data is outgoing
#define _F_TERM  0x0200            // File is a terminal
//Defined for QLIB only
#define _F_STR   0x0800            // stream is a string (for ...sscanf())
#define _F_UBUF  0x1000            // User buffer provided (free() on fclose())

//Flags for FILE.buftyp and used in setvbuf(,,x)
#define _IOFBF	0
#define _IOLBF	1
#define _IONBF	2

extern FILE* stdin;
extern FILE* stdout;
extern FILE* stderr;
extern FILE* stdaux;
extern FILE* stdprn;

#endif
