/*
	BASECVT.C - Convert between Decimal/Hexadecimal/Binary number bases.
				The idea for this method was originally thought of by
				Andrew Walsh and his Tonto! v1.01 TSR program.
*/

#include <stdio.h>
#include <ctype.h>
#include <kbd.h>

extern unsigned long NumIdx;

extern int BorderClr;
extern int TitleClr;
extern int TextClr;
extern int FooterClr;

void BaseConvert(void);
static void DrawMenu(void);
static char *BinStr(char *str);

void BaseConvert()
{
	char binnum[80];

	ScrPush();
	DrawMenu();

	for (;;)	{
		ultoa(NumIdx, binnum,  2); strcpy(binnum, BinStr(binnum));
		PutStr(51,7, TextClr, "%22lu ", NumIdx);
		PutStr(55,9, TextClr, "%18X ",  NumIdx);
		PutStr(50,11,TextClr, "%23s ",  binnum);
		switch (KbdGetC())	{
			case UP:
				if (++NumIdx > 65535) NumIdx = 0;
				break;
			case DN:
				if (--NumIdx < 0 || NumIdx > 65535) NumIdx = 65535;
				break;
			case PGUP:
				NumIdx += 10;
				if (NumIdx > 65535) NumIdx = 0;
				break;
			case PGDN:
				NumIdx -= 10;
				if (NumIdx < 0 || NumIdx > 65535) NumIdx = 65535;
				break;
			case 0x8400:			/* Ctrl-PgUp */
				NumIdx += 100;
				if (NumIdx > 65535) NumIdx = 0;
				break;
			case 0x7600:			/* Ctrl-PgDn */
				NumIdx -= 100;
				if (NumIdx < 0 || NumIdx > 65535) NumIdx = 65535;
				break;
			case HOME:
				NumIdx = 0;
				break;
			case END:
				NumIdx = 65535;
				break;
			case RET:
			case ESC:
				ScrPop(1);
				return;
		}
	}
}

static char *BinStr(char *str)
{
	register int i=0, j=0, k=0;
	char temp[80];

	temp[0] = '\0';
	strrev(str);
	while (*str)	{
		if (i == 4)	{
			temp[j+1] = '\0';
			temp[j++] = ' ';
			i = 0;
		}
		i++;
		temp[j+1] = '\0';
		temp[j++] = *str++;
	}
	for (k=j; k<19; k++)	{
		if (i == 4)	{
			temp[k+1] = '\0';
			temp[k++] = ' ';
			i = 0;
		}
		i++;
		temp[k+1] = '\0';
		temp[k] = '0';
	}

	strrev(temp);
	return(temp);
}

static void DrawMenu()
{
	ShadowBox(41,4,74,14, 2, BorderClr);
	PutStr(42,5, TitleClr,   "       Number Conversions       ");
	PutStr(41,6, BorderClr, "͵");
	PutStr(42,7, FooterClr,  " Decimal:");
	PutStr(41,8, BorderClr, "͵");
	PutStr(42,9, FooterClr,  " Hexadecimal:");
	PutStr(41,10,BorderClr, "͵");
	PutStr(42,11,FooterClr,  " Binary:");
	PutStr(41,12,BorderClr, "͵");
	PutStr(42,13,FooterClr, " %c %c PgUp PgDn ^PgUp ^PgDn Esc ", 24, 25);
}
