/*
 *                             8250NSC.H
 *
 *                    National SemiConducter 8250
 *
 *               Serial Chip Routine Defines & Globals
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 */
 
/*
 *	Intel 8259a interrupt controller addresses and constants
 */

# define INT_cntrl        0x20
# define INT_mask         0x21
# define INT_port_enable  0xEF
# define EOI_word         0x20


/*
 *	Constants used to enable and disable interrupts from the
 *	8250 - they are stored in PORT_command 
 */

# define RX_enable        0x0D /* Enable Rcv & RLS Interrupt       */
# define TX_enable        0x0E /* Enable Xmit & RLS Interrupt      */
# define RX_TX_enable     0x0F /* Enable Rcv, Xmit & RLS Interrupt */
# define ERROR_reset      0xF1
# define LCR_DLAB         0x80


/*
 *	8250 register offsets - should be added to value in PORT_address
 */

# define IER              1  /* interrupt enable offset */
# define IIR              2  /* interupt identification register */
# define LCR              3  /* line control register */
# define MCR              4  /* modem control register */
# define LSR              5  /* line status register */
# define MSR              6  /* modem status register */


/*
 *	The following constants are primarily for documentaiton purposes
 *	to show what the values sent to the 8250 Control Registers do to
 *	the chip.
 *
 *
 *                     INTERRUPT ENABLE REGISTER
 */

# define IER_Received_Data      1
# define IER_Xmt_Hld_Reg_Empty  (1<<1)
# define IER_Recv_Line_Status   (1<<2)
# define IER_Modem_Status       (1<<3)
# define IER_Not_Used           0xF0


/*
 *                 INTERRUPT IDENTIFICATION REGISTER
 */

# define IIR_receive      4
# define IIR_transmit     2
# define IIR_mstatus      0
# define IIR_rls          6
# define IIR_complete     1
# define IIR_Not_Used     0xF8


/*
 *                       LINE CONTROL REGISTER
 */

# define LCR_Word_Length_Mask     3
# define LCR_Stop_Bits            (1<<2)
# define LCR_Parity_Enable        (1<<3)
# define LCR_Even_Parity          (1<<4)
# define LCR_Stick_Parity         (1<<5)
# define LCR_Set_Break            (1<<6)
# define LCR_Divisor_Latch_Access (1<<7) /* Divisor Latch - must be set to 1
                                          * to get to the divisor latches of 
										  * the baud rate generator - must
										  * be set to 0 to access the
										  * Receiver Buffer Register and
										  * the Transmit Holding Register
                                          */


/*
 *                    	MODEM CONTROL REGISTER
 */

# define MCR_dtr          1
# define MCR_rts          (1<<1)
# define MCR_Out_1        (1<<2)
# define MCR_Out_2        (1<<3) /* MUST BE ASSERTED TO ENABLE INTERRRUPTS */
# define MCR_Loop_Back    (1<<4)
# define MCR_Not_Used     (7<<1)


/*
 *                        LINE STATUS REGISTER
 */

# define LSR_Data_Ready      1
# define LSR_Overrun_Error   (1<<1)
# define LSR_Parity_Error    (1<<2)
# define LSR_Framing_Error   (1<<3)
# define LSR_Break_Interrupt (1<<4)
# define LSR_THR_Empty       (1<<5)  /* Transmitter Holding Register */
# define LSR_TSR_Empty       (1<<6)  /* Transmitter Shift Register */
# define LSR_Not_Used        (1<<7)


/*
 *                       MODEM STATUS REGISTER
 */

# define MSR_Delta_CTS       1
# define MSR_Delta_DSR       (1<<1)
# define MSR_TERD            (1<<2)  /* Trailing Edge Ring Detect   */
# define MSR_Delta_RLSD      (1<<3)  /* Received Line Signal Detect */
# define MSR_CTS             (1<<4)  /* Clear to Send               */
# define MSR_DSR             (1<<5)  /* Data Set Ready              */
# define MSR_RD              (1<<6)  /* Ring Detect                 */
# define MSR_RLSD            (1<<7)  /* Received Line Signal Detect */
