/* TOXCC.C -- test program for running oxcc while being compiled */
/* 
	try:	oxcc -r toxcc.c -TRACE=1 >trace
		  and
		    oxcc -Gb toxcc.c
		    bterp toxcc -TRACE=1 >trace
*/

#include <stdlib.h>
#include <stdio.h>
#include "oxcc.h"

typedef void *object;

extern object Compiler;
extern object String;
extern object File;
extern object stdoutStream;

extern int gSeek();
extern int gPosition();
extern int gGets();
extern void *gNew();
extern void gDispose();
extern int gPrintf();
extern int gPuts();

extern void *oxlink_find_bare_symb();
extern void *oxlink_load_bare_symb();
extern void oxlink_use_library();

static char *testcode =

	"static inline int addfunc(int a, int b)"
	"{"
	"int q;"
		"return a + b;"
	"}"
	"int func(void)"
	"{"
	"int x;"
		"x = addfunc(1,2);"
		"return x;"
	"}";


int toxcc(int argc, char **argv)
{
void *instance;
void *is;		/* input stream */
void *os;		/* output stream */
void *es;		/* error stream */
char buf[200];
int err;

	printf("toxcc: Running\n");

	/* Dynamic link `oxcc' if it is not already there */
	if(!oxlink_find_bare_symb("_oxcc"))
	{
	  oxlink_use_library("oxcc.cff");
	  if(!oxlink_load_bare_symb("_oxcc", 1))
	    {printf("toxcc:ERROR: oxcc load failed\n"); return 1;}
	}
	/* METHOD 1 -- GET AN INSTANCE OF OXCC USING C CALLS */
	printf("toxcc: Method 1, expect a warning for line:1 col:46\n");

	/* 
		NOTE: The global calls to `oxcc_' below may have been unresolved until
		the dynamic linker loaded it above.
	*/
	instance = oxcc_open_instance();

	is = fopen(testcode, "x");	/* open string as a stream (readonly) */
	os = fopen("", "w+UTM");		/* create a Unique Temp file in Memory */
	es = fopen("", "w+UTM");		/* create a Unique Temp file in Memory */

	/* check the input file */
	if(!(err = oxcc_preproc_file(instance, is, os, es, 0, 0)))
	{
	  rewind(os);
	  if((err = oxcc_parse_file(instance, os, es, "testcode")))
	  {
		oxcc_print_parse_errors(instance, es);
	  }
	  else
	  {
		err = oxcc_check_ast_tree(instance, es, "testcode");
	  }
	}
	oxcc_cleanup_parse(instance);

	/* dump accumulated errors and warnings */
	if(ftell(es) > 0)
	{
		rewind(es);
		while(fgets(buf, 199, es))
		  fputs(buf, stdout);
	}
	fclose(is);
	fclose(os);
	fclose(es);
	/* could loop here on a new file */

	oxcc_close_instance(instance);

	/*
		NOTE: Using the class method, the `gNew' function would handle the
		dynamic linking of `oxcc' if it hadn't been loaded above.
	*/
	/* METHOD 2 -- GET AN INSTANCE OF OXCC USING THE CLASS METHOD */
	gPrintf(stdoutStream, "\ntoxcc: Method 2, expect a warning for line:1 col:46\n");

	if(!(instance = gNew(Compiler, "cc")))
	  {gPrintf(stdoutStream, "toxcc:ERROR:oxcc class failed\n"); return 1;}

	is = gNew(String, testcode); /* or could use gNew(File, testcode, "x") */
	os = gNew(File, "", "w+UTM");
	es = gNew(File, "", "w+UTM");

	/* check the input file */
	if(!(err = gPreProc(instance, is, os, es, 0, 0)))
	{
	  gSeek(os, 0);
	  if((err = gParse(instance, os, es, "testcode")))
	  {
		gPerror(instance, es);
	  }
	  else
	  {
		err = gCheckTree(instance, es, "testcode");
	  }
	}
	gCleanup(instance);

	/* dump accumulated errors and warnings */
	if(gPosition(es) > 0)
	{
		gSeek(es, 0);
		while(gGets(es, buf, 199))
		  gPuts(stdoutStream, buf);
	}
	gDispose(is);
	gDispose(os);
	gDispose(es);
	/* could loop here on a new file */

	gDispose(instance);
	return 0;
}
