/* xpc.h                        freeware                   xhunga@tiscali.fr  */

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printc(
pmatrix mA)
{
 int i;
 int j;

 printf("double pb[%d][%d*TWOCOL]=\n", mA->rows, mA->cols/TWOCOL);
 printf("{");

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf(" %6.0lf,%-.0lf, ",*(mA->pblock+i *mA->cols+j  ),
                               *(mA->pblock+i *mA->cols+j+1));
    }
  }

 printf("\n};\n");
 printf(" matrix m={%d,%d*TWOCOL,&pb[0][0]};\n",mA->rows,mA->cols/TWOCOL);

 printf("\n");
}


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printc4(
pmatrix mA)
{
 int i;
 int j;

 printf("double pb[%d][%d*TWOCOL]=\n", mA->rows, mA->cols/TWOCOL);
 printf("{");

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf(" %4.0lf,%-.0lf, ",*(mA->pblock+i *mA->cols+j  ),
                               *(mA->pblock+i *mA->cols+j+1));
    }
  }

 printf("\n};\n");
 printf(" matrix m={%d,%d*TWOCOL,&pb[0][0]};\n",mA->rows,mA->cols/TWOCOL);

 printf("\n");
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printc3(
pmatrix mA)
{
 int i;
 int j;

 printf("double pb[%d][%d*TWOCOL]=\n", mA->rows, mA->cols/TWOCOL);
 printf("{");

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf(" %3.0lf,%-.0lf, ",*(mA->pblock+i *mA->cols+j  ),
                               *(mA->pblock+i *mA->cols+j+1));
    }
  }

 printf("\n};\n");
 printf(" matrix m={%d,%d*TWOCOL,&pb[0][0]};\n",mA->rows,mA->cols/TWOCOL);

 printf("\n");
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printc2(
pmatrix mA)
{
 int i;
 int j;

 printf("double pb[%d][%d*TWOCOL]=\n", mA->rows, mA->cols/TWOCOL);
 printf("{");

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf(" %2.0lf,%-.0lf,",*(mA->pblock+i *mA->cols+j  ),
                             *(mA->pblock+i *mA->cols+j+1) );
    }
  }

 printf("\n};\n");
 printf(" matrix m={%d,%d*TWOCOL,&pb[0][0]};\n",mA->rows,mA->cols/TWOCOL);

 printf("\n");
}


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printc0(
pmatrix mA)
{
 int i;
 int j;

 printf("double pb[%d][%d*TWOCOL]=\n", mA->rows, mA->cols/TWOCOL);
 printf("{");

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf(" %.0lf,%-.0lf, ",*(mA->pblock+i *mA->cols+j  ),
                             *(mA->pblock+i *mA->cols+j+1) );
    }
  }

 printf("\n};\n");
 printf(" matrix m={%d,%d*TWOCOL,&pb[0][0]};\n",mA->rows,mA->cols/TWOCOL);

 printf("\n");
}

