/*
 *      File table.c
 *      Demonstrates the use of the TABLE Container Object
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

extern MTColor black, white, darkblue, cadetblue, seagreen;
extern int LowRes;

void
AddRowsCB(MOBJECT p, void *s, void *table)
{
    int ii;
    int nc = 5;
    char buff[32];
    MOBJECT lbl;

    MObjectUnmap(table);
    for (ii=0; ii < 5*nc; ii++)
    {
	sprintf(buff, "Cell %d - %d", ii/nc, ii%nc);
	lbl = MCreateLabel(table, buff, (ii%3) ? FIXED_MEDIUM : FIXED_LARGE);
	MObjectSetShadow(lbl, WS_SHADOW_IN, 1, 0);
	MObjectSetResize(lbl, 0, 0);
    }
    MObjectMap(table);
}

void
ClearTableCB(MOBJECT p, void *s, void *table)
{
    MTableFormDeleteDataRows(table);
}

/**********************************************************
 *      This callback destroys the dialog
 **********************************************************/
void
CloseTableCB(MOBJECT p, void *s, void *adata)
{
    p = MObjectShell(p);
    MShellUnrealize(p);
    MShellDestroy(p);
}

/*****************************************************
 *      This callback opens the dialog when the
 *      corresponding menu item is selected
 *****************************************************/
void
TableCB(MOBJECT o, void *o_data, void *a_data)
{
    MOBJECT shell, form, table;
    MOBJECT pbutton, sfile, lbl;
    int ii, nc;
    char buff[64];

    shell = MCreateShell("Test Table", SF_NO_CLOSE | SF_NO_MAXIMIZE);
    nc = 5;

    table = MCreateScrolledTableForm(shell, nc, 200, 180, 1, 1);
    MTableFormShowGrid(table);

    for (ii=0; ii < nc; ii++)
    {
	sprintf(buff, "Head %d - %d", ii/nc, ii%nc);
	MCreatePButton(table, buff, HELV_LARGE);
    }
    for (; ii < nc*5; ii++)
    {
	sprintf(buff, "Cell %d - %d", ii/nc, ii%nc);
	lbl = MCreateLabel(table, buff, (ii%3) ? FIXED_MEDIUM : FIXED_LARGE);
	MObjectSetShadow(lbl, WS_SHADOW_IN, 1, 0);
	MObjectSetResize(lbl, 0, 0);
    }

    sfile = MCreateSFile(shell, __FILE__, FIXED_MEDIUM, 12, 60);
    MObjectSetColor(sfile, darkblue, white);

    form = MCreateColForm(shell);

    pbutton = MCreatePButton(form, "Clear", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, ClearTableCB, table);
    pbutton = MCreatePButton(form, "Add Rows", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, AddRowsCB, table);
    pbutton = MCreatePButton(form, "Close", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, CloseTableCB, 0);

    MShellRealize(shell);
}
